/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.util.ImmutablePoint2i;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import mezz.jei.gui.overlay.bookmarks.IBookmarkDragTarget;
import net.minecraft.class_241;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class BookmarkDrag<T> {
    private final BookmarkOverlay bookmarkOverlay;
    private final List<IBookmarkDragTarget> targets;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final ITypedIngredient<T> ingredient;
    private final double mouseStartX;
    private final double mouseStartY;
    private final IBookmark bookmark;
    private final ImmutableRect2i origin;

    public BookmarkDrag(BookmarkOverlay bookmarkOverlay, List<IBookmarkDragTarget> targets, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> ingredient, IBookmark bookmark, double mouseX, double mouseY, ImmutableRect2i origin) {
        this.bookmarkOverlay = bookmarkOverlay;
        this.targets = targets;
        this.ingredientRenderer = ingredientRenderer;
        this.ingredient = ingredient;
        this.bookmark = bookmark;
        this.origin = origin;
        this.mouseStartX = mouseX;
        this.mouseStartY = mouseY;
    }

    public static boolean farEnoughToDraw(BookmarkDrag<?> drag, double mouseX, double mouseY) {
        ImmutableRect2i origin = drag.origin;
        class_241 center = origin.isEmpty() ? new class_241((float)drag.mouseStartX, (float)drag.mouseStartY) : new class_241((float)origin.getX() + (float)origin.getWidth() / 2.0f, (float)origin.getY() + (float)origin.getHeight() / 2.0f);
        double mouseXDist = (double)center.field_1343 - mouseX;
        double mouseYDist = (double)center.field_1342 - mouseY;
        double mouseDistSq = mouseXDist * mouseXDist + mouseYDist * mouseYDist;
        return mouseDistSq > 64.0;
    }

    public void update(int mouseX, int mouseY) {
        if (this.bookmark.isVisible() && !BookmarkDrag.farEnoughToDraw(this, mouseX, mouseY)) {
            return;
        }
        this.bookmark.setVisible(false);
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateMouseExclusionArea(new ImmutablePoint2i(mouseX, mouseY)).update();
    }

    public boolean drawItem(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.bookmark.isVisible()) {
            return false;
        }
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)(mouseX - 8), (float)(mouseY - 8), 0.0f);
        SafeIngredientUtil.render(guiGraphics, this.ingredientRenderer, this.ingredient);
        poseStack.method_22909();
        return true;
    }

    public boolean onClick(UserInput input) {
        for (IBookmarkDragTarget target : this.targets) {
            ImmutableRect2i area = target.getArea();
            if (!MathUtil.contains(area, input.getMouseX(), input.getMouseY()) || input.isSimulate()) continue;
            target.accept(this.bookmark);
            this.stop();
            return true;
        }
        if (!input.isSimulate()) {
            this.stop();
        }
        return false;
    }

    public void stop() {
        this.bookmark.setVisible(true);
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateMouseExclusionArea(null).update();
    }
}

