/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.elements;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.gui.TooltipHelper;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.bookmarks.IngredientBookmark;
import mezz.jei.gui.overlay.IngredientGridTooltipHelper;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.util.FocusUtil;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5684;

public class IngredientBookmarkElement<T>
implements IElement<T> {
    private final IngredientBookmark<T> bookmark;

    public IngredientBookmarkElement(IngredientBookmark<T> bookmark) {
        this.bookmark = bookmark;
    }

    @Override
    public ITypedIngredient<T> getTypedIngredient() {
        return this.bookmark.getIngredient();
    }

    @Override
    public Optional<IBookmark> getBookmark() {
        return Optional.of(this.bookmark);
    }

    @Override
    public void renderExtras(class_332 guiGraphics) {
    }

    @Override
    public void show(IRecipesGui recipesGui, FocusUtil focusUtil, List<RecipeIngredientRole> roles) {
        ITypedIngredient<T> ingredient = this.getTypedIngredient();
        List<IFocus<?>> focuses = focusUtil.createFocuses(ingredient, roles);
        recipesGui.show(focuses);
    }

    @Override
    public List<class_5684> getTooltipComponents(IngredientGridTooltipHelper tooltipHelper, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper) {
        ITypedIngredient<T> ingredient = this.bookmark.getIngredient();
        List<class_2561> ingredientTooltip = tooltipHelper.getIngredientTooltip(ingredient, ingredientRenderer, ingredientHelper);
        return TooltipHelper.toTooltipComponents(ingredientTooltip);
    }

    @Override
    public boolean isVisible() {
        return this.bookmark.isVisible();
    }
}

