/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.elements;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.Internal;
import mezz.jei.common.config.BookmarkTooltipFeature;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.TooltipHelper;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.overlay.IngredientGridTooltipHelper;
import mezz.jei.gui.overlay.bookmarks.IngredientsTooltipComponent;
import mezz.jei.gui.overlay.bookmarks.PreviewTooltipComponent;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.util.FocusUtil;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class RecipeBookmarkElement<R, I>
implements IElement<I> {
    private final RecipeBookmark<R, I> recipeBookmark;
    private final IDrawable icon;
    private final IClientConfig clientConfig;
    private final EnumMap<BookmarkTooltipFeature, class_5684> cache = new EnumMap(BookmarkTooltipFeature.class);
    @Nullable
    private Optional<IRecipeLayoutDrawable<R>> cachedLayoutDrawable;

    public RecipeBookmarkElement(RecipeBookmark<R, I> recipeBookmark, IDrawable icon) {
        this.recipeBookmark = recipeBookmark;
        this.icon = icon;
        this.clientConfig = Internal.getJeiClientConfigs().getClientConfig();
    }

    @Override
    public ITypedIngredient<I> getTypedIngredient() {
        return this.recipeBookmark.getRecipeOutput();
    }

    @Override
    public Optional<IBookmark> getBookmark() {
        return Optional.of(this.recipeBookmark);
    }

    @Override
    public void renderExtras(class_332 guiGraphics) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(8.0f, 8.0f, 200.0f);
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        this.icon.draw(guiGraphics);
        poseStack.method_22909();
    }

    @Override
    public boolean handleClick(UserInput input, IInternalKeyMappings keyBindings, IRecipesGui recipesGui, FocusUtil focusUtil) {
        boolean transferOnce = input.is(keyBindings.getTransferRecipeBookmark());
        boolean transferMax = input.is(keyBindings.getMaxTransferRecipeBookmark());
        if (transferOnce || transferMax) {
            class_310 minecraft = class_310.method_1551();
            class_437 screen = minecraft.field_1755;
            class_746 player = minecraft.field_1724;
            if (player != null && screen instanceof class_465) {
                class_465 containerScreen = (class_465)screen;
                IRecipeLayoutDrawable recipeLayout = this.getRecipeLayoutDrawable().orElse(null);
                if (recipeLayout == null) {
                    return false;
                }
                IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
                class_1703 container = containerScreen.method_17577();
                if (input.isSimulate()) {
                    IRecipeTransferError recipeTransferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, recipeLayout, (class_1657)player).orElse(null);
                    return recipeTransferError == null || recipeTransferError.getType().allowsTransfer;
                }
                return RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, (class_1657)player, transferMax);
            }
        }
        return false;
    }

    @Override
    public void show(IRecipesGui recipesGui, FocusUtil focusUtil, List<RecipeIngredientRole> roles) {
        IRecipeCategory<R> recipeCategory = this.recipeBookmark.getRecipeCategory();
        R recipe = this.recipeBookmark.getRecipe();
        ITypedIngredient<I> ingredient = this.getTypedIngredient();
        List<IFocus<?>> focuses = focusUtil.createFocuses(ingredient, List.of(RecipeIngredientRole.OUTPUT));
        recipesGui.showRecipes(recipeCategory, List.of(recipe), focuses);
    }

    @Override
    public List<class_5684> getTooltipComponents(IngredientGridTooltipHelper tooltipHelper, IIngredientRenderer<I> ingredientRenderer, IIngredientHelper<I> ingredientHelper) {
        class_2960 ingredientName;
        String ingredientModId;
        String recipeModId;
        ArrayList<class_5684> components = new ArrayList<class_5684>();
        ITypedIngredient<I> recipeOutput = this.recipeBookmark.getRecipeOutput();
        R recipe = this.recipeBookmark.getRecipe();
        IRecipeCategory<R> recipeCategory = this.recipeBookmark.getRecipeCategory();
        this.addTooltipComponent(components, (class_2561)class_2561.method_43469((String)"jei.tooltip.bookmarks.recipe", (Object[])new Object[]{recipeCategory.getTitle()}));
        this.addBookmarkTooltipFeaturesIfEnabled(components);
        IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
        IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
        IModIdHelper modIdHelper = jeiRuntime.getJeiHelpers().getModIdHelper();
        class_2960 recipeName = recipeCategory.getRegistryName(recipe);
        if (recipeName != null && !(recipeModId = recipeName.method_12836()).equals(ingredientModId = (ingredientName = ingredientHelper.getResourceLocation(recipeOutput.getIngredient())).method_12836())) {
            String modName = modIdHelper.getFormattedModNameForModId(recipeModId);
            class_5250 recipeBy = class_2561.method_43469((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName});
            this.addTooltipComponent(components, (class_2561)recipeBy.method_27692(class_124.field_1080));
        }
        this.addTooltipComponent(components, (class_2561)class_2561.method_43473());
        List<class_2561> outputTooltip = SafeIngredientUtil.getTooltip(ingredientManager, ingredientRenderer, recipeOutput);
        this.addAllTooltipComponents(components, outputTooltip);
        List<class_2561> modIdTooltip = new ArrayList<class_2561>();
        modIdTooltip = modIdHelper.addModNameToIngredientTooltip(modIdTooltip, recipeOutput.getIngredient(), ingredientHelper);
        this.addAllTooltipComponents(components, modIdTooltip);
        return components;
    }

    private void addAllTooltipComponents(List<class_5684> tooltipComponents, List<class_2561> components) {
        for (class_2561 component : components) {
            this.addTooltipComponent(tooltipComponents, component);
        }
    }

    private void addTooltipComponent(List<class_5684> tooltipComponents, class_2561 component) {
        class_5684 clientTooltipComponent = TooltipHelper.toTooltipComponent(component);
        tooltipComponents.add(clientTooltipComponent);
    }

    private void addBookmarkTooltipFeaturesIfEnabled(List<class_5684> components) {
        List<class_5684> transferComponents = this.createTransferComponents();
        if (this.clientConfig.getBookmarkTooltipFeatures().isEmpty() && transferComponents.isEmpty()) {
            return;
        }
        if (this.clientConfig.isHoldShiftToShowBookmarkTooltipFeaturesEnabled()) {
            if (class_437.method_25442()) {
                this.addBookmarkTooltipFeatures(components);
                components.addAll(transferComponents);
            } else {
                class_5684 tooltipComponent = TooltipHelper.createKeyUsageTooltipComponent("jei.tooltip.bookmarks.tooltips.usage", class_2561.method_43472((String)"jei.key.shift"));
                components.add(tooltipComponent);
            }
        } else {
            this.addBookmarkTooltipFeatures(components);
            components.addAll(transferComponents);
        }
    }

    private void addBookmarkTooltipFeatures(List<class_5684> components) {
        for (BookmarkTooltipFeature feature : this.clientConfig.getBookmarkTooltipFeatures()) {
            Object component = this.cache.get((Object)feature);
            if (component == null) {
                IRecipeLayoutDrawable recipeLayout = this.getRecipeLayoutDrawable().orElse(null);
                if (recipeLayout == null) break;
                component = switch (feature) {
                    default -> throw new MatchException(null, null);
                    case BookmarkTooltipFeature.PREVIEW -> new PreviewTooltipComponent(recipeLayout);
                    case BookmarkTooltipFeature.INGREDIENTS -> new IngredientsTooltipComponent(recipeLayout);
                };
                this.cache.put(feature, (class_5684)component);
            }
            components.add((class_5684)component);
        }
    }

    private List<class_5684> createTransferComponents() {
        ArrayList<class_5684> results = new ArrayList<class_5684>();
        class_310 minecraft = class_310.method_1551();
        class_437 screen = minecraft.field_1755;
        class_746 player = minecraft.field_1724;
        if (player != null && screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            IRecipeTransferError recipeTransferError = this.getRecipeLayoutDrawable().flatMap(arg_0 -> RecipeBookmarkElement.lambda$createTransferComponents$0(containerScreen, (class_1657)player, arg_0)).orElse(null);
            if (recipeTransferError == null || recipeTransferError.getType().allowsTransfer) {
                IJeiKeyMapping maxTransferRecipeBookmark;
                IInternalKeyMappings keyMappings = Internal.getKeyMappings();
                IJeiKeyMapping transferRecipeBookmark = keyMappings.getTransferRecipeBookmark();
                if (!transferRecipeBookmark.isUnbound()) {
                    class_5684 transferUsage = TooltipHelper.createKeyUsageTooltipComponent("jei.tooltip.bookmarks.tooltips.transfer.usage", transferRecipeBookmark);
                    results.add(transferUsage);
                }
                if (!(maxTransferRecipeBookmark = keyMappings.getMaxTransferRecipeBookmark()).isUnbound()) {
                    class_5684 transferUsage = TooltipHelper.createKeyUsageTooltipComponent("jei.tooltip.bookmarks.tooltips.transfer.max.usage", maxTransferRecipeBookmark);
                    results.add(transferUsage);
                }
            }
        }
        return results;
    }

    private Optional<IRecipeLayoutDrawable<R>> getRecipeLayoutDrawable() {
        if (this.cachedLayoutDrawable == null) {
            IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
            IRecipeManager recipeManager = jeiRuntime.getRecipeManager();
            IFocusFactory focusFactory = jeiRuntime.getJeiHelpers().getFocusFactory();
            DrawableNineSliceTexture recipePreviewBackground = Internal.getTextures().getRecipePreviewBackground();
            this.cachedLayoutDrawable = recipeManager.createRecipeLayoutDrawable(this.recipeBookmark.getRecipeCategory(), this.recipeBookmark.getRecipe(), focusFactory.getEmptyFocusGroup(), recipePreviewBackground, 4);
        }
        return this.cachedLayoutDrawable;
    }

    @Override
    public boolean isVisible() {
        return this.recipeBookmark.isVisible();
    }

    private static /* synthetic */ Optional lambda$createTransferComponents$0(class_465 containerScreen, class_1657 player, IRecipeLayoutDrawable recipeLayout) {
        IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
        IRecipeTransferManager recipeTransferManager = jeiRuntime.getRecipeTransferManager();
        class_1703 container = containerScreen.method_17577();
        return RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, recipeLayout, player);
    }
}

