/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.ClickableIngredientInternal;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.input.handlers.NullInputHandler;
import mezz.jei.gui.input.handlers.ProxyInputHandler;
import mezz.jei.gui.overlay.elements.IngredientElement;
import mezz.jei.gui.recipes.RecipeBookmarkButton;
import mezz.jei.gui.recipes.RecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_768;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

public class RecipeGuiLayouts {
    private final List<RecipeLayoutWithButtons<?>> recipeLayoutsWithButtons = new ArrayList();
    @Nullable
    private IUserInputHandler cachedInputHandler = NullInputHandler.INSTANCE;

    public void updateLayout(ImmutableRect2i recipeLayoutsArea, int recipesPerPage) {
        RecipeLayoutWithButtons<?> firstLayout = this.recipeLayoutsWithButtons.getFirst();
        if (firstLayout == null) {
            return;
        }
        ImmutableRect2i layoutAreaWithBorder = new ImmutableRect2i(firstLayout.getRecipeLayout().getRectWithBorder());
        int recipeXOffset = this.getRecipeXOffset(layoutAreaWithBorder, recipeLayoutsArea);
        int recipeHeight = layoutAreaWithBorder.getHeight();
        int availableHeight = Math.max(recipeLayoutsArea.getHeight(), recipeHeight);
        int remainingHeight = availableHeight - recipesPerPage * recipeHeight;
        int recipeSpacing = remainingHeight / (recipesPerPage + 1);
        int spacingY = recipeHeight + recipeSpacing;
        int recipeYOffset = recipeLayoutsArea.getY() + recipeSpacing;
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            IRecipeLayoutDrawable<?> recipeLayout = recipeLayoutWithButtons.getRecipeLayout();
            class_768 rectWithBorder = recipeLayout.getRectWithBorder();
            class_768 rect = recipeLayout.getRect();
            recipeLayout.setPosition(recipeXOffset - rectWithBorder.method_3321() + rect.method_3321(), recipeYOffset - rectWithBorder.method_3322() + rect.method_3322());
            recipeYOffset += spacingY;
        }
        this.updateRecipeButtonPositions();
    }

    private void updateRecipeButtonPositions() {
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            IRecipeLayoutDrawable<?> recipeLayout = recipeLayoutWithButtons.getRecipeLayout();
            class_768 layoutArea = recipeLayout.getRect();
            GuiIconToggleButton button = recipeLayoutWithButtons.getTransferButton();
            class_768 buttonArea = recipeLayout.getRecipeTransferButtonArea();
            buttonArea.method_35778(buttonArea.method_3321() + layoutArea.method_3321());
            buttonArea.method_35781(buttonArea.method_3322() + layoutArea.method_3322());
            button.updateBounds(buttonArea);
            button = recipeLayoutWithButtons.getBookmarkButton();
            buttonArea = recipeLayout.getRecipeBookmarkButtonArea();
            buttonArea.method_35778(buttonArea.method_3321() + layoutArea.method_3321());
            buttonArea.method_35781(buttonArea.method_3322() + layoutArea.method_3322());
            button.updateBounds(buttonArea);
        }
    }

    private int getRecipeXOffset(ImmutableRect2i layoutRect, ImmutableRect2i layoutsArea) {
        if (this.recipeLayoutsWithButtons.isEmpty()) {
            return layoutsArea.getX();
        }
        int recipeWidth = layoutRect.getWidth();
        int recipeWidthWithButtons = this.recipeLayoutsWithButtons.getFirst().totalWidth();
        int buttonSpace = recipeWidthWithButtons - recipeWidth;
        int availableArea = layoutsArea.getWidth();
        if (availableArea > recipeWidth + 2 * buttonSpace) {
            return layoutsArea.getX() + (layoutsArea.getWidth() - recipeWidth) / 2;
        }
        return layoutsArea.getX() + (layoutsArea.getWidth() - recipeWidthWithButtons) / 2;
    }

    public IUserInputHandler createInputHandler() {
        return new ProxyInputHandler(() -> {
            if (this.cachedInputHandler == null) {
                List<IUserInputHandler> handlers = this.recipeLayoutsWithButtons.stream().map(RecipeLayoutWithButtons::createUserInputHandler).toList();
                this.cachedInputHandler = new CombinedInputHandler(handlers);
            }
            return this.cachedInputHandler;
        });
    }

    public void tick(@Nullable class_1703 parentContainer) {
        class_746 player = class_310.method_1551().field_1724;
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            RecipeTransferButton button = recipeLayoutWithButtons.getTransferButton();
            button.update(parentContainer, (class_1657)player);
            RecipeBookmarkButton bookmarkButton = recipeLayoutWithButtons.getBookmarkButton();
            bookmarkButton.tick();
        }
    }

    public void setRecipeLayoutsWithButtons(List<RecipeLayoutWithButtons<?>> recipeLayoutsWithButtons) {
        this.recipeLayoutsWithButtons.clear();
        this.recipeLayoutsWithButtons.addAll(recipeLayoutsWithButtons);
        this.cachedInputHandler = null;
    }

    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        return this.recipeLayoutsWithButtons.stream().map(RecipeLayoutWithButtons::getRecipeLayout).map(recipeLayout -> RecipeGuiLayouts.getRecipeLayoutIngredientUnderMouse(recipeLayout, mouseX, mouseY)).flatMap(Optional::stream);
    }

    private static Optional<IClickableIngredientInternal<?>> getRecipeLayoutIngredientUnderMouse(IRecipeLayoutDrawable<?> recipeLayout, double mouseX, double mouseY) {
        return recipeLayout.getRecipeSlotUnderMouse(mouseX, mouseY).flatMap(recipeSlot -> RecipeGuiLayouts.getClickedIngredient(recipeLayout, recipeSlot));
    }

    private static Optional<IClickableIngredientInternal<?>> getClickedIngredient(IRecipeLayoutDrawable<?> recipeLayout, IRecipeSlotDrawable recipeSlot) {
        return recipeSlot.getDisplayedIngredient().map(displayedIngredient -> {
            ImmutableRect2i area = RecipeGuiLayouts.absoluteClickedArea(recipeLayout, recipeSlot.getRect());
            IngredientElement element = new IngredientElement(displayedIngredient);
            return new ClickableIngredientInternal(element, area, false, true);
        });
    }

    private static ImmutableRect2i absoluteClickedArea(IRecipeLayoutDrawable<?> recipeLayout, class_768 area) {
        class_768 layoutArea = recipeLayout.getRect();
        return new ImmutableRect2i(area.method_3321() + layoutArea.method_3321(), area.method_3322() + layoutArea.method_3322(), area.method_3319(), area.method_3320());
    }

    public Optional<IRecipeLayoutDrawable<?>> draw(class_332 guiGraphics, int mouseX, int mouseY) {
        IRecipeLayoutDrawable<?> hoveredLayout = null;
        class_310 minecraft = class_310.method_1551();
        class_9779 deltaTracker = minecraft.method_60646();
        float partialTicks = deltaTracker.method_60637(false);
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            IRecipeLayoutDrawable<?> recipeLayout = recipeLayoutWithButtons.getRecipeLayout();
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(guiGraphics, mouseX, mouseY);
            RecipeTransferButton transferButton = recipeLayoutWithButtons.getTransferButton();
            transferButton.draw(guiGraphics, mouseX, mouseY, partialTicks);
            RecipeBookmarkButton bookmarkButton = recipeLayoutWithButtons.getBookmarkButton();
            bookmarkButton.draw(guiGraphics, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableBlend();
        return Optional.ofNullable(hoveredLayout);
    }

    public void drawTooltips(class_332 guiGraphics, int mouseX, int mouseY) {
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            recipeLayoutWithButtons.getTransferButton().drawTooltips(guiGraphics, mouseX, mouseY);
            recipeLayoutWithButtons.getBookmarkButton().drawTooltips(guiGraphics, mouseX, mouseY);
        }
    }

    public int getWidth() {
        RecipeLayoutWithButtons<?> first = this.recipeLayoutsWithButtons.getFirst();
        if (first == null) {
            return 0;
        }
        return first.totalWidth();
    }
}

