/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.recipes.RecipeBookmarkButton;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_768;

public class RecipeLayoutWithButtons<R> {
    private final IRecipeLayoutDrawable<R> recipeLayout;
    private final RecipeTransferButton transferButton;
    private final RecipeBookmarkButton bookmarkButton;

    public RecipeLayoutWithButtons(IRecipeLayoutDrawable<R> recipeLayout, RecipeTransferButton transferButton, RecipeBookmarkButton bookmarkButton) {
        this.recipeLayout = recipeLayout;
        this.transferButton = transferButton;
        this.bookmarkButton = bookmarkButton;
    }

    public IRecipeLayoutDrawable<R> getRecipeLayout() {
        return this.recipeLayout;
    }

    public RecipeTransferButton getTransferButton() {
        return this.transferButton;
    }

    public RecipeBookmarkButton getBookmarkButton() {
        return this.bookmarkButton;
    }

    public int totalWidth() {
        int buttonRight;
        class_768 buttonArea;
        class_768 area = this.recipeLayout.getRect();
        class_768 areaWithBorder = this.recipeLayout.getRectWithBorder();
        int leftBorderWidth = area.method_3321() - areaWithBorder.method_3321();
        int rightAreaWidth = areaWithBorder.method_3319() - leftBorderWidth;
        if (this.transferButton.isVisible()) {
            buttonArea = this.recipeLayout.getRecipeTransferButtonArea();
            buttonRight = buttonArea.method_3321() + buttonArea.method_3319();
            rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
        }
        if (this.bookmarkButton.isVisible()) {
            buttonArea = this.recipeLayout.getRecipeBookmarkButtonArea();
            buttonRight = buttonArea.method_3321() + buttonArea.method_3319();
            rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
        }
        return leftBorderWidth + rightAreaWidth;
    }

    public IUserInputHandler createUserInputHandler() {
        return new CombinedInputHandler(new RecipeLayoutUserInputHandler<R>(this.recipeLayout), this.bookmarkButton.createInputHandler(), this.transferButton.createInputHandler());
    }

    private static class RecipeLayoutUserInputHandler<R>
    implements IUserInputHandler {
        private final IRecipeLayoutDrawable<R> recipeLayout;

        public RecipeLayoutUserInputHandler(IRecipeLayoutDrawable<R> recipeLayout) {
            this.recipeLayout = recipeLayout;
        }

        @Override
        public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
            if (!this.recipeLayout.isMouseOver(input.getMouseX(), input.getMouseY())) {
                return Optional.empty();
            }
            class_768 recipeArea = this.recipeLayout.getRect();
            double recipeMouseX = input.getMouseX() - (double)recipeArea.method_3321();
            double recipeMouseY = input.getMouseY() - (double)recipeArea.method_3322();
            R recipe = this.recipeLayout.getRecipe();
            IRecipeCategory<R> recipeCategory = this.recipeLayout.getRecipeCategory();
            if (recipeCategory.handleInput(recipe, recipeMouseX, recipeMouseY, input.getKey())) {
                return Optional.of(this);
            }
            if (input.is(keyBindings.getCopyRecipeId()) && this.handleCopyRecipeId(this.recipeLayout)) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        private boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout) {
            R recipe;
            class_310 minecraft = class_310.method_1551();
            class_746 player = minecraft.field_1724;
            IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
            class_2960 registryName = recipeCategory.getRegistryName(recipe = recipeLayout.getRecipe());
            if (registryName == null) {
                class_5250 message = class_2561.method_43471((String)"jei.message.copy.recipe.id.failure");
                if (player != null) {
                    player.method_7353((class_2561)message, false);
                }
                return false;
            }
            String recipeId = registryName.toString();
            minecraft.field_1774.method_1455(recipeId);
            class_5250 message = class_2561.method_43469((String)"jei.message.copy.recipe.id.success", (Object[])new Object[]{class_2561.method_43470((String)recipeId)});
            if (player != null) {
                player.method_7353((class_2561)message, false);
            }
            return true;
        }
    }
}

