/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.List;
import java.util.Set;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.config.RecipeSorterStage;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_2561;

public class RecipeSortStateButton
extends GuiIconToggleButton {
    private final RecipeSorterStage recipeSorterStage;
    private final class_2561 disabledTooltip;
    private final class_2561 enabledTooltip;
    private final Runnable onValueChanged;
    private boolean toggledOn;

    public RecipeSortStateButton(RecipeSorterStage recipeSorterStage, IDrawable offIcon, IDrawable onIcon, class_2561 disabledTooltip, class_2561 enabledTooltip, Runnable onValueChanged) {
        super(offIcon, onIcon);
        this.recipeSorterStage = recipeSorterStage;
        this.disabledTooltip = disabledTooltip;
        this.enabledTooltip = enabledTooltip;
        this.onValueChanged = onValueChanged;
        this.tick();
    }

    @Override
    protected void getTooltips(List<class_2561> tooltip) {
        if (this.toggledOn) {
            tooltip.add(this.enabledTooltip);
        } else {
            tooltip.add(this.disabledTooltip);
        }
    }

    @Override
    public void tick() {
        IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
        IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        Set<RecipeSorterStage> recipeSorterStages = clientConfig.getRecipeSorterStages();
        boolean toggledOn = recipeSorterStages.contains((Object)this.recipeSorterStage);
        if (toggledOn != this.toggledOn) {
            this.toggledOn = toggledOn;
            this.onValueChanged.run();
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.toggledOn;
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (!input.isSimulate()) {
            IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
            IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
            if (this.toggledOn) {
                clientConfig.disableRecipeSorterStage(this.recipeSorterStage);
                this.toggledOn = false;
            } else {
                clientConfig.enableRecipeSorterStage(this.recipeSorterStage);
                this.toggledOn = true;
            }
            this.onValueChanged.run();
        }
        return true;
    }
}

