/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.Internal;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeBookmarkButton;
import mezz.jei.gui.recipes.RecipeCatalysts;
import mezz.jei.gui.recipes.RecipeGuiLayouts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipeOptionButtons;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.recipes.lookups.StaticFocusedRecipes;
import net.minecraft.class_1703;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class RecipesGui
extends class_437
implements IRecipesGui,
IRecipeFocusSource {
    private static final int borderPadding = 6;
    private static final int minRecipePadding = 4;
    private static final int navBarPadding = 2;
    private static final int titleInnerPadding = 14;
    private static final int smallButtonWidth = 13;
    private static final int smallButtonHeight = 13;
    private static final int minGuiWidth = 198;
    private final IInternalKeyMappings keyBindings;
    private final IRecipeManager recipeManager;
    private final BookmarkList bookmarks;
    private final IGuiHelper guiHelper;
    private final IFocusFactory focusFactory;
    private final IIngredientManager ingredientManager;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final RecipeGuiLayouts layouts;
    private String pageString = "1/1";
    private class_2561 title = class_5244.field_39003;
    private final DrawableNineSliceTexture background;
    private final RecipeCatalysts recipeCatalysts;
    private final RecipeGuiTabs recipeGuiTabs;
    private final RecipeOptionButtons optionButtons;
    private final CombinedInputHandler inputHandler;
    private final GuiIconButton nextRecipeCategory;
    private final GuiIconButton previousRecipeCategory;
    private final GuiIconButton nextPage;
    private final GuiIconButton previousPage;
    @Nullable
    private class_437 parentScreen;
    private ImmutableRect2i idealArea = ImmutableRect2i.EMPTY;
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;
    private ImmutableRect2i titleArea = ImmutableRect2i.EMPTY;
    private ImmutableRect2i titleStringArea = ImmutableRect2i.EMPTY;
    private boolean init = false;

    public RecipesGui(IRecipeManager recipeManager, IRecipeTransferManager recipeTransferManager, IIngredientManager ingredientManager, IInternalKeyMappings keyBindings, IFocusFactory focusFactory, BookmarkList bookmarks, IGuiHelper guiHelper) {
        super((class_2561)class_2561.method_43470((String)"Recipes"));
        this.recipeManager = recipeManager;
        this.bookmarks = bookmarks;
        this.guiHelper = guiHelper;
        this.ingredientManager = ingredientManager;
        this.keyBindings = keyBindings;
        this.logic = new RecipeGuiLogic(recipeManager, recipeTransferManager, this::updateLayout, focusFactory, this::createRecipeLayoutWithButtons);
        this.recipeCatalysts = new RecipeCatalysts(recipeManager);
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic, recipeManager, guiHelper);
        this.optionButtons = new RecipeOptionButtons(this.logic::goToFirstPage);
        this.focusFactory = focusFactory;
        this.field_22787 = class_310.method_1551();
        this.layouts = new RecipeGuiLayouts();
        Textures textures = Internal.getTextures();
        IDrawableStatic arrowNext = textures.getArrowNext();
        IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        this.nextRecipeCategory = new GuiIconButton(0, 0, 13, 13, arrowNext, b -> this.logic.nextRecipeCategory());
        this.previousRecipeCategory = new GuiIconButton(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousRecipeCategory());
        this.nextPage = new GuiIconButton(0, 0, 13, 13, arrowNext, b -> this.logic.nextPage());
        this.previousPage = new GuiIconButton(0, 0, 13, 13, arrowPrevious, b -> this.logic.previousPage());
        this.background = textures.getRecipeGuiBackground();
        this.inputHandler = new CombinedInputHandler(new UserInputHandler(this), this.layouts.createInputHandler(), this.optionButtons.createInputHandler(), this.recipeGuiTabs.createInputHandler(), this.nextRecipeCategory.createInputHandler(), this.previousRecipeCategory.createInputHandler(), this.nextPage.createInputHandler(), this.previousPage.createInputHandler());
    }

    private static void drawCenteredStringWithShadow(class_332 guiGraphics, class_327 font, String string, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, string);
        guiGraphics.method_25303(font, string, textArea.getX(), textArea.getY(), -1);
    }

    private static void drawCenteredStringWithShadow(class_332 guiGraphics, class_327 font, class_2561 text, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, (class_5348)text);
        guiGraphics.method_27535(font, text, textArea.getX(), textArea.getY(), -1);
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public int getLeftSideExtraWidth() {
        if (this.recipeCatalysts.isEmpty()) {
            return this.optionButtons.getWidth();
        }
        return Math.max(this.recipeCatalysts.getWidth(), this.optionButtons.getWidth());
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25426() {
        super.method_25426();
        int xSize = 198;
        IClientConfig clientConfig = Internal.getJeiClientConfigs().getClientConfig();
        int ySize = clientConfig.isCenterSearchBarEnabled() ? this.field_22790 - 76 : this.field_22790 - 58;
        int extraSpace = 0;
        int maxHeight = clientConfig.getMaxRecipeGuiHeight();
        if (ySize > maxHeight) {
            extraSpace = ySize - maxHeight;
            ySize = maxHeight;
        }
        int guiLeft = (this.field_22789 - 198) / 2;
        int guiTop = 45 + extraSpace / 2;
        this.area = this.idealArea = new ImmutableRect2i(guiLeft, guiTop, 198, ySize);
        int rightButtonX = guiLeft + 198 - 6 - 13;
        int leftButtonX = guiLeft + 6;
        Objects.requireNonNull(this.field_22793);
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.method_46421(rightButtonX);
        this.nextRecipeCategory.method_46419(recipeClassButtonTop);
        this.previousRecipeCategory.method_46421(leftButtonX);
        this.previousRecipeCategory.method_46419(recipeClassButtonTop);
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.method_46421(rightButtonX);
        this.nextPage.method_46419(pageButtonTop);
        this.previousPage.method_46421(leftButtonX);
        this.previousPage.method_46419(pageButtonTop);
        this.headerHeight = pageButtonTop + 13 - guiTop;
        this.titleArea = MathUtil.union(this.previousRecipeCategory.getArea(), this.nextRecipeCategory.getArea()).cropLeft(this.previousRecipeCategory.method_25368() + 14).cropRight(this.nextRecipeCategory.method_25368() + 14);
        this.init = true;
        this.updateLayout();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22787 == null) {
            return;
        }
        this.method_52752(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.background.draw(guiGraphics, this.area);
        RenderSystem.disableBlend();
        guiGraphics.method_51739(class_1921.method_51784(), this.previousRecipeCategory.method_46426() + this.previousRecipeCategory.method_25368(), this.previousRecipeCategory.method_46427(), this.nextRecipeCategory.method_46426(), this.nextRecipeCategory.method_46427() + this.nextRecipeCategory.method_25364(), 0x30000000);
        guiGraphics.method_51739(class_1921.method_51784(), this.previousPage.method_46426() + this.previousPage.method_25368(), this.previousPage.method_46427(), this.nextPage.method_46426(), this.nextPage.method_46427() + this.nextPage.method_25364(), 0x30000000);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipesGui.drawCenteredStringWithShadow(guiGraphics, this.field_22793, this.title, this.titleArea);
        ImmutableRect2i pageArea = MathUtil.union(this.previousPage.getArea(), this.nextPage.getArea());
        RecipesGui.drawCenteredStringWithShadow(guiGraphics, this.field_22793, this.pageString, pageArea);
        this.nextRecipeCategory.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.nextPage.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.previousPage.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        Optional<IRecipeLayoutDrawable<?>> hoveredRecipeLayout = this.layouts.draw(guiGraphics, mouseX, mouseY);
        this.optionButtons.draw(guiGraphics, mouseX, mouseY, partialTicks);
        Optional<IRecipeSlotDrawable> hoveredRecipeCatalyst = this.recipeCatalysts.draw(guiGraphics, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.field_22787, guiGraphics, mouseX, mouseY, partialTicks);
        this.layouts.drawTooltips(guiGraphics, mouseX, mouseY);
        this.optionButtons.drawTooltips(guiGraphics, mouseX, mouseY);
        RenderSystem.disableBlend();
        hoveredRecipeLayout.ifPresent(l -> l.drawOverlays(guiGraphics, mouseX, mouseY));
        hoveredRecipeCatalyst.ifPresent(h -> h.drawHoverOverlays(guiGraphics));
        hoveredRecipeCatalyst.ifPresent(h -> h.getDisplayedIngredient().ifPresent(i -> {
            List<class_2561> tooltip = h.getTooltip();
            IModIdHelper modIdHelper = Internal.getJeiRuntime().getJeiHelpers().getModIdHelper();
            tooltip = modIdHelper.addModNameToIngredientTooltip(tooltip, i);
            TooltipRenderer.drawHoveringText(guiGraphics, tooltip, mouseX, mouseY, i);
        }));
        RenderSystem.enableDepthTest();
        if (this.titleStringArea.contains(mouseX, mouseY) && !this.logic.hasAllCategories()) {
            class_5250 showAllRecipesString = class_2561.method_43471((String)"jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText(guiGraphics, List.of(showAllRecipesString), mouseX, mouseY);
        }
        if (DebugConfig.isDebugGuisEnabled()) {
            guiGraphics.method_51739(class_1921.method_51784(), this.idealArea.getX(), this.idealArea.getY(), this.idealArea.getX() + this.idealArea.getWidth(), this.idealArea.getY() + this.idealArea.getHeight(), 0x4400FF00);
            guiGraphics.method_51739(class_1921.method_51784(), this.area.getX(), this.area.getY(), this.area.getX() + this.area.getWidth(), this.area.getY() + this.area.getHeight(), 0x44990044);
            ImmutableRect2i recipeLayoutsArea = this.getRecipeLayoutsArea();
            guiGraphics.method_51739(class_1921.method_51784(), recipeLayoutsArea.getX(), recipeLayoutsArea.getY(), recipeLayoutsArea.getX() + recipeLayoutsArea.getWidth(), recipeLayoutsArea.getY() + recipeLayoutsArea.getHeight(), 0x44228844);
        }
    }

    private static ImmutableRect2i calculateAreaToFitLayouts(ImmutableRect2i idealArea, int screenWidth, int recipeWidth) {
        if (recipeWidth == 0) {
            return idealArea;
        }
        int padding = 12;
        int width = 186;
        width = Math.max(recipeWidth, width);
        int newWidth = width + 12;
        int newX = (screenWidth - newWidth) / 2;
        return new ImmutableRect2i(newX, idealArea.getY(), newWidth, idealArea.getHeight());
    }

    public void method_25393() {
        super.method_25393();
        class_1703 container = this.getParentContainerMenu();
        this.layouts.tick(container);
        this.optionButtons.tick();
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (this.field_22787 != null && this.field_22787.field_1755 == this) {
            return this.area.contains(mouseX, mouseY) || this.optionButtons.getArea().contains(mouseX, mouseY);
        }
        return false;
    }

    @Override
    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            return Stream.concat(this.recipeCatalysts.getIngredientUnderMouse(mouseX, mouseY), this.layouts.getIngredientUnderMouse(mouseX, mouseY));
        }
        return Stream.empty();
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.inputHandler.handleMouseScrolled(mouseX, mouseY, scrollX, scrollY).isPresent()) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        boolean handled = UserInput.fromVanilla(mouseX, mouseY, mouseButton, InputType.IMMEDIATE).map(this::handleInput).orElse(false);
        if (handled) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        UserInput input = UserInput.fromVanilla(keyCode, scanCode, modifiers, InputType.IMMEDIATE);
        return this.handleInput(input);
    }

    private boolean handleInput(UserInput input) {
        return this.inputHandler.handleUserInput(this, input, this.keyBindings).isPresent();
    }

    public boolean isOpen() {
        return this.field_22787 != null && this.field_22787.field_1755 == this;
    }

    private void open() {
        if (this.field_22787 != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.field_22787.field_1755;
            }
            this.field_22787.method_1507((class_437)this);
        }
    }

    public void method_25419() {
        if (this.isOpen() && this.field_22787 != null) {
            this.field_22787.method_1507(this.parentScreen);
            this.parentScreen = null;
            this.logic.clearHistory();
            return;
        }
        super.method_25419();
    }

    @Override
    public void show(List<IFocus<?>> focuses) {
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        if (this.logic.showFocus(checkedFocuses)) {
            this.open();
        }
    }

    @Override
    public void showTypes(List<RecipeType<?>> recipeTypes) {
        ErrorUtil.checkNotEmpty(recipeTypes, "recipeTypes");
        if (this.logic.showCategories(recipeTypes)) {
            this.open();
        }
    }

    @Override
    public <T> void showRecipes(IRecipeCategory<T> recipeCategory, List<T> recipes, List<IFocus<?>> focuses) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ErrorUtil.checkNotEmpty(recipes, "recipes");
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        StaticFocusedRecipes<T> focusedRecipes = new StaticFocusedRecipes<T>(recipeCategory, recipes);
        if (this.logic.showRecipes(focusedRecipes, checkedFocuses)) {
            this.open();
        }
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        double x = MouseUtil.getX();
        double y = MouseUtil.getY();
        return this.getIngredientUnderMouse(x, y).map(IClickableIngredientInternal::getTypedIngredient).flatMap(i -> i.getIngredient(ingredientType).stream()).findFirst();
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        if (!this.init) {
            return;
        }
        IRecipeCategory<?> recipeCategory = this.logic.getSelectedRecipeCategory();
        this.title = StringUtil.stripStyling(recipeCategory.getTitle());
        int availableTitleWidth = this.titleArea.getWidth();
        if (this.field_22793.method_27525((class_5348)this.title) > availableTitleWidth) {
            this.title = StringUtil.truncateStringToWidth(this.title, availableTitleWidth, this.field_22793);
        }
        this.titleStringArea = MathUtil.centerTextArea(this.titleArea, this.field_22793, (class_5348)this.title);
        ImmutableRect2i recipeLayoutsArea = this.getRecipeLayoutsArea();
        int availableHeight = recipeLayoutsArea.getHeight();
        class_1703 containerMenu = this.getParentContainerMenu();
        List<RecipeLayoutWithButtons<?>> recipeLayoutsWithButtons = this.logic.getVisibleRecipeLayoutsWithButtons(availableHeight, 4, containerMenu);
        int recipesPerPage = this.logic.getRecipesPerPage();
        this.layouts.setRecipeLayoutsWithButtons(recipeLayoutsWithButtons);
        this.layouts.tick(containerMenu);
        this.area = RecipesGui.calculateAreaToFitLayouts(this.idealArea, this.field_22789, this.layouts.getWidth());
        recipeLayoutsArea = this.getRecipeLayoutsArea();
        this.layouts.updateLayout(recipeLayoutsArea, recipesPerPage);
        this.nextPage.field_22763 = this.previousPage.field_22763 = this.logic.hasMultiplePages();
        this.nextRecipeCategory.field_22763 = this.previousRecipeCategory.field_22763 = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        this.optionButtons.updateLayout(this.area);
        ImmutableRect2i optionButtonsArea = this.optionButtons.getArea();
        List<ITypedIngredient<?>> recipeCatalystIngredients = this.logic.getRecipeCatalysts().toList();
        this.recipeCatalysts.updateLayout(recipeCatalystIngredients, this.area, optionButtonsArea);
        this.recipeGuiTabs.initLayout(this.idealArea);
    }

    private ImmutableRect2i getRecipeLayoutsArea() {
        return new ImmutableRect2i(this.area.getX() + 6, this.area.getY() + this.headerHeight + 2, this.area.getWidth() - 12, this.area.getHeight() - (this.headerHeight + 6 + 2));
    }

    private <T> RecipeLayoutWithButtons<T> createRecipeLayoutWithButtons(IRecipeLayoutDrawable<T> recipeLayoutDrawable) {
        RecipeTransferButton transferButton = RecipeTransferButton.create(recipeLayoutDrawable, this::method_25419);
        RecipeBookmarkButton bookmarkButton = RecipeBookmarkButton.create(recipeLayoutDrawable, this.ingredientManager, this.bookmarks, this.recipeManager, this.guiHelper);
        return new RecipeLayoutWithButtons<T>(recipeLayoutDrawable, transferButton, bookmarkButton);
    }

    @Nullable
    private class_1703 getParentContainerMenu() {
        class_437 screen = this.parentScreen == null ? class_310.method_1551().field_1755 : this.parentScreen;
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            return containerScreen.method_17577();
        }
        return null;
    }

    @Nullable
    public IGuiProperties getProperties() {
        if (this.field_22789 <= 0 || this.field_22790 <= 0) {
            return null;
        }
        int extraWidth = this.getLeftSideExtraWidth();
        ImmutableRect2i recipeArea = this.getArea();
        int guiXSize = recipeArea.getWidth() + extraWidth;
        int guiYSize = recipeArea.getHeight();
        if (guiXSize <= 0 || guiYSize <= 0) {
            return null;
        }
        return new GuiProperties(this.getClass(), recipeArea.getX() - extraWidth, recipeArea.getY(), guiXSize, guiYSize, this.field_22789, this.field_22790);
    }

    private static class UserInputHandler
    implements IUserInputHandler {
        private final RecipesGui recipesGui;

        public UserInputHandler(RecipesGui recipesGui) {
            this.recipesGui = recipesGui;
        }

        @Override
        public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
            double mouseY;
            double mouseX = input.getMouseX();
            if (this.recipesGui.method_25405(mouseX, mouseY = input.getMouseY()) && this.recipesGui.titleStringArea.contains(mouseX, mouseY) && input.is(keyBindings.getLeftClick()) && this.recipesGui.logic.showAllRecipes()) {
                return Optional.of(this);
            }
            class_310 minecraft = class_310.method_1551();
            if (input.is(keyBindings.getCloseRecipeGui()) || input.is(minecraft.field_1690.field_1822)) {
                this.recipesGui.method_25419();
                return Optional.of(this);
            }
            if (input.is(keyBindings.getRecipeBack())) {
                this.recipesGui.back();
                return Optional.of(this);
            }
            if (input.is(keyBindings.getNextCategory())) {
                this.recipesGui.logic.nextRecipeCategory();
                return Optional.of(this);
            }
            if (input.is(keyBindings.getPreviousCategory())) {
                this.recipesGui.logic.previousRecipeCategory();
                return Optional.of(this);
            }
            if (input.is(keyBindings.getNextRecipePage())) {
                this.recipesGui.logic.nextPage();
                return Optional.of(this);
            }
            if (input.is(keyBindings.getPreviousRecipePage())) {
                this.recipesGui.logic.previousPage();
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
            if (this.recipesGui.method_25405(mouseX, mouseY)) {
                if (scrollDeltaY < 0.0) {
                    this.recipesGui.logic.nextPage();
                    return Optional.of(this);
                }
                if (scrollDeltaY > 0.0) {
                    this.recipesGui.logic.previousPage();
                    return Optional.of(this);
                }
            }
            return Optional.empty();
        }
    }
}

