/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.TooltipHelper;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.library.gui.ingredients.RecipeSlot;
import mezz.jei.library.gui.ingredients.RecipeSlots;
import mezz.jei.library.gui.ingredients.TagContentTooltipComponent;
import mezz.jei.library.gui.recipes.OutputSlotTooltipCallback;
import mezz.jei.library.gui.recipes.RecipeLayoutBuilder;
import mezz.jei.library.gui.recipes.ShapelessIcon;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import net.minecraft.class_768;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RecipeLayout<R>
implements IRecipeLayoutDrawable<R> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_RECIPE_BORDER_PADDING = 4;
    public static final int RECIPE_BUTTON_SIZE = 13;
    public static final int RECIPE_BUTTON_SPACING = 2;
    private final int ingredientCycleOffset = (int)(Math.random() * 10000.0 % 2.147483647E9);
    private final IRecipeCategory<R> recipeCategory;
    private final Collection<IRecipeCategoryDecorator<R>> recipeCategoryDecorators;
    private final RecipeSlots recipeSlots;
    private final R recipe;
    private final IScalableDrawable recipeBackground;
    private final int recipeBorderPadding;
    private ImmutableRect2i recipeTransferButtonArea;
    @Nullable
    private ShapelessIcon shapelessIcon;
    private ImmutableRect2i area;

    public static <T> Optional<IRecipeLayoutDrawable<T>> create(IRecipeCategory<T> recipeCategory, Collection<IRecipeCategoryDecorator<T>> decorators, T recipe, IFocusGroup focuses, IIngredientManager ingredientManager) {
        DrawableNineSliceTexture recipeBackground = Internal.getTextures().getRecipeBackground();
        return RecipeLayout.create(recipeCategory, decorators, recipe, focuses, ingredientManager, recipeBackground, 4);
    }

    public static <T> Optional<IRecipeLayoutDrawable<T>> create(IRecipeCategory<T> recipeCategory, Collection<IRecipeCategoryDecorator<T>> decorators, T recipe, IFocusGroup focuses, IIngredientManager ingredientManager, IScalableDrawable recipeBackground, int recipeBorderPadding) {
        RecipeLayout<T> recipeLayout = new RecipeLayout<T>(recipeCategory, decorators, recipe, recipeBackground, recipeBorderPadding);
        if (recipeLayout.setRecipeLayout(recipeCategory, recipe, focuses, ingredientManager)) {
            class_2960 recipeName = recipeCategory.getRegistryName(recipe);
            if (recipeName != null) {
                RecipeLayout.addOutputSlotTooltip(recipeLayout, recipeName);
            }
            return Optional.of(recipeLayout);
        }
        return Optional.empty();
    }

    private boolean setRecipeLayout(IRecipeCategory<R> recipeCategory, R recipe, IFocusGroup focuses, IIngredientManager ingredientManager) {
        RecipeLayoutBuilder builder = new RecipeLayoutBuilder(ingredientManager, this.ingredientCycleOffset);
        try {
            recipeCategory.setRecipe(builder, recipe, focuses);
            if (builder.isUsed()) {
                builder.setRecipeLayout(this, focuses);
                return true;
            }
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error caught from Recipe Category: {}", (Object)recipeCategory.getRecipeType().getUid(), (Object)e);
        }
        return false;
    }

    private static void addOutputSlotTooltip(RecipeLayout<?> recipeLayout, class_2960 recipeName) {
        RecipeSlots recipeSlots = recipeLayout.recipeSlots;
        List<RecipeSlot> outputSlots = recipeSlots.getSlots().stream().filter(r -> r.getRole() == RecipeIngredientRole.OUTPUT).toList();
        if (!outputSlots.isEmpty()) {
            OutputSlotTooltipCallback callback = new OutputSlotTooltipCallback(recipeName);
            for (RecipeSlot outputSlot : outputSlots) {
                outputSlot.addTooltipCallback(callback);
            }
        }
    }

    public RecipeLayout(IRecipeCategory<R> recipeCategory, Collection<IRecipeCategoryDecorator<R>> recipeCategoryDecorators, R recipe, IScalableDrawable recipeBackground, int recipeBorderPadding) {
        this.recipeCategory = recipeCategory;
        this.recipeCategoryDecorators = recipeCategoryDecorators;
        this.recipeSlots = new RecipeSlots();
        this.recipeBorderPadding = recipeBorderPadding;
        this.area = new ImmutableRect2i(0, 0, recipeCategory.getWidth(), recipeCategory.getHeight());
        this.recipeTransferButtonArea = new ImmutableRect2i(this.area.getWidth() + recipeBorderPadding + 2, this.area.getHeight() + recipeBorderPadding - 13, 13, 13);
        this.recipe = recipe;
        this.recipeBackground = recipeBackground;
    }

    @Override
    public void setPosition(int posX, int posY) {
        this.area = new ImmutableRect2i(posX, posY, this.recipeCategory.getWidth(), this.recipeCategory.getHeight());
    }

    @Override
    public void drawRecipe(class_332 guiGraphics, int mouseX, int mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.recipeBackground.draw(guiGraphics, this.getRectWithBorder());
        int recipeMouseX = mouseX - this.area.getX();
        int recipeMouseY = mouseY - this.area.getY();
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)this.area.getX(), (float)this.area.getY(), 0.0f);
        background.draw(guiGraphics);
        poseStack.method_22903();
        this.recipeCategory.draw(this.recipe, this.recipeSlots.getView(), guiGraphics, recipeMouseX, recipeMouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22909();
        for (IRecipeCategoryDecorator<R> decorator : this.recipeCategoryDecorators) {
            poseStack.method_22903();
            decorator.draw(this.recipe, this.recipeCategory, this.recipeSlots.getView(), guiGraphics, recipeMouseX, recipeMouseY);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.method_22909();
        }
        if (this.shapelessIcon != null) {
            this.shapelessIcon.draw(guiGraphics);
        }
        this.recipeSlots.draw(guiGraphics);
        poseStack.method_22909();
        RenderSystem.disableBlend();
    }

    @Override
    public void drawOverlays(class_332 guiGraphics, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int recipeMouseX = mouseX - this.area.getX();
        int recipeMouseY = mouseY - this.area.getY();
        IRecipeSlotDrawable hoveredSlot = this.recipeSlots.getHoveredSlot(recipeMouseX, recipeMouseY).orElse(null);
        RenderSystem.disableBlend();
        class_4587 poseStack = guiGraphics.method_51448();
        if (hoveredSlot != null) {
            poseStack.method_22903();
            poseStack.method_46416((float)this.area.getX(), (float)this.area.getY(), 0.0f);
            hoveredSlot.drawHoverOverlays(guiGraphics);
            poseStack.method_22909();
            IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
            IModIdHelper modIdHelper = jeiRuntime.getJeiHelpers().getModIdHelper();
            hoveredSlot.getDisplayedIngredient().ifPresent(i -> {
                List components = hoveredSlot.getTooltip().stream().map(TooltipHelper::toTooltipComponent).collect(Collectors.toCollection(ArrayList::new));
                this.addTagContentTooltip(components, (ITypedIngredient)i, hoveredSlot);
                List<class_2561> modIdTooltip = new ArrayList<class_2561>();
                modIdTooltip = modIdHelper.addModNameToIngredientTooltip(modIdTooltip, i);
                this.addAllTooltipComponents(components, modIdTooltip);
                TooltipRenderer.drawHoveringTooltip(guiGraphics, components, mouseX, mouseY, i);
            });
        } else if (this.isMouseOver(mouseX, mouseY)) {
            List<class_2561> tooltipStrings = this.recipeCategory.getTooltipStrings(this.recipe, this.recipeSlots.getView(), recipeMouseX, recipeMouseY);
            for (IRecipeCategoryDecorator<R> decorator : this.recipeCategoryDecorators) {
                tooltipStrings = decorator.decorateExistingTooltips(tooltipStrings, this.recipe, this.recipeCategory, this.recipeSlots.getView(), recipeMouseX, recipeMouseY);
            }
            if (tooltipStrings.isEmpty() && this.shapelessIcon != null) {
                tooltipStrings = this.shapelessIcon.getTooltipStrings(recipeMouseX, recipeMouseY);
            }
            if (!tooltipStrings.isEmpty()) {
                TooltipRenderer.drawHoveringText(guiGraphics, tooltipStrings, mouseX, mouseY);
            }
        }
    }

    private void addAllTooltipComponents(List<class_5684> tooltipComponents, List<class_2561> components) {
        tooltipComponents.addAll(TooltipHelper.toTooltipComponents(components));
    }

    private <T> void addTagContentTooltip(List<class_5684> tooltipComponents, ITypedIngredient<T> displayed, IRecipeSlotDrawable slotDrawable) {
        IClientConfig clientConfig = Internal.getJeiClientConfigs().getClientConfig();
        if (clientConfig.isTagContentTooltipEnabled()) {
            IIngredientType<T> type = displayed.getType();
            IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
            IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
            IIngredientRenderer<T> renderer = ingredientManager.getIngredientRenderer(type);
            List<T> ingredients = slotDrawable.getIngredients(type).toList();
            if (ingredients.size() > 1) {
                tooltipComponents.add(new TagContentTooltipComponent<T>(renderer, ingredients));
            }
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.contains(this.area, mouseX, mouseY);
    }

    @Override
    public class_768 getRect() {
        return this.area.toMutable();
    }

    @Override
    public class_768 getRectWithBorder() {
        return this.area.expandBy(this.recipeBorderPadding).toMutable();
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(int mouseX, int mouseY, IIngredientType<T> ingredientType) {
        return this.getRecipeSlotUnderMouse(mouseX, mouseY).flatMap(slot -> slot.getDisplayedIngredient(ingredientType));
    }

    @Override
    public Optional<IRecipeSlotDrawable> getRecipeSlotUnderMouse(double mouseX, double mouseY) {
        double recipeMouseX = mouseX - (double)this.area.getX();
        double recipeMouseY = mouseY - (double)this.area.getY();
        return this.recipeSlots.getHoveredSlot(recipeMouseX, recipeMouseY).map(r -> r);
    }

    public void moveRecipeTransferButton(int posX, int posY) {
        this.recipeTransferButtonArea = new ImmutableRect2i(posX, posY, 13, 13);
    }

    public void setShapeless() {
        this.shapelessIcon = new ShapelessIcon();
        int x = this.area.getWidth() - this.shapelessIcon.getIcon().getWidth();
        this.shapelessIcon.setPosition(x, 0);
    }

    public void setShapeless(int shapelessX, int shapelessY) {
        this.shapelessIcon = new ShapelessIcon();
        this.shapelessIcon.setPosition(shapelessX, shapelessY);
    }

    @Override
    public IRecipeCategory<R> getRecipeCategory() {
        return this.recipeCategory;
    }

    @Override
    public class_768 getRecipeTransferButtonArea() {
        return this.recipeTransferButtonArea.toMutable();
    }

    @Override
    public class_768 getRecipeBookmarkButtonArea() {
        class_768 area = this.getRecipeTransferButtonArea();
        area.method_35779(area.method_3321(), area.method_3322() - area.method_3320() - 2);
        return area;
    }

    @Override
    public IRecipeSlotsView getRecipeSlotsView() {
        return this.recipeSlots.getView();
    }

    @Override
    public R getRecipe() {
        return this.recipe;
    }

    public RecipeSlots getRecipeSlots() {
        return this.recipeSlots;
    }
}

