/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;

public class IngredientSet<V>
extends AbstractSet<V> {
    private final IIngredientHelper<V> ingredientHelper;
    private final UidContext context;
    private final Map<String, V> ingredients;

    public IngredientSet(IIngredientHelper<V> ingredientHelper, UidContext context) {
        this.ingredientHelper = ingredientHelper;
        this.context = context;
        this.ingredients = new LinkedHashMap<String, V>();
    }

    private String getUid(V ingredient) {
        return this.ingredientHelper.getUniqueId(ingredient, this.context);
    }

    @Override
    public boolean add(V v) {
        String uid = this.getUid(v);
        return this.ingredients.put(uid, v) == null;
    }

    @Override
    public boolean remove(Object o) {
        String uid = this.getUid(o);
        return this.ingredients.remove(uid) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof IngredientSet) {
            return super.removeAll(c);
        }
        Objects.requireNonNull(c);
        boolean modified = false;
        for (Object aC : c) {
            modified |= this.remove(aC);
        }
        return modified;
    }

    @Override
    public boolean contains(Object o) {
        String uid = this.getUid(o);
        return this.ingredients.containsKey(uid);
    }

    public Optional<V> getByUid(String uid) {
        V v = this.ingredients.get(uid);
        return Optional.ofNullable(v);
    }

    @Override
    public void clear() {
        this.ingredients.clear();
    }

    @Override
    public Iterator<V> iterator() {
        return this.ingredients.values().iterator();
    }

    @Override
    public int size() {
        return this.ingredients.size();
    }
}

