/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.anvil;

import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.IExtendableSmithingRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_8059;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class SmithingRecipeCategory
implements IRecipeCategory<class_8786<class_8059>>,
IExtendableSmithingRecipeCategory {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable recipeArrow;
    private final Map<Class<? extends class_8059>, ISmithingCategoryExtension<?>> extensions = new HashMap();

    public SmithingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(108, 28);
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableItemStack(new class_1799((class_1935)class_2246.field_16329));
        Textures textures = Internal.getTextures();
        this.recipeArrow = textures.getRecipeArrow();
    }

    @Override
    public RecipeType<class_8786<class_8059>> getRecipeType() {
        return RecipeTypes.SMITHING;
    }

    @Override
    public class_2561 getTitle() {
        return class_2246.field_16329.method_9518();
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<class_8059> recipeHolder, IFocusGroup focuses) {
        class_8059 recipe = (class_8059)recipeHolder.comp_1933();
        ISmithingCategoryExtension<class_8059> extension = this.getExtension(recipe);
        if (extension == null) {
            return;
        }
        IRecipeSlotBuilder template = builder.addSlot(RecipeIngredientRole.INPUT, 1, 6).setBackground(this.slot, -1, -1);
        IRecipeSlotBuilder base = builder.addSlot(RecipeIngredientRole.INPUT, 19, 6).setBackground(this.slot, -1, -1);
        IRecipeSlotBuilder addition = builder.addSlot(RecipeIngredientRole.INPUT, 37, 6).setBackground(this.slot, -1, -1);
        extension.setTemplate(recipe, template);
        extension.setBase(recipe, base);
        extension.setAddition(recipe, addition);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 6).addItemStack(RecipeUtil.getResultItem(recipe))).setBackground(this.slot, -1, -1);
    }

    @Override
    public void draw(class_8786<class_8059> recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.recipeArrow.draw(guiGraphics, 61, 7);
    }

    @Override
    public boolean isHandled(class_8786<class_8059> recipeHolder) {
        class_8059 recipe = (class_8059)recipeHolder.comp_1933();
        ISmithingCategoryExtension extension = this.getExtension(recipe);
        return extension != null;
    }

    @Override
    public class_2960 getRegistryName(class_8786<class_8059> recipe) {
        return recipe.comp_1932();
    }

    @Override
    public <R extends class_8059> void addExtension(Class<? extends R> recipeClass, ISmithingCategoryExtension<R> extension) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ErrorUtil.checkNotNull(extension, "extension");
        if (this.extensions.containsKey(recipeClass)) {
            throw new IllegalArgumentException("An extension has already been registered for: " + String.valueOf(recipeClass));
        }
        this.extensions.put(recipeClass, extension);
    }

    @Nullable
    private <R extends class_8059> ISmithingCategoryExtension<? super R> getExtension(class_8059 recipe) {
        ISmithingCategoryExtension<?> extension = this.extensions.get(recipe.getClass());
        if (extension != null) {
            return extension;
        }
        for (Map.Entry<Class<class_8059>, ISmithingCategoryExtension<?>> e : this.extensions.entrySet()) {
            if (!e.getKey().isInstance(recipe)) continue;
            return e.getValue();
        }
        return null;
    }
}

