/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.brewing;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.library.plugins.vanilla.brewing.BrewingRecipeUtil;
import mezz.jei.library.plugins.vanilla.brewing.PotionSubtypeInterpreter;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class JeiBrewingRecipe
implements IJeiBrewingRecipe {
    private final List<class_1799> ingredients;
    private final List<class_1799> potionInputs;
    private final class_1799 potionOutput;
    @Nullable
    private final class_2960 uid;
    private final BrewingRecipeUtil brewingRecipeUtil;
    private final int hashCode;

    public JeiBrewingRecipe(List<class_1799> ingredients, List<class_1799> potionInputs, class_1799 potionOutput, @Nullable class_2960 uid, BrewingRecipeUtil brewingRecipeUtil) {
        this.ingredients = List.copyOf(ingredients);
        this.potionInputs = List.copyOf(potionInputs);
        this.potionOutput = potionOutput;
        this.uid = uid;
        this.brewingRecipeUtil = brewingRecipeUtil;
        brewingRecipeUtil.addRecipe(potionInputs, potionOutput);
        this.hashCode = uid != null ? uid.hashCode() : Objects.hash(ingredients.stream().map(class_1799::method_7909).toList(), potionInputs.stream().map(class_1799::method_7909).toList(), potionOutput.method_7909());
    }

    @Override
    public List<class_1799> getPotionInputs() {
        return this.potionInputs;
    }

    @Override
    public List<class_1799> getIngredients() {
        return this.ingredients;
    }

    @Override
    public class_1799 getPotionOutput() {
        return this.potionOutput;
    }

    @Override
    @Nullable
    public class_2960 getUid() {
        return this.uid;
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof JeiBrewingRecipe)) {
            return false;
        }
        JeiBrewingRecipe other = (JeiBrewingRecipe)obj;
        if (this.uid != null) {
            return this.uid.equals((Object)other.uid);
        }
        for (i = 0; i < this.potionInputs.size(); ++i) {
            class_1799 otherPotionInput;
            class_1799 potionInput = this.potionInputs.get(i);
            if (JeiBrewingRecipe.arePotionsEqual(potionInput, otherPotionInput = other.potionInputs.get(i))) continue;
            return false;
        }
        if (!JeiBrewingRecipe.arePotionsEqual(other.potionOutput, this.potionOutput)) {
            return false;
        }
        if (this.ingredients.size() != other.ingredients.size()) {
            return false;
        }
        for (i = 0; i < this.ingredients.size(); ++i) {
            if (class_1799.method_7973((class_1799)this.ingredients.get(i), (class_1799)other.ingredients.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean arePotionsEqual(class_1799 potion1, class_1799 potion2) {
        String key1 = PotionSubtypeInterpreter.INSTANCE.apply(potion1, UidContext.Recipe);
        String key2 = PotionSubtypeInterpreter.INSTANCE.apply(potion2, UidContext.Recipe);
        return Objects.equals(key1, key2);
    }

    @Override
    public int getBrewingSteps() {
        return this.brewingRecipeUtil.getBrewingSteps(this.potionOutput);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        class_1799 input = this.potionInputs.getFirst();
        String inputName = PotionSubtypeInterpreter.INSTANCE.apply(input, UidContext.Recipe);
        String outputName = PotionSubtypeInterpreter.INSTANCE.apply(this.potionOutput, UidContext.Recipe);
        return String.valueOf(this.ingredients) + " + [" + String.valueOf(input.method_7909()) + " " + inputName + "] = [" + String.valueOf(this.potionOutput) + " " + outputName + "]";
    }
}

