/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.cooking;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.common.Constants;
import mezz.jei.library.plugins.vanilla.cooking.FurnaceVariantCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8786;

public abstract class AbstractCookingCategory<T extends class_1874>
extends FurnaceVariantCategory<class_8786<T>> {
    private final IDrawable background;
    private final int regularCookTime;
    private final IDrawable icon;
    private final class_2561 localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public AbstractCookingCategory(final IGuiHelper guiHelper, class_2248 icon, String translationKey, int regularCookTime) {
        super(guiHelper);
        this.background = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 114, 82, 54);
        this.regularCookTime = regularCookTime;
        this.icon = guiHelper.createDrawableItemStack(new class_1799((class_1935)icon));
        this.localizedName = class_2561.method_43471((String)translationKey);
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(this){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(cookTime, IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    protected IDrawableAnimated getArrow(class_8786<T> recipeHolder) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        int cookTime = recipe.method_8167();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void draw(class_8786<T> recipeHolder, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.animatedFlame.draw(guiGraphics, 1, 20);
        IDrawableAnimated arrow = this.getArrow(recipeHolder);
        arrow.draw(guiGraphics, 24, 18);
        this.drawExperience(recipeHolder, guiGraphics, 0);
        this.drawCookTime(recipeHolder, guiGraphics, 45);
    }

    protected void drawExperience(class_8786<T> recipeHolder, class_332 guiGraphics, int y) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        float experience = recipe.method_8171();
        if (experience > 0.0f) {
            class_5250 experienceString = class_2561.method_43469((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            class_310 minecraft = class_310.method_1551();
            class_327 fontRenderer = minecraft.field_1772;
            int stringWidth = fontRenderer.method_27525((class_5348)experienceString);
            guiGraphics.method_51439(fontRenderer, (class_2561)experienceString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    protected void drawCookTime(class_8786<T> recipeHolder, class_332 guiGraphics, int y) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        int cookTime = recipe.method_8167();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            class_5250 timeString = class_2561.method_43469((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            class_310 minecraft = class_310.method_1551();
            class_327 fontRenderer = minecraft.field_1772;
            int stringWidth = fontRenderer.method_27525((class_5348)timeString);
            guiGraphics.method_51439(fontRenderer, (class_2561)timeString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<T> recipeHolder, IFocusGroup focuses) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((class_1856)recipe.method_8117().getFirst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 19).addItemStack(RecipeUtil.getResultItem(recipe));
    }

    @Override
    public boolean isHandled(class_8786<T> recipeHolder) {
        class_1874 recipe = (class_1874)recipeHolder.comp_1933();
        return !recipe.method_8118();
    }

    @Override
    public class_2960 getRegistryName(class_8786<T> recipe) {
        return recipe.comp_1932();
    }
}

