/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.data.MobCapDataHandler;
import fi.dy.masa.minihud.mixin.IMixinServerWorld;
import fi.dy.masa.minihud.mixin.IMixinWorldRenderer;
import fi.dy.masa.minihud.mixin.entity.IMixinPassiveEntity;
import fi.dy.masa.minihud.mixin.entity.IMixinSkeletonEntity;
import fi.dy.masa.minihud.mixin.entity.IMixinZombieEntity;
import fi.dy.masa.minihud.mixin.entity.IMixinZombieVillagerEntity;
import fi.dy.masa.minihud.renderer.InventoryOverlayHandler;
import fi.dy.masa.minihud.renderer.OverlayRenderer;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.IServerEntityManager;
import fi.dy.masa.minihud.util.MiscUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1132;
import net.minecraft.class_1266;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1433;
import net.minecraft.class_1440;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1462;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1474;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1501;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_156;
import net.minecraft.class_1613;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2599;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3568;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4019;
import net.minecraft.class_4184;
import net.minecraft.class_4481;
import net.minecraft.class_4482;
import net.minecraft.class_4604;
import net.minecraft.class_5134;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5537;
import net.minecraft.class_5762;
import net.minecraft.class_6025;
import net.minecraft.class_640;
import net.minecraft.class_6880;
import net.minecraft.class_7102;
import net.minecraft.class_7106;
import net.minecraft.class_7225;
import net.minecraft.class_7375;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9259;
import net.minecraft.class_9334;
import net.minecraft.class_9347;
import net.minecraft.class_9958;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;

public class RenderHandler
implements IRenderer {
    private static final RenderHandler INSTANCE = new RenderHandler();
    private final class_310 mc;
    private final DataStorage data;
    private final HudDataManager hudData;
    private final Date date;
    private final Map<class_1923, CompletableFuture<class_9259<class_2791>>> chunkFutures = new HashMap<class_1923, CompletableFuture<class_9259<class_2791>>>();
    private final Set<InfoToggle> addedTypes = new HashSet<InfoToggle>();
    @Nullable
    private class_2818 cachedClientChunk;
    private long infoUpdateTime;
    private final List<StringHolder> lineWrappers = new ArrayList<StringHolder>();
    private final List<String> lines = new ArrayList<String>();
    private Pair<class_2586, class_2487> lastBlockEntity = null;
    private Pair<class_1297, class_2487> lastEntity = null;

    public RenderHandler() {
        this.mc = class_310.method_1551();
        this.data = DataStorage.getInstance();
        this.hudData = HudDataManager.getInstance();
        this.date = new Date();
    }

    public static RenderHandler getInstance() {
        return INSTANCE;
    }

    public DataStorage getDataStorage() {
        return this.data;
    }

    public HudDataManager getHudData() {
        return this.hudData;
    }

    public static void fixDebugRendererState() {
    }

    public void onRenderGameOverlayPostAdvanced(class_332 drawContext, float partialTicks, class_3695 profiler, class_310 mc) {
        if (!Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue()) {
            this.resetCachedChunks();
            return;
        }
        if (!(mc.method_53526().method_53536() || mc.field_1724 == null || mc.field_1690.field_1842 || Configs.Generic.REQUIRE_SNEAK.getBooleanValue() && !mc.field_1724.method_5715() || !Configs.Generic.REQUIRED_KEY.getKeybind().isKeybindHeld())) {
            long currentTime = System.nanoTime();
            if (currentTime - this.infoUpdateTime >= 50000000L) {
                this.updateLines();
                this.infoUpdateTime = currentTime;
            }
            int x = Configs.Generic.TEXT_POS_X.getIntegerValue();
            int y = Configs.Generic.TEXT_POS_Y.getIntegerValue();
            int textColor = Configs.Colors.TEXT_COLOR.getIntegerValue();
            int bgColor = Configs.Colors.TEXT_BACKGROUND_COLOR.getIntegerValue();
            HudAlignment alignment = (HudAlignment)Configs.Generic.HUD_ALIGNMENT.getOptionListValue();
            boolean useBackground = Configs.Generic.USE_TEXT_BACKGROUND.getBooleanValue();
            boolean useShadow = Configs.Generic.USE_FONT_SHADOW.getBooleanValue();
            RenderUtils.renderText((int)x, (int)y, (double)Configs.Generic.FONT_SCALE.getDoubleValue(), (int)textColor, (int)bgColor, (HudAlignment)alignment, (boolean)useBackground, (boolean)useShadow, this.lines, (class_332)drawContext);
            RenderUtils.forceDraw((class_332)drawContext);
        }
        if (Configs.Generic.INVENTORY_PREVIEW_ENABLED.getBooleanValue() && Configs.Generic.INVENTORY_PREVIEW.getKeybind().isKeybindHeld()) {
            InventoryOverlayHandler.getInstance().getRenderContext(drawContext, profiler, mc);
        }
    }

    public void onRenderTooltipLast(class_332 drawContext, class_1799 stack, int x, int y) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1806) {
            if (Configs.Generic.MAP_PREVIEW.getBooleanValue() && (!Configs.Generic.MAP_PREVIEW_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
                RenderUtils.renderMapPreview((class_1799)stack, (int)x, (int)y, (int)Configs.Generic.MAP_PREVIEW_SIZE.getIntegerValue(), (boolean)false, (class_332)drawContext);
            }
        } else if (stack.method_57353().method_57832(class_9334.field_49622) && InventoryUtils.shulkerBoxHasItems((class_1799)stack)) {
            if (Configs.Generic.SHULKER_BOX_PREVIEW.getBooleanValue() && (!Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
                RenderUtils.renderShulkerBoxPreview((class_1799)stack, (int)x, (int)y, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue(), (class_332)drawContext);
            }
        } else if (stack.method_31574(class_1802.field_8466) && Configs.Generic.SHULKER_DISPLAY_ENDER_CHEST.getBooleanValue()) {
            class_1937 world;
            class_1657 player;
            if (Configs.Generic.SHULKER_BOX_PREVIEW.getBooleanValue() && (!Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown()) && (player = (world = WorldUtils.getBestWorld((class_310)this.mc)).method_18470(this.mc.field_1724.method_5667())) != null) {
                Pair<class_1297, class_2487> pair = EntitiesDataManager.getInstance().requestEntity(world, player.method_5628());
                class_2487 nbt = new class_2487();
                class_1730 inv = pair != null && pair.getRight() != null && ((class_2487)pair.getRight()).method_10545("EnderItems") ? InventoryUtils.getPlayerEnderItemsFromNbt((class_2487)((class_2487)pair.getRight()), (class_7225.class_7874)world.method_30349()) : player.method_7274();
                if (inv != null) {
                    nbt.method_10566("EnderItems", (class_2520)inv.method_7660((class_7225.class_7874)world.method_30349()));
                    RenderUtils.renderNbtItemsPreview((class_1799)stack, (class_2487)nbt, (int)x, (int)y, (boolean)false, (class_332)drawContext);
                }
            }
        } else if (stack.method_57353().method_57832(class_9334.field_49650) && InventoryUtils.bundleHasItems((class_1799)stack) && Configs.Generic.BUNDLE_PREVIEW.getBooleanValue() && (!Configs.Generic.BUNDLE_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
            RenderUtils.renderBundlePreview((class_1799)stack, (int)x, (int)y, (int)Configs.Generic.BUNDLE_DISPLAY_ROW_WIDTH.getIntegerValue(), (boolean)Configs.Generic.BUNDLE_DISPLAY_BACKGROUND_COLOR.getBooleanValue(), (class_332)drawContext);
        }
    }

    public void onRenderWorldPreWeather(Matrix4f posMatrix, Matrix4f projMatrix, class_4604 frustum, class_4184 camera, class_9958 fog, class_3695 profiler) {
        if (Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && this.mc.field_1687 != null && this.mc.field_1724 != null && !this.mc.field_1690.field_1842) {
            OverlayRenderer.renderOverlays(posMatrix, projMatrix, this.mc, frustum, camera, fog, profiler);
        }
    }

    public void onRenderTooltipComponentInsertFirst(class_1792.class_9635 context, class_1799 stack, List<class_2561> list) {
    }

    public void onRenderTooltipComponentInsertMiddle(class_1792.class_9635 context, class_1799 stack, List<class_2561> list) {
        if (Configs.Generic.BUNDLE_TOOLTIPS.getBooleanValue() && stack.method_7909() instanceof class_5537) {
            MiscUtils.addBundleTooltip(stack, list);
        }
    }

    public void onRenderTooltipComponentInsertLast(class_1792.class_9635 context, class_1799 stack, List<class_2561> list) {
        class_1747 blockItem;
        class_1792 class_17922;
        if (Configs.Generic.AXOLOTL_TOOLTIPS.getBooleanValue() && stack.method_7909() == class_1802.field_28354) {
            MiscUtils.addAxolotlTooltip(stack, list);
        }
        if (Configs.Generic.BEE_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_49624)) {
            MiscUtils.addBeeTooltip(stack, list);
        }
        if (Configs.Generic.CUSTOM_MODEL_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_49637)) {
            MiscUtils.addCustomModelTooltip(stack, list);
        }
        if (Configs.Generic.FOOD_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_50075)) {
            MiscUtils.addFoodTooltip(stack, list);
        }
        if (Configs.Generic.HONEY_TOOLTIPS.getBooleanValue() && (class_17922 = stack.method_7909()) instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_4481) {
            MiscUtils.addHoneyTooltip(stack, list);
        }
        if (Configs.Generic.LODESTONE_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_49614)) {
            MiscUtils.addLodestoneTooltip(stack, list);
        }
    }

    public int getSubtitleOffset() {
        if (Configs.Generic.OFFSET_SUBTITLE_HUD.getBooleanValue() && Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && Configs.Generic.HUD_ALIGNMENT.getOptionListValue() == HudAlignment.BOTTOM_RIGHT) {
            int offset = (int)((double)(this.lineWrappers.size() * (StringUtils.getFontHeight() + 2)) * Configs.Generic.FONT_SCALE.getDoubleValue());
            return -(offset - 16);
        }
        return 0;
    }

    public void updateData(class_310 mc) {
        if (mc.field_1687 != null && RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            DataStorage.getInstance().updateStructureData();
        }
    }

    private void updateLines() {
        this.lineWrappers.clear();
        this.addedTypes.clear();
        if (this.chunkFutures.size() >= 4) {
            this.resetCachedChunks();
        }
        ArrayList<LinePos> positions = new ArrayList<LinePos>();
        for (InfoToggle toggle : InfoToggle.values()) {
            if (!toggle.getBooleanValue()) continue;
            positions.add(new LinePos(toggle.getIntegerValue(), toggle));
        }
        Collections.sort(positions);
        for (LinePos pos : positions) {
            try {
                this.addLine(pos.type);
            }
            catch (Exception e) {
                this.addLine(pos.type.getName() + ": exception");
            }
        }
        if (Configs.Generic.SORT_LINES_BY_LENGTH.getBooleanValue()) {
            Collections.sort(this.lineWrappers);
            if (Configs.Generic.SORT_LINES_REVERSED.getBooleanValue()) {
                Collections.reverse(this.lineWrappers);
            }
        }
        this.lines.clear();
        for (StringHolder holder : this.lineWrappers) {
            this.lines.add(holder.str);
        }
    }

    public void addLine(String text) {
        this.lineWrappers.add(new StringHolder(this, text));
    }

    public void addLineI18n(String translatedName, Object ... args) {
        this.addLine(StringUtils.translate((String)translatedName, (Object[])args));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addLine(InfoToggle type) {
        Pair<class_1297, class_2487> pair;
        block198: {
            Map effects;
            block199: {
                class_1937 world;
                class_310 mc;
                block200: {
                    int conversionTimer;
                    String zombieType;
                    block203: {
                        Pair<class_1297, class_2487> pair2;
                        block201: {
                            class_1299 entityType;
                            class_2487 nbt;
                            block202: {
                                block197: {
                                    mc = this.mc;
                                    class_1297 entity = mc.method_1560();
                                    world = entity.method_5770();
                                    double y = entity.method_23318();
                                    class_2338 pos = class_2338.method_49637((double)entity.method_23317(), (double)y, (double)entity.method_23321());
                                    class_1923 chunkPos = new class_1923(pos);
                                    boolean isChunkLoaded = mc.field_1687.method_22340(pos);
                                    if (!isChunkLoaded) {
                                        return;
                                    }
                                    if (type == InfoToggle.FPS) {
                                        this.addLineI18n("minihud.info_line.fps", mc.method_47599());
                                        return;
                                    }
                                    if (type == InfoToggle.MEMORY_USAGE) {
                                        long memMax = Runtime.getRuntime().maxMemory();
                                        long memTotal = Runtime.getRuntime().totalMemory();
                                        long memFree = Runtime.getRuntime().freeMemory();
                                        long memUsed = memTotal - memFree;
                                        this.addLineI18n("minihud.info_line.memory_usage", memUsed * 100L / memMax, MiscUtils.bytesToMb(memUsed), MiscUtils.bytesToMb(memMax), memTotal * 100L / memMax, MiscUtils.bytesToMb(memTotal));
                                        return;
                                    }
                                    if (type == InfoToggle.TIME_REAL) {
                                        try {
                                            SimpleDateFormat sdf = new SimpleDateFormat(Configs.Generic.DATE_FORMAT_REAL.getStringValue());
                                            this.date.setTime(System.currentTimeMillis());
                                            this.addLine(sdf.format(this.date));
                                            return;
                                        }
                                        catch (Exception e) {
                                            this.addLineI18n("minihud.info_line.time.exception", new Object[0]);
                                            return;
                                        }
                                    }
                                    if (type == InfoToggle.TIME_WORLD) {
                                        long current = world.method_8532();
                                        long total = world.method_8510();
                                        this.addLineI18n("minihud.info_line.time_world", current, total);
                                        return;
                                    }
                                    if (type == InfoToggle.TIME_WORLD_FORMATTED) {
                                        try {
                                            long timeDay = world.method_8532();
                                            long day = (int)(timeDay / 24000L);
                                            int dayTicks = (int)(timeDay % 24000L);
                                            int hour = (dayTicks / 1000 + 6) % 24;
                                            int min = (int)((double)dayTicks / 16.666666) % 60;
                                            int sec = (int)((double)dayTicks / 0.277777) % 60;
                                            int moonNumber = (int)day % 8;
                                            String moon = moonNumber > 7 ? StringUtils.translate((String)"minihud.info_line.invalid_value", (Object[])new Object[0]) : StringUtils.translate((String)("minihud.info_line.time_world_formatted.moon_" + moonNumber), (Object[])new Object[0]);
                                            String str = Configs.Generic.DATE_FORMAT_MINECRAFT.getStringValue();
                                            str = str.replace("{DAY}", String.format("%d", day));
                                            str = str.replace("{DAY_1}", String.format("%d", day + 1L));
                                            str = str.replace("{HOUR}", String.format("%02d", hour));
                                            str = str.replace("{MIN}", String.format("%02d", min));
                                            str = str.replace("{SEC}", String.format("%02d", sec));
                                            str = str.replace("{MOON}", String.format("%s", moon));
                                            this.addLine(str);
                                            return;
                                        }
                                        catch (Exception e) {
                                            this.addLineI18n("minihud.info_line.time.exception", new Object[0]);
                                            return;
                                        }
                                    }
                                    if (type == InfoToggle.TIME_DAY_MODULO) {
                                        int mod = Configs.Generic.TIME_DAY_DIVISOR.getIntegerValue();
                                        long current = world.method_8532() % (long)mod;
                                        this.addLineI18n("minihud.info_line.time_day_modulo", mod, current);
                                        return;
                                    }
                                    if (type == InfoToggle.TIME_TOTAL_MODULO) {
                                        int mod = Configs.Generic.TIME_TOTAL_DIVISOR.getIntegerValue();
                                        long current = world.method_8510() % (long)mod;
                                        this.addLineI18n("minihud.info_line.time_total_modulo", mod, current);
                                        return;
                                    }
                                    if (type == InfoToggle.SERVER_TPS) {
                                        String preTps;
                                        if (this.data.hasIntegratedServer() && this.data.getIntegratedServer().method_3780() % 10 == 0) {
                                            this.data.updateIntegratedServerTPS();
                                        }
                                        if (!this.data.hasTPSData()) {
                                            this.addLineI18n("minihud.info_line.server_tps.invalid", new Object[0]);
                                            return;
                                        }
                                        double tps = this.data.getServerTPS();
                                        double mspt = this.data.getServerMSPT();
                                        String rst = GuiBase.TXT_RST;
                                        String string = preTps = tps >= 20.0 ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                                        if (this.data.hasCarpetServer() || this.data.isSinglePlayer()) {
                                            String preMspt = mspt <= 40.0 ? GuiBase.TXT_GREEN : (mspt <= 45.0 ? GuiBase.TXT_YELLOW : (mspt <= 50.0 ? GuiBase.TXT_GOLD : GuiBase.TXT_RED));
                                            this.addLineI18n("minihud.info_line.server_tps", preTps, tps, rst, preMspt, mspt, rst);
                                            return;
                                        }
                                        String preMspt = mspt <= 51.0 ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                                        this.addLineI18n("minihud.info_line.server_tps.est", preTps, tps, rst, preMspt, mspt, rst);
                                        return;
                                    }
                                    if (type == InfoToggle.SERVUX) {
                                        if (EntitiesDataManager.getInstance().hasServuxServer()) {
                                            this.addLineI18n("minihud.info_line.servux", EntitiesDataManager.getInstance().getServuxVersion());
                                        } else if (this.getDataStorage().hasServuxServer()) {
                                            this.addLineI18n("minihud.info_line.servux", this.getDataStorage().getServuxVersion());
                                        } else if (this.getHudData().hasServuxServer()) {
                                            this.addLineI18n("minihud.info_line.servux", this.getHudData().getServuxVersion());
                                        } else if (!(this.getDataStorage().hasIntegratedServer() || EntitiesDataManager.getInstance().hasServuxServer() || this.getHudData().hasServuxServer())) {
                                            this.addLineI18n("minihud.info_line.servux.not_connected", new Object[0]);
                                        }
                                        if (EntitiesDataManager.getInstance().hasServuxServer()) {
                                            this.addLineI18n("minihud.info_line.servux.entity_sync", EntitiesDataManager.getInstance().getBlockEntityCacheCount(), EntitiesDataManager.getInstance().getPendingBlockEntitiesCount(), EntitiesDataManager.getInstance().getEntityCacheCount(), EntitiesDataManager.getInstance().getPendingEntitiesCount());
                                        }
                                        if (this.getDataStorage().hasServuxServer()) {
                                            this.addLineI18n("minihud.info_line.servux.structures", this.getDataStorage().getStrucutreCount(), this.getHudData().getSpawnChunkRadius(), this.getHudData().getWorldSpawn().method_23854(), this.getHudData().isWorldSpawnKnown() ? StringUtils.translate((String)"minihud.info_line.slime_chunk.yes", (Object[])new Object[0]) : StringUtils.translate((String)"minihud.info_line.slime_chunk.no", (Object[])new Object[0]));
                                            return;
                                        }
                                        if (this.getHudData().hasServuxServer()) {
                                            this.addLineI18n("minihud.info_line.servux.no_structures_hud", this.getHudData().getSpawnChunkRadius(), this.getHudData().getWorldSpawn().method_23854(), this.getHudData().isWorldSpawnKnown() ? StringUtils.translate((String)"minihud.info_line.slime_chunk.yes", (Object[])new Object[0]) : StringUtils.translate((String)"minihud.info_line.slime_chunk.no", (Object[])new Object[0]));
                                            return;
                                        }
                                        if (!this.getDataStorage().hasIntegratedServer()) return;
                                        this.addLineI18n("minihud.info_line.servux.structures_integrated", this.getDataStorage().getStrucutreCount(), this.getHudData().getSpawnChunkRadius(), this.getHudData().getWorldSpawn().method_23854(), this.getHudData().isWorldSpawnKnown() ? StringUtils.translate((String)"minihud.info_line.slime_chunk.yes", (Object[])new Object[0]) : StringUtils.translate((String)"minihud.info_line.slime_chunk.no", (Object[])new Object[0]));
                                        return;
                                    }
                                    if (type == InfoToggle.WEATHER) {
                                        class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
                                        String weatherType = "clear";
                                        int weatherTime = -1;
                                        if (bestWorld == null) {
                                            return;
                                        }
                                        if (this.getHudData().isWeatherThunder() && this.getHudData().isWeatherRain()) {
                                            weatherType = "thundering";
                                            weatherTime = this.getHudData().getThunderTime();
                                        } else if (this.getHudData().isWeatherRain()) {
                                            weatherType = "raining";
                                            weatherTime = this.getHudData().getRainTime();
                                        } else if (this.getHudData().isWeatherClear()) {
                                            weatherType = "clear";
                                            weatherTime = this.getHudData().getClearTime();
                                        }
                                        if (weatherTime < 1) {
                                            this.addLineI18n("minihud.info_line.weather", StringUtils.translate((String)("minihud.info_line.weather." + weatherType), (Object[])new Object[0]), "");
                                            return;
                                        }
                                        this.addLineI18n("minihud.info_line.weather", StringUtils.translate((String)("minihud.info_line.weather." + weatherType), (Object[])new Object[0]), ", " + StringUtils.getDurationString((long)((long)weatherTime * 50L)) + " " + StringUtils.translate((String)"minihud.info_line.remaining", (Object[])new Object[0]));
                                        return;
                                    }
                                    if (type == InfoToggle.MOB_CAPS) {
                                        MobCapDataHandler mobCapData = this.data.getMobCapData();
                                        if (mc.method_1496() && mc.method_1576().method_3780() % 100 == 0) {
                                            mobCapData.updateIntegratedServerMobCaps();
                                        }
                                        if (!mobCapData.getHasValidData()) return;
                                        this.addLine(mobCapData.getFormattedInfoLine());
                                        return;
                                    }
                                    if (type == InfoToggle.PING) {
                                        class_640 info = mc.field_1724.field_3944.method_2871(mc.field_1724.method_5667());
                                        if (info == null) return;
                                        this.addLineI18n("minihud.info_line.ping", info.method_2959());
                                        return;
                                    }
                                    if (type == InfoToggle.COORDINATES || type == InfoToggle.COORDINATES_SCALED || type == InfoToggle.DIMENSION) {
                                        if (this.addedTypes.contains((Object)InfoToggle.COORDINATES)) return;
                                        if (this.addedTypes.contains((Object)InfoToggle.COORDINATES_SCALED)) return;
                                        if (this.addedTypes.contains((Object)InfoToggle.DIMENSION)) {
                                            return;
                                        }
                                        String pre = "";
                                        StringBuilder str = new StringBuilder(128);
                                        String fmtStr = Configs.Generic.COORDINATE_FORMAT_STRING.getStringValue();
                                        double x = entity.method_23317();
                                        double z = entity.method_23321();
                                        if (InfoToggle.COORDINATES.getBooleanValue()) {
                                            if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                                                try {
                                                    str.append(String.format(fmtStr, x, y, z));
                                                }
                                                catch (Exception e) {
                                                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates.exception", (Object[])new Object[0]));
                                                }
                                            } else {
                                                str.append(StringUtils.translate((String)"minihud.info_line.coordinates.format", (Object[])new Object[]{x, y, z}));
                                            }
                                            pre = " / ";
                                        }
                                        if (InfoToggle.COORDINATES_SCALED.getBooleanValue() && (world.method_27983() == class_1937.field_25180 || world.method_27983() == class_1937.field_25179)) {
                                            boolean isNether = world.method_27983() == class_1937.field_25180;
                                            double scale = isNether ? 8.0 : 0.125;
                                            x *= scale;
                                            z *= scale;
                                            str.append(pre);
                                            if (isNether) {
                                                str.append(StringUtils.translate((String)"minihud.info_line.coordinates_scaled.overworld", (Object[])new Object[0]));
                                            } else {
                                                str.append(StringUtils.translate((String)"minihud.info_line.coordinates_scaled.nether", (Object[])new Object[0]));
                                            }
                                            if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                                                try {
                                                    str.append(String.format(fmtStr, x, y, z));
                                                }
                                                catch (Exception e) {
                                                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates.exception", (Object[])new Object[0]));
                                                }
                                            } else {
                                                str.append(StringUtils.translate((String)"minihud.info_line.coordinates.format", (Object[])new Object[]{x, y, z}));
                                            }
                                            pre = " / ";
                                        }
                                        if (InfoToggle.DIMENSION.getBooleanValue()) {
                                            String dimName = world.method_27983().method_29177().toString();
                                            str.append(pre).append(StringUtils.translate((String)"minihud.info_line.dimension", (Object[])new Object[0])).append(dimName);
                                        }
                                        this.addLine(str.toString());
                                        this.addedTypes.add(InfoToggle.COORDINATES);
                                        this.addedTypes.add(InfoToggle.COORDINATES_SCALED);
                                        this.addedTypes.add(InfoToggle.DIMENSION);
                                        return;
                                    }
                                    if (type == InfoToggle.BLOCK_POS || type == InfoToggle.CHUNK_POS || type == InfoToggle.REGION_FILE) {
                                        if (this.addedTypes.contains((Object)InfoToggle.BLOCK_POS)) return;
                                        if (this.addedTypes.contains((Object)InfoToggle.CHUNK_POS)) return;
                                        if (this.addedTypes.contains((Object)InfoToggle.REGION_FILE)) {
                                            return;
                                        }
                                        String pre = "";
                                        StringBuilder str = new StringBuilder(256);
                                        if (InfoToggle.BLOCK_POS.getBooleanValue()) {
                                            try {
                                                String fmt = Configs.Generic.BLOCK_POS_FORMAT_STRING.getStringValue();
                                                str.append(String.format(fmt, pos.method_10263(), pos.method_10264(), pos.method_10260()));
                                            }
                                            catch (Exception e) {
                                                str.append(StringUtils.translate((String)"minihud.info_line.block_pos.exception", (Object[])new Object[0]));
                                            }
                                            pre = " / ";
                                        }
                                        if (InfoToggle.CHUNK_POS.getBooleanValue()) {
                                            str.append(pre).append(StringUtils.translate((String)"minihud.info_line.chunk_pos", (Object[])new Object[]{chunkPos.field_9181, pos.method_10264() >> 4, chunkPos.field_9180}));
                                            pre = " / ";
                                        }
                                        if (InfoToggle.REGION_FILE.getBooleanValue()) {
                                            str.append(pre).append(StringUtils.translate((String)"minihud.info_line.region_file", (Object[])new Object[]{pos.method_10263() >> 9, pos.method_10260() >> 9}));
                                        }
                                        this.addLine(str.toString());
                                        this.addedTypes.add(InfoToggle.BLOCK_POS);
                                        this.addedTypes.add(InfoToggle.CHUNK_POS);
                                        this.addedTypes.add(InfoToggle.REGION_FILE);
                                        return;
                                    }
                                    if (type == InfoToggle.BLOCK_IN_CHUNK) {
                                        this.addLineI18n("minihud.info_line.block_in_chunk", pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF, chunkPos.field_9181, pos.method_10264() >> 4, chunkPos.field_9180);
                                        return;
                                    }
                                    if (type == InfoToggle.BLOCK_BREAK_SPEED) {
                                        this.addLineI18n("minihud.info_line.block_break_speed", DataStorage.getInstance().getBlockBreakingSpeed());
                                        return;
                                    }
                                    if (type == InfoToggle.SPRINTING && mc.field_1724.method_5624()) {
                                        this.addLineI18n("minihud.info_line.sprinting", new Object[0]);
                                        return;
                                    }
                                    if (type == InfoToggle.DISTANCE) {
                                        class_243 ref = DataStorage.getInstance().getDistanceReferencePoint();
                                        double dist = Math.sqrt(ref.method_1028(entity.method_23317(), entity.method_23318(), entity.method_23321()));
                                        this.addLineI18n("minihud.info_line.distance", dist, entity.method_23317() - ref.field_1352, entity.method_23318() - ref.field_1351, entity.method_23321() - ref.field_1350, ref.field_1352, ref.field_1351, ref.field_1350);
                                        return;
                                    }
                                    if (type == InfoToggle.FACING) {
                                        String str;
                                        class_2350 facing = entity.method_5735();
                                        String facingName = StringUtils.translate((String)("minihud.info_line.facing." + facing.method_10151() + ".name"), (Object[])new Object[0]);
                                        if (facingName.contains("minihud.info_line.facing." + facing.method_10151() + ".name")) {
                                            facingName = facing.name();
                                            str = StringUtils.translate((String)"minihud.info_line.invalid_value", (Object[])new Object[0]);
                                        } else {
                                            str = StringUtils.translate((String)("minihud.info_line.facing." + facing.method_10151()), (Object[])new Object[0]);
                                        }
                                        this.addLineI18n("minihud.info_line.facing", facingName, str);
                                        return;
                                    }
                                    if (type == InfoToggle.LIGHT_LEVEL) {
                                        class_2818 clientChunk = this.getClientChunk(chunkPos);
                                        if (clientChunk.method_12223()) return;
                                        class_3568 lightingProvider = world.method_8398().method_12130();
                                        this.addLineI18n("minihud.info_line.light_level", lightingProvider.method_15562(class_1944.field_9282).method_15543(pos));
                                        return;
                                    }
                                    if (type == InfoToggle.BEE_COUNT) {
                                        class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
                                        Pair<class_2586, class_2487> pair3 = this.getTargetedBlockEntity(bestWorld, mc);
                                        if (pair3 == null) {
                                            return;
                                        }
                                        if (Configs.Generic.INFO_LINES_USES_NBT.getBooleanValue() && NbtBlockUtils.getBlockEntityTypeFromNbt((class_2487)((class_2487)pair3.getRight())).equals(class_2591.field_20431) && !((class_2487)pair3.getRight()).method_33133()) {
                                            Pair bees = NbtBlockUtils.getBeesDataFromNbt((class_2487)((class_2487)pair3.getRight()));
                                            if (((class_2338)bees.getRight()).equals((Object)class_2338.field_10980)) {
                                                this.addLineI18n("minihud.info_line.bee_count", ((List)bees.getLeft()).size());
                                                return;
                                            }
                                            this.addLineI18n("minihud.info_line.bee_count.flower_pos", ((List)bees.getLeft()).size(), ((class_2338)bees.getRight()).method_23854());
                                            return;
                                        }
                                        Object bees = pair3.getLeft();
                                        if (!(bees instanceof class_4482)) return;
                                        class_4482 be = (class_4482)bees;
                                        this.addLineI18n("minihud.info_line.bee_count", be.method_23903());
                                        return;
                                    }
                                    if (type == InfoToggle.COMPARATOR_OUTPUT) {
                                        class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
                                        Pair<class_2586, class_2487> pair4 = this.getTargetedBlockEntity(bestWorld, mc);
                                        if (pair4 == null) {
                                            return;
                                        }
                                        if (Configs.Generic.INFO_LINES_USES_NBT.getBooleanValue() && NbtBlockUtils.getBlockEntityTypeFromNbt((class_2487)((class_2487)pair4.getRight())).equals(class_2591.field_11908) && !((class_2487)pair4.getRight()).method_33133()) {
                                            int output = NbtBlockUtils.getOutputSignalFromNbt((class_2487)((class_2487)pair4.getRight()));
                                            if (output <= 0) return;
                                            this.addLineI18n("minihud.info_line.comparator_output_signal", output);
                                            return;
                                        }
                                        Object output = pair4.getLeft();
                                        if (!(output instanceof class_2599)) return;
                                        class_2599 be = (class_2599)output;
                                        if (be.method_11071() <= 0) return;
                                        this.addLineI18n("minihud.info_line.comparator_output_signal", be.method_11071());
                                        return;
                                    }
                                    if (type == InfoToggle.HONEY_LEVEL) {
                                        class_2680 state = this.getTargetedBlock(mc);
                                        if (state == null) return;
                                        if (!(state.method_26204() instanceof class_4481)) return;
                                        this.addLineI18n("minihud.info_line.honey_level", class_4482.method_23902((class_2680)state));
                                        return;
                                    }
                                    if (type == InfoToggle.FURNACE_XP) {
                                        class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
                                        Pair<class_2586, class_2487> pair5 = this.getTargetedBlockEntity(bestWorld, mc);
                                        if (pair5 == null) {
                                            return;
                                        }
                                        if (Configs.Generic.INFO_LINES_USES_NBT.getBooleanValue() && !((class_2487)pair5.getRight()).method_33133()) {
                                            class_2591 beType = NbtBlockUtils.getBlockEntityTypeFromNbt((class_2487)((class_2487)pair5.getRight()));
                                            if (!beType.equals(class_2591.field_11903) && !beType.equals(class_2591.field_16415)) {
                                                if (!beType.equals(class_2591.field_16414)) return;
                                            }
                                            if (bestWorld instanceof class_3218) {
                                                class_3218 serverWorld = (class_3218)bestWorld;
                                                int exp = MiscUtils.getFurnaceXpAmount(serverWorld, (class_2487)pair5.getRight());
                                                if (exp <= 0) return;
                                                this.addLineI18n("minihud.info_line.furnace_xp", exp);
                                                return;
                                            }
                                            if (!this.getHudData().hasServuxServer()) return;
                                            if (!this.getHudData().hasRecipes()) return;
                                            int exp = MiscUtils.getFurnaceXpAmount((class_2487)pair5.getRight());
                                            if (exp <= 0) return;
                                            this.addLineI18n("minihud.info_line.furnace_xp", exp);
                                            return;
                                        }
                                        Object beType = pair5.getLeft();
                                        if (!(beType instanceof class_2609)) return;
                                        class_2609 furnace = (class_2609)beType;
                                        if (bestWorld instanceof class_3218) {
                                            class_3218 serverWorld = (class_3218)bestWorld;
                                            int exp = MiscUtils.getFurnaceXpAmount(serverWorld, furnace);
                                            if (exp <= 0) return;
                                            this.addLineI18n("minihud.info_line.furnace_xp", exp);
                                            return;
                                        }
                                        if (!this.getHudData().hasServuxServer()) return;
                                        if (!this.getHudData().hasRecipes()) return;
                                        int exp = MiscUtils.getFurnaceXpAmount(furnace);
                                        if (exp <= 0) return;
                                        this.addLineI18n("minihud.info_line.furnace_xp", exp);
                                        return;
                                    }
                                    if (type == InfoToggle.HORSE_SPEED || type == InfoToggle.HORSE_JUMP) {
                                        class_1297 vehicle;
                                        if (this.addedTypes.contains((Object)InfoToggle.HORSE_SPEED)) return;
                                        if (this.addedTypes.contains((Object)InfoToggle.HORSE_JUMP)) {
                                            return;
                                        }
                                        class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
                                        Pair<class_1297, class_2487> pair6 = this.getTargetEntity(bestWorld, mc);
                                        if (pair6 == null) {
                                            vehicle = mc.field_1724.method_5854();
                                        } else {
                                            class_1297 class_12972 = vehicle = pair6.getLeft() == null ? mc.field_1724.method_5854() : (class_1297)pair6.getLeft();
                                        }
                                        if (!(vehicle instanceof class_1496)) {
                                            return;
                                        }
                                        class_1496 horse = (class_1496)vehicle;
                                        String AnimalType = horse.method_5864().method_5897().getString();
                                        double speed = 0.0;
                                        double jump = 0.0;
                                        if (pair6 != null && Configs.Generic.INFO_LINES_USES_NBT.getBooleanValue() && !((class_2487)pair6.getRight()).method_33133()) {
                                            class_2487 nbt2 = (class_2487)pair6.getRight();
                                            class_1299 entityType2 = NbtEntityUtils.getEntityTypeFromNbt((class_2487)nbt2);
                                            if (entityType2.equals(class_1299.field_40116) || entityType2.equals(class_1299.field_6067) || entityType2.equals(class_1299.field_6139) || entityType2.equals(class_1299.field_6074) || entityType2.equals(class_1299.field_6057) || entityType2.equals(class_1299.field_6075) || entityType2.equals(class_1299.field_17714) || entityType2.equals(class_1299.field_6048)) {
                                                Pair horsePair = NbtEntityUtils.getSpeedAndJumpStrengthFromNbt((class_2487)nbt2);
                                                speed = (Double)horsePair.getLeft();
                                                jump = (Double)horsePair.getRight();
                                            }
                                        } else {
                                            speed = horse.method_45325(class_5134.field_23719);
                                            jump = horse.method_45325(class_5134.field_23728);
                                        }
                                        if (InfoToggle.HORSE_SPEED.getBooleanValue() && speed > 0.0) {
                                            this.addLineI18n("minihud.info_line.horse_speed", AnimalType, speed *= 42.1629638671875);
                                            this.addedTypes.add(InfoToggle.HORSE_SPEED);
                                        }
                                        if (!InfoToggle.HORSE_JUMP.getBooleanValue()) return;
                                        if (!(jump > 0.0)) return;
                                        double calculatedJumpHeight = -0.1817584952 * jump * jump * jump + 3.689713992 * jump * jump + 2.128599134 * jump + -0.343930367;
                                        this.addLineI18n("minihud.info_line.horse_jump", AnimalType, calculatedJumpHeight);
                                        this.addedTypes.add(InfoToggle.HORSE_JUMP);
                                        return;
                                    }
                                    if (type == InfoToggle.ROTATION_YAW || type == InfoToggle.ROTATION_PITCH || type == InfoToggle.SPEED) {
                                        if (this.addedTypes.contains((Object)InfoToggle.ROTATION_YAW)) return;
                                        if (this.addedTypes.contains((Object)InfoToggle.ROTATION_PITCH)) return;
                                        if (this.addedTypes.contains((Object)InfoToggle.SPEED)) {
                                            return;
                                        }
                                        String pre = "";
                                        StringBuilder str = new StringBuilder(128);
                                        if (InfoToggle.ROTATION_YAW.getBooleanValue()) {
                                            str.append(StringUtils.translate((String)"minihud.info_line.rotation_yaw", (Object[])new Object[]{Float.valueOf(class_3532.method_15393((float)entity.method_36454()))}));
                                            pre = " / ";
                                        }
                                        if (InfoToggle.ROTATION_PITCH.getBooleanValue()) {
                                            str.append(pre).append(StringUtils.translate((String)"minihud.info_line.rotation_pitch", (Object[])new Object[]{Float.valueOf(class_3532.method_15393((float)entity.method_36455()))}));
                                            pre = " / ";
                                        }
                                        if (InfoToggle.SPEED.getBooleanValue()) {
                                            double dx = entity.method_23317() - entity.field_6038;
                                            double dy = entity.method_23318() - entity.field_5971;
                                            double dz = entity.method_23321() - entity.field_5989;
                                            double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                                            str.append(pre).append(StringUtils.translate((String)"minihud.info_line.speed", (Object[])new Object[]{dist * 20.0}));
                                        }
                                        this.addLine(str.toString());
                                        this.addedTypes.add(InfoToggle.ROTATION_YAW);
                                        this.addedTypes.add(InfoToggle.ROTATION_PITCH);
                                        this.addedTypes.add(InfoToggle.SPEED);
                                        return;
                                    }
                                    if (type == InfoToggle.SPEED_HV) {
                                        double dx = entity.method_23317() - entity.field_6038;
                                        double dy = entity.method_23318() - entity.field_5971;
                                        double dz = entity.method_23321() - entity.field_5989;
                                        this.addLineI18n("minihud.info_line.speed_hv", Math.sqrt(dx * dx + dz * dz) * 20.0, dy * 20.0);
                                        return;
                                    }
                                    if (type == InfoToggle.SPEED_AXIS) {
                                        double dx = entity.method_23317() - entity.field_6038;
                                        double dy = entity.method_23318() - entity.field_5971;
                                        double dz = entity.method_23321() - entity.field_5989;
                                        this.addLineI18n("minihud.info_line.speed_axis", dx * 20.0, dy * 20.0, dz * 20.0);
                                        return;
                                    }
                                    if (type == InfoToggle.CHUNK_SECTIONS) {
                                        this.addLineI18n("minihud.info_line.chunk_sections", ((IMixinWorldRenderer)mc.field_1769).minihud_getRenderedChunksInvoker());
                                        return;
                                    }
                                    if (type == InfoToggle.CHUNK_SECTIONS_FULL) {
                                        this.addLine(mc.field_1769.method_3289());
                                        return;
                                    }
                                    if (type == InfoToggle.CHUNK_UPDATES) {
                                        this.addLine("TODO");
                                        return;
                                    }
                                    if (type == InfoToggle.LOADED_CHUNKS_COUNT) {
                                        String chunksClient = mc.field_1687.method_31419();
                                        class_1937 worldServer = WorldUtils.getBestWorld((class_310)mc);
                                        if (worldServer != null && worldServer != mc.field_1687) {
                                            int chunksServer = worldServer.method_8398().method_14151();
                                            int chunksServerTot = ((class_3215)worldServer.method_8398()).method_17301();
                                            this.addLineI18n("minihud.info_line.loaded_chunks_count.server", chunksServer, chunksServerTot, chunksClient);
                                            return;
                                        }
                                        this.addLine(chunksClient);
                                        return;
                                    }
                                    if (type == InfoToggle.PANDA_GENE) {
                                        Pair<class_1297, class_2487> pair7 = this.getTargetEntity(world, mc);
                                        if (pair7 == null) {
                                            return;
                                        }
                                        if (Configs.Generic.INFO_LINES_USES_NBT.getBooleanValue() && !((class_2487)pair7.getRight()).method_33133()) {
                                            class_2487 nbt3 = (class_2487)pair7.getRight();
                                            class_1299 entityType3 = NbtEntityUtils.getEntityTypeFromNbt((class_2487)nbt3);
                                            if (!entityType3.equals(class_1299.field_6146)) return;
                                            Pair genes = NbtEntityUtils.getPandaGenesFromNbt((class_2487)nbt3);
                                            if (genes.getLeft() == null) return;
                                            if (genes.getRight() == null) return;
                                            this.addLineI18n("minihud.info_line.panda_gene.main_gene", StringUtils.translate((String)("minihud.info_line.panda_gene.gene." + ((class_1440.class_1443)genes.getLeft()).method_15434()), (Object[])new Object[0]), ((class_1440.class_1443)genes.getLeft()).method_6568() ? StringUtils.translate((String)"minihud.info_line.panda_gene.recessive_gene", (Object[])new Object[0]) : StringUtils.translate((String)"minihud.info_line.panda_gene.dominant_gene", (Object[])new Object[0]));
                                            this.addLineI18n("minihud.info_line.panda_gene.hidden_gene", StringUtils.translate((String)("minihud.info_line.panda_gene.gene." + ((class_1440.class_1443)genes.getRight()).method_15434()), (Object[])new Object[0]), ((class_1440.class_1443)genes.getRight()).method_6568() ? StringUtils.translate((String)"minihud.info_line.panda_gene.recessive_gene", (Object[])new Object[0]) : StringUtils.translate((String)"minihud.info_line.panda_gene.dominant_gene", (Object[])new Object[0]));
                                            return;
                                        }
                                        Object nbt3 = pair7.getLeft();
                                        if (!(nbt3 instanceof class_1440)) return;
                                        class_1440 panda = (class_1440)nbt3;
                                        this.addLineI18n("minihud.info_line.panda_gene.main_gene", StringUtils.translate((String)("minihud.info_line.panda_gene.gene." + panda.method_6525().method_15434()), (Object[])new Object[0]), panda.method_6525().method_6568() ? StringUtils.translate((String)"minihud.info_line.panda_gene.recessive_gene", (Object[])new Object[0]) : StringUtils.translate((String)"minihud.info_line.panda_gene.dominant_gene", (Object[])new Object[0]));
                                        this.addLineI18n("minihud.info_line.panda_gene.hidden_gene", StringUtils.translate((String)("minihud.info_line.panda_gene.gene." + panda.method_6508().method_15434()), (Object[])new Object[0]), panda.method_6508().method_6568() ? StringUtils.translate((String)"minihud.info_line.panda_gene.recessive_gene", (Object[])new Object[0]) : StringUtils.translate((String)"minihud.info_line.panda_gene.dominant_gene", (Object[])new Object[0]));
                                        return;
                                    }
                                    if (type == InfoToggle.PARTICLE_COUNT) {
                                        this.addLineI18n("minihud.info_line.particle_count", mc.field_1713.method_3052());
                                        return;
                                    }
                                    if (type == InfoToggle.DIFFICULTY) {
                                        long chunkInhabitedTime = 0L;
                                        float moonPhaseFactor = 0.0f;
                                        class_2818 serverChunk = this.getChunk(chunkPos);
                                        if (serverChunk != null) {
                                            moonPhaseFactor = mc.field_1687.method_30272();
                                            chunkInhabitedTime = serverChunk.method_12033();
                                        }
                                        class_1266 diff = new class_1266(mc.field_1687.method_8407(), mc.field_1687.method_8532(), chunkInhabitedTime, moonPhaseFactor);
                                        this.addLineI18n("minihud.info_line.difficulty", Float.valueOf(diff.method_5457()), Float.valueOf(diff.method_5458()), mc.field_1687.method_8532() / 24000L);
                                        return;
                                    }
                                    if (type == InfoToggle.BIOME) {
                                        class_2818 clientChunk = this.getClientChunk(chunkPos);
                                        if (clientChunk.method_12223()) return;
                                        class_1959 biome = (class_1959)mc.field_1687.method_23753(pos).comp_349();
                                        class_2960 id = mc.field_1687.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
                                        String translationKey = "biome." + id.toString().replace(":", ".");
                                        String biomeName = StringUtils.translate((String)translationKey, (Object[])new Object[0]);
                                        if (biomeName.equals(translationKey)) {
                                            biomeName = StringUtils.prettifyRawTranslationPath((String)id.method_12832());
                                        }
                                        this.addLineI18n("minihud.info_line.biome", biomeName);
                                        return;
                                    }
                                    if (type == InfoToggle.BIOME_REG_NAME) {
                                        class_2818 clientChunk = this.getClientChunk(chunkPos);
                                        if (clientChunk.method_12223()) return;
                                        class_1959 biome = (class_1959)mc.field_1687.method_23753(pos).comp_349();
                                        class_2960 rl = mc.field_1687.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
                                        String name = rl != null ? rl.toString() : "?";
                                        this.addLineI18n("minihud.info_line.biome_reg_name", name);
                                        return;
                                    }
                                    if (type == InfoToggle.ENTITIES) {
                                        String ent = mc.field_1769.method_3272();
                                        int p = ent.indexOf(",");
                                        if (p != -1) {
                                            ent = ent.substring(0, p);
                                        }
                                        this.addLine(ent);
                                        return;
                                    }
                                    if (type == InfoToggle.TILE_ENTITIES) {
                                        this.addLineI18n("minihud.info_line.tile_entities", new Object[0]);
                                        return;
                                    }
                                    if (type == InfoToggle.ENTITIES_CLIENT_WORLD) {
                                        class_1937 serverWorld;
                                        int countClient = mc.field_1687.method_18120();
                                        if (mc.method_1496() && (serverWorld = WorldUtils.getBestWorld((class_310)mc)) instanceof class_3218) {
                                            IServerEntityManager manager = (IServerEntityManager)((IMixinServerWorld)serverWorld).minihud_getEntityManager();
                                            int indexSize = manager.minihud$getIndexSize();
                                            this.addLineI18n("minihud.info_line.entities_client_world.server", countClient, indexSize);
                                            return;
                                        }
                                        this.addLineI18n("minihud.info_line.entities_client_world", countClient);
                                        return;
                                    }
                                    if (type == InfoToggle.SLIME_CHUNK) {
                                        String result;
                                        if (!MiscUtils.isOverworld(world)) {
                                            return;
                                        }
                                        if (this.getHudData().isWorldSeedKnown(world)) {
                                            long seed = this.getHudData().getWorldSeed(world);
                                            result = MiscUtils.canSlimeSpawnAt(pos.method_10263(), pos.method_10260(), seed) ? StringUtils.translate((String)"minihud.info_line.slime_chunk.yes", (Object[])new Object[0]) : StringUtils.translate((String)"minihud.info_line.slime_chunk.no", (Object[])new Object[0]);
                                        } else {
                                            result = StringUtils.translate((String)"minihud.info_line.slime_chunk.no_seed", (Object[])new Object[0]);
                                        }
                                        this.addLineI18n("minihud.info_line.slime_chunk", result);
                                        return;
                                    }
                                    if (type == InfoToggle.LOOKING_AT_ENTITY) {
                                        class_1296 passive;
                                        class_6025 tamable;
                                        class_1309 owner;
                                        Object nbt4;
                                        Object indexSize;
                                        if (mc.field_1765 == null) return;
                                        if (mc.field_1765.method_17783() != class_239.class_240.field_1331) return;
                                        Pair<class_1297, class_2487> pair8 = this.getTargetEntity(world, mc);
                                        if (pair8 == null) {
                                            return;
                                        }
                                        if (Configs.Generic.INFO_LINES_USES_NBT.getBooleanValue() && (indexSize = pair8.getLeft()) instanceof class_1309) {
                                            class_1309 living = (class_1309)indexSize;
                                            if (!((class_2487)pair8.getRight()).method_33133()) {
                                                class_1657 owner2;
                                                nbt4 = (class_2487)pair8.getRight();
                                                Pair healthPair = NbtEntityUtils.getHealthFromNbt((class_2487)nbt4);
                                                Pair ownerPair = NbtEntityUtils.getOwnerAndSaddle((class_2487)nbt4, (class_5455)world.method_30349());
                                                Pair agePair = NbtEntityUtils.getAgeFromNbt((class_2487)nbt4);
                                                double health = (Double)healthPair.getLeft();
                                                double maxHealth = (Double)healthPair.getRight();
                                                if ((double)living.method_6032() != health) {
                                                    health = living.method_6032();
                                                }
                                                Object entityLine = StringUtils.translate((String)"minihud.info_line.looking_at_entity.livingentity", (Object[])new Object[]{((class_1297)pair8.getLeft()).method_5477().getString(), health, maxHealth});
                                                if (ownerPair.getLeft() != class_156.field_25140 && (owner2 = world.method_18470((UUID)ownerPair.getLeft())) != null) {
                                                    entityLine = (String)entityLine + " - " + StringUtils.translate((String)"minihud.info_line.looking_at_entity.owner", (Object[])new Object[0]) + ": " + owner2.method_5477().method_54160();
                                                }
                                                if ((Integer)agePair.getLeft() < 0) {
                                                    int untilGrown = (Integer)agePair.getLeft() * -1;
                                                    entityLine = (String)entityLine + " [" + StringUtils.getDurationString((long)(untilGrown * 50)) + " " + StringUtils.translate((String)"minihud.info_line.remaining", (Object[])new Object[0]) + "]";
                                                }
                                                this.addLine((String)entityLine);
                                                return;
                                            }
                                        }
                                        if (!((nbt4 = pair8.getLeft()) instanceof class_1309)) {
                                            this.addLineI18n("minihud.info_line.looking_at_entity", ((class_1297)pair8.getLeft()).method_5477().getString());
                                            return;
                                        }
                                        class_1309 living = (class_1309)nbt4;
                                        Object entityLine = StringUtils.translate((String)"minihud.info_line.looking_at_entity.livingentity", (Object[])new Object[]{living.method_5477().getString(), Float.valueOf(living.method_6032()), Float.valueOf(living.method_6063())});
                                        if (living instanceof class_6025 && (owner = (tamable = (class_6025)living).method_35057()) != null) {
                                            entityLine = (String)entityLine + " - " + StringUtils.translate((String)"minihud.info_line.looking_at_entity.owner", (Object[])new Object[0]) + ": " + owner.method_5477().method_54160();
                                        }
                                        if (living instanceof class_1296 && (passive = (class_1296)living).method_5618() < 0) {
                                            int untilGrown = ((IMixinPassiveEntity)passive).minihud_getRealBreedingAge() * -1;
                                            entityLine = (String)entityLine + " [" + StringUtils.getDurationString((long)(untilGrown * 50)) + " " + StringUtils.translate((String)"minihud.info_line.remaining", (Object[])new Object[0]) + "]";
                                        }
                                        this.addLine((String)entityLine);
                                        return;
                                    }
                                    if (type == InfoToggle.ENTITY_VARIANT) {
                                        Object paintingVariant;
                                        Object variant;
                                        Object nbt5;
                                        Object object;
                                        if (mc.field_1765 == null) return;
                                        if (mc.field_1765.method_17783() != class_239.class_240.field_1331) return;
                                        Pair<class_1297, class_2487> pair9 = this.getTargetEntity(world, mc);
                                        if (pair9 == null) {
                                            return;
                                        }
                                        if (Configs.Generic.INFO_LINES_USES_NBT.getBooleanValue() && (object = pair9.getLeft()) instanceof class_1309) {
                                            class_1309 living = (class_1309)object;
                                            if (!((class_2487)pair9.getRight()).method_33133()) {
                                                nbt5 = (class_2487)pair9.getRight();
                                                class_1299 entityType4 = NbtEntityUtils.getEntityTypeFromNbt((class_2487)nbt5);
                                                if (entityType4.equals(class_1299.field_28315)) {
                                                    class_5762.class_5767 variant2 = NbtEntityUtils.getAxolotlVariantFromNbt((class_2487)nbt5);
                                                    if (variant2 == null) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.axolotl", variant2.method_33238());
                                                    return;
                                                }
                                                if (entityType4.equals(class_1299.field_16281)) {
                                                    Pair catPair = NbtEntityUtils.getCatVariantFromNbt((class_2487)nbt5);
                                                    if (catPair.getLeft() == null) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.cat", ((class_5321)catPair.getLeft()).method_29177().method_12832(), ((class_1767)catPair.getRight()).method_7792());
                                                    return;
                                                }
                                                if (entityType4.equals(class_1299.field_17943)) {
                                                    class_4019.class_4039 foxType = NbtEntityUtils.getFoxVariantFromNbt((class_2487)nbt5);
                                                    if (foxType == null) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.fox", foxType.method_15434());
                                                    return;
                                                }
                                                if (entityType4.equals(class_1299.field_37419)) {
                                                    class_5321 variant3 = NbtEntityUtils.getFrogVariantFromNbt((class_2487)nbt5);
                                                    if (variant3 == null) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.frog", variant3.method_29177().method_12832());
                                                    return;
                                                }
                                                if (entityType4.equals(class_1299.field_6139)) {
                                                    Pair horsePair = NbtEntityUtils.getHorseVariantFromNbt((class_2487)nbt5);
                                                    if (horsePair.getLeft() == null) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.horse", ((class_5149)horsePair.getLeft()).method_15434(), ((class_5148)horsePair.getRight()).name().toLowerCase());
                                                    return;
                                                }
                                                if (entityType4.equals(class_1299.field_6074) || entityType4.equals(class_1299.field_17714)) {
                                                    Pair llamaPair = NbtEntityUtils.getLlamaTypeFromNbt((class_2487)nbt5);
                                                    if (llamaPair.getLeft() == null) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.llama", ((class_1501.class_7993)llamaPair.getLeft()).method_15434(), llamaPair.getRight());
                                                    return;
                                                }
                                                if (entityType4.equals(class_1299.field_6120)) {
                                                    Pair paintingPair = NbtEntityUtils.getPaintingDataFromNbt((class_2487)nbt5, (class_5455)world.method_30349());
                                                    if (paintingPair.getRight() == null) return;
                                                    Optional title = ((class_1535)paintingPair.getRight()).comp_2918();
                                                    Optional author = ((class_1535)paintingPair.getRight()).comp_2919();
                                                    if (title.isPresent() && author.isPresent()) {
                                                        this.addLineI18n("minihud.info_line.entity_variant.painting.both", ((class_2561)title.get()).getString(), ((class_2561)author.get()).getString());
                                                        return;
                                                    }
                                                    if (title.isPresent()) {
                                                        this.addLineI18n("minihud.info_line.entity_variant.painting.title_only", ((class_2561)title.get()).getString());
                                                        return;
                                                    }
                                                    if (!author.isPresent()) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.painting.author_only", ((class_2561)author.get()).getString());
                                                    return;
                                                }
                                                if (entityType4.equals(class_1299.field_6104)) {
                                                    class_1453.class_7989 variant4 = NbtEntityUtils.getParrotVariantFromNbt((class_2487)nbt5);
                                                    if (variant4 == null) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.parrot", variant4.method_15434());
                                                    return;
                                                }
                                                if (entityType4.equals(class_1299.field_6140)) {
                                                    class_1463.class_7990 rabbitType = NbtEntityUtils.getRabbitTypeFromNbt((class_2487)nbt5);
                                                    if (rabbitType == null) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.rabbit", rabbitType.method_15434());
                                                    return;
                                                }
                                                if (entityType4.equals(class_1299.field_6073)) {
                                                    class_1462.class_9869 salmonVariant = NbtEntityUtils.getSalmonVariantFromNbt((class_2487)nbt5);
                                                    if (salmonVariant == null) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.salmon", salmonVariant.method_15434());
                                                    return;
                                                }
                                                if (entityType4.equals(class_1299.field_6115)) {
                                                    class_1767 color = NbtEntityUtils.getSheepColorFromNbt((class_2487)nbt5);
                                                    if (color == null) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.sheep", color.method_7792());
                                                    return;
                                                }
                                                if (entityType4.equals(class_1299.field_6111)) {
                                                    class_1474.class_1475 variant5 = NbtEntityUtils.getFishVariantFromNbt((class_2487)nbt5);
                                                    if (variant5 == null) return;
                                                    this.addLineI18n("minihud.info_line.entity_variant.tropical_fish", variant5.method_15434());
                                                    return;
                                                }
                                                if (!entityType4.equals(class_1299.field_6055)) return;
                                                Pair wolfPair = NbtEntityUtils.getWolfVariantFromNbt((class_2487)nbt5);
                                                if (wolfPair.getLeft() == null) return;
                                                this.addLineI18n("minihud.info_line.entity_variant.wolf", ((class_5321)wolfPair.getLeft()).method_29177().method_12832(), ((class_1767)wolfPair.getRight()).method_7792());
                                                return;
                                            }
                                        }
                                        if ((nbt5 = pair9.getLeft()) instanceof class_5762) {
                                            class_5762 axolotl = (class_5762)nbt5;
                                            this.addLineI18n("minihud.info_line.entity_variant.axolotl", axolotl.method_33225().method_33238());
                                            return;
                                        }
                                        nbt5 = pair9.getLeft();
                                        if (nbt5 instanceof class_1451) {
                                            class_1451 cat = (class_1451)nbt5;
                                            variant = cat.method_47843().method_40230().orElse(class_7375.field_38710);
                                            this.addLineI18n("minihud.info_line.entity_variant.cat", variant.method_29177().method_12832(), cat.method_16096().method_7792());
                                            return;
                                        }
                                        variant = pair9.getLeft();
                                        if (variant instanceof class_4019) {
                                            class_4019 fox = (class_4019)variant;
                                            this.addLineI18n("minihud.info_line.entity_variant.fox", fox.method_47845().method_15434());
                                            return;
                                        }
                                        variant = pair9.getLeft();
                                        if (variant instanceof class_7102) {
                                            class_7102 frog = (class_7102)variant;
                                            variant = frog.method_41354().method_40230().orElse(class_7106.field_37462);
                                            this.addLineI18n("minihud.info_line.entity_variant.frog", variant.method_29177().method_12832());
                                            return;
                                        }
                                        variant = pair9.getLeft();
                                        if (variant instanceof class_1498) {
                                            class_1498 horse = (class_1498)variant;
                                            this.addLineI18n("minihud.info_line.entity_variant.horse", horse.method_27077().method_15434(), horse.method_27078().name().toLowerCase());
                                            return;
                                        }
                                        variant = pair9.getLeft();
                                        if (variant instanceof class_1501) {
                                            class_1501 llama = (class_1501)variant;
                                            this.addLineI18n("minihud.info_line.entity_variant.llama", llama.method_6809().method_15434(), llama.method_6803());
                                            return;
                                        }
                                        variant = pair9.getLeft();
                                        if (variant instanceof class_1534) {
                                            class_1534 painting = (class_1534)variant;
                                            paintingVariant = (class_1535)painting.method_43404().comp_349();
                                            if (paintingVariant == null) return;
                                            Optional title = paintingVariant.comp_2918();
                                            Optional author = paintingVariant.comp_2919();
                                            if (title.isPresent() && author.isPresent()) {
                                                this.addLineI18n("minihud.info_line.entity_variant.painting.both", ((class_2561)title.get()).getString(), ((class_2561)author.get()).getString());
                                                return;
                                            }
                                            if (title.isPresent()) {
                                                this.addLineI18n("minihud.info_line.entity_variant.painting.title_only", ((class_2561)title.get()).getString());
                                                return;
                                            }
                                            if (!author.isPresent()) return;
                                            this.addLineI18n("minihud.info_line.entity_variant.painting.author_only", ((class_2561)author.get()).getString());
                                            return;
                                        }
                                        paintingVariant = pair9.getLeft();
                                        if (paintingVariant instanceof class_1453) {
                                            class_1453 parrot = (class_1453)paintingVariant;
                                            this.addLineI18n("minihud.info_line.entity_variant.parrot", parrot.method_6584().method_15434());
                                            return;
                                        }
                                        paintingVariant = pair9.getLeft();
                                        if (paintingVariant instanceof class_1463) {
                                            class_1463 rabbit = (class_1463)paintingVariant;
                                            this.addLineI18n("minihud.info_line.entity_variant.rabbit", rabbit.method_47855().method_15434());
                                            return;
                                        }
                                        paintingVariant = pair9.getLeft();
                                        if (paintingVariant instanceof class_1462) {
                                            class_1462 salmon = (class_1462)paintingVariant;
                                            this.addLineI18n("minihud.info_line.entity_variant.salmon", salmon.method_61472().method_15434());
                                            return;
                                        }
                                        paintingVariant = pair9.getLeft();
                                        if (paintingVariant instanceof class_1472) {
                                            class_1472 sheep = (class_1472)paintingVariant;
                                            this.addLineI18n("minihud.info_line.entity_variant.sheep", sheep.method_6633().method_7792());
                                            return;
                                        }
                                        paintingVariant = pair9.getLeft();
                                        if (paintingVariant instanceof class_1474) {
                                            class_1474 fish = (class_1474)paintingVariant;
                                            this.addLineI18n("minihud.info_line.entity_variant.tropical_fish", fish.method_47862().method_15434());
                                            return;
                                        }
                                        paintingVariant = pair9.getLeft();
                                        if (!(paintingVariant instanceof class_1493)) return;
                                        class_1493 wolf = (class_1493)paintingVariant;
                                        variant = wolf.method_58062().method_40230().orElse(class_9347.field_49725);
                                        this.addLineI18n("minihud.info_line.entity_variant.wolf", variant.method_29177().method_12832(), wolf.method_6713().method_7792());
                                        return;
                                    }
                                    if (type != InfoToggle.LOOKING_AT_EFFECTS) break block197;
                                    if (mc.field_1765 == null) return;
                                    if (mc.field_1765.method_17783() != class_239.class_240.field_1331) return;
                                    pair = this.getTargetEntity(world, mc);
                                    if (pair == null) {
                                        return;
                                    }
                                    if (!Configs.Generic.INFO_LINES_USES_NBT.getBooleanValue() || !(pair.getLeft() instanceof class_1309) || ((class_2487)pair.getRight()).method_33133()) break block198;
                                    class_2487 nbt6 = (class_2487)pair.getRight();
                                    effects = NbtEntityUtils.getActiveStatusEffectsFromNbt((class_2487)nbt6);
                                    if (effects == null) return;
                                    if (effects.isEmpty()) {
                                        return;
                                    }
                                    break block199;
                                }
                                if (type != InfoToggle.ZOMBIE_CONVERSION) break block200;
                                if (mc.field_1765 == null) return;
                                if (mc.field_1765.method_17783() != class_239.class_240.field_1331) return;
                                pair2 = this.getTargetEntity(world, mc);
                                if (pair2 == null) {
                                    return;
                                }
                                zombieType = ((class_1297)pair2.getLeft()).method_5864().method_5897().getString();
                                conversionTimer = -1;
                                if (!Configs.Generic.INFO_LINES_USES_NBT.getBooleanValue() || ((class_2487)pair2.getRight()).method_33133()) break block201;
                                nbt = (class_2487)pair2.getRight();
                                entityType = NbtEntityUtils.getEntityTypeFromNbt((class_2487)nbt);
                                if (!entityType.equals(class_1299.field_6054)) break block202;
                                Pair zombieDoctor = NbtEntityUtils.getZombieConversionTimerFromNbt((class_2487)nbt);
                                conversionTimer = (Integer)zombieDoctor.getLeft();
                                break block203;
                            }
                            if (entityType.equals(class_1299.field_6051)) {
                                Pair zombieDoctor = NbtEntityUtils.getDrownedConversionTimerFromNbt((class_2487)nbt);
                                conversionTimer = (Integer)zombieDoctor.getLeft();
                                break block203;
                            } else if (entityType.equals(class_1299.field_6137)) {
                                conversionTimer = NbtEntityUtils.getStrayConversionTimeFromNbt((class_2487)nbt);
                            }
                            break block203;
                        }
                        Object effect = pair2.getLeft();
                        if (effect instanceof class_1641) {
                            class_1641 zombie = (class_1641)effect;
                            conversionTimer = ((IMixinZombieVillagerEntity)zombie).minihud_conversionTimer();
                        } else {
                            effect = pair2.getLeft();
                            if (effect instanceof class_1642) {
                                class_1642 zombert = (class_1642)effect;
                                conversionTimer = ((IMixinZombieEntity)zombert).minihud_ticksUntilWaterConversion();
                            } else {
                                effect = pair2.getLeft();
                                if (effect instanceof class_1613) {
                                    class_1613 skeleton = (class_1613)effect;
                                    conversionTimer = ((IMixinSkeletonEntity)skeleton).minihud_conversionTime();
                                }
                            }
                        }
                    }
                    if (conversionTimer <= 0) return;
                    this.addLineI18n("minihud.info_line.zombie_conversion", zombieType, StringUtils.getDurationString((long)((long)(conversionTimer / 20) * 1000L)));
                    return;
                }
                if (type == InfoToggle.DOLPHIN_TREASURE) {
                    if (mc.field_1765 == null) return;
                    if (mc.field_1765.method_17783() != class_239.class_240.field_1331) return;
                    Pair<class_1297, class_2487> pair10 = this.getTargetEntity(world, mc);
                    if (pair10 == null) {
                        return;
                    }
                    if (Configs.Generic.INFO_LINES_USES_NBT.getBooleanValue() && !((class_2487)pair10.getRight()).method_33133()) {
                        class_2487 nbt = (class_2487)pair10.getRight();
                        class_1299 entityType = NbtEntityUtils.getEntityTypeFromNbt((class_2487)nbt);
                        Triple dolphinTriple = NbtEntityUtils.getDolphinDataFromNbt((class_2487)nbt);
                        if (dolphinTriple == null) return;
                        if (!entityType.equals(class_1299.field_6087)) return;
                        class_2338 treasure = (class_2338)dolphinTriple.getLeft();
                        boolean hasTreasure = !treasure.equals((Object)class_2338.field_10980);
                        int dryTime = (Integer)dolphinTriple.getMiddle();
                        if (dryTime == 2400) {
                            if (!hasTreasure) return;
                            this.addLineI18n("minihud.info_line.dolphin_treasure", treasure.method_23854());
                            return;
                        }
                        if (dryTime > 0) {
                            if (hasTreasure) {
                                this.addLineI18n("minihud.info_line.dolphin_treasure.drying", treasure.method_23854(), StringUtils.getDurationString((long)((long)(dryTime / 20) * 1000L)));
                                return;
                            }
                            this.addLineI18n("minihud.info_line.dolphin_treasure.drying_no_treasure", StringUtils.getDurationString((long)((long)(dryTime / 20) * 1000L)));
                            return;
                        }
                        if (dryTime >= 0) return;
                        if (hasTreasure) {
                            this.addLineI18n("minihud.info_line.dolphin_treasure.dying", treasure.method_23854(), StringUtils.getDurationString((long)((long)(dryTime * -1 / 20) * 1000L)));
                            return;
                        }
                        this.addLineI18n("minihud.info_line.dolphin_treasure.dying_no_treasure", StringUtils.getDurationString((long)((long)(dryTime * -1 / 20) * 1000L)));
                        return;
                    }
                    Object entityType = pair10.getLeft();
                    if (!(entityType instanceof class_1433)) return;
                    class_1433 dolphin = (class_1433)entityType;
                    class_2338 treasure = dolphin.method_6494();
                    boolean hasTreasure = !treasure.equals((Object)class_2338.field_10980);
                    int dryTime = dolphin.method_6491();
                    if (dryTime == 2400) {
                        if (!hasTreasure) return;
                        this.addLineI18n("minihud.info_line.dolphin_treasure", treasure.method_23854());
                        return;
                    }
                    if (dryTime > 0) {
                        if (hasTreasure) {
                            this.addLineI18n("minihud.info_line.dolphin_treasure.drying", treasure.method_23854(), StringUtils.getDurationString((long)((long)(dryTime / 20) * 1000L)));
                            return;
                        }
                        this.addLineI18n("minihud.info_line.dolphin_treasure.drying_no_treasure", StringUtils.getDurationString((long)((long)(dryTime / 20) * 1000L)));
                        return;
                    }
                    if (dryTime >= 0) return;
                    if (hasTreasure) {
                        this.addLineI18n("minihud.info_line.dolphin_treasure.dying", treasure.method_23854(), StringUtils.getDurationString((long)((long)(dryTime * -1 / 20) * 1000L)));
                        return;
                    }
                    this.addLineI18n("minihud.info_line.dolphin_treasure.dying_no_treasure", StringUtils.getDurationString((long)((long)(dryTime * -1 / 20) * 1000L)));
                    return;
                }
                if (type == InfoToggle.ENTITY_REG_NAME) {
                    if (mc.field_1765 == null) return;
                    if (mc.field_1765.method_17783() != class_239.class_240.field_1331) return;
                    Pair<class_1297, class_2487> pair11 = this.getTargetEntity(world, mc);
                    if (pair11 == null) {
                        return;
                    }
                    class_2960 regName = class_1299.method_5890((class_1299)((class_1297)pair11.getLeft()).method_5864());
                    if (regName == null) return;
                    this.addLineI18n("minihud.info_line.entity_reg_name", regName);
                    return;
                }
                if (type == InfoToggle.PLAYER_EXPERIENCE) {
                    if (mc.field_1724 == null) return;
                    this.addLineI18n("minihud.info_line.player_experience", mc.field_1724.field_7520, Float.valueOf(100.0f * mc.field_1724.field_7510), mc.field_1724.field_7495);
                    return;
                }
                if (type == InfoToggle.LOOKING_AT_PLAYER_EXP) {
                    if (mc.field_1765 == null) return;
                    if (mc.field_1765.method_17783() != class_239.class_240.field_1331) return;
                    Pair<class_1297, class_2487> pair12 = this.getTargetEntity(world, mc);
                    if (pair12 == null) {
                        return;
                    }
                    if (Configs.Generic.INFO_LINES_USES_NBT.getBooleanValue() && !((class_2487)pair12.getRight()).method_33133()) {
                        class_2487 nbt = (class_2487)pair12.getRight();
                        class_1299 entityType = NbtEntityUtils.getEntityTypeFromNbt((class_2487)nbt);
                        if (!entityType.equals(class_1299.field_6097)) return;
                        Triple triple = NbtEntityUtils.getPlayerExpFromNbt((class_2487)nbt);
                        if ((Integer)triple.getLeft() <= 0) return;
                        this.addLineI18n("minihud.info_line.looking_at_player_exp", triple.getLeft(), triple.getRight(), 100 * (Integer)triple.getMiddle());
                        return;
                    }
                    Object nbt = pair12.getLeft();
                    if (!(nbt instanceof class_3222)) return;
                    class_3222 player = (class_3222)nbt;
                    this.addLineI18n("minihud.info_line.looking_at_player_exp", player.field_7520, Float.valueOf(100.0f * player.field_7510), player.field_7495);
                    return;
                }
                if (type != InfoToggle.LOOKING_AT_BLOCK && type != InfoToggle.LOOKING_AT_BLOCK_CHUNK) {
                    if (type != InfoToggle.BLOCK_PROPS) return;
                    this.getBlockProperties(mc);
                    return;
                }
                if (this.addedTypes.contains((Object)InfoToggle.LOOKING_AT_BLOCK)) return;
                if (this.addedTypes.contains((Object)InfoToggle.LOOKING_AT_BLOCK_CHUNK)) {
                    return;
                }
                if (mc.field_1765 == null) return;
                if (mc.field_1765.method_17783() != class_239.class_240.field_1332) return;
                class_2338 lookPos = ((class_3965)mc.field_1765).method_17777();
                String pre = "";
                StringBuilder str = new StringBuilder(128);
                if (InfoToggle.LOOKING_AT_BLOCK.getBooleanValue()) {
                    str.append(StringUtils.translate((String)"minihud.info_line.looking_at_block", (Object[])new Object[]{lookPos.method_10263(), lookPos.method_10264(), lookPos.method_10260()}));
                    pre = " // ";
                }
                if (InfoToggle.LOOKING_AT_BLOCK_CHUNK.getBooleanValue()) {
                    str.append(pre).append(StringUtils.translate((String)"minihud.info_line.looking_at_block_chunk", (Object[])new Object[]{lookPos.method_10263() & 0xF, lookPos.method_10264() & 0xF, lookPos.method_10260() & 0xF, lookPos.method_10263() >> 4, lookPos.method_10264() >> 4, lookPos.method_10260() >> 4}));
                }
                this.addLine(str.toString());
                this.addedTypes.add(InfoToggle.LOOKING_AT_BLOCK);
                this.addedTypes.add(InfoToggle.LOOKING_AT_BLOCK_CHUNK);
                return;
            }
            Iterator fox = effects.keySet().iterator();
            while (fox.hasNext()) {
                class_6880 effectType = (class_6880)fox.next();
                class_1293 effect = (class_1293)effects.get(effectType);
                if (!effect.method_48559() && effect.method_5584() <= 0) continue;
                this.addLineI18n("minihud.info_line.looking_at_effects", ((class_1291)effectType.comp_349()).method_5560().getString(), effect.method_5578() > 0 ? StringUtils.translate((String)"minihud.info_line.looking_at_effects.amplifier", (Object[])new Object[]{effect.method_5578() + 1}) : "", effect.method_48559() ? StringUtils.translate((String)"minihud.info_line.looking_at_effects.infinite", (Object[])new Object[0]) : StringUtils.getDurationString((long)((long)(effect.method_5584() / 20) * 1000L)), StringUtils.translate((String)"minihud.info_line.remaining", (Object[])new Object[0]));
            }
            return;
        }
        Object nbt6 = pair.getLeft();
        if (!(nbt6 instanceof class_1309)) return;
        class_1309 living = (class_1309)nbt6;
        Collection effects = living.method_6026();
        Iterator iter = effects.iterator();
        while (iter.hasNext()) {
            class_1293 effect = (class_1293)iter.next();
            if (!effect.method_48559() && effect.method_5584() <= 0) continue;
            this.addLineI18n("minihud.info_line.looking_at_effects", ((class_1291)effect.method_5579().comp_349()).method_5560().getString(), effect.method_5578() > 0 ? StringUtils.translate((String)"minihud.info_line.looking_at_effects.amplifier", (Object[])new Object[]{effect.method_5578() + 1}) : "", effect.method_48559() ? StringUtils.translate((String)"minihud.info_line.looking_at_effects.infinite", (Object[])new Object[0]) : StringUtils.getDurationString((long)((long)(effect.method_5584() / 20) * 1000L)), StringUtils.translate((String)"minihud.info_line.remaining", (Object[])new Object[0]));
        }
    }

    private boolean isEntityDataValid(@Nonnull class_2487 nbt) {
        if (InventoryUtils.hasNbtItems((class_2487)nbt)) {
            return true;
        }
        Iterator iterator = nbt.method_10541().iterator();
        block30: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "Fire": {
                    short fire = nbt.method_10568("Fire");
                    if (fire >= 0 && fire <= 0) continue block30;
                    return true;
                }
                case "Age": {
                    int age = nbt.method_10550("Age");
                    if (age != 0 && age <= 1) continue block30;
                    return true;
                }
                case "Brain": {
                    class_2487 tag = nbt.method_10562("Brain");
                    if (tag.method_33133() || tag.method_10562("memories").method_33133()) continue block30;
                    return true;
                }
                case "Offers": {
                    return true;
                }
                case "Recipes": {
                    return true;
                }
                case "ConversionTime": {
                    if (nbt.method_10550("ConversionTime") <= 0) break;
                    return true;
                }
                case "DrownedConversionTime": {
                    if (nbt.method_10550("DrownedConversionTime") <= 0) break;
                    return true;
                }
                case "StrayConversionTime": {
                    if (nbt.method_10550("StrayConversionTime") <= 0) break;
                    return true;
                }
                case "ConversionPlayer": {
                    return true;
                }
                case "recipeBook": {
                    return true;
                }
                case "recipes": {
                    return true;
                }
                case "SaddleItem": {
                    return true;
                }
                case "active_effects": {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public Pair<class_1297, class_2487> getTargetEntity(class_1937 world, class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1331) {
            class_1297 lookedEntity = ((class_3966)mc.field_1765).method_17782();
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            Pair<class_1297, class_2487> pair = null;
            if (bestWorld instanceof class_3218) {
                class_3218 serverWorld = (class_3218)bestWorld;
                class_1297 serverEntity = serverWorld.method_8469(lookedEntity.method_5628());
                class_2487 nbt = new class_2487();
                serverEntity.method_5786(nbt);
                pair = Pair.of((Object)serverEntity, (Object)nbt);
            } else {
                pair = EntitiesDataManager.getInstance().requestEntity(world, lookedEntity.method_5628());
            }
            if (pair == null && this.lastEntity != null && ((class_1297)this.lastEntity.getLeft()).method_5628() == lookedEntity.method_5628()) {
                pair = this.lastEntity;
            } else if (pair != null && pair.getRight() != null && !((class_2487)pair.getRight()).method_33133() && this.isEntityDataValid((class_2487)pair.getRight())) {
                this.lastEntity = pair;
            } else if (this.lastEntity != null && ((class_1297)this.lastEntity.getLeft()).method_5628() == lookedEntity.method_5628()) {
                pair = this.lastEntity;
            }
            return pair;
        }
        return null;
    }

    @Nullable
    public Pair<class_2586, class_2487> getTargetedBlockEntity(class_1937 world, class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            class_2680 state = bestWorld.method_8320(posLooking);
            Pair<class_2586, class_2487> pair = null;
            if (state.method_26204() instanceof class_2343) {
                if (bestWorld instanceof class_3218) {
                    class_2586 be;
                    class_2487 nbt = new class_2487();
                    pair = Pair.of((Object)be, (Object)((be = bestWorld.method_8500(posLooking).method_8321(posLooking)) != null ? be.method_38242((class_7225.class_7874)bestWorld.method_30349()) : nbt));
                } else {
                    pair = EntitiesDataManager.getInstance().requestBlockEntity(world, posLooking);
                }
                if (pair == null && this.lastBlockEntity != null && ((class_2586)this.lastBlockEntity.getLeft()).method_11016().equals((Object)posLooking)) {
                    pair = this.lastBlockEntity;
                } else if (pair != null) {
                    this.lastBlockEntity = pair;
                }
                return pair;
            }
        }
        return null;
    }

    @Nullable
    public Pair<class_2586, class_2487> requestBlockEntityAt(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            class_2745 type;
            Pair<class_2586, class_2487> pair = EntitiesDataManager.getInstance().requestBlockEntity(world, pos);
            class_2680 state = world.method_8320(pos);
            if (state.method_26204() instanceof class_2281 && (type = (class_2745)state.method_11654((class_2769)class_2281.field_10770)) != class_2745.field_12569) {
                return EntitiesDataManager.getInstance().requestBlockEntity(world, pos.method_10093(class_2281.method_9758((class_2680)state)));
            }
            return pair;
        }
        return null;
    }

    @Nullable
    private class_2680 getTargetedBlock(class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            return mc.field_1687.method_8320(posLooking);
        }
        return null;
    }

    private <T extends Comparable<T>> void getBlockProperties(class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            class_2680 state = mc.field_1687.method_8320(posLooking);
            class_2960 rl = class_7923.field_41175.method_10221((Object)state.method_26204());
            this.addLine(rl != null ? rl.toString() : "<null>");
            for (String line : BlockUtils.getFormattedBlockStateProperties((class_2680)state)) {
                this.addLine(line);
            }
        }
    }

    @Nullable
    private class_2818 getChunk(class_1923 chunkPos) {
        class_9259 chunkResult;
        CompletableFuture<class_9259<class_2791>> future = this.chunkFutures.get(chunkPos);
        if (future == null) {
            future = this.setupChunkFuture(chunkPos);
        }
        if ((chunkResult = (class_9259)future.getNow(null)) == null) {
            return null;
        }
        class_2791 chunk = (class_2791)chunkResult.method_57130(null);
        if (chunk instanceof class_2818) {
            return (class_2818)chunk;
        }
        return null;
    }

    private CompletableFuture<class_9259<class_2791>> setupChunkFuture(class_1923 chunkPos) {
        class_3218 world;
        class_1132 server = this.getDataStorage().getIntegratedServer();
        CompletionStage<Object> future = null;
        if (server != null && (world = server.method_3847(this.mc.field_1687.method_27983())) != null) {
            future = world.method_14178().method_17299(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false).thenApply(either -> either.method_57127(chunk -> (class_2818)chunk));
        }
        if (future == null) {
            future = CompletableFuture.completedFuture(class_9259.method_57124((Object)this.getClientChunk(chunkPos)));
        }
        this.chunkFutures.put(chunkPos, (CompletableFuture<class_9259<class_2791>>)future);
        return future;
    }

    private class_2818 getClientChunk(class_1923 chunkPos) {
        if (this.cachedClientChunk == null || !this.cachedClientChunk.method_12004().equals((Object)chunkPos)) {
            this.cachedClientChunk = this.mc.field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180);
        }
        return this.cachedClientChunk;
    }

    private void resetCachedChunks() {
        this.chunkFutures.clear();
        this.cachedClientChunk = null;
    }

    private static class LinePos
    implements Comparable<LinePos> {
        private final int position;
        private final InfoToggle type;

        private LinePos(int position, InfoToggle type) {
            this.position = position;
            this.type = type;
        }

        @Override
        public int compareTo(@Nonnull LinePos other) {
            if (this.position < 0) {
                return other.position >= 0 ? 1 : 0;
            }
            if (other.position < 0 && this.position >= 0) {
                return -1;
            }
            return this.position < other.position ? -1 : (this.position > other.position ? 1 : 0);
        }
    }

    private class StringHolder
    implements Comparable<StringHolder> {
        public final String str;

        public StringHolder(RenderHandler renderHandler, String str) {
            this.str = str;
        }

        @Override
        public int compareTo(StringHolder other) {
            int lenOther;
            int lenThis = this.str.length();
            if (lenThis == (lenOther = other.str.length())) {
                return 0;
            }
            return this.str.length() > other.str.length() ? -1 : 1;
        }
    }
}

