/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.network;

import fi.dy.masa.malilib.network.IClientPayloadData;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.network.PacketSplitter;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.network.ServuxEntitiesPacket;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_634;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public abstract class ServuxEntitiesHandler<T extends class_8710>
implements IPluginClientPlayHandler<T> {
    private static final ServuxEntitiesHandler<ServuxEntitiesPacket.Payload> INSTANCE = new ServuxEntitiesHandler<ServuxEntitiesPacket.Payload>(){

        public void receive(ServuxEntitiesPacket.Payload payload, ClientPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final class_2960 CHANNEL_ID = class_2960.method_60655((String)"servux", (String)"entity_data");
    private boolean servuxRegistered;
    private boolean payloadRegistered = false;
    private int failures = 0;
    private static final int MAX_FAILURES = 4;
    private long readingSessionKey = -1L;

    public static ServuxEntitiesHandler<ServuxEntitiesPacket.Payload> getInstance() {
        return INSTANCE;
    }

    public class_2960 getPayloadChannel() {
        return CHANNEL_ID;
    }

    public boolean isPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    public void setPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    public <P extends IClientPayloadData> void decodeClientData(class_2960 channel, P data) {
        ServuxEntitiesPacket packet = (ServuxEntitiesPacket)data;
        if (!channel.equals((Object)CHANNEL_ID) || packet == null) {
            return;
        }
        switch (packet.getType()) {
            case PACKET_S2C_METADATA: {
                if (!EntitiesDataManager.getInstance().receiveServuxMetadata(packet.getCompound())) break;
                this.servuxRegistered = true;
                break;
            }
            case PACKET_S2C_BLOCK_NBT_RESPONSE_SIMPLE: {
                EntitiesDataManager.getInstance().handleBlockEntityData(packet.getPos(), packet.getCompound(), null);
                break;
            }
            case PACKET_S2C_ENTITY_NBT_RESPONSE_SIMPLE: {
                EntitiesDataManager.getInstance().handleEntityData(packet.getEntityId(), packet.getCompound());
                break;
            }
            case PACKET_S2C_NBT_RESPONSE_DATA: {
                class_2540 fullPacket;
                if (this.readingSessionKey == -1L) {
                    this.readingSessionKey = class_5819.method_43049((long)class_156.method_658()).method_43055();
                }
                if ((fullPacket = PacketSplitter.receive((IPluginClientPlayHandler)this, (long)this.readingSessionKey, (class_2540)packet.getBuffer())) == null) break;
                try {
                    this.readingSessionKey = -1L;
                    EntitiesDataManager.getInstance().handleBulkEntityData(fullPacket.method_10816(), (class_2487)fullPacket.method_30616(class_2505.method_53898()));
                }
                catch (Exception e) {
                    MiniHUD.logger.error("ServuxEntitiesHandler#decodeClientData(): Entity Data: error reading fullBuffer [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            default: {
                MiniHUD.logger.warn("ServuxEntitiesHandler#decodeClientData(): received unhandled packetType {} of size {} bytes.", (Object)packet.getPacketType(), (Object)packet.getTotalSize());
            }
        }
    }

    public void reset(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.servuxRegistered) {
            this.servuxRegistered = false;
            this.failures = 0;
            this.readingSessionKey = -1L;
        }
    }

    public void resetFailures(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.failures > 0) {
            this.failures = 0;
        }
    }

    public void receivePlayPayload(T payload, ClientPlayNetworking.Context ctx) {
        if (payload.method_56479().comp_2242().equals((Object)CHANNEL_ID)) {
            INSTANCE.decodeClientData(CHANNEL_ID, ((ServuxEntitiesPacket.Payload)payload).data());
        }
    }

    public void encodeWithSplitter(class_2540 buffer, class_634 handler) {
        INSTANCE.sendPlayPayload(new ServuxEntitiesPacket.Payload(ServuxEntitiesPacket.ResponseC2SData(buffer)));
    }

    public <P extends IClientPayloadData> void encodeClientData(P data) {
        ServuxEntitiesPacket packet = (ServuxEntitiesPacket)data;
        if (packet.getType().equals((Object)ServuxEntitiesPacket.Type.PACKET_C2S_NBT_RESPONSE_START)) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.method_10804(packet.getTransactionId());
            buffer.method_10794((class_2520)packet.getCompound());
            PacketSplitter.send((IPluginClientPlayHandler)this, (class_2540)buffer, (class_634)class_310.method_1551().method_1562());
        } else if (!INSTANCE.sendPlayPayload(new ServuxEntitiesPacket.Payload(packet))) {
            if (this.failures > 4) {
                MiniHUD.printDebug("ServuxEntitiesHandler#encodeClientData(): encountered [{}] sendPayload failures, cancelling any Servux join attempt(s)", 4);
                this.servuxRegistered = false;
                INSTANCE.unregisterPlayReceiver();
                EntitiesDataManager.getInstance().onPacketFailure();
            } else {
                ++this.failures;
            }
        }
    }
}

