/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import org.joml.Matrix4f;

public abstract class OverlayRendererBase
implements IOverlayRenderer {
    protected static final class_289 TESSELLATOR_1 = new class_289(0x200000);
    protected static final class_289 TESSELLATOR_2 = new class_289(0x200000);
    protected static class_287 BUFFER_1;
    protected static class_287 BUFFER_2;
    protected final List<RenderObjectBase> renderObjects = new ArrayList<RenderObjectBase>();
    protected boolean renderThrough;
    protected boolean useCulling;
    protected float glLineWidth = 1.0f;
    @Nullable
    protected class_2338 lastUpdatePos = class_2338.field_10980;
    private class_243 updateCameraPos = class_243.field_1353;

    @Override
    public final class_243 getUpdatePosition() {
        return this.updateCameraPos;
    }

    @Override
    public final void setUpdatePosition(class_243 cameraPosition) {
        this.updateCameraPos = cameraPosition;
    }

    protected void preRender() {
        RenderSystem.lineWidth((float)this.glLineWidth);
        if (this.renderThrough) {
            RenderSystem.disableDepthTest();
        }
        if (this.useCulling) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
    }

    protected void postRender() {
        if (this.renderThrough) {
            RenderSystem.enableDepthTest();
        }
        RenderSystem.enableCull();
    }

    @Override
    public void draw(Matrix4f matrix4f, Matrix4f projMatrix) {
        this.preRender();
        for (RenderObjectBase obj : this.renderObjects) {
            obj.draw(matrix4f, projMatrix);
        }
        this.postRender();
    }

    @Override
    public void deleteGlResources() {
        for (RenderObjectBase obj : this.renderObjects) {
            obj.deleteGlResources();
        }
        this.renderObjects.clear();
    }

    protected RenderObjectBase allocateBuffer(class_293.class_5596 glMode) {
        return this.allocateBuffer(glMode, class_290.field_1576, class_10142.field_53876);
    }

    protected RenderObjectBase allocateBuffer(class_293.class_5596 glMode, class_293 format, class_10156 shader) {
        RenderObjectVbo obj = new RenderObjectVbo(glMode, format, shader);
        this.renderObjects.add(obj);
        return obj;
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(class_293.class_5596.field_27382);
        this.allocateBuffer(class_293.class_5596.field_29344);
    }

    public void setRenderThrough(boolean renderThrough) {
        this.renderThrough = renderThrough;
    }

    public String getSaveId() {
        return "";
    }

    @Nullable
    public JsonObject toJson() {
        return null;
    }

    public void fromJson(JsonObject obj) {
    }
}

