/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_310;

public class OverlayRendererRandomTickableChunks
extends OverlayRendererBase {
    protected static boolean needsUpdate = true;
    @Nullable
    public static class_243 newPos;
    private static final class_2350[] HORIZONTALS;
    protected final RendererToggle toggle;
    protected class_243 pos = class_243.field_1353;
    protected double minX;
    protected double minZ;
    protected double maxX;
    protected double maxZ;

    @Override
    public String getName() {
        return "OverlayRendererRandomTickableChunks";
    }

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    public OverlayRendererRandomTickableChunks(RendererToggle toggle) {
        this.toggle = toggle;
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return this.toggle.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (needsUpdate) {
            return true;
        }
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            return newPos != null;
        }
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            return entity.method_23317() != this.pos.field_1352 || entity.method_23321() != this.pos.field_1350;
        }
        return false;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            this.pos = entity.method_19538();
        } else if (newPos != null) {
            this.pos = newPos;
            newPos = null;
        }
        Color4f color = this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER ? Configs.Colors.RANDOM_TICKS_PLAYER_OVERLAY_COLOR.getColor() : Configs.Colors.RANDOM_TICKS_FIXED_OVERLAY_COLOR.getColor();
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1 = TESSELLATOR_1.method_60827(renderQuads.getGlMode(), class_290.field_1576);
        BUFFER_2 = TESSELLATOR_2.method_60827(renderLines.getGlMode(), class_290.field_1576);
        Set<class_1923> chunks = this.getRandomTickableChunks(this.pos);
        for (class_1923 pos : chunks) {
            this.renderChunkEdgesIfApplicable(cameraPos, pos, chunks, entity.method_5770(), color);
        }
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        needsUpdate = false;
    }

    protected Set<class_1923> getRandomTickableChunks(class_243 posCenter) {
        HashSet<class_1923> set = new HashSet<class_1923>();
        int centerChunkX = (int)Math.floor(posCenter.field_1352) >> 4;
        int centerChunkZ = (int)Math.floor(posCenter.field_1350) >> 4;
        double maxRange = 16384.0;
        int r = 9;
        for (int cz = centerChunkZ - 9; cz <= centerChunkZ + 9; ++cz) {
            for (int cx = centerChunkX - 9; cx <= centerChunkX + 9; ++cx) {
                double dx = (double)(cx * 16 + 8) - posCenter.field_1352;
                double dz = (double)(cz * 16 + 8) - posCenter.field_1350;
                if (!(dx * dx + dz * dz < 16384.0)) continue;
                set.add(new class_1923(cx, cz));
            }
        }
        return set;
    }

    protected void renderChunkEdgesIfApplicable(class_243 cameraPos, class_1923 pos, Set<class_1923> chunks, class_1937 world, Color4f color) {
        for (class_2350 side : HORIZONTALS) {
            class_1923 posAdj = new class_1923(pos.field_9181 + side.method_10148(), pos.field_9180 + side.method_10165());
            if (chunks.contains(posAdj)) continue;
            this.renderChunkEdge(pos, side, cameraPos, color, world);
        }
    }

    private void renderChunkEdge(class_1923 pos, class_2350 side, class_243 cameraPos, Color4f color, class_1937 world) {
        float maxZ;
        float maxX;
        float minZ;
        float minX;
        switch (side) {
            case field_11043: {
                minX = pos.field_9181 << 4;
                minZ = pos.field_9180 << 4;
                maxX = (float)((double)(pos.field_9181 << 4) + 16.0);
                maxZ = pos.field_9180 << 4;
                break;
            }
            case field_11035: {
                minX = pos.field_9181 << 4;
                minZ = (float)((double)(pos.field_9180 << 4) + 16.0);
                maxX = (float)((double)(pos.field_9181 << 4) + 16.0);
                maxZ = (float)((double)(pos.field_9180 << 4) + 16.0);
                break;
            }
            case field_11039: {
                minX = pos.field_9181 << 4;
                minZ = pos.field_9180 << 4;
                maxX = pos.field_9181 << 4;
                maxZ = (float)((double)(pos.field_9180 << 4) + 16.0);
                break;
            }
            case field_11034: {
                minX = (float)((double)(pos.field_9181 << 4) + 16.0);
                minZ = pos.field_9180 << 4;
                maxX = (float)((double)(pos.field_9181 << 4) + 16.0);
                maxZ = (float)((double)(pos.field_9180 << 4) + 16.0);
                break;
            }
            default: {
                return;
            }
        }
        int minY = world != null ? world.method_31607() : -64;
        int maxY = world != null ? world.method_31600() + 1 : 320;
        RenderUtils.renderWallWithLines(minX, minY, minZ, maxX, maxY, maxZ, 16.0, 16.0, true, cameraPos, color, BUFFER_1, BUFFER_2);
    }

    @Override
    public String getSaveId() {
        return this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED ? "random_tickable_chunks" : "";
    }

    @Override
    @Nullable
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("pos", (JsonElement)JsonUtils.vec3dToJson((class_243)this.pos));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        class_243 pos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"pos");
        if (pos != null && this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            newPos = pos;
        }
    }

    static {
        HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    }
}

