/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import journeymap.client.io.FileHandler;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.log.JMLogger;
import journeymap.client.model.RegionImageCache;
import journeymap.client.render.draw.MobIconCache;
import journeymap.client.texture.IgnSkin;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.ui.theme.Theme;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.accessors.TextureManagerAccess;
import journeymap.common.thread.JMThreadFactory;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_8666;

public class TextureCache {
    public static final class_8666 TELEPORT_SPRITE = new class_8666(TextureCache.uiImage("teleport.png"), TextureCache.uiImage("teleport.png"));
    public static final class_8666 SHARE_SPRITE = new class_8666(TextureCache.uiImage("share.png"), TextureCache.uiImage("share.png"));
    public static final class_8666 POWER_SPRITE = new class_8666(TextureCache.uiImage("power.png"), TextureCache.uiImage("power.png"));
    public static final class_8666 PIN_SPRITE = new class_8666(TextureCache.uiImage("pin.png"), TextureCache.uiImage("pin.png"));
    public static final class_8666 OPTIONS_SPRITE = new class_8666(TextureCache.uiImage("option.png"), TextureCache.uiImage("option.png"));
    public static final class_8666 X_OUTLINE_SPRITE = new class_8666(TextureCache.uiImage("x_outline_icon.png"), TextureCache.uiImage("x_outline_icon.png"));
    public static final class_8666 X_SPRITE = new class_8666(TextureCache.uiImage("x_icon.png"), TextureCache.uiImage("x_icon.png"));
    public static final class_2960 TOGGLE_ON = TextureCache.uiImage("toggle-button-on.png");
    public static final class_2960 TOGGLE_OFF = TextureCache.uiImage("toggle-button-off.png");
    public static final class_2960 ARROW_GLYPH = TextureCache.uiImage("arrow_glyph.png");
    public static final class_2960 Question = TextureCache.uiImage("question.png");
    public static final class_2960 GridSquares = TextureCache.uiImage("grid.png");
    public static final class_2960 GridRegionSquares = TextureCache.uiImage("grid-region.png");
    public static final class_2960 GridRegion = TextureCache.uiImage("region.png");
    public static final class_2960 SearchIcon = TextureCache.uiImage("search.png");
    public static final class_2960 ColorPicker = TextureCache.uiImage("colorpick.png");
    public static final class_2960 ColorPicker2 = TextureCache.uiImage("colorpick2.png");
    public static final class_2960 TileSampleDay = TextureCache.uiImage("tile-sample-day.png");
    public static final class_2960 TileSampleNight = TextureCache.uiImage("tile-sample-night.png");
    public static final class_2960 TileSampleUnderground = TextureCache.uiImage("tile-sample-underground.png");
    public static final class_2960 UnknownEntity = TextureCache.uiImage("unknown.png");
    public static final class_2960 Deathpoint = TextureCache.waypointTexture("waypoint-death-icon.png");
    public static final class_2960 Waypoint = TextureCache.waypointTexture("waypoint-icon.png");
    public static final class_2960 MobDot = TextureCache.uiImage("marker-dot-160.png");
    public static final class_2960 MobDotArrow = TextureCache.uiImage("marker-dot-arrow-160.png");
    public static final class_2960 MobDotChevron = TextureCache.uiImage("marker-chevron-160.png");
    public static final class_2960 MobIconArrow = TextureCache.uiImage("marker-icon-arrow-160.png");
    public static final class_2960 MobIconArrowBG = TextureCache.uiImage("marker-icon-arrow-bg-160.png");
    public static final class_2960 MobIcon = TextureCache.uiImage("marker-icon-160.png");
    public static final class_2960 MobIconBG = TextureCache.uiImage("marker-icon-bg-160.png");
    public static final class_2960 MobIconMask = TextureCache.uiImage("marker-icon-mask.png");
    public static final class_2960 PlayerArrow = TextureCache.uiImage("marker-player-160.png");
    public static final class_2960 PlayerArrowBG = TextureCache.uiImage("marker-player-bg-160.png");
    public static final class_2960 PlayerOutline = TextureCache.uiImage("marker-player-outline.png");
    public static final class_2960 Logo = TextureCache.uiImage("ico/journeymap.png");
    public static final class_2960 MinimapSquare128 = TextureCache.uiImage("minimap/minimap-square-128.png");
    public static final class_2960 MinimapSquare256 = TextureCache.uiImage("minimap/minimap-square-256.png");
    public static final class_2960 MinimapSquare512 = TextureCache.uiImage("minimap/minimap-square-512.png");
    public static final class_2960 Discord = TextureCache.uiImage("discord.png");
    public static final class_2960 CurseForge = TextureCache.uiImage("curseforge.png");
    public static final class_2960 Modrinth = TextureCache.uiImage("modrinth.png");
    public static final class_2960 ColorWheel = TextureCache.uiImage("colorwheel.png");
    public static final class_2960 ColorWheelHandler = TextureCache.uiImage("colorwheel-handler.png");
    public static final class_2960 ColorBox = TextureCache.uiImage("color-box.png");
    public static final class_2960 ColorVSlider = TextureCache.uiImage("color-v-slider.png");
    public static final class_2960 ColorVSliderHandler = TextureCache.uiImage("color-v-slider-handler.png");
    public static final class_2960 ColorHistoryButton = TextureCache.uiImage("color-history-button.png");
    public static final class_2960 Flag = TextureCache.uiImage("flag.png");
    public static final class_2960 WaypointEdit = TextureCache.uiImage("waypoint-edit.png");
    public static final class_2960 WaypointOffscreen = TextureCache.uiImage("waypoint-offscreen.png");
    private static final Map<String, class_2960> dynamicTextureMap = Collections.synchronizedMap(new HashMap());
    public static final Map<String, class_1043> colorizedWPIconMap = Collections.synchronizedMap(new HashMap());
    public static final Map<class_2960, class_1043> waypointIconMap = Collections.synchronizedMap(new HashMap());
    public static final Map<class_2960, class_2960> modTextureMap = Collections.synchronizedMap(new HashMap());
    public static final Map<String, class_1043> playerSkins = Collections.synchronizedMap(new HashMap());
    public static final Map<String, class_1043> themeImages = Collections.synchronizedMap(new HashMap());
    private static ThreadPoolExecutor texExec = new ThreadPoolExecutor(2, 4, 15L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(8), new JMThreadFactory("texture"), new ThreadPoolExecutor.CallerRunsPolicy());
    public static final Map<String, class_2960> waypointIconCache = Collections.synchronizedMap(new HashMap<String, class_2960>(){
        {
            this.put(Waypoint.toString(), Waypoint);
            this.put(Deathpoint.toString(), Deathpoint);
        }
    });

    public static class_2960 getTexture(String texturePath) {
        class_2960 tex = dynamicTextureMap.get(texturePath);
        if (tex == null) {
            tex = TextureCache.uiImage(texturePath);
            dynamicTextureMap.put(texturePath, tex);
        }
        return tex;
    }

    public static class_2960 spriteImage(String fileName) {
        class_2960 location = class_2960.method_60655((String)"journeymap", (String)("ui/img/" + fileName));
        return location;
    }

    public static class_2960 waypointTexture(String fileName) {
        return class_2960.method_60655((String)"journeymap", (String)("textures/waypoint/icon/" + fileName));
    }

    public static class_2960 uiImage(String fileName) {
        return class_2960.method_60655((String)"journeymap", (String)("ui/img/" + fileName));
    }

    public static void flush() {
        LogUtils.getLogger().info("[JourneyMap]: Purging Theme Images");
        TextureCache.purgeThemeImages(themeImages);
        LogUtils.getLogger().info("[JourneyMap]: Purging Region Images");
        RegionImageCache.INSTANCE.clear();
        LogUtils.getLogger().info("[JourneyMap]: Purging Mob Icon Images");
        MobIconCache.clearCache();
    }

    public static class_1043 getTexture(class_2960 location) {
        class_1044 textureObject;
        block8: {
            class_1011 image;
            class_1060 textureManager;
            block7: {
                if (location == null) {
                    return null;
                }
                textureManager = class_310.method_1551().method_1531();
                textureObject = ((TextureManagerAccess)textureManager).journeymap$getTex(location);
                if (textureObject == null) break block7;
                if (!(textureObject instanceof class_1049)) break block8;
                class_1049 class_10492 = (class_1049)textureObject;
            }
            if ((image = TextureCache.resolveImage(location)) != null) {
                textureObject = new class_1043(image);
                textureManager.method_4616(location, textureObject);
            }
        }
        try {
            return (class_1043)textureObject;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Not a proper texture for {}", (Object)location);
            return null;
        }
    }

    public static class_1043 getWaypointIcon(class_2960 location) {
        if (!"journeymap".equals(location.method_12836())) {
            class_1060 manager = class_310.method_1551().method_1531();
            class_2960 fakeResource = modTextureMap.get(location);
            if (fakeResource == null || ((TextureManagerAccess)manager).journeymap$getTex(fakeResource) == null) {
                fakeResource = class_2960.method_60655((String)"fake", (String)location.method_12832());
                modTextureMap.put(location, fakeResource);
                try (class_1011 nativeImage = TextureCache.resolveImage(location);){
                    class_1011 img = ImageUtil.getScaledImage(4.0f, nativeImage, false);
                    class_1043 scaledTexture = new class_1043(img);
                    manager.method_4616(fakeResource, (class_1044)scaledTexture);
                    ((TextureAccess)scaledTexture).journeymap$setDisplayHeight(nativeImage.method_4323());
                    ((TextureAccess)scaledTexture).journeymap$setDisplayWidth(nativeImage.method_4323());
                }
            }
            return (class_1043)((TextureManagerAccess)manager).journeymap$getTex(fakeResource);
        }
        return TextureCache.getTexture(location);
    }

    public static <T extends class_1044> Future<T> scheduleTextureTask(Callable<T> textureTask) {
        return texExec.submit(textureTask);
    }

    public static void reset() {
        playerSkins.clear();
        colorizedWPIconMap.clear();
        dynamicTextureMap.clear();
        modTextureMap.clear();
        waypointIconMap.clear();
        TextureCache.getTextures("waypoint/icon").forEach(loc -> waypointIconMap.put((class_2960)loc, TextureCache.getTexture(loc)));
        Arrays.asList(OPTIONS_SPRITE, X_SPRITE, X_OUTLINE_SPRITE, TELEPORT_SPRITE, SHARE_SPRITE, POWER_SPRITE, PIN_SPRITE).forEach(TextureCache::resetSprite);
        Arrays.asList(ARROW_GLYPH, Question, ColorPicker, ColorPicker2, Deathpoint, GridSquares, GridRegionSquares, GridRegion, Logo, MinimapSquare128, MinimapSquare256, MinimapSquare512, MobDot, MobDotArrow, MobDotChevron, PlayerArrow, PlayerArrowBG, PlayerArrowBG, TileSampleDay, TileSampleNight, TileSampleUnderground, UnknownEntity, SearchIcon, Waypoint, WaypointEdit, WaypointOffscreen, ColorPicker, ColorPicker2, GridSquares, GridRegion, GridRegionSquares, TileSampleDay, TileSampleNight, TileSampleUnderground, UnknownEntity).stream().map(TextureCache::getTexture);
    }

    public static Collection<class_2960> getTextures(String path) {
        Map textures = class_310.method_1551().method_1478().method_14488("textures/" + path, location -> location.method_12832().endsWith(".png"));
        return textures.keySet();
    }

    static void resetSprite(class_8666 sprites) {
        TextureCache.getTexture(sprites.comp_1605());
        TextureCache.getTexture(sprites.comp_1607());
        TextureCache.getTexture(sprites.comp_1604());
        TextureCache.getTexture(sprites.comp_1606());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeThemeImages(Map<String, class_1043> themeImages) {
        Map<String, class_1043> map = themeImages;
        synchronized (map) {
            themeImages.values().forEach(class_1043::close);
            themeImages.clear();
        }
    }

    public static class_1011 resolveImage(class_2960 location) {
        if (location.method_12836().equals("fake")) {
            return null;
        }
        class_3300 resourceManager = class_310.method_1551().method_1478();
        try {
            class_3298 resource = resourceManager.method_14486(location).orElse(null);
            InputStream is = resource.method_14482();
            return class_1011.method_4309((InputStream)is);
        }
        catch (FileNotFoundException e) {
            try {
                class_3298 imgFile;
                if ("journeymap".equals(location.method_12836()) && (imgFile = (class_3298)class_310.method_1551().method_1478().method_14486(class_2960.method_60654((String)("../src/main/resources/assets/journeymap/" + location.method_12832()))).orElse(null)) != null) {
                    return class_1011.method_4309((InputStream)imgFile.method_14482());
                }
            }
            catch (IOException ioe) {
                Journeymap.getLogger().warn("Image not found: " + ioe.getMessage());
            }
            return null;
        }
        catch (Exception e) {
            JMLogger.throwLogOnce("Resource not readable: " + String.valueOf(location), e);
            return null;
        }
    }

    public static class_1043 getThemeTexture(Theme theme, String iconPath) {
        return TextureCache.getSizedThemeTexture(theme, iconPath, 0, 0, false, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_1043 getThemeTextureFromResource(class_2960 icon) {
        Map<String, class_1043> map = themeImages;
        synchronized (map) {
            class_1043 tex = themeImages.get(icon.toString());
            if (tex == null || !((TextureAccess)tex).journeymap$hasImage()) {
                class_1011 nativeImage;
                if (tex != null) {
                    ImageUtil.closeSafely(tex);
                }
                if ((nativeImage = TextureCache.resolveImage(icon)) != null && nativeImage.field_4988 > 0L) {
                    tex = new class_1043(nativeImage);
                    themeImages.put(icon.toString(), tex);
                } else {
                    Journeymap.getLogger().error("Unknown theme image: {}", (Object)icon);
                    IconSetFileHandler.ensureEntityIconSet("Default");
                    return TextureCache.getTexture(UnknownEntity);
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_1043 getSizedThemeTexture(Theme theme, String iconPath, int width, int height, boolean resize, float alpha) {
        String texName = String.format("%s/%s", theme.directory, iconPath);
        Map<String, class_1043> map = themeImages;
        synchronized (map) {
            class_1043 tex = themeImages.get(texName);
            if (tex == null || !((TextureAccess)tex).journeymap$hasImage() || resize && (width != ((TextureAccess)tex).journeymap$getWidth() || height != ((TextureAccess)tex).journeymap$getHeight())) {
                File parentDir;
                class_1011 nativeImage;
                if (tex != null) {
                    ImageUtil.closeSafely(tex);
                }
                if ((nativeImage = FileHandler.getIconFromFile(parentDir = ThemeLoader.getThemeIconDir(), theme.directory, iconPath)) == null) {
                    String resourcePath = String.format("theme/%s/%s", theme.directory, iconPath);
                    nativeImage = TextureCache.resolveImage(class_2960.method_60655((String)"journeymap", (String)resourcePath));
                }
                if (nativeImage != null && nativeImage.field_4988 > 0L) {
                    if ((resize || alpha < 1.0f) && (alpha < 1.0f || nativeImage.method_4307() != width || nativeImage.method_4323() != height)) {
                        class_1011 tmp = ImageUtil.getSizedImage(width, height, nativeImage, false);
                        nativeImage.close();
                        nativeImage = tmp;
                    }
                    tex = new class_1043(nativeImage);
                    themeImages.put(texName, tex);
                } else {
                    Journeymap.getLogger().error("Unknown theme image: " + texName);
                    IconSetFileHandler.ensureEntityIconSet("Default");
                    return TextureCache.getTexture(UnknownEntity);
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static class_1043 getScaledCopy(String texName, class_1043 original, int width, int height, float alpha) {
        Map<String, class_1043> map = themeImages;
        synchronized (map) {
            try {
                class_1043 tex = themeImages.get(texName);
                if (tex == null || !((TextureAccess)tex).journeymap$hasImage() || width != ((TextureAccess)tex).journeymap$getWidth() || height != ((TextureAccess)tex).journeymap$getHeight()) {
                    if (original == null) {
                        Journeymap.getLogger().error("Unable to get scaled image: " + texName);
                        return TextureCache.getTexture(UnknownEntity);
                    }
                    if (!(alpha < 1.0f) && ((TextureAccess)original).journeymap$getWidth() == width && ((TextureAccess)original).journeymap$getHeight() == height) {
                        return original;
                    }
                    tex = new class_1043(ImageUtil.getSizedImage(width, height, original.method_4525(), true));
                    themeImages.put(texName, tex);
                }
                return tex;
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Unable to get scaled image: {}", (Object)texName, (Object)e);
                return original;
            }
        }
    }

    public static class_1043 getColorizedWaypointIcon(String id) {
        ClientWaypointImpl holder = WaypointStore.getInstance().get(id);
        if (holder != null) {
            class_2960 location = holder.getTextureResource();
            int color = holder.getIconColor();
            class_1060 textureManager = class_310.method_1551().method_1531();
            if (holder.hasCustomIconColor() || "journeymap".equals(location.method_12836())) {
                class_1011 nativeImage = TextureCache.resolveImage(location);
                if (colorizedWPIconMap.get(id) == null && nativeImage != null && nativeImage.field_4988 != 0L) {
                    class_1011 coloredImage = ImageUtil.recolorImage(nativeImage, color);
                    class_1043 texture = new class_1043(coloredImage);
                    colorizedWPIconMap.put(id, texture);
                    nativeImage.close();
                    return texture;
                }
                return colorizedWPIconMap.get(id);
            }
            return (class_1043)((TextureManagerAccess)textureManager).journeymap$getTex(location);
        }
        return null;
    }

    public static class_1043 getPlayerSkin(GameProfile profile) {
        return IgnSkin.getFace(profile);
    }
}

