/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.data;

import fi.dy.masa.malilib.MaLiLib;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;

public class DataDump {
    public static final String EMPTY_STRING = "";
    protected final int columns;
    protected Alignment[] alignment;
    protected boolean[] columnIsNumeric;
    protected Row title;
    protected List<Row> headers = new ArrayList<Row>();
    protected List<Row> footers = new ArrayList<Row>();
    protected List<Row> lines = new ArrayList<Row>();
    protected int[] widths;
    protected int totalWidth;
    protected String formatStringColumns;
    protected String formatStringSingleCenter;
    protected String formatStringSingleLeft;
    protected String formatStringTitleCSV;
    protected String formatStringSingleLeftCSV;
    protected String lineSeparator;
    protected boolean useColumnSeparator = false;
    protected boolean centerTitle = false;
    protected boolean repeatTitleAtBottom = true;
    private boolean sort = true;
    private Format format = Format.ASCII;

    public DataDump(int columns) {
        this(columns, Format.ASCII);
    }

    public DataDump(int columns, Format format) {
        this.columns = columns;
        this.format = format;
        this.alignment = new Alignment[this.columns];
        this.columnIsNumeric = new boolean[this.columns];
        this.widths = new int[this.columns];
        Arrays.fill((Object[])this.alignment, (Object)Alignment.LEFT);
        Arrays.fill(this.columnIsNumeric, false);
    }

    public DataDump setColumnProperties(int columnId, Alignment align, boolean isNumeric) {
        this.setColumnAlignment(columnId, align);
        this.columnIsNumeric[columnId] = isNumeric;
        return this;
    }

    public DataDump setColumnAlignment(int columnId, Alignment align) {
        if (columnId >= this.columns) {
            throw new IllegalArgumentException("setColumnAlignment(): Invalid column id '" + columnId + "', max is " + (this.columns - 1));
        }
        this.alignment[columnId] = align;
        return this;
    }

    public DataDump setColumnIsNumeric(int columnId, boolean isNumeric) {
        if (columnId >= this.columns) {
            throw new IllegalArgumentException("setColumnIsNumeric(): Invalid column id '" + columnId + "', max is " + (this.columns - 1));
        }
        this.columnIsNumeric[columnId] = isNumeric;
        return this;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public void setCenterTitle(boolean center) {
        this.centerTitle = center;
    }

    public void setRepeatTitleAtBottom(boolean repeat) {
        this.repeatTitleAtBottom = repeat;
    }

    public void setUseColumnSeparator(boolean value) {
        this.useColumnSeparator = value;
    }

    public void addTitle(String ... data) {
        if (this.checkHeaderData(data)) {
            this.title = new Row(data);
        }
    }

    public void addHeader(String ... data) {
        this.headers.add(new Row(data));
    }

    public void addHeader(int index, String ... data) {
        this.headers.add(index, new Row(data));
    }

    public void addFooter(String ... data) {
        this.footers.add(new Row(data));
    }

    public void addData(String ... data) {
        if (this.checkData(data)) {
            this.lines.add(new Row(data));
        }
    }

    private boolean checkHeaderData(String ... data) {
        if (data.length != 1 || this.columns == 1) {
            return this.checkData(data);
        }
        return false;
    }

    private void checkAllHeaders() {
        if (this.format == Format.ASCII && this.columns != 1) {
            int i;
            if (this.title != null) {
                this.checkHeaderLength(this.title);
            }
            int size = this.headers.size();
            for (i = 0; i < size; ++i) {
                this.checkHeaderLength(this.headers.get(i));
            }
            size = this.footers.size();
            for (i = 0; i < size; ++i) {
                this.checkHeaderLength(this.footers.get(i));
            }
        }
    }

    private void checkHeaderLength(Row row) {
        String[] values = row.getValues();
        if (values.length == 1) {
            this.checkHeaderLength(values[0]);
        }
    }

    private void checkHeaderLength(String header) {
        int columns;
        int space;
        int len = header.length();
        if (len > (space = this.totalWidth + Math.max((columns = this.widths.length) - 1, 0) * 3)) {
            int diff = len - space;
            int n = this.widths.length - 1;
            this.widths[n] = this.widths[n] + diff;
            this.totalWidth += diff;
        }
    }

    private boolean checkData(String ... data) {
        if (data.length != this.columns && data.length != 1) {
            throw new IllegalArgumentException("Invalid number of columns, you must add exactly " + this.columns + " columns for this type of DataDump");
        }
        int total = 0;
        boolean valid = true;
        for (int i = 0; i < data.length; ++i) {
            int width;
            if (data[i] == null) {
                MaLiLib.LOGGER.warn("null value at column index {} on row '{}'", (Object)i, (Object)this.rowDataToString(data));
                valid = false;
                continue;
            }
            if (this.format != Format.ASCII) continue;
            int len = data[i].length();
            if (len > (width = this.widths[i])) {
                this.widths[i] = len;
            }
            total += this.widths[i];
        }
        if (this.format == Format.ASCII && total > this.totalWidth) {
            this.totalWidth = total;
        }
        return valid;
    }

    private String rowDataToString(String ... data) {
        return String.join((CharSequence)", ", data);
    }

    protected void generateFormatStrings() {
        if (this.format == Format.ASCII) {
            this.generateFormatStringsASCII();
        } else if (this.format == Format.CSV) {
            this.generateFormatStringsCSV();
        }
    }

    private String getFormattedLine(Row row) {
        if (this.format == Format.ASCII) {
            return this.getFormattedLineASCII(row);
        }
        if (this.format == Format.CSV) {
            return this.getFormattedLineCSV(row, this.formatStringColumns);
        }
        return EMPTY_STRING;
    }

    private String getFormattedTitle(Row row) {
        if (this.format == Format.ASCII) {
            return this.getFormattedLineASCII(row);
        }
        if (this.format == Format.CSV) {
            return this.getFormattedLineCSV(row, this.formatStringTitleCSV);
        }
        return EMPTY_STRING;
    }

    protected void generateFormatStringsASCII() {
        this.checkAllHeaders();
        String colSep = this.useColumnSeparator ? "|" : " ";
        String lineColSep = this.useColumnSeparator ? "+" : "-";
        StringBuilder sbFmt = new StringBuilder(128);
        StringBuilder sbSep = new StringBuilder(256);
        sbFmt.append(colSep);
        sbSep.append(lineColSep);
        for (int i = 0; i < this.columns; ++i) {
            int width = this.widths[i];
            if (this.alignment[i] == Alignment.LEFT) {
                sbFmt.append(String.format(" %%-%ds %s", width, colSep));
            } else {
                sbFmt.append(String.format(" %%%ds %s", width, colSep));
            }
            for (int j = 0; j < width + 2; ++j) {
                sbSep.append("-");
            }
            sbSep.append(lineColSep);
        }
        this.formatStringColumns = sbFmt.toString();
        this.lineSeparator = sbSep.toString();
        this.formatStringSingleCenter = colSep + " %%%ds%%s%%%ds " + colSep;
        this.formatStringSingleLeft = colSep + " %%-%ds " + colSep;
    }

    private String getFormattedLineASCII(Row row) {
        Object[] values = row.getValues();
        if (values.length == 1 && this.columns > 1) {
            int space = this.totalWidth + Math.max(this.columns - 1, 0) * 3;
            String fmt = null;
            boolean isCenter = false;
            if (this.centerTitle) {
                String str = String.valueOf(values[0]);
                int len = str.length();
                int start = (space - len) / 2;
                if (start > 0) {
                    fmt = String.format(this.formatStringSingleCenter, start, space - len - start);
                    isCenter = true;
                } else {
                    fmt = String.format(this.formatStringSingleLeft, space);
                }
            } else {
                fmt = String.format(this.formatStringSingleLeft, space);
            }
            return isCenter ? String.format(fmt, " ", values[0], " ") : String.format(fmt, values[0]);
        }
        return String.format(this.formatStringColumns, values);
    }

    protected void generateFormatStringsCSV() {
        StringBuilder sbFmtTitle = new StringBuilder(128);
        StringBuilder sbFmtColumns = new StringBuilder(128);
        StringBuilder sbFmtSingleLeft = new StringBuilder(128);
        String fmtNumeric = "%s";
        String fmtString = "\"%s\"";
        sbFmtSingleLeft.append(this.columnIsNumeric[0] ? "%s" : "\"%s\"");
        for (int i = 0; i < this.columns; ++i) {
            sbFmtTitle.append("\"%s\"");
            sbFmtColumns.append(this.columnIsNumeric[i] ? "%s" : "\"%s\"");
            if (i >= this.columns - 1) continue;
            sbFmtTitle.append(",");
            sbFmtColumns.append(",");
            sbFmtSingleLeft.append(",");
        }
        this.formatStringTitleCSV = sbFmtTitle.toString();
        this.formatStringColumns = sbFmtColumns.toString();
        this.lineSeparator = EMPTY_STRING;
        this.formatStringSingleCenter = EMPTY_STRING;
        this.formatStringSingleLeftCSV = sbFmtSingleLeft.toString();
    }

    private String getFormattedLineCSV(Row row, String formatStringColumns) {
        String[] valuesStr = row.getValues();
        Object[] valuesObj = new Object[valuesStr.length];
        for (int i = 0; i < valuesObj.length; ++i) {
            valuesStr[i] = valuesStr[i].replace("\"", "\"\"");
            if (this.columnIsNumeric[i] && valuesStr[i].contains(",")) {
                valuesStr[i] = "\"" + valuesStr[i] + "\"";
            }
            valuesObj[i] = valuesStr[i].trim();
        }
        if (valuesObj.length == 1 && this.columns > 1) {
            return String.format(this.formatStringSingleLeftCSV, valuesObj[0]);
        }
        return String.format(formatStringColumns, valuesObj);
    }

    protected List<String> getFormattedData(List<String> lines) {
        int i;
        if (this.sort) {
            Collections.sort(this.lines);
        }
        if (this.format == Format.ASCII) {
            lines.add(this.lineSeparator);
            int len = this.headers.size();
            if (len > 0) {
                for (i = 0; i < len; ++i) {
                    lines.add(this.getFormattedLine(this.headers.get(i)));
                }
                lines.add(this.lineSeparator);
            }
        }
        if (this.title != null) {
            lines.add(this.getFormattedTitle(this.title));
            if (this.format == Format.ASCII) {
                lines.add(this.lineSeparator);
            }
        }
        int rows = this.lines.size();
        for (i = 0; i < rows; ++i) {
            lines.add(this.getFormattedLine(this.lines.get(i)));
        }
        if (this.format == Format.ASCII) {
            if (this.repeatTitleAtBottom && this.title != null) {
                lines.add(this.lineSeparator);
                lines.add(this.getFormattedLine(this.title));
            }
            lines.add(this.lineSeparator);
            int len = this.footers.size();
            if (len > 0) {
                for (int i2 = 0; i2 < len; ++i2) {
                    lines.add(this.getFormattedLine(this.footers.get(i2)));
                }
                lines.add(this.lineSeparator);
            }
        }
        return lines;
    }

    public List<String> getLines() {
        ArrayList<String> lines = new ArrayList<String>();
        this.generateFormatStrings();
        this.getFormattedData(lines);
        return lines;
    }

    @Nullable
    public static File dumpDataToFile(File dir, String fileNameBase, List<String> lines, Format format) {
        if (format == Format.CSV) {
            return DataDump.dumpDataToFile(dir, fileNameBase + "-csv", ".csv", lines);
        }
        return DataDump.dumpDataToFile(dir, fileNameBase, ".txt", lines);
    }

    @Nullable
    public static File dumpDataToFile(File dir, String fileNameBase, List<String> lines) {
        return DataDump.dumpDataToFile(dir, fileNameBase, ".txt", lines);
    }

    @Nullable
    public static File dumpDataToFile(File dir, String fileNameBase, String fileNameExtension, List<String> lines) {
        File outFile = null;
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (Exception e) {
                MaLiLib.LOGGER.error("dumpDataToFile(): Failed to create the configuration directory", (Throwable)e);
                return null;
            }
        }
        String fileNameBaseWithDate = fileNameBase + "_" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date(System.currentTimeMillis()));
        String fileName = fileNameBaseWithDate + fileNameExtension;
        outFile = new File(dir, fileName);
        for (int postFix = 1; outFile.exists() && postFix < 100; ++postFix) {
            fileName = fileNameBaseWithDate + "_" + postFix + fileNameExtension;
            outFile = new File(dir, fileName);
        }
        if (outFile.exists()) {
            MaLiLib.LOGGER.error("dumpDataToFile(): Failed to create data dump file '{}', one already exists", (Object)fileName);
            return null;
        }
        try {
            outFile.createNewFile();
        }
        catch (IOException e) {
            MaLiLib.LOGGER.error("dumpDataToFile(): Failed to create data dump file '{}'", (Object)fileName, (Object)e);
            return null;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
            int size = lines.size();
            for (int i = 0; i < size; ++i) {
                writer.write(lines.get(i));
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            MaLiLib.LOGGER.error("dumpDataToFile(): Exception while writing data dump to file '{}'", (Object)fileName, (Object)e);
        }
        return outFile;
    }

    public static void printDataToLogger(List<String> lines) {
        int size = lines.size();
        for (int i = 0; i < size; ++i) {
            MaLiLib.LOGGER.info(lines.get(i));
        }
    }

    public static enum Format {
        ASCII,
        CSV;

    }

    public static enum Alignment {
        LEFT,
        RIGHT;

    }

    public static class Row
    implements Comparable<Row> {
        private final String[] strings;
        private final Double[] numbers;

        public Row(String[] strings) {
            this.strings = strings;
            this.numbers = new Double[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                try {
                    this.numbers[i] = Double.parseDouble(strings[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public String[] getValues() {
            return this.strings;
        }

        @Override
        public int compareTo(Row other) {
            for (int i = 0; i < this.strings.length; ++i) {
                if (this.numbers[i] != null && other.numbers[i] != null) {
                    double d2;
                    double d1 = this.numbers[i];
                    if (d1 < (d2 = other.numbers[i].doubleValue())) {
                        return -1;
                    }
                    if (!(d1 > d2)) continue;
                    return 1;
                }
                int res = this.strings[i].compareTo(other.strings[i]);
                if (res == 0) continue;
                return res;
            }
            return 0;
        }
    }
}

