/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigLockedListEntry;
import fi.dy.masa.malilib.config.IConfigLockedListType;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class ConfigTestLockedList
implements IConfigLockedListType {
    public static final ConfigTestLockedList INSTANCE = new ConfigTestLockedList();
    public ImmutableList<Entry> VALUES = ImmutableList.copyOf((Object[])Entry.values());

    @Override
    public ImmutableList<IConfigLockedListEntry> getDefaultEntries() {
        ImmutableList.Builder list = ImmutableList.builder();
        this.VALUES.forEach(arg_0 -> ((ImmutableList.Builder)list).add(arg_0));
        return list.build();
    }

    @Override
    @Nullable
    public IConfigLockedListEntry fromString(String element) {
        return Entry.fromString(element);
    }

    public static enum Entry implements IConfigLockedListEntry
    {
        TEST1("test1", "test1"),
        TEST2("test2", "test2"),
        TEST3("test3", "test3"),
        TEST4("test4", "test4");

        private final String configKey;
        private final String translationKey;

        private Entry(String configKey, String translationKey) {
            this.configKey = configKey;
            this.translationKey = "malilib.gui.label.locked_test." + translationKey;
        }

        @Override
        public String getStringValue() {
            return this.configKey;
        }

        @Override
        public String getDisplayName() {
            return StringUtils.getTranslatedOrFallback(this.translationKey, this.configKey);
        }

        @Nullable
        public static Entry fromString(String key) {
            for (Entry entry : Entry.values()) {
                if (entry.configKey.equalsIgnoreCase(key)) {
                    return entry;
                }
                if (entry.translationKey.equalsIgnoreCase(key)) {
                    return entry;
                }
                if (!StringUtils.hasTranslation(entry.translationKey) || !StringUtils.translate(entry.translationKey, new Object[0]).equalsIgnoreCase(key)) continue;
                return entry;
            }
            return null;
        }
    }
}

