/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.test.TestUtils;
import fi.dy.masa.malilib.util.Color4f;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_5944;
import net.minecraft.class_8555;
import net.minecraft.class_9801;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@ApiStatus.Experimental
public class TestWalls
implements AutoCloseable {
    protected static final class_289 TESSELLATOR_1 = new class_289(0x200000);
    protected static final class_289 TESSELLATOR_2 = new class_289(0x200000);
    protected static class_287 BUFFER_1;
    protected static class_287 BUFFER_2;
    protected static class_291 VERTEX_1;
    protected static class_291 VERTEX_2;
    protected static class_10156 SHADER_1;
    protected static class_10156 SHADER_2;
    protected static boolean renderThrough;
    protected static boolean useCulling;
    protected static float glLineWidth;
    protected static class_2338 lastPos;
    private static class_243 updateCameraPos;
    private static boolean hasData;

    public static class_243 getUpdatePosition() {
        return updateCameraPos;
    }

    public static void setUpdatePosition(class_243 cameraPosition) {
        updateCameraPos = cameraPosition;
    }

    public static boolean needsUpdate(class_2338 pos) {
        if (lastPos.equals((Object)class_2338.field_10980)) {
            lastPos = pos;
            return true;
        }
        if (!pos.equals((Object)class_2338.field_10980) && !pos.equals((Object)lastPos)) {
            lastPos = pos;
            return true;
        }
        return false;
    }

    public static void update(class_4184 camera, class_310 mc) {
        Color4f color = MaLiLibConfigs.Test.TEST_CONFIG_COLOR.getColor();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        class_2338 pos = camera.method_19328();
        class_243 vec = camera.method_19326();
        int radius = 5;
        if (VERTEX_1 == null || VERTEX_1.method_43444()) {
            VERTEX_1 = new class_291(class_8555.field_54340);
        }
        if (VERTEX_2 == null || VERTEX_2.method_43444()) {
            VERTEX_2 = new class_291(class_8555.field_54340);
        }
        BUFFER_1 = TESSELLATOR_1.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        BUFFER_2 = TESSELLATOR_2.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        Pair<class_2338, class_2338> corners = TestUtils.getSpawnChunkCorners(pos, radius, (class_1937)mc.field_1687);
        TestUtils.renderWallsWithLines((class_2338)corners.getLeft(), (class_2338)corners.getRight(), vec, 16.0, 16.0, true, color, BUFFER_1, BUFFER_2);
        TestWalls.uploadData(BUFFER_1, VERTEX_1);
        TestWalls.uploadData(BUFFER_2, VERTEX_2);
        TestWalls.setUpdatePosition(vec);
    }

    private static void uploadData(class_287 bufferBuilder, class_291 vertexBuffer) {
        if (vertexBuffer.method_43444()) {
            return;
        }
        try {
            class_9801 builtBuffer = bufferBuilder.method_60794();
            if (builtBuffer != null) {
                hasData = true;
                vertexBuffer.method_1353();
                vertexBuffer.method_1352(builtBuffer);
                class_291.method_1354();
                builtBuffer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void preRender() {
        RenderSystem.lineWidth((float)glLineWidth);
        if (renderThrough) {
            RenderSystem.disableDepthTest();
        }
        if (useCulling) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
    }

    protected static void postRender() {
        if (renderThrough) {
            RenderSystem.enableDepthTest();
        }
        RenderSystem.enableCull();
    }

    public static void draw(class_243 cameraPos, Matrix4f matrix4f, Matrix4f projMatrix, class_310 mc, class_3695 profiler) {
        profiler.method_15400(() -> "TestWalls#draw()");
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderUtils.setupBlend();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        class_243 updatePos = TestWalls.getUpdatePosition();
        matrix4fstack.pushMatrix();
        matrix4fstack.translate((float)(updatePos.field_1352 - cameraPos.field_1352), (float)(updatePos.field_1351 - cameraPos.field_1351), (float)(updatePos.field_1350 - cameraPos.field_1350));
        TestWalls.drawData(matrix4f, projMatrix);
        matrix4fstack.popMatrix();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        profiler.method_15407();
    }

    private static void drawData(Matrix4f matrix4f, Matrix4f projMatrix) {
        if (hasData) {
            TestWalls.preRender();
            TestWalls.drawInternal(matrix4f, projMatrix, VERTEX_1, SHADER_1);
            TestWalls.drawInternal(matrix4f, projMatrix, VERTEX_2, SHADER_2);
            TestWalls.postRender();
        }
    }

    private static void drawInternal(Matrix4f matrix4f, Matrix4f projMatrix, class_291 vertexBuffer, class_10156 shaderKey) {
        if (hasData) {
            class_5944 shader = RenderSystem.setShader((class_10156)shaderKey);
            vertexBuffer.method_1353();
            vertexBuffer.method_34427(matrix4f, projMatrix, shader);
            class_291.method_1354();
        }
    }

    public static void clear() {
        lastPos = class_2338.field_10980;
        VERTEX_1.close();
        VERTEX_2.close();
        TESSELLATOR_1.method_60828();
        TESSELLATOR_2.method_60828();
        hasData = false;
    }

    @Override
    public void close() {
        TestWalls.clear();
    }

    static {
        SHADER_1 = class_10142.field_53876;
        SHADER_2 = class_10142.field_53876;
        renderThrough = false;
        useCulling = false;
        glLineWidth = 1.0f;
        lastPos = class_2338.field_10980;
        updateCameraPos = class_243.field_1353;
        hasData = false;
    }
}

