/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.client.gui.AbstractContainerEventHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public abstract class DynamicErrorFreeEntryListWidget<E extends Entry<E>>
extends AbstractContainerEventHandler
implements class_4068,
class_6379 {
    protected static final int DRAG_OUTSIDE = -2;
    protected final class_310 client;
    private final List<E> entries = new Entries();
    public int width;
    public int height;
    public int top;
    public int bottom;
    public int right;
    public int left;
    protected boolean verticallyCenter = true;
    protected int yDrag = -2;
    protected boolean selectionVisible = true;
    protected boolean renderSelection;
    protected int headerHeight;
    protected double scroll;
    protected boolean scrolling;
    @Nullable
    protected E hoveredItem;
    protected E selectedItem;
    protected class_2960 backgroundLocation;

    public DynamicErrorFreeEntryListWidget(class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
        this.backgroundLocation = backgroundLocation;
    }

    public void setRenderSelection(boolean boolean_1) {
        this.selectionVisible = boolean_1;
    }

    protected void setRenderHeader(boolean boolean_1, int headerHeight) {
        this.renderSelection = boolean_1;
        this.headerHeight = headerHeight;
        if (!boolean_1) {
            this.headerHeight = 0;
        }
    }

    public class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        return this.hoveredItem != null ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 narrationElementOutput) {
        E entry = this.hoveredItem;
        if (entry != null) {
            ((Entry)entry).updateNarration(narrationElementOutput.method_37031());
            this.narrateListElementPosition(narrationElementOutput, entry);
        } else {
            E entry2 = this.getFocused();
            if (entry2 != null) {
                ((Entry)entry2).updateNarration(narrationElementOutput.method_37031());
                this.narrateListElementPosition(narrationElementOutput, entry2);
            }
        }
        narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
    }

    protected void narrateListElementPosition(class_6382 narrationElementOutput, E entry) {
        int i;
        List<E> list = this.method_25396();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            narrationElementOutput.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    public int getItemWidth() {
        return 220;
    }

    public E getSelectedItem() {
        return this.selectedItem;
    }

    public void selectItem(E item) {
        this.selectedItem = item;
    }

    public E getFocused() {
        return (E)((Entry)super.method_25399());
    }

    public final List<E> method_25396() {
        return this.entries;
    }

    protected final void clearItems() {
        this.entries.clear();
    }

    protected E getItem(int index) {
        return (E)((Entry)this.method_25396().get(index));
    }

    protected int addItem(E item) {
        this.entries.add(item);
        return this.entries.size() - 1;
    }

    protected int getItemCount() {
        return this.method_25396().size();
    }

    protected boolean isSelected(int index) {
        return Objects.equals(this.getSelectedItem(), this.method_25396().get(index));
    }

    protected final E getItemAtPosition(double mouseX, double mouseY) {
        int listMiddleX = this.left + this.width / 2;
        int minX = listMiddleX - this.getItemWidth() / 2;
        int maxX = listMiddleX + this.getItemWidth() / 2;
        int currentY = class_3532.method_15357((double)(mouseY - (double)this.top)) - this.headerHeight + (int)this.getScroll() - 4;
        int itemY = 0;
        int itemIndex = -1;
        for (int i = 0; i < this.entries.size(); ++i) {
            E item = this.getItem(i);
            if ((itemY += ((Entry)item).getItemHeight()) <= currentY) continue;
            itemIndex = i;
            break;
        }
        return (E)(mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)minX && mouseX <= (double)maxX && itemIndex >= 0 && currentY >= 0 && itemIndex < this.getItemCount() ? (Entry)this.method_25396().get(itemIndex) : null);
    }

    public void updateSize(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setLeftPos(int left) {
        this.left = left;
        this.right = left + this.width;
    }

    protected int getMaxScrollPosition() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = this.headerHeight;
        for (Entry entry : this.entries) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0);
    }

    protected void clickedHeader(int int_1, int int_2) {
    }

    public static void renderBackBackground(class_332 graphics, class_2960 backgroundLocation, int left, int top, int right, int bottom, int yOffset, int color) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_64039(source -> {
            class_4588 buffer = source.getBuffer(class_1921.method_62277((class_2960)backgroundLocation));
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            buffer.method_22918(matrix, (float)left, (float)bottom, 0.0f).method_22913((float)left / 32.0f, (float)(bottom + yOffset) / 32.0f).method_1336(color, color, color, 255);
            buffer.method_22918(matrix, (float)right, (float)bottom, 0.0f).method_22913((float)right / 32.0f, (float)(bottom + yOffset) / 32.0f).method_1336(color, color, color, 255);
            buffer.method_22918(matrix, (float)right, (float)top, 0.0f).method_22913((float)right / 32.0f, (float)(top + yOffset) / 32.0f).method_1336(color, color, color, 255);
            buffer.method_22918(matrix, (float)left, (float)top, 0.0f).method_22913((float)left / 32.0f, (float)(top + yOffset) / 32.0f).method_1336(color, color, color, 255);
        });
    }

    protected void drawBackground() {
    }

    protected void renderDecorations(class_332 graphics, int mouseX, int mouseY) {
    }

    protected void renderHeader(class_332 graphics, int rowLeft, int startY) {
    }

    @Deprecated
    protected void renderBackBackground(class_332 graphics) {
        DynamicErrorFreeEntryListWidget.renderBackBackground(graphics, this.backgroundLocation, this.left, this.top, this.right, this.bottom, (int)this.getScroll(), 32);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.drawBackground();
        int scrollbarPosition = this.getScrollbarPosition();
        int int_4 = scrollbarPosition + 6;
        this.renderBackBackground(graphics);
        int rowLeft = this.getRowLeft();
        int startY = this.top + 4 - (int)this.getScroll();
        if (this.renderSelection) {
            this.renderHeader(graphics, rowLeft, startY);
        }
        this.renderList(graphics, rowLeft, startY, mouseX, mouseY, delta);
        RenderSystem.disableDepthTest();
        this.renderHoleBackground(graphics, 0, this.top, 255, 255);
        this.renderHoleBackground(graphics, this.bottom, this.height, 255, 255);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        buffer.method_22918(matrix, (float)this.left, (float)(this.top + 4), 0.0f).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 0);
        buffer.method_22918(matrix, (float)this.right, (float)(this.top + 4), 0.0f).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 0);
        buffer.method_22918(matrix, (float)this.right, (float)this.top, 0.0f).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 255);
        buffer.method_22918(matrix, (float)this.left, (float)this.top, 0.0f).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 255);
        buffer.method_22918(matrix, (float)this.left, (float)this.bottom, 0.0f).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 255);
        buffer.method_22918(matrix, (float)this.right, (float)this.bottom, 0.0f).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 255);
        buffer.method_22918(matrix, (float)this.right, (float)(this.bottom - 4), 0.0f).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 0);
        buffer.method_22918(matrix, (float)this.left, (float)(this.bottom - 4), 0.0f).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 0);
        class_286.method_43433((class_9801)buffer.method_60800());
        int maxScroll = this.getMaxScroll();
        this.renderScrollBar(graphics, maxScroll, scrollbarPosition, int_4);
        this.renderDecorations(graphics, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    protected void renderScrollBar(class_332 graphics, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (maxScroll > 0) {
            int height = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            height = class_3532.method_15340((int)height, (int)32, (int)(this.bottom - this.top - 8));
            int y = (int)this.getScroll() * (this.bottom - this.top - height) / maxScroll + this.top;
            if (y < this.top) {
                y = this.top;
            }
            int finalY = y;
            int finalHeight = height;
            graphics.method_64039(source -> {
                class_4588 buffer = source.getBuffer(class_1921.method_51784());
                Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
                buffer.method_22918(matrix, (float)scrollbarPositionMinX, (float)this.bottom, 0.0f).method_1336(0, 0, 0, 255);
                buffer.method_22918(matrix, (float)scrollbarPositionMaxX, (float)this.bottom, 0.0f).method_1336(0, 0, 0, 255);
                buffer.method_22918(matrix, (float)scrollbarPositionMaxX, (float)this.top, 0.0f).method_1336(0, 0, 0, 255);
                buffer.method_22918(matrix, (float)scrollbarPositionMinX, (float)this.top, 0.0f).method_1336(0, 0, 0, 255);
                buffer.method_22918(matrix, (float)scrollbarPositionMinX, (float)(finalY + finalHeight), 0.0f).method_1336(128, 128, 128, 255);
                buffer.method_22918(matrix, (float)scrollbarPositionMaxX, (float)(finalY + finalHeight), 0.0f).method_1336(128, 128, 128, 255);
                buffer.method_22918(matrix, (float)scrollbarPositionMaxX, (float)finalY, 0.0f).method_1336(128, 128, 128, 255);
                buffer.method_22918(matrix, (float)scrollbarPositionMinX, (float)finalY, 0.0f).method_1336(128, 128, 128, 255);
                buffer.method_22912((float)scrollbarPositionMinX, (float)(finalY + finalHeight - 1), 0.0f).method_1336(192, 192, 192, 255);
                buffer.method_22912((float)(scrollbarPositionMaxX - 1), (float)(finalY + finalHeight - 1), 0.0f).method_1336(192, 192, 192, 255);
                buffer.method_22912((float)(scrollbarPositionMaxX - 1), (float)finalY, 0.0f).method_1336(192, 192, 192, 255);
                buffer.method_22912((float)scrollbarPositionMinX, (float)finalY, 0.0f).method_1336(192, 192, 192, 255);
            });
        }
    }

    protected void centerScrollOn(E item) {
        double d = (double)(this.bottom - this.top) / -2.0;
        for (int i = 0; i < this.method_25396().indexOf(item) && i < this.getItemCount(); ++i) {
            d += (double)((Entry)this.getItem(i)).getItemHeight();
        }
        this.capYPosition(d);
    }

    protected void ensureVisible(E item) {
        int int_3;
        int rowTop = this.getRowTop(this.method_25396().indexOf(item));
        int int_2 = rowTop - this.top - 4 - ((Entry)item).getItemHeight();
        if (int_2 < 0) {
            this.scroll(int_2);
        }
        if ((int_3 = this.bottom - rowTop - ((Entry)item).getItemHeight() * 2) < 0) {
            this.scroll(-int_3);
        }
    }

    protected void scroll(int int_1) {
        this.capYPosition(this.getScroll() + (double)int_1);
        this.yDrag = -2;
    }

    public double getScroll() {
        return this.scroll;
    }

    public void capYPosition(double double_1) {
        this.scroll = class_3532.method_15350((double)double_1, (double)0.0, (double)this.getMaxScroll());
    }

    protected int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - (this.bottom - this.top - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScroll() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        this.scrolling = int_1 == 0 && double_1 >= (double)this.getScrollbarPosition() && double_1 < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        this.updateScrollingState(double_1, double_2, int_1);
        if (!this.method_25405(double_1, double_2)) {
            return false;
        }
        E item = this.getItemAtPosition(double_1, double_2);
        if (item != null) {
            if (item.method_25402(double_1, double_2, int_1)) {
                this.method_25395((class_364)item);
                this.method_25398(true);
                return true;
            }
        } else if (int_1 == 0) {
            this.clickedHeader((int)(double_1 - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(double_2 - (double)this.top) + (int)this.getScroll() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean method_25406(double double_1, double double_2, int int_1) {
        if (this.getFocused() != null) {
            this.getFocused().method_25406(double_1, double_2, int_1);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.capYPosition(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = class_3532.method_15340((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(this.getScroll() + deltaY * double_6);
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double double_1, double double_2, double amountX, double amountY) {
        for (Entry entry : this.entries) {
            if (!entry.method_25401(double_1, double_2, amountX, amountY)) continue;
            return true;
        }
        if (amountY == 0.0) {
            return false;
        }
        this.capYPosition(this.getScroll() - amountY * (double)(this.getMaxScroll() / this.getItemCount()) / 2.0);
        return true;
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (super.method_25404(int_1, int_2, int_3)) {
            return true;
        }
        if (int_1 == 264) {
            this.moveSelection(1);
            return true;
        }
        if (int_1 == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int int_1) {
        if (!this.method_25396().isEmpty()) {
            int int_2 = this.method_25396().indexOf(this.getSelectedItem());
            int int_3 = class_3532.method_15340((int)(int_2 + int_1), (int)0, (int)(this.getItemCount() - 1));
            Entry itemListWidget$Item_1 = (Entry)this.method_25396().get(int_3);
            this.selectItem(itemListWidget$Item_1);
            this.ensureVisible(itemListWidget$Item_1);
        }
    }

    public boolean method_25405(double double_1, double double_2) {
        return double_2 >= (double)this.top && double_2 <= (double)this.bottom && double_1 >= (double)this.left && double_1 <= (double)this.right;
    }

    protected void renderList(class_332 graphics, int startX, int startY, int int_3, int int_4, float float_1) {
        this.hoveredItem = this.method_25405(int_3, int_4) ? this.getItemAtPosition(int_3, int_4) : null;
        int itemCount = this.getItemCount();
        class_289 tessellator = class_289.method_1348();
        for (int renderIndex = 0; renderIndex < itemCount; ++renderIndex) {
            E item = this.getItem(renderIndex);
            int itemY = startY + this.headerHeight;
            for (int i = 0; i < this.entries.size() && i < renderIndex; ++i) {
                itemY += ((Entry)this.entries.get(i)).getItemHeight();
            }
            int itemHeight = ((Entry)item).getItemHeight() - 4;
            int itemWidth = this.getItemWidth();
            if (this.selectionVisible && this.isSelected(renderIndex)) {
                int itemMinX = this.left + this.width / 2 - itemWidth / 2;
                int itemMaxX = itemMinX + itemWidth;
                float float_2 = this.method_25370() ? 1.0f : 0.5f;
                Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int finalItemY = itemY;
                graphics.method_64039(source -> {
                    class_4588 buffer = source.getBuffer(class_1921.method_51784());
                    buffer.method_22918(matrix, (float)itemMinX, (float)(finalItemY + itemHeight + 2), 0.0f).method_22915(float_2, float_2, float_2, 1.0f);
                    buffer.method_22918(matrix, (float)itemMaxX, (float)(finalItemY + itemHeight + 2), 0.0f).method_22915(float_2, float_2, float_2, 1.0f);
                    buffer.method_22918(matrix, (float)itemMaxX, (float)(finalItemY - 2), 0.0f).method_22915(float_2, float_2, float_2, 1.0f);
                    buffer.method_22918(matrix, (float)itemMinX, (float)(finalItemY - 2), 0.0f).method_22915(float_2, float_2, float_2, 1.0f);
                    buffer.method_22918(matrix, (float)(itemMinX + 1), (float)(finalItemY + itemHeight + 1), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 1.0f);
                    buffer.method_22918(matrix, (float)(itemMaxX - 1), (float)(finalItemY + itemHeight + 1), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 1.0f);
                    buffer.method_22918(matrix, (float)(itemMaxX - 1), (float)(finalItemY - 1), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 1.0f);
                    buffer.method_22918(matrix, (float)(itemMinX + 1), (float)(finalItemY - 1), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 1.0f);
                });
            }
            int y = this.getRowTop(renderIndex);
            int x = this.getRowLeft();
            this.renderItem(graphics, item, renderIndex, y, x, itemWidth, itemHeight, int_3, int_4, Objects.equals(this.hoveredItem, item), float_1);
        }
    }

    protected void renderItem(class_332 graphics, E item, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        ((Entry)item).render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
    }

    protected int getRowLeft() {
        return this.left + this.width / 2 - this.getItemWidth() / 2 + 2;
    }

    protected int getRowTop(int index) {
        int integer = this.top + 4 - (int)this.getScroll() + this.headerHeight;
        for (int i = 0; i < this.entries.size() && i < index; ++i) {
            integer += ((Entry)this.entries.get(i)).getItemHeight();
        }
        return integer;
    }

    public boolean method_25370() {
        return false;
    }

    protected void renderHoleBackground(class_332 graphics, int y1, int y2, int alpha1, int alpha2) {
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_64039(source -> {
            class_4588 buffer = source.getBuffer(class_1921.method_62277((class_2960)this.backgroundLocation));
            buffer.method_22918(matrix, (float)this.left, (float)y2, 0.0f).method_22913(0.0f, (float)y2 / 32.0f).method_1336(64, 64, 64, alpha2);
            buffer.method_22918(matrix, (float)(this.left + this.width), (float)y2, 0.0f).method_22913((float)this.width / 32.0f, (float)y2 / 32.0f).method_1336(64, 64, 64, alpha2);
            buffer.method_22918(matrix, (float)(this.left + this.width), (float)y1, 0.0f).method_22913((float)this.width / 32.0f, (float)y1 / 32.0f).method_1336(64, 64, 64, alpha1);
            buffer.method_22918(matrix, (float)this.left, (float)y1, 0.0f).method_22913(0.0f, (float)y1 / 32.0f).method_1336(64, 64, 64, alpha1);
        });
    }

    protected E remove(int int_1) {
        Entry itemListWidget$Item_1 = (Entry)this.entries.get(int_1);
        return (E)(this.removeEntry((Entry)this.entries.get(int_1)) ? itemListWidget$Item_1 : null);
    }

    protected boolean removeEntry(E itemListWidget$Item_1) {
        boolean boolean_1 = this.entries.remove(itemListWidget$Item_1);
        if (boolean_1 && itemListWidget$Item_1 == this.getSelectedItem()) {
            this.selectItem(null);
        }
        return boolean_1;
    }

    @Environment(value=EnvType.CLIENT)
    class Entries
    extends AbstractList<E> {
        private final ArrayList<E> items = Lists.newArrayList();

        private Entries() {
        }

        @Override
        public void clear() {
            this.items.clear();
        }

        @Override
        public E get(int int_1) {
            return (Entry)this.items.get(int_1);
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public E set(int int_1, E itemListWidget$Item_1) {
            Entry itemListWidget$Item_2 = (Entry)this.items.set(int_1, itemListWidget$Item_1);
            ((Entry)itemListWidget$Item_1).parent = DynamicErrorFreeEntryListWidget.this;
            return itemListWidget$Item_2;
        }

        @Override
        public void add(int int_1, E itemListWidget$Item_1) {
            this.items.add(int_1, itemListWidget$Item_1);
            ((Entry)itemListWidget$Item_1).parent = DynamicErrorFreeEntryListWidget.this;
        }

        @Override
        public E remove(int int_1) {
            return (Entry)this.items.remove(int_1);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry<E extends Entry<E>>
    implements class_364 {
        @Deprecated
        DynamicErrorFreeEntryListWidget<E> parent;
        @Nullable
        private class_6379 lastNarratable;

        public abstract void render(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public boolean method_25405(double double_1, double double_2) {
            return Objects.equals(this.parent.getItemAtPosition(double_1, double_2), this);
        }

        public DynamicErrorFreeEntryListWidget<E> getParent() {
            return this.parent;
        }

        public void setParent(DynamicErrorFreeEntryListWidget<E> parent) {
            this.parent = parent;
        }

        public abstract int getItemHeight();

        @Deprecated
        public int getMorePossibleHeight() {
            return -1;
        }

        public abstract List<? extends class_6379> narratables();

        void updateNarration(class_6382 narrationElementOutput) {
            List<class_6379> list = this.narratables();
            class_437.class_6390 narratableSearchResult = class_437.method_37061(list, (class_6379)this.lastNarratable);
            if (narratableSearchResult != null) {
                if (narratableSearchResult.field_33827.method_37028()) {
                    this.lastNarratable = narratableSearchResult.field_33825;
                }
                if (list.size() > 1) {
                    narrationElementOutput.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.object_list", (Object[])new Object[]{narratableSearchResult.field_33826 + 1, list.size()}));
                    if (narratableSearchResult.field_33827 == class_6379.class_6380.field_33786) {
                        narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
                    }
                }
                narratableSearchResult.field_33825.method_37020(narrationElementOutput.method_37031());
            }
        }
    }

    public static final class SmoothScrollingSettings {
        public static final double CLAMP_EXTENSION = 200.0;

        private SmoothScrollingSettings() {
        }
    }
}

