/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.transformers;

import com.seibel.distanthorizons.api.enums.config.EDhApiWorldCompressionMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.api.objects.data.DhApiChunk;
import com.seibel.distanthorizons.api.objects.data.DhApiTerrainDataPoint;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IMutableBlockPosWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class LodDataBuilder {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IBlockStateWrapper AIR = SingletonInjector.INSTANCE.get(IWrapperFactory.class).getAirBlockStateWrapper();
    private static boolean getTopErrorLogged = false;

    public static FullDataSourceV2 createFromChunk(IChunkWrapper chunkWrapper) {
        LodUtil.assertTrue(chunkWrapper.isDhBlockLightingCorrect());
        int sectionPosX = LodDataBuilder.getXOrZSectionPosFromChunkPos(chunkWrapper.getChunkPos().getX());
        int sectionPosZ = LodDataBuilder.getXOrZSectionPosFromChunkPos(chunkWrapper.getChunkPos().getZ());
        long pos = DhSectionPos.encode((byte)6, sectionPosX, sectionPosZ);
        FullDataSourceV2 dataSource = FullDataSourceV2.createEmpty(pos);
        dataSource.isEmpty = false;
        int chunkOffsetX = chunkWrapper.getChunkPos().getX();
        if (chunkWrapper.getChunkPos().getX() < 0) {
            if ((chunkOffsetX %= 4) != 0) {
                chunkOffsetX += 4;
            }
        } else {
            chunkOffsetX %= 4;
        }
        chunkOffsetX *= 16;
        int chunkOffsetZ = chunkWrapper.getChunkPos().getZ();
        if (chunkWrapper.getChunkPos().getZ() < 0) {
            if ((chunkOffsetZ %= 4) != 0) {
                chunkOffsetZ += 4;
            }
        } else {
            chunkOffsetZ %= 4;
        }
        chunkOffsetZ *= 16;
        EDhApiWorldCompressionMode worldCompressionMode = Config.Common.LodBuilding.worldCompression.get();
        boolean ignoreHiddenBlocks = worldCompressionMode != EDhApiWorldCompressionMode.MERGE_SAME_BLOCKS;
        try {
            IMutableBlockPosWrapper mcBlockPos = chunkWrapper.getMutableBlockPosWrapper();
            IBlockStateWrapper previousBlockState = null;
            int minBuildHeight = chunkWrapper.getMinNonEmptyHeight();
            for (int relBlockX = 0; relBlockX < 16; ++relBlockX) {
                for (int relBlockZ = 0; relBlockZ < 16; ++relBlockZ) {
                    byte skyLight;
                    byte blockLight;
                    LongArrayList longs = dataSource.get(relBlockX + chunkOffsetX, relBlockZ + chunkOffsetZ);
                    if (longs == null) {
                        longs = new LongArrayList(chunkWrapper.getHeight() / 4);
                    } else {
                        longs.clear();
                    }
                    int lastY = chunkWrapper.getExclusiveMaxBuildHeight();
                    IBiomeWrapper biome = chunkWrapper.getBiome(relBlockX, lastY, relBlockZ);
                    IBlockStateWrapper blockState = AIR;
                    int mappedId = dataSource.mapping.addIfNotPresentAndGetId(biome, blockState);
                    if (lastY < chunkWrapper.getExclusiveMaxBuildHeight()) {
                        blockLight = (byte)chunkWrapper.getDhBlockLight(relBlockX, lastY + 1, relBlockZ);
                        skyLight = (byte)chunkWrapper.getDhSkyLight(relBlockX, lastY + 1, relBlockZ);
                    } else {
                        blockLight = 0;
                        skyLight = 15;
                    }
                    int y = Math.max(chunkWrapper.getLightBlockingHeightMapValue(relBlockX, relBlockZ), chunkWrapper.getSolidHeightMapValue(relBlockX, relBlockZ));
                    IBlockStateWrapper topBlockState = previousBlockState = chunkWrapper.getBlockState(relBlockX, y, relBlockZ, mcBlockPos, previousBlockState);
                    while (!topBlockState.isAir() && y < chunkWrapper.getExclusiveMaxBuildHeight()) {
                        try {
                            topBlockState = previousBlockState = chunkWrapper.getBlockState(relBlockX, ++y, relBlockZ, mcBlockPos, previousBlockState);
                        }
                        catch (Exception e) {
                            if (!getTopErrorLogged) {
                                LOGGER.warn("Unexpected issue in LodDataBuilder, future errors won't be logged. Chunk [" + chunkWrapper.getChunkPos() + "] with max height: [" + chunkWrapper.getExclusiveMaxBuildHeight() + "] had issue getting block at pos [" + relBlockX + "," + y + "," + relBlockZ + "] error: " + e.getMessage(), (Throwable)e);
                                getTopErrorLogged = true;
                            }
                            --y;
                            break;
                        }
                    }
                    while (y >= minBuildHeight) {
                        IBiomeWrapper newBiome = chunkWrapper.getBiome(relBlockX, y, relBlockZ);
                        IBlockStateWrapper newBlockState = previousBlockState = chunkWrapper.getBlockState(relBlockX, y, relBlockZ, mcBlockPos, previousBlockState);
                        byte newBlockLight = (byte)chunkWrapper.getDhBlockLight(relBlockX, y + 1, relBlockZ);
                        byte newSkyLight = (byte)chunkWrapper.getDhSkyLight(relBlockX, y + 1, relBlockZ);
                        if (!newBiome.equals(biome) || !newBlockState.equals(blockState)) {
                            longs.add(FullDataPointUtil.encode(mappedId, lastY - y, y + 1 - chunkWrapper.getInclusiveMinBuildHeight(), blockLight, skyLight));
                            biome = newBiome;
                            blockState = newBlockState;
                            mappedId = dataSource.mapping.addIfNotPresentAndGetId(biome, blockState);
                            blockLight = newBlockLight;
                            skyLight = newSkyLight;
                            lastY = y;
                        }
                        --y;
                    }
                    longs.add(FullDataPointUtil.encode(mappedId, lastY - y, y + 1 - chunkWrapper.getInclusiveMinBuildHeight(), blockLight, skyLight));
                    dataSource.setSingleColumn(longs, relBlockX + chunkOffsetX, relBlockZ + chunkOffsetZ, EDhApiWorldGenerationStep.LIGHT, worldCompressionMode);
                }
            }
            if (ignoreHiddenBlocks) {
                LodDataBuilder.cullHiddenBlocks(dataSource, chunkOffsetX, chunkOffsetZ);
            }
        }
        catch (DataCorruptedException e) {
            LOGGER.error("Unable to convert chunk at pos [" + chunkWrapper.getChunkPos() + "] to an LOD. Error: " + e.getMessage(), (Throwable)e);
            return null;
        }
        LodUtil.assertTrue(!dataSource.isEmpty);
        return dataSource;
    }

    private static void cullHiddenBlocks(FullDataSourceV2 dataSource, int chunkOffsetX, int chunkOffsetZ) {
        for (int relZ = 1; relZ < 15; ++relZ) {
            for (int relX = 1; relX < 15; ++relX) {
                LongArrayList centerColumn = dataSource.get(relX + chunkOffsetX, relZ + chunkOffsetZ);
                LongArrayList posXColumn = dataSource.get(relX + chunkOffsetX + 1, relZ + chunkOffsetZ);
                LongArrayList negXColumn = dataSource.get(relX + chunkOffsetX - 1, relZ + chunkOffsetZ);
                LongArrayList posZColumn = dataSource.get(relX + chunkOffsetX, relZ + chunkOffsetZ + 1);
                LongArrayList negZColumn = dataSource.get(relX + chunkOffsetX, relZ + chunkOffsetZ - 1);
                int posXIndex = posXColumn.size() - 1;
                int negXIndex = negXColumn.size() - 1;
                int posZIndex = posZColumn.size() - 1;
                int negZIndex = negZColumn.size() - 1;
                for (int centerIndex = centerColumn.size() - 1; centerIndex >= 0; --centerIndex) {
                    long currentPoint = centerColumn.getLong(centerIndex);
                    if (LodDataBuilder.isTranslucent(dataSource, currentPoint) || centerIndex == 0 || LodDataBuilder.isTranslucent(dataSource, centerColumn.getLong(centerIndex - 1)) || centerIndex + 1 < centerColumn.size() && LodDataBuilder.isTranslucent(dataSource, centerColumn.getLong(centerIndex + 1))) continue;
                    if ((posXIndex = LodDataBuilder.checkOcclusion(dataSource, currentPoint, posXColumn, posXIndex)) < 0) {
                        posXIndex ^= 0xFFFFFFFF;
                        continue;
                    }
                    if ((negXIndex = LodDataBuilder.checkOcclusion(dataSource, currentPoint, negXColumn, negXIndex)) < 0) {
                        negXIndex ^= 0xFFFFFFFF;
                        continue;
                    }
                    if ((posZIndex = LodDataBuilder.checkOcclusion(dataSource, currentPoint, posZColumn, posZIndex)) < 0) {
                        posZIndex ^= 0xFFFFFFFF;
                        continue;
                    }
                    if ((negZIndex = LodDataBuilder.checkOcclusion(dataSource, currentPoint, negZColumn, negZIndex)) < 0) {
                        negZIndex ^= 0xFFFFFFFF;
                        continue;
                    }
                    centerColumn.removeLong(centerIndex);
                    long above = centerColumn.getLong(centerIndex - 1);
                    above = FullDataPointUtil.setBottomY(above, FullDataPointUtil.getBottomY(currentPoint));
                    above = FullDataPointUtil.setHeight(above, FullDataPointUtil.getHeight(currentPoint) + FullDataPointUtil.getHeight(above));
                    centerColumn.set(centerIndex - 1, above);
                }
            }
        }
    }

    private static int checkOcclusion(FullDataSourceV2 source, long centerPoint, LongArrayList adjacentColumn, int adjacentIndex) {
        int bottomOfCenter = FullDataPointUtil.getBottomY(centerPoint);
        int topOfCenter = bottomOfCenter + FullDataPointUtil.getHeight(centerPoint);
        while (adjacentIndex >= 0) {
            long adjacentPoint = adjacentColumn.getLong(adjacentIndex);
            int topOfAdjacent = FullDataPointUtil.getBottomY(adjacentPoint) + FullDataPointUtil.getHeight(adjacentPoint);
            if (topOfAdjacent > bottomOfCenter) {
                if (LodDataBuilder.isTranslucent(source, adjacentPoint)) {
                    return ~adjacentIndex;
                }
                if (topOfAdjacent >= topOfCenter) {
                    return adjacentIndex;
                }
            }
            --adjacentIndex;
        }
        throw new LodUtil.AssertFailureException("Adjacent column ends before center column does.");
    }

    private static boolean isTranslucent(FullDataSourceV2 source, long point) {
        return source.mapping.getBlockStateWrapper(FullDataPointUtil.getId(point)).getOpacity() < 16;
    }

    public static FullDataSourceV2 createFromApiChunkData(DhApiChunk apiChunk, boolean runAdditionalValidation) throws ClassCastException, DataCorruptedException, IllegalArgumentException {
        int sectionPosX = LodDataBuilder.getXOrZSectionPosFromChunkPos(apiChunk.chunkPosX);
        int sectionPosZ = LodDataBuilder.getXOrZSectionPosFromChunkPos(apiChunk.chunkPosZ);
        long pos = DhSectionPos.encode((byte)6, sectionPosX, sectionPosZ);
        int relSourceBlockX = Math.floorMod(apiChunk.chunkPosX, 4) * 16;
        int relSourceBlockZ = Math.floorMod(apiChunk.chunkPosZ, 4) * 16;
        FullDataSourceV2 dataSource = FullDataSourceV2.createEmpty(pos);
        for (int relBlockZ = 0; relBlockZ < 16; ++relBlockZ) {
            for (int relBlockX = 0; relBlockX < 16; ++relBlockX) {
                List<DhApiTerrainDataPoint> columnDataPoints = apiChunk.getDataPoints(relBlockX, relBlockZ);
                LodDataBuilder.correctDataColumnOrder(columnDataPoints);
                if (runAdditionalValidation) {
                    LodDataBuilder.validateOrThrowApiDataColumn(columnDataPoints);
                }
                LongArrayList packedDataPoints = LodDataBuilder.convertApiDataPointListToPackedLongArray(columnDataPoints, dataSource, apiChunk.bottomYBlockPos);
                dataSource.setSingleColumn(packedDataPoints, relBlockX + relSourceBlockX, relBlockZ + relSourceBlockZ, EDhApiWorldGenerationStep.LIGHT, EDhApiWorldCompressionMode.MERGE_SAME_BLOCKS);
                dataSource.isEmpty = false;
            }
        }
        return dataSource;
    }

    public static LongArrayList convertApiDataPointListToPackedLongArray(@Nullable List<DhApiTerrainDataPoint> columnDataPoints, FullDataSourceV2 dataSource, int bottomYBlockPos) throws DataCorruptedException {
        int size = columnDataPoints != null ? columnDataPoints.size() : 0;
        LongArrayList packedDataPoints = new LongArrayList(new long[size]);
        for (int index = 0; index < size; ++index) {
            DhApiTerrainDataPoint dataPoint = columnDataPoints.get(index);
            int id = dataSource.mapping.addIfNotPresentAndGetId((IBiomeWrapper)dataPoint.biomeWrapper, (IBlockStateWrapper)dataPoint.blockStateWrapper);
            packedDataPoints.set(index, FullDataPointUtil.encode(id, dataPoint.topYBlockPos - dataPoint.bottomYBlockPos, dataPoint.bottomYBlockPos - bottomYBlockPos, (byte)dataPoint.blockLightLevel, (byte)dataPoint.skyLightLevel));
        }
        return packedDataPoints;
    }

    public static void correctDataColumnOrder(List<DhApiTerrainDataPoint> dataPoints) {
        if (dataPoints.size() > 1) {
            DhApiTerrainDataPoint first = dataPoints.get(0);
            DhApiTerrainDataPoint last = dataPoints.get(dataPoints.size() - 1);
            if (first.bottomYBlockPos < last.bottomYBlockPos) {
                Collections.reverse(dataPoints);
            }
        }
    }

    public static void validateOrThrowApiDataColumn(List<DhApiTerrainDataPoint> dataPoints) throws IllegalArgumentException {
        int lastBottomYPos = Integer.MIN_VALUE;
        for (int i = 0; i < dataPoints.size(); ++i) {
            DhApiTerrainDataPoint dataPoint = dataPoints.get(i);
            if (dataPoint == null) {
                throw new IllegalArgumentException("Datapoint: [" + i + "] is null DhApiTerrainDataPoints are not allowed. If you want to represent empty terrain, please use AIR.");
            }
            if (dataPoint.detailLevel != 0) {
                throw new IllegalArgumentException("Datapoint: [" + i + "] has the wrong detail level [" + dataPoint.detailLevel + "], all data points must be block sized; IE their detail level must be [0].");
            }
            int bottomYPos = dataPoint.bottomYBlockPos;
            int topYPos = dataPoint.topYBlockPos;
            int height = dataPoint.topYBlockPos - dataPoint.bottomYBlockPos;
            if (bottomYPos > topYPos) {
                throw new IllegalArgumentException("Datapoint: [" + i + "] is upside down. Top Pos: [" + topYPos + "], bottom pos: [" + bottomYPos + "].");
            }
            if (height <= 0 || height >= 4096) {
                throw new IllegalArgumentException("Datapoint: [" + i + "] has invalid height. Height must be in the range [1 - " + 4096 + "] (inclusive).");
            }
            if (lastBottomYPos > topYPos) {
                throw new IllegalArgumentException("DhApiTerrainDataPoint [" + i + "] is overlapping with the last datapoint, this top Y: [" + topYPos + "], lastBottomYPos: [" + lastBottomYPos + "].");
            }
            if (topYPos != lastBottomYPos && lastBottomYPos != Integer.MIN_VALUE) {
                throw new IllegalArgumentException("DhApiTerrainDataPoint [" + i + "] has a gap between it and index [" + (i - 1) + "]. Empty spaces should be filled by air, otherwise DH's downsampling won't calculate lighting correctly.");
            }
            lastBottomYPos = bottomYPos;
        }
    }

    public static int getXOrZSectionPosFromChunkPos(int chunkXOrZPos) {
        int sectionPos = chunkXOrZPos;
        sectionPos = sectionPos < 0 ? (sectionPos + 1) / 4 - 1 : sectionPos / 4;
        return sectionPos;
    }
}

