/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV1;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.AbstractDataSourceHandler;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV1;
import com.seibel.distanthorizons.core.file.structure.ISaveStructure;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenResult;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV2Repo;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FullDataSourceProviderV2
extends AbstractDataSourceHandler<FullDataSourceV2, FullDataSourceV2DTO, FullDataSourceV2Repo, IDhLevel>
implements IDebugRenderable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    protected static final int NUMBER_OF_PARENT_UPDATE_TASKS_PER_THREAD = 50;
    protected static final int MAX_UPDATE_TASK_COUNT = 50 * Config.Common.MultiThreading.numberOfThreads.get();
    protected static final int UPDATE_QUEUE_THREAD_DELAY_IN_MS = 250;
    private static final int MIGRATION_BATCH_COUNT = 50;
    private static final int MIGRATION_MAX_UPDATE_TIMEOUT_IN_MS = 300000;
    protected final AtomicBoolean migrationThreadRunning = new AtomicBoolean(true);
    protected final FullDataSourceProviderV1<IDhLevel> legacyFileHandler;
    protected boolean migrationStartMessageQueued = false;
    protected long legacyDeletionCount = -1L;
    protected long migrationCount = -1L;
    protected boolean migrationStoppedWithError = false;
    public final Set<Long> parentUpdatingPosSet = ConcurrentHashMap.newKeySet();
    @Nullable
    private final ThreadPoolExecutor updateQueueProcessor;

    public FullDataSourceProviderV2(IDhLevel level, ISaveStructure saveStructure) {
        this(level, saveStructure, (File)null);
    }

    public FullDataSourceProviderV2(IDhLevel level, ISaveStructure saveStructure, @Nullable File saveDirOverride) {
        super(level, saveStructure, saveDirOverride);
        this.legacyFileHandler = new FullDataSourceProviderV1<IDhLevel>(level, saveStructure, saveDirOverride);
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showFullDataUpdateStatus);
        String levelId = level.getLevelWrapper().getDhIdentifier();
        ThreadPoolExecutor executor = ThreadPoolUtil.getFullDataMigrationExecutor();
        if (executor != null) {
            executor.execute(this::convertLegacyDataSources);
        } else {
            LOGGER.error("Unable to start migration for level: [" + levelId + "] due to missing executor.");
        }
        this.updateQueueProcessor = ThreadUtil.makeSingleThreadPool("Parent Update Queue [" + levelId + "]");
        this.updateQueueProcessor.execute(this::runUpdateQueue);
    }

    @Override
    protected FullDataSourceV2Repo createRepo() {
        try {
            return new FullDataSourceV2Repo("jdbc:sqlite", new File(this.saveDir.getPath() + File.separator + "DistantHorizons.sqlite"));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected FullDataSourceV2DTO createDtoFromDataSource(FullDataSourceV2 dataSource) {
        try {
            EDhApiDataCompressionMode compressionModeEnum = Config.Common.LodBuilding.dataCompression.get();
            return FullDataSourceV2DTO.CreateFromDataSource(dataSource, compressionModeEnum);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to create DTO, error: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected FullDataSourceV2 createDataSourceFromDto(FullDataSourceV2DTO dto) throws InterruptedException, IOException, DataCorruptedException {
        return dto.createDataSource(this.level.getLevelWrapper());
    }

    @Override
    protected FullDataSourceV2 makeEmptyDataSource(long pos) {
        return FullDataSourceV2.createEmpty(pos);
    }

    private void runUpdateQueue() {
        block6: while (!Thread.interrupted()) {
            try {
                Thread.sleep(250L);
                PriorityTaskPicker.Executor executor = ThreadPoolUtil.getUpdatePropagatorExecutor();
                if (executor == null || executor.isTerminated()) continue;
                DhBlockPos targetBlockPos = DhBlockPos.ZERO;
                if (MC_CLIENT != null && MC_CLIENT.playerExists()) {
                    targetBlockPos = MC_CLIENT.getPlayerBlockPos();
                }
                if (executor.getQueueSize() >= MAX_UPDATE_TASK_COUNT || this.parentUpdatingPosSet.size() >= MAX_UPDATE_TASK_COUNT) continue;
                LongArrayList parentUpdatePosList = ((FullDataSourceV2Repo)this.repo).getPositionsToUpdate(targetBlockPos.getX(), targetBlockPos.getZ(), MAX_UPDATE_TASK_COUNT);
                HashMap<Long, HashSet> updatePosByParentPos = new HashMap<Long, HashSet>();
                for (Long pos : parentUpdatePosList) {
                    updatePosByParentPos.compute(DhSectionPos.getParentPos(pos), (parentPos, updatePosSet) -> {
                        if (updatePosSet == null) {
                            updatePosSet = new HashSet<Long>();
                        }
                        updatePosSet.add(pos);
                        return updatePosSet;
                    });
                }
                for (Long parentUpdatePos : updatePosByParentPos.keySet()) {
                    if (this.parentUpdatingPosSet.size() > MAX_UPDATE_TASK_COUNT || !this.parentUpdatingPosSet.add(parentUpdatePos)) continue block6;
                    try {
                        executor.execute(() -> {
                            block15: {
                                ReentrantLock parentWriteLock = this.updateLockProvider.getLock(parentUpdatePos);
                                boolean parentLocked = false;
                                try {
                                    if (!parentWriteLock.tryLock()) break block15;
                                    parentLocked = true;
                                    this.lockedPosSet.add(parentUpdatePos);
                                    for (Long childPos : (HashSet)updatePosByParentPos.get(parentUpdatePos)) {
                                        ReentrantLock childReadLock = this.updateLockProvider.getLock(childPos);
                                        try {
                                            childReadLock.lock();
                                            this.lockedPosSet.add(childPos);
                                            FullDataSourceV2 dataSource = (FullDataSourceV2)this.get(childPos);
                                            try {
                                                if (dataSource == null) continue;
                                                this.updateDataSourceAtPos(parentUpdatePos, dataSource, false);
                                                ((FullDataSourceV2Repo)this.repo).setApplyToParent(childPos, false);
                                            }
                                            finally {
                                                if (dataSource == null) continue;
                                                dataSource.close();
                                            }
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Unexpected in update for parent pos: [" + DhSectionPos.toString(parentUpdatePos) + "] Error: [" + e.getMessage() + "].", (Throwable)e);
                                        }
                                        finally {
                                            childReadLock.unlock();
                                            this.lockedPosSet.remove(childPos);
                                        }
                                    }
                                }
                                finally {
                                    if (parentLocked) {
                                        parentWriteLock.unlock();
                                        this.lockedPosSet.remove(parentUpdatePos);
                                    }
                                    this.parentUpdatingPosSet.remove(parentUpdatePos);
                                }
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                    }
                    catch (Exception e) {
                        this.parentUpdatingPosSet.remove(parentUpdatePos);
                        throw e;
                    }
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error in the parent update queue thread. Error: " + e.getMessage(), (Throwable)e);
            }
        }
        LOGGER.info("Update thread [" + Thread.currentThread().getName() + "] terminated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertLegacyDataSources() {
        block22: {
            try {
                long totalMigrationCount;
                String levelId = this.level.getLevelWrapper().getDhIdentifier();
                LOGGER.info("Attempting to migrate data sources for: [" + levelId + "]-[" + this.saveDir + "]...");
                this.migrationThreadRunning.set(true);
                long unusedCount = 0L;
                long totalDeleteCount = this.legacyFileHandler.repo.getUnusedDataSourceCount();
                if (totalDeleteCount != 0L) {
                    this.showMigrationStartMessage();
                    LOGGER.info("deleting [" + levelId + "] - [" + totalDeleteCount + "] unused data sources...");
                    this.legacyDeletionCount = totalDeleteCount;
                    ArrayList<String> unusedDataPosList = this.legacyFileHandler.repo.getUnusedDataSourcePositionStringList(50);
                    while (unusedDataPosList.size() != 0) {
                        unusedCount += (long)unusedDataPosList.size();
                        this.legacyDeletionCount -= (long)unusedDataPosList.size();
                        long startTime = System.currentTimeMillis();
                        this.legacyFileHandler.repo.deleteUnusedLegacyData(unusedDataPosList);
                        unusedDataPosList = this.legacyFileHandler.repo.getUnusedDataSourcePositionStringList(50);
                        long endStart = System.currentTimeMillis();
                        long deleteTime = endStart - startTime;
                        LOGGER.info("Deleting [" + levelId + "] - [" + unusedCount + "/" + totalDeleteCount + "] in [" + deleteTime + "]ms ...");
                        try {
                            Thread.sleep(deleteTime / 2L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    LOGGER.info("Done deleting [" + levelId + "] - [" + totalDeleteCount + "] unused data sources.");
                }
                this.migrationCount = totalMigrationCount = this.legacyFileHandler.getDataSourceMigrationCount();
                LOGGER.info("Found [" + totalMigrationCount + "] data sources that need migration.");
                ArrayList<FullDataSourceV1> legacyDataSourceList = this.legacyFileHandler.getDataSourcesToMigrate(50);
                if (!legacyDataSourceList.isEmpty()) {
                    this.showMigrationStartMessage();
                    try {
                        int progressCount = 0;
                        while (!legacyDataSourceList.isEmpty() && this.migrationThreadRunning.get()) {
                            NumberFormat numFormat = F3Screen.NUMBER_FORMAT;
                            LOGGER.info("Migrating [" + levelId + "] - [" + numFormat.format(progressCount) + "/" + numFormat.format(totalMigrationCount) + "]...");
                            ArrayList<CompletableFuture<Void>> updateFutureList = new ArrayList<CompletableFuture<Void>>();
                            for (int i = 0; i < legacyDataSourceList.size() && this.migrationThreadRunning.get(); ++i) {
                                FullDataSourceV1 legacyDataSource = legacyDataSourceList.get(i);
                                try {
                                    FullDataSourceV2 newDataSource = FullDataSourceV2.createFromLegacyDataSourceV1(legacyDataSource);
                                    newDataSource.applyToParent = true;
                                    CompletableFuture<Void> future = this.updateDataSourceAsync(newDataSource);
                                    updateFutureList.add(future);
                                    future.thenRun(() -> {
                                        this.legacyFileHandler.repo.deleteWithKey(legacyDataSource.getPos());
                                        newDataSource.close();
                                    });
                                    continue;
                                }
                                catch (Exception e) {
                                    Long migrationPos = legacyDataSource.getPos();
                                    LOGGER.warn("Unexpected issue migrating data source at pos [" + DhSectionPos.toString(migrationPos) + "]. Error: " + e.getMessage(), (Throwable)e);
                                    this.legacyFileHandler.markMigrationFailed(migrationPos);
                                }
                            }
                            try {
                                CompletableFuture<Void> combinedFutures = CompletableFuture.allOf(updateFutureList.toArray(new CompletableFuture[0]));
                                combinedFutures.get(300000L, TimeUnit.MILLISECONDS);
                            }
                            catch (InterruptedException | TimeoutException e) {
                                LOGGER.warn("Migration update timed out after [300000] milliseconds. Migration will re-try the same positions again in a moment.", (Throwable)e);
                            }
                            catch (ExecutionException e) {
                                LOGGER.warn("Migration update failed. Migration will re-try the same positions again. Error:" + e.getMessage(), (Throwable)e);
                            }
                            legacyDataSourceList = this.legacyFileHandler.getDataSourcesToMigrate(50);
                            progressCount += legacyDataSourceList.size();
                            this.migrationCount -= (long)legacyDataSourceList.size();
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        LOGGER.info("migration stopped due to error for: [" + levelId + "]-[" + this.saveDir + "], error: [" + e.getMessage() + "].", (Throwable)e);
                        this.showMigrationEndMessage(false);
                        this.migrationStoppedWithError = true;
                        break block22;
                    }
                    finally {
                        if (this.migrationThreadRunning.get()) {
                            LOGGER.info("migration complete for: [" + levelId + "]-[" + this.saveDir + "].");
                            this.showMigrationEndMessage(true);
                            this.migrationCount = 0L;
                        } else {
                            LOGGER.info("migration stopped for: [" + levelId + "]-[" + this.saveDir + "].");
                            this.showMigrationEndMessage(false);
                            this.migrationStoppedWithError = true;
                        }
                    }
                }
                LOGGER.info("No migration necessary.");
            }
            finally {
                this.migrationThreadRunning.set(false);
            }
        }
    }

    public long getLegacyDeletionCount() {
        return this.legacyDeletionCount;
    }

    public long getTotalMigrationCount() {
        return this.migrationCount;
    }

    public boolean getMigrationStoppedWithError() {
        return this.migrationStoppedWithError;
    }

    private void showMigrationStartMessage() {
        if (this.migrationStartMessageQueued) {
            return;
        }
        this.migrationStartMessageQueued = true;
        String levelId = this.level.getLevelWrapper().getDhIdentifier();
        ClientApi.INSTANCE.showChatMessageNextFrame("Old Distant Horizons data is being migrated for [" + levelId + "]. \nWhile migrating LODs may load slowly \nand DH world gen will be disabled. \nYou can see migration progress in the F3 menu.");
    }

    private void showMigrationEndMessage(boolean success) {
        String levelId = this.level.getLevelWrapper().getDhIdentifier();
        if (success) {
            ClientApi.INSTANCE.showChatMessageNextFrame("Distant Horizons data migration for [" + levelId + "] completed.");
        } else {
            ClientApi.INSTANCE.showChatMessageNextFrame("Distant Horizons data migration for [" + levelId + "] stopped. \nSome data may not have been migrated.");
        }
    }

    public boolean canRetrieveMissingDataSources() {
        return false;
    }

    public boolean canQueueRetrieval() {
        return !this.migrationThreadRunning.get();
    }

    @Nullable
    public LongArrayList getPositionsToRetrieve(Long pos) {
        return null;
    }

    @Nullable
    public CompletableFuture<WorldGenResult> queuePositionForRetrieval(Long genPos) {
        return null;
    }

    public void removeRetrievalRequestIf(DhSectionPos.ICancelablePrimitiveLongConsumer removeIf) {
    }

    public void clearRetrievalQueue() {
    }

    public void setTotalRetrievalPositionCount(int newCount) {
    }

    public void setEstimatedRemainingRetrievalChunkCount(int newCount) {
    }

    public boolean fileExists(long pos) {
        return ((FullDataSourceV2Repo)this.repo).getDataSizeInBytes(pos) > 0L;
    }

    @Nullable
    public Long getTimestampForPos(long pos) {
        return ((FullDataSourceV2Repo)this.repo).getTimestampForPos(pos);
    }

    @Override
    public void debugRender(DebugRenderer renderer) {
        this.lockedPosSet.forEach(pos -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 74.0f, 0.15f, Color.PINK)));
        this.queuedUpdateCountsByPos.forEach((pos, updateCountRef) -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 80.0f + (float)updateCountRef.get() * 16.0f, 0.2f, Color.WHITE)));
        this.parentUpdatingPosSet.forEach(pos -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 80.0f, 0.2f, Color.MAGENTA)));
    }

    @Override
    public void close() {
        super.close();
        if (this.updateQueueProcessor != null) {
            this.updateQueueProcessor.shutdownNow();
        }
        this.legacyFileHandler.close();
        this.migrationThreadRunning.set(false);
    }
}

