/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.render.CachedColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBuffer;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBufferBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dataObjects.transformers.FullDataToRenderDataTransformer;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.LodQuadTree;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.render.renderer.generic.BeaconRenderHandler;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.sql.repo.BeaconBeamRepo;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV2Repo;
import com.seibel.distanthorizons.core.util.KeyedLockContainer;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.WillNotClose;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class LodRenderSection
implements IDebugRenderable,
AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public static final AtomicInteger GLOBAL_UPLOAD_TASKS_COUNT_REF = new AtomicInteger(0);
    public final long pos;
    private final IDhClientLevel level;
    @WillNotClose
    private final FullDataSourceProviderV2 fullDataSourceProvider;
    private final LodQuadTree quadTree;
    private final KeyedLockContainer<Long> renderLoadLockContainer;
    private final Cache<Long, CachedColumnRenderSource> cachedRenderSourceByPos;
    private final List<BeaconBeamDTO> activeBeaconList = new ArrayList<BeaconBeamDTO>();
    @Nullable
    public final BeaconRenderHandler beaconRenderHandler;
    @Nullable
    public final BeaconBeamRepo beaconBeamRepo;
    private boolean renderingEnabled = false;
    public ColumnRenderBuffer renderBuffer;
    private CompletableFuture<Void> getAndBuildRenderDataFuture = null;
    private Runnable getAndBuildRenderDataRunnable = null;
    private CompletableFuture<ColumnRenderBuffer> bufferUploadFuture = null;
    @Nullable
    private Supplier<LongArrayList> missingGenerationPosFunc;
    private boolean checkedIfFullDataSourceExists = false;
    private boolean fullDataSourceExists = false;

    @Nullable
    public CompletableFuture<Void> getRenderDataBuildFuture() {
        return this.getAndBuildRenderDataFuture;
    }

    private LongArrayList getMissingGenerationPos() {
        return this.missingGenerationPosFunc != null ? this.missingGenerationPosFunc.get() : null;
    }

    public LodRenderSection(long pos, LodQuadTree quadTree, IDhClientLevel level, FullDataSourceProviderV2 fullDataSourceProvider, Cache<Long, CachedColumnRenderSource> cachedRenderSourceByPos, KeyedLockContainer<Long> renderLoadLockContainer) {
        this.pos = pos;
        this.quadTree = quadTree;
        this.cachedRenderSourceByPos = cachedRenderSourceByPos;
        this.renderLoadLockContainer = renderLoadLockContainer;
        this.level = level;
        this.fullDataSourceProvider = fullDataSourceProvider;
        this.beaconRenderHandler = this.quadTree.beaconRenderHandler;
        this.beaconBeamRepo = this.level.getBeaconBeamRepo();
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus);
    }

    public synchronized boolean uploadRenderDataToGpuAsync() {
        if (!GLProxy.hasInstance()) {
            return false;
        }
        if (this.getAndBuildRenderDataFuture != null) {
            return false;
        }
        PriorityTaskPicker.Executor executor = ThreadPoolUtil.getFileHandlerExecutor();
        if (executor == null || executor.isTerminated()) {
            return false;
        }
        if (GLOBAL_UPLOAD_TASKS_COUNT_REF.getAndIncrement() > executor.getPoolSize()) {
            GLOBAL_UPLOAD_TASKS_COUNT_REF.decrementAndGet();
            return false;
        }
        try {
            CompletableFuture future = new CompletableFuture();
            this.getAndBuildRenderDataFuture = future;
            future.handle((voidObj, throwable) -> {
                GLOBAL_UPLOAD_TASKS_COUNT_REF.decrementAndGet();
                return null;
            });
            this.getAndBuildRenderDataRunnable = () -> {
                this.getAndRefreshRenderingBeacons();
                this.getAndUploadRenderDataToGpu();
                future.complete(null);
                this.getAndBuildRenderDataFuture = null;
                this.getAndBuildRenderDataRunnable = null;
            };
            executor.execute(this.getAndBuildRenderDataRunnable);
            return true;
        }
        catch (RejectedExecutionException ignore) {
            this.getAndBuildRenderDataFuture.complete(null);
            this.getAndBuildRenderDataFuture = null;
            this.getAndBuildRenderDataRunnable = null;
            return false;
        }
    }

    private void getAndUploadRenderDataToGpu() {
        try (CachedColumnRenderSource cachedRenderSource = this.getRenderSourceForPos(this.pos);){
            if (cachedRenderSource == null) {
                return;
            }
            ColumnRenderSource thisRenderSource = cachedRenderSource.columnRenderSource;
            boolean enableTransparency = Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled;
            LodQuadBuilder lodQuadBuilder = new LodQuadBuilder(enableTransparency, this.level.getClientLevelWrapper());
            try (CachedColumnRenderSource northRenderSource = this.getRenderSourceForPos(DhSectionPos.getAdjacentPos(this.pos, EDhDirection.NORTH));
                 CachedColumnRenderSource southRenderSource = this.getRenderSourceForPos(DhSectionPos.getAdjacentPos(this.pos, EDhDirection.SOUTH));
                 CachedColumnRenderSource eastRenderSource = this.getRenderSourceForPos(DhSectionPos.getAdjacentPos(this.pos, EDhDirection.EAST));
                 CachedColumnRenderSource westRenderSource = this.getRenderSourceForPos(DhSectionPos.getAdjacentPos(this.pos, EDhDirection.WEST));){
                ColumnRenderSource[] adjacentRenderSections = new ColumnRenderSource[EDhDirection.ADJ_DIRECTIONS.length];
                adjacentRenderSections[EDhDirection.NORTH.ordinal() - 2] = northRenderSource != null ? northRenderSource.columnRenderSource : null;
                adjacentRenderSections[EDhDirection.SOUTH.ordinal() - 2] = southRenderSource != null ? southRenderSource.columnRenderSource : null;
                adjacentRenderSections[EDhDirection.EAST.ordinal() - 2] = eastRenderSource != null ? eastRenderSource.columnRenderSource : null;
                adjacentRenderSections[EDhDirection.WEST.ordinal() - 2] = westRenderSource != null ? westRenderSource.columnRenderSource : null;
                boolean[] adjIsSameDetailLevel = new boolean[EDhDirection.ADJ_DIRECTIONS.length];
                adjIsSameDetailLevel[EDhDirection.NORTH.ordinal() - 2] = this.isAdjacentPosSameDetailLevel(EDhDirection.NORTH);
                adjIsSameDetailLevel[EDhDirection.SOUTH.ordinal() - 2] = this.isAdjacentPosSameDetailLevel(EDhDirection.SOUTH);
                adjIsSameDetailLevel[EDhDirection.EAST.ordinal() - 2] = this.isAdjacentPosSameDetailLevel(EDhDirection.EAST);
                adjIsSameDetailLevel[EDhDirection.WEST.ordinal() - 2] = this.isAdjacentPosSameDetailLevel(EDhDirection.WEST);
                ColumnRenderBufferBuilder.makeLodRenderData(lodQuadBuilder, thisRenderSource, this.level, adjacentRenderSections, adjIsSameDetailLevel);
            }
            this.uploadToGpuAsync(lodQuadBuilder);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error while loading LodRenderSection [" + DhSectionPos.toString(this.pos) + "], Error: [" + e.getMessage() + "].", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CachedColumnRenderSource getRenderSourceForPos(long pos) {
        ReentrantLock lock = this.renderLoadLockContainer.getLockForPos(pos);
        try {
            lock.lock();
            CachedColumnRenderSource cachedRenderSource = (CachedColumnRenderSource)this.cachedRenderSourceByPos.getIfPresent((Object)pos);
            if (cachedRenderSource != null) {
                cachedRenderSource.markInUse();
                CachedColumnRenderSource cachedColumnRenderSource = cachedRenderSource;
                return cachedColumnRenderSource;
            }
            try (FullDataSourceV2 fullDataSource = (FullDataSourceV2)this.fullDataSourceProvider.get(pos);){
                ColumnRenderSource renderSource = FullDataToRenderDataTransformer.transformFullDataToRenderSource(fullDataSource, this.level);
                if (renderSource != null) {
                    cachedRenderSource = new CachedColumnRenderSource(renderSource, lock, this.cachedRenderSourceByPos);
                    this.cachedRenderSourceByPos.put((Object)pos, (Object)cachedRenderSource);
                }
            }
            CachedColumnRenderSource cachedColumnRenderSource = cachedRenderSource;
            return cachedColumnRenderSource;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isAdjacentPosSameDetailLevel(EDhDirection direction) {
        long adjPos = DhSectionPos.getAdjacentPos(this.pos, direction);
        byte detailLevel = this.quadTree.calculateExpectedDetailLevel(new DhBlockPos2D(MC.getPlayerBlockPos()), adjPos);
        return (detailLevel = (byte)(detailLevel + 6)) == DhSectionPos.getDetailLevel(this.pos);
    }

    private void uploadToGpuAsync(LodQuadBuilder lodQuadBuilder) {
        if (this.bufferUploadFuture != null) {
            this.bufferUploadFuture.cancel(true);
        }
        this.bufferUploadFuture = ColumnRenderBufferBuilder.uploadBuffersAsync(this.level, this.pos, lodQuadBuilder);
        this.bufferUploadFuture.thenAccept(buffer -> {
            ColumnRenderBuffer previousBuffer = this.renderBuffer;
            this.renderBuffer = buffer.buffersUploaded ? buffer : null;
            this.getAndBuildRenderDataFuture = null;
            if (previousBuffer != null) {
                previousBuffer.close();
            }
        });
    }

    public boolean canRender() {
        return this.renderBuffer != null;
    }

    public boolean getRenderingEnabled() {
        return this.renderingEnabled;
    }

    public void setRenderingEnabled(boolean enabled) {
        this.renderingEnabled = enabled;
    }

    public void onRenderingEnabled() {
        this.startRenderingBeacons();
    }

    public void onRenderingDisabled() {
        this.stopRenderingBeacons();
        if (Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus.get().booleanValue()) {
            DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(this.pos, 128.0f, 156.0f, 0.09f, Color.CYAN.darker()), 0.2, 32.0f));
        }
    }

    public boolean gpuUploadInProgress() {
        return this.getAndBuildRenderDataFuture != null;
    }

    public boolean isFullyGenerated() {
        LongArrayList missingGenerationPos = this.getMissingGenerationPos();
        return missingGenerationPos != null && missingGenerationPos.isEmpty();
    }

    public boolean getFullDataSourceExists() {
        if (!this.checkedIfFullDataSourceExists) {
            this.fullDataSourceExists = ((FullDataSourceV2Repo)this.fullDataSourceProvider.repo).existsWithKey(this.pos);
            this.checkedIfFullDataSourceExists = true;
        }
        return this.fullDataSourceExists;
    }

    public void updateFullDataSourceExists() {
        if (!this.fullDataSourceExists) {
            this.checkedIfFullDataSourceExists = false;
            this.getFullDataSourceExists();
        }
    }

    public boolean missingPositionsCalculated() {
        return this.getMissingGenerationPos() != null;
    }

    public int ungeneratedPositionCount() {
        LongArrayList missingGenerationPos = this.getMissingGenerationPos();
        return missingGenerationPos != null ? missingGenerationPos.size() : 0;
    }

    public int ungeneratedChunkCount() {
        LongArrayList missingGenerationPos = this.getMissingGenerationPos();
        if (missingGenerationPos == null) {
            return 0;
        }
        int chunkCount = 0;
        for (int i = 0; i < missingGenerationPos.size(); ++i) {
            int chunkWidth = DhSectionPos.getChunkWidth(missingGenerationPos.getLong(i));
            chunkCount += chunkWidth * chunkWidth;
        }
        return chunkCount;
    }

    public void tryQueuingMissingLodRetrieval() {
        if (this.fullDataSourceProvider.canRetrieveMissingDataSources() && this.fullDataSourceProvider.canQueueRetrieval()) {
            LongArrayList missingGenerationPos;
            if (this.missingGenerationPosFunc == null) {
                this.missingGenerationPosFunc = Suppliers.memoizeWithExpiration(() -> this.fullDataSourceProvider.getPositionsToRetrieve(this.pos), (long)1L, (TimeUnit)TimeUnit.MINUTES);
            }
            if ((missingGenerationPos = this.getMissingGenerationPos()) != null) {
                for (int i = missingGenerationPos.size() - 1; i >= 0 && this.fullDataSourceProvider.canQueueRetrieval(); --i) {
                    boolean positionQueued;
                    long pos = missingGenerationPos.removeLong(i);
                    boolean bl = positionQueued = this.fullDataSourceProvider.queuePositionForRetrieval(pos) != null;
                    if (positionQueued) continue;
                    missingGenerationPos.add(pos);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndRefreshRenderingBeacons() {
        if (this.beaconBeamRepo == null || this.beaconRenderHandler == null) {
            return;
        }
        List<BeaconBeamDTO> list = this.activeBeaconList;
        synchronized (list) {
            List<BeaconBeamDTO> activeBeacons = this.beaconBeamRepo.getAllBeamsForPos(this.pos);
            for (BeaconBeamDTO beam : this.activeBeaconList) {
                this.beaconRenderHandler.stopRenderingBeaconAtPos(beam.blockPos);
            }
            this.activeBeaconList.clear();
            this.activeBeaconList.addAll(activeBeacons);
            for (BeaconBeamDTO beam : this.activeBeaconList) {
                this.beaconRenderHandler.startRenderingBeacon(beam);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRenderingBeacons() {
        if (this.beaconRenderHandler == null) {
            return;
        }
        List<BeaconBeamDTO> list = this.activeBeaconList;
        synchronized (list) {
            for (BeaconBeamDTO beam : this.activeBeaconList) {
                this.beaconRenderHandler.stopRenderingBeaconAtPos(beam.blockPos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRenderingBeacons() {
        if (this.beaconRenderHandler == null) {
            return;
        }
        List<BeaconBeamDTO> list = this.activeBeaconList;
        synchronized (list) {
            for (BeaconBeamDTO beam : this.activeBeaconList) {
                this.beaconRenderHandler.startRenderingBeacon(beam);
            }
        }
    }

    @Override
    public void debugRender(DebugRenderer debugRenderer) {
        Color color = Color.red;
        if (this.renderingEnabled) {
            color = Color.green;
        } else if (this.getAndBuildRenderDataFuture != null) {
            color = Color.yellow;
        } else if (this.canRender()) {
            color = Color.cyan;
        }
        debugRenderer.renderBox(new DebugRenderer.Box(this.pos, 400.0f, 8.0f, (Object)Objects.hashCode(this), 0.1f, color));
    }

    public String toString() {
        return "pos=[" + DhSectionPos.toString(this.pos) + "] enabled=[" + this.renderingEnabled + "] uploading=[" + this.gpuUploadInProgress() + "] ";
    }

    @Override
    public void close() {
        CompletableFuture<ColumnRenderBuffer> uploadFuture;
        Runnable runnable;
        PriorityTaskPicker.Executor executor;
        CompletableFuture<Void> buildFuture;
        DebugRenderer.unregister(this, Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus);
        if (Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionStatus.get().booleanValue()) {
            DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(this.pos, 128.0f, 156.0f, 0.09f, Color.RED.darker()), 0.5, 32.0f));
        }
        this.stopRenderingBeacons();
        if (this.renderBuffer != null) {
            this.renderBuffer.close();
        }
        if ((buildFuture = this.getAndBuildRenderDataFuture) != null && (executor = ThreadPoolUtil.getFileHandlerExecutor()) != null && !executor.isTerminated() && (runnable = this.getAndBuildRenderDataRunnable) != null) {
            executor.remove(runnable);
        }
        if ((uploadFuture = this.bufferUploadFuture) != null) {
            uploadFuture.cancel(true);
        }
        ThreadPoolExecutor executor2 = ThreadPoolUtil.getCleanupExecutor();
        executor2.execute(() -> this.fullDataSourceProvider.removeRetrievalRequestIf(genPos -> DhSectionPos.contains(this.pos, genPos)));
    }
}

