/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.threading;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.util.objects.RollingAverage;
import com.seibel.distanthorizons.core.util.threading.DhThreadFactory;
import com.seibel.distanthorizons.core.util.threading.RateLimitedThreadPoolExecutor;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class PriorityTaskPicker {
    private final ConfigEntry<Integer> threadCountConfig = Config.Common.MultiThreading.numberOfThreads;
    private final RateLimitedThreadPoolExecutor threadPoolExecutor = new RateLimitedThreadPoolExecutor(this.threadCountConfig.getMax(), new DhThreadFactory("PriorityTaskPicker", 1, false), new ArrayBlockingQueue<Runnable>(this.threadCountConfig.getMax()));
    private final ArrayList<Executor> executorQueue = new ArrayList();
    private int nextExecutorQueuePos = 0;
    private final ReentrantLock taskPickerLock = new ReentrantLock();
    private final AtomicBoolean shouldPickTask = new AtomicBoolean(false);
    private final AtomicInteger occupiedThreads = new AtomicInteger(0);
    private volatile boolean isShutDown = false;

    public Executor createExecutor(int priority) {
        int entriesToAdd;
        Executor executor = new Executor();
        int gapBetweenEntries = (int)(1.0 / (double)entriesToAdd * (double)this.executorQueue.size());
        for (entriesToAdd = BitShiftUtil.powerOfTwo(priority); entriesToAdd > 0; --entriesToAdd) {
            this.executorQueue.add(executor);
            Collections.rotate(this.executorQueue, -gapBetweenEntries);
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStartNextTask() {
        this.shouldPickTask.set(true);
        while (this.taskPickerLock.tryLock()) {
            try {
                if (!this.shouldPickTask.compareAndSet(true, false)) {
                    return;
                }
                for (int taskPickAttempts = 0; taskPickAttempts < this.executorQueue.size() && this.occupiedThreads.get() < this.threadCountConfig.get(); ++taskPickAttempts) {
                    Executor executor = this.executorQueue.get(this.nextExecutorQueuePos);
                    TrackedRunnable task = (TrackedRunnable)executor.tasks.poll();
                    if (task != null) {
                        try {
                            this.threadPoolExecutor.execute(task);
                            this.occupiedThreads.getAndIncrement();
                            executor.runningTasks.getAndIncrement();
                            taskPickAttempts = 0;
                        }
                        catch (RejectedExecutionException e) {
                            if (this.isShutDown) {
                                executor.tasks.clear();
                            }
                            throw e;
                        }
                    }
                    this.nextExecutorQueuePos = (this.nextExecutorQueuePos + 1) % this.executorQueue.size();
                }
            }
            finally {
                this.taskPickerLock.unlock();
            }
        }
    }

    public void shutdown() {
        this.isShutDown = true;
        try {
            this.threadPoolExecutor.shutdown();
            if (!this.threadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.threadPoolExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public class Executor
    extends AbstractExecutorService {
        private final Queue<TrackedRunnable> tasks = new ConcurrentLinkedQueue<TrackedRunnable>();
        private final AtomicInteger runningTasks = new AtomicInteger(0);
        private final AtomicInteger completedTasks = new AtomicInteger(0);
        private final RollingAverage runTimeInMsRollingAverage = new RollingAverage(200);

        @Override
        public void execute(@NotNull Runnable command) {
            this.tasks.add(new TrackedRunnable(this, command));
            PriorityTaskPicker.this.tryStartNextTask();
        }

        public int getQueueSize() {
            return this.tasks.size();
        }

        public int getPoolSize() {
            return (Integer)PriorityTaskPicker.this.threadCountConfig.get();
        }

        public int getRunningTaskCount() {
            return this.runningTasks.get();
        }

        public int getCompletedTaskCount() {
            return this.completedTasks.get();
        }

        public double getAverageRunTimeInMs() {
            return this.runTimeInMsRollingAverage.getAverage();
        }

        public void remove(@NotNull Runnable command) {
            this.tasks.removeIf(trackedRunnable -> trackedRunnable.command == command);
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
            return false;
        }
    }

    private class TrackedRunnable
    implements Runnable {
        private final Executor executor;
        public final Runnable command;

        public TrackedRunnable(Executor executor, Runnable command) {
            this.executor = executor;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.nanoTime();
            try {
                this.command.run();
            }
            finally {
                long timeElapsed = System.nanoTime() - startTime;
                this.executor.runTimeInMsRollingAverage.addValue(TimeUnit.NANOSECONDS.toMillis(timeElapsed));
                PriorityTaskPicker.this.occupiedThreads.getAndDecrement();
                this.executor.runningTasks.getAndDecrement();
                this.executor.completedTasks.getAndIncrement();
                PriorityTaskPicker.this.tryStartNextTask();
            }
        }
    }
}

