/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import com.google.common.collect.ImmutableMap;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.ConfigBasedSpamLogger;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.gridList.ArrayGridList;
import com.seibel.distanthorizons.core.util.objects.EventTimer;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModChecker;
import com.seibel.distanthorizons.core.wrapperInterfaces.worldGeneration.AbstractBatchGenerationEnvironmentWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.DependencySetupDoneCheck;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.GenerationEvent;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.GlobalParameters;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.Rolling;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.ChunkLoader;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhLitWorldGenRegion;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DummyLightEngine;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.LightGetterAdaptor;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.RegionFileStorageExternalCache;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepBiomes;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepFeatures;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepNoise;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepStructureReference;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepStructureStart;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepSurface;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2839;
import net.minecraft.class_2843;
import net.minecraft.class_2867;
import net.minecraft.class_2891;
import net.minecraft.class_2897;
import net.minecraft.class_2902;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3754;
import net.minecraft.class_4698;
import net.minecraft.class_5281;
import net.minecraft.class_5539;
import net.minecraft.class_7924;
import net.minecraft.class_8563;
import org.apache.logging.log4j.LogManager;

public final class BatchGenerationEnvironment
extends AbstractBatchGenerationEnvironmentWrapper {
    public static final ConfigBasedSpamLogger PREF_LOGGER = new ConfigBasedSpamLogger(LogManager.getLogger((String)"LodWorldGen"), () -> Config.Common.Logging.logWorldGenPerformance.get(), 1);
    public static final ConfigBasedLogger EVENT_LOGGER = new ConfigBasedLogger(LogManager.getLogger((String)"LodWorldGen"), () -> Config.Common.Logging.logWorldGenEvent.get());
    public static final ConfigBasedLogger LOAD_LOGGER = new ConfigBasedLogger(LogManager.getLogger((String)"LodWorldGen"), () -> Config.Common.Logging.logWorldGenLoadEvent.get());
    private static final class_3230<class_1923> DH_SERVER_GEN_TICKET = class_3230.method_14291((String)"dh_server_gen_ticket", Comparator.comparingLong(class_1923::method_8324));
    private static final IModChecker MOD_CHECKER = SingletonInjector.INSTANCE.get(IModChecker.class);
    private final IDhServerLevel serverlevel;
    private boolean pullExistingChunkAsync = false;
    public final LinkedBlockingQueue<GenerationEvent> generationEventList = new LinkedBlockingQueue();
    public final GlobalParameters params;
    public final StepStructureStart stepStructureStart = new StepStructureStart(this);
    public final StepStructureReference stepStructureReference = new StepStructureReference(this);
    public final StepBiomes stepBiomes = new StepBiomes(this);
    public final StepNoise stepNoise = new StepNoise(this);
    public final StepSurface stepSurface = new StepSurface(this);
    public final StepFeatures stepFeatures = new StepFeatures(this);
    public boolean unsafeThreadingRecorded = false;
    public static final long EXCEPTION_TIMER_RESET_TIME = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    public static final int EXCEPTION_COUNTER_TRIGGER = 20;
    public static final int RANGE_TO_RANGE_EMPTY_EXTENSION = 1;
    public int unknownExceptionCount = 0;
    public long lastExceptionTriggerTime = 0L;
    private final AtomicReference<RegionFileStorageExternalCache> regionFileStorageCacheRef = new AtomicReference();
    public static ThreadLocal<Boolean> isDistantGeneratorThread = new ThreadLocal();
    public static final ImmutableMap<EDhApiWorldGenerationStep, Integer> WORLD_GEN_CHUNK_BORDER_NEEDED_BY_GEN_STEP;
    public static final int MAX_WORLD_GEN_CHUNK_BORDER_NEEDED;

    public RegionFileStorageExternalCache getOrCreateRegionFileCache(class_2867 storage) {
        RegionFileStorageExternalCache cache = this.regionFileStorageCacheRef.get();
        if (cache == null && !this.regionFileStorageCacheRef.compareAndSet(null, cache = new RegionFileStorageExternalCache(storage))) {
            cache = this.regionFileStorageCacheRef.get();
        }
        return cache;
    }

    public static boolean isCurrentThreadDistantGeneratorThread() {
        return isDistantGeneratorThread.get() != null;
    }

    public BatchGenerationEnvironment(IDhServerLevel serverlevel) {
        super(serverlevel);
        this.serverlevel = serverlevel;
        EVENT_LOGGER.info("================WORLD_GEN_STEP_INITING=============", new Object[0]);
        serverlevel.getServerLevelWrapper().getDimensionType();
        class_2794 generator = ((ServerLevelWrapper)serverlevel.getServerLevelWrapper()).getLevel().method_14178().method_12129();
        if (!(generator instanceof class_3754 || generator instanceof class_2891 || generator instanceof class_2897)) {
            if (generator.getClass().toString().equals("class com.terraforged.mod.chunk.TFChunkGenerator")) {
                EVENT_LOGGER.info("TerraForge Chunk Generator detected: [" + String.valueOf(generator.getClass()) + "], Distant Generation will try its best to support it.", new Object[0]);
                EVENT_LOGGER.info("If it does crash, turn Distant Generation off or set it to to [" + String.valueOf((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + "].", new Object[0]);
            } else if (generator.getClass().toString().equals("class net.dries007.tfc.world.TFCChunkGenerator")) {
                EVENT_LOGGER.info("TerraFirmaCraft Chunk Generator detected: [" + String.valueOf(generator.getClass()) + "], Distant Generation will try its best to support it.", new Object[0]);
                EVENT_LOGGER.info("If it does crash, turn Distant Generation off or set it to to [" + String.valueOf((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + "].", new Object[0]);
            } else {
                EVENT_LOGGER.warn("Unknown Chunk Generator detected: [" + String.valueOf(generator.getClass()) + "], Distant Generation May Fail!", new Object[0]);
                EVENT_LOGGER.warn("If it does crash, disable Distant Generation or set the Generation Mode to [" + String.valueOf((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + "].", new Object[0]);
            }
        }
        if (MOD_CHECKER.isModLoaded("c2me")) {
            EVENT_LOGGER.info("C2ME detected: DH's pre-existing chunk accessing will use async methods handled by C2ME.", new Object[0]);
            this.pullExistingChunkAsync = true;
        }
        this.params = new GlobalParameters(serverlevel);
    }

    public <T> T confirmFutureWasRunSynchronously(CompletableFuture<T> future) {
        if (!this.unsafeThreadingRecorded && !future.isDone()) {
            EVENT_LOGGER.warn("Unsafe MultiThreading in Distant Horizons Chunk Generator. \nThis can happen if world generation is run on one of Minecraft's thread pools instead of the thread DH provided. \nThis can likely be ignored, however if world generator crashes occur setting DH's world generation thread count to 1 may improve stability. ", new RuntimeException("Incorrect thread pool use"));
            this.unsafeThreadingRecorded = true;
        }
        return future.join();
    }

    @Override
    public void updateAllFutures() {
        if (this.unknownExceptionCount > 0 && System.nanoTime() - this.lastExceptionTriggerTime >= EXCEPTION_TIMER_RESET_TIME) {
            this.unknownExceptionCount = 0;
        }
        Iterator<GenerationEvent> iter = this.generationEventList.iterator();
        while (iter.hasNext()) {
            GenerationEvent event = iter.next();
            if (!event.future.isDone()) continue;
            if (event.future.isCompletedExceptionally() && !event.future.isCancelled()) {
                try {
                    event.future.get();
                    LodUtil.assertNotReach();
                }
                catch (Exception e) {
                    ++this.unknownExceptionCount;
                    this.lastExceptionTriggerTime = System.nanoTime();
                    EVENT_LOGGER.error("Batching World Generator event [" + String.valueOf(event) + "] threw an exception: " + e.getMessage(), e);
                }
            }
            iter.remove();
        }
        if (this.unknownExceptionCount > 20) {
            EVENT_LOGGER.error("Too many exceptions in Batching World Generator! Disabling the generator.", new Object[0]);
            this.unknownExceptionCount = 0;
            Config.Common.WorldGenerator.enableDistantGeneration.set(false);
        }
    }

    public CompletableFuture<Void> generateLodFromListAsync(GenerationEvent genEvent, Executor executor) throws RejectedExecutionException, InterruptedException {
        EVENT_LOGGER.debug("Lod Generate Event: " + String.valueOf(genEvent.minPos), new Object[0]);
        LodUtil.assertTrue(genEvent.size % 2 == 0, "Generation events are expected to be an evan number of chunks wide.");
        if (genEvent.generatorMode == EDhApiDistantGeneratorMode.INTERNAL_SERVER) {
            return this.generateChunksViaInternalServerAsync(genEvent);
        }
        int borderSize = MAX_WORLD_GEN_CHUNK_BORDER_NEEDED;
        int refSize = genEvent.size - 1 + borderSize * 2;
        int refPosX = genEvent.minPos.getX() - borderSize;
        int refPosZ = genEvent.minPos.getZ() - borderSize;
        LightGetterAdaptor lightGetterAdaptor = new LightGetterAdaptor((class_1922)this.params.level);
        DummyLightEngine dummyLightEngine = new DummyLightEngine(lightGetterAdaptor);
        Map chunkSkyLightingByDhPos = Collections.synchronizedMap(new HashMap());
        Map chunkBlockLightingByDhPos = Collections.synchronizedMap(new HashMap());
        Map generatedChunkByDhPos = Collections.synchronizedMap(new HashMap());
        Map chunkWrappersByDhPos = Collections.synchronizedMap(new HashMap());
        CompletableFuture[] readFutures = (CompletableFuture[])BatchGenerationEnvironment.getChunkPosToGenerateStream(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.size, 8).map(chunkPos -> this.createEmptyOrPreExistingChunkAsync(chunkPos.field_9181, chunkPos.field_9180, chunkSkyLightingByDhPos, chunkBlockLightingByDhPos, generatedChunkByDhPos)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(readFutures).thenRunAsync(() -> {
            for (int xOffset = 0; xOffset < 2; ++xOffset) {
                int xOffsetFinal = xOffset;
                for (int zOffset = 0; zOffset < 2; ++zOffset) {
                    int zOffsetFinal = zOffset;
                    int radius = refSize / 2;
                    int centerX = refPosX + radius + xOffset;
                    int centerZ = refPosZ + radius + zOffset;
                    IEmptyChunkRetrievalFunc fallbackFunc = (chunkPosX, chunkPosZ) -> Objects.requireNonNull((class_2791)generatedChunkByDhPos.get(new DhChunkPos(chunkPosX, chunkPosZ)), () -> String.format("Requested chunk [%d, %d] unavailable during world generation", chunkPosX, chunkPosZ));
                    ArrayGridList<class_2791> regionChunks = new ArrayGridList<class_2791>(refSize, (relX, relZ) -> fallbackFunc.getChunk(relX + refPosX + xOffsetFinal, relZ + refPosZ + zOffsetFinal));
                    class_2791 centerChunk = regionChunks.stream().filter(chunk -> chunk.method_12004().field_9181 == centerX && chunk.method_12004().field_9180 == centerZ).findFirst().orElseGet(() -> (class_2791)regionChunks.getFirst());
                    genEvent.refreshTimeout();
                    DhLitWorldGenRegion region = new DhLitWorldGenRegion(centerX, centerZ, centerChunk, this.params.level, dummyLightEngine, regionChunks, class_2806.field_16423, radius, fallbackFunc);
                    lightGetterAdaptor.setRegion(region);
                    genEvent.threadedParam.makeStructFeat((class_5281)region, this.params);
                    ArrayGridList<ChunkWrapper> chunkWrapperList = new ArrayGridList<ChunkWrapper>(regionChunks.gridSize);
                    regionChunks.forEachPos((relX, relZ) -> {
                        DhChunkPos chunkPos = new DhChunkPos(relX + refPosX + xOffsetFinal, relZ + refPosZ + zOffsetFinal);
                        class_2791 chunk = (class_2791)regionChunks.get((int)relX, (int)relZ);
                        if (chunkWrappersByDhPos.containsKey(chunkPos)) {
                            chunkWrapperList.set((int)relX, (int)relZ, (ChunkWrapper)chunkWrappersByDhPos.get(chunkPos));
                        } else if (chunk != null) {
                            ChunkWrapper chunkWrapper = new ChunkWrapper(chunk, this.serverlevel.getLevelWrapper());
                            chunkWrapperList.set((int)relX, (int)relZ, chunkWrapper);
                            if (chunkBlockLightingByDhPos.containsKey(chunkWrapper.getChunkPos())) {
                                chunkWrapper.setBlockLightStorage((ChunkLightStorage)chunkBlockLightingByDhPos.get(chunkWrapper.getChunkPos()));
                                chunkWrapper.setSkyLightStorage((ChunkLightStorage)chunkSkyLightingByDhPos.get(chunkWrapper.getChunkPos()));
                                chunkWrapper.setIsDhBlockLightCorrect(true);
                                chunkWrapper.setIsDhSkyLightCorrect(true);
                            }
                            chunkWrappersByDhPos.put(chunkPos, chunkWrapper);
                        } else {
                            LodUtil.assertNotReach("Programmer Error: No chunk found in grid list, position offset is likely wrong.");
                        }
                    });
                    try {
                        this.generateDirect(genEvent, chunkWrapperList, region);
                    }
                    catch (InterruptedException e) {
                        throw new CompletionException(e);
                    }
                    genEvent.timer.nextEvent("cleanup");
                }
            }
            genEvent.timer.nextEvent("cleanup");
            Iterator iterator = BatchGenerationEnvironment.getChunkPosToGenerateStream(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.size, 0).iterator();
            while (iterator.hasNext()) {
                class_1923 pos = (class_1923)iterator.next();
                DhChunkPos dhPos = new DhChunkPos(pos.field_9181, pos.field_9180);
                ChunkWrapper wrappedChunk = (ChunkWrapper)chunkWrappersByDhPos.get(dhPos);
                genEvent.resultConsumer.accept(wrappedChunk);
            }
            genEvent.timer.complete();
            genEvent.refreshTimeout();
            if (PREF_LOGGER.canMaybeLog()) {
                genEvent.threadedParam.perf.recordEvent(genEvent.timer);
                PREF_LOGGER.debugInc(genEvent.timer.toString(), new Object[0]);
            }
        }, executor);
    }

    private static Stream<class_1923> getChunkPosToGenerateStream(int genMinX, int genMinZ, int width, int extraRadius) {
        return StreamSupport.stream(new InclusiveChunkPosStream(genMinX, genMinZ, width, extraRadius), false);
    }

    private CompletableFuture<class_2791> createEmptyOrPreExistingChunkAsync(int x, int z, Map<DhChunkPos, ChunkLightStorage> chunkSkyLightingByDhPos, Map<DhChunkPos, ChunkLightStorage> chunkBlockLightingByDhPos, Map<DhChunkPos, class_2791> generatedChunkByDhPos) {
        class_1923 chunkPos = new class_1923(x, z);
        DhChunkPos dhChunkPos = new DhChunkPos(x, z);
        if (generatedChunkByDhPos.containsKey(dhChunkPos)) {
            return CompletableFuture.completedFuture(generatedChunkByDhPos.get(dhChunkPos));
        }
        return ((CompletableFuture)((CompletableFuture)this.getChunkNbtDataAsync(chunkPos).thenApply(chunkData -> {
            ChunkLoader.CombinedChunkLightStorage combinedLights;
            class_2791 newChunk = this.loadOrMakeChunk(chunkPos, (class_2487)chunkData);
            if (Config.Common.LodBuilding.pullLightingForPregeneratedChunks.get().booleanValue() && (combinedLights = ChunkLoader.readLight(newChunk, chunkData)) != null) {
                chunkSkyLightingByDhPos.put(dhChunkPos, combinedLights.skyLightStorage);
                chunkBlockLightingByDhPos.put(dhChunkPos, combinedLights.blockLightStorage);
            }
            return newChunk;
        })).handle((newChunk, throwable) -> {
            if (newChunk != null) {
                return newChunk;
            }
            return BatchGenerationEnvironment.CreateEmptyChunk(this.params.level, chunkPos);
        })).thenApply(newChunk -> {
            generatedChunkByDhPos.put(dhChunkPos, (class_2791)newChunk);
            return newChunk;
        });
    }

    private CompletableFuture<class_2487> getChunkNbtDataAsync(class_1923 chunkPos) {
        class_3218 level = this.params.level;
        try {
            class_4698 ioWorker = level.method_14178().field_17254.field_21494;
            if (!this.pullExistingChunkAsync && ioWorker.field_21499 != null) {
                try {
                    class_2867 storage = this.params.level.method_14178().field_17254.field_21494.field_21499;
                    RegionFileStorageExternalCache cache = this.getOrCreateRegionFileCache(storage);
                    return CompletableFuture.completedFuture(cache.read(chunkPos));
                }
                catch (NullPointerException e) {
                    EVENT_LOGGER.error("Unexpected issue pulling pre-existing chunk [" + String.valueOf(chunkPos) + "], falling back to async chunk pulling. This may cause server-tick lag.", e);
                    this.pullExistingChunkAsync = true;
                    return this.getChunkNbtDataAsync(chunkPos);
                }
            }
            if (!this.pullExistingChunkAsync) {
                EVENT_LOGGER.info("Unable to pull pre-existing chunk using synchronous method. Falling back to async method. this may cause server-tick lag.", new Object[0]);
                this.pullExistingChunkAsync = true;
            }
            return ((CompletableFuture)ioWorker.method_31738(chunkPos).thenApply(optional -> optional.orElse(null))).exceptionally(throwable -> {
                Throwable actualThrowable = throwable;
                while (actualThrowable instanceof CompletionException) {
                    CompletionException completionException = (CompletionException)actualThrowable;
                    actualThrowable = completionException.getCause();
                }
                LOAD_LOGGER.warn("DistantHorizons: Couldn't load or make chunk [" + String.valueOf(chunkPos) + "], error: [" + actualThrowable.getMessage() + "].", actualThrowable);
                return null;
            });
        }
        catch (Exception e) {
            LOAD_LOGGER.warn("DistantHorizons: Couldn't load or make chunk [" + String.valueOf(chunkPos) + "]. Error: [" + e.getMessage() + "].", e);
            return CompletableFuture.completedFuture(null);
        }
    }

    private class_2791 loadOrMakeChunk(class_1923 chunkPos, class_2487 chunkData) {
        class_3218 level = this.params.level;
        if (chunkData == null) {
            return BatchGenerationEnvironment.CreateEmptyChunk(level, chunkPos);
        }
        try {
            LOAD_LOGGER.debug("DistantHorizons: Loading chunk [" + String.valueOf(chunkPos) + "] from disk.", new Object[0]);
            class_2818 chunk = ChunkLoader.read((class_5281)level, chunkPos, chunkData);
            if (chunk != null) {
                if (Config.Common.LodBuilding.assumePreExistingChunksAreFinished.get().booleanValue()) {
                    ChunkWrapper.trySetStatus((class_2791)chunk, class_2806.field_12803);
                }
            } else {
                chunk = BatchGenerationEnvironment.CreateEmptyChunk(level, chunkPos);
            }
            return chunk;
        }
        catch (Exception e) {
            LOAD_LOGGER.error("DistantHorizons: couldn't load or make chunk at [" + String.valueOf(chunkPos) + "].Please try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen.\nError: [" + e.getMessage() + "].", e);
            return BatchGenerationEnvironment.CreateEmptyChunk(level, chunkPos);
        }
    }

    private static class_2839 CreateEmptyChunk(class_3218 level, class_1923 chunkPos) {
        return new class_2839(chunkPos, class_2843.field_12950, (class_5539)level, level.method_30349().method_30530(class_7924.field_41236), null);
    }

    private CompletableFuture<Void> generateChunksViaInternalServerAsync(GenerationEvent genEvent) throws InterruptedException {
        genEvent.timer.nextEvent("requestFromServer");
        LinkedBlockingQueue runnableQueue = new LinkedBlockingQueue();
        Map chunkWrappersByDhPos = Collections.synchronizedMap(new HashMap());
        CompletableFuture[] requestFutures = (CompletableFuture[])BatchGenerationEnvironment.getChunkPosToGenerateStream(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.size, 0).map(chunkPos -> BatchGenerationEnvironment.requestChunkFromServerAsync(this.params.level, chunkPos, true).whenCompleteAsync((chunk, throwable) -> {
            Throwable actualThrowable = throwable;
            while (actualThrowable instanceof CompletionException) {
                actualThrowable = actualThrowable.getCause();
            }
            if (throwable != null) {
                LOAD_LOGGER.warn("DistantHorizons: Couldn't load chunk [" + String.valueOf(chunkPos) + "] from server, error: [" + actualThrowable.getMessage() + "].", actualThrowable);
            }
            if (chunk != null) {
                ChunkWrapper chunkWrapper = new ChunkWrapper((class_2791)chunk, this.serverlevel.getLevelWrapper());
                chunkWrappersByDhPos.put(new DhChunkPos(chunkPos.field_9181, chunkPos.field_9180), chunkWrapper);
            }
        }, runnableQueue::add)).toArray(CompletableFuture[]::new);
        CompletionStage processGeneratedChunksFuture = ((CompletableFuture)CompletableFuture.allOf(requestFutures).whenCompleteAsync((voidObj, throwable) -> {
            genEvent.timer.nextEvent("light");
            int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
            ArrayList<IChunkWrapper> generatedChunks = new ArrayList<IChunkWrapper>(chunkWrappersByDhPos.values());
            for (IChunkWrapper iChunkWrapper : generatedChunks) {
                ((ChunkWrapper)iChunkWrapper).recalculateDhHeightMapsIfNeeded();
                if (!iChunkWrapper.isDhBlockLightingCorrect()) {
                    DhLightingEngine.INSTANCE.bakeChunkBlockLighting(iChunkWrapper, generatedChunks, maxSkyLight);
                }
                this.serverlevel.updateBeaconBeamsForChunk(iChunkWrapper, generatedChunks);
            }
            genEvent.timer.nextEvent("cleanup");
            for (IChunkWrapper iChunkWrapper : generatedChunks) {
                genEvent.resultConsumer.accept(iChunkWrapper);
            }
        }, runnableQueue::add)).whenCompleteAsync((unused, throwable) -> {
            Iterator iterator = BatchGenerationEnvironment.getChunkPosToGenerateStream(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.size, 0).iterator();
            while (iterator.hasNext()) {
                class_1923 chunkPos = (class_1923)iterator.next();
                BatchGenerationEnvironment.releaseChunkToServer(this.params.level, chunkPos, true);
            }
            genEvent.timer.complete();
            genEvent.refreshTimeout();
            if (PREF_LOGGER.canMaybeLog()) {
                genEvent.threadedParam.perf.recordEvent(genEvent.timer);
                PREF_LOGGER.debugInc(genEvent.timer.toString(), new Object[0]);
            }
        });
        ((CompletableFuture)processGeneratedChunksFuture).whenCompleteAsync((unused, throwable) -> {}, runnableQueue::add);
        while (!((CompletableFuture)processGeneratedChunksFuture).isDone()) {
            try {
                Runnable command = (Runnable)runnableQueue.poll(1L, TimeUnit.SECONDS);
                if (command == null) continue;
                command.run();
            }
            catch (InterruptedException e) {
                Iterator iterator = BatchGenerationEnvironment.getChunkPosToGenerateStream(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.size, 0).iterator();
                while (iterator.hasNext()) {
                    class_1923 chunkPos2 = (class_1923)iterator.next();
                    BatchGenerationEnvironment.releaseChunkToServer(this.params.level, chunkPos2, true);
                }
                throw e;
            }
        }
        return processGeneratedChunksFuture;
    }

    private static CompletableFuture<class_2791> requestChunkFromServerAsync(class_3218 level, class_1923 pos, boolean generateUpToFeatures) {
        return CompletableFuture.supplyAsync(() -> {
            int chunkLevel = generateUpToFeatures ? class_8563.method_51829((class_2806)class_2806.field_12795) : 33;
            level.method_14178().field_17252.method_17290(DH_SERVER_GEN_TICKET, pos, chunkLevel, (Object)pos);
            level.method_14178().field_17252.method_15892(level.method_14178().field_17254);
            class_3193 holder = level.method_14178().field_17254.method_17255(pos.method_8324());
            if (holder == null) {
                throw new IllegalStateException("No chunk holder after ticket has been added");
            }
            return holder.method_60458(class_2806.field_12795, level.method_14178().field_17254).thenApply(result -> (class_2791)result.method_57132(() -> new RuntimeException(result.method_57129())));
        }, (Executor)level.method_14178().field_17254.field_17216).thenCompose(Function.identity());
    }

    private static void releaseChunkToServer(class_3218 level, class_1923 pos, boolean chunkWasGeneratedUpToFeatures) {
        level.method_14178().field_17254.field_17216.execute(() -> {
            try {
                int chunkLevel = chunkWasGeneratedUpToFeatures ? class_8563.method_51829((class_2806)class_2806.field_12795) : 33;
                level.method_14178().field_17252.method_20444(DH_SERVER_GEN_TICKET, pos, chunkLevel, (Object)pos);
                level.method_14178().field_17254.method_17233(() -> false);
                level.field_26935.method_31809();
            }
            catch (Exception e) {
                EVENT_LOGGER.warn("Failed to release chunk back to internal server. Error: [" + e.getMessage() + "]", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDirect(GenerationEvent genEvent, ArrayGridList<ChunkWrapper> chunkWrappersToGenerate, DhLitWorldGenRegion region) throws InterruptedException {
        int i;
        block43: {
            int i2;
            EDhApiWorldGenerationStep step;
            block42: {
                int i3;
                block41: {
                    int i4;
                    block40: {
                        int i5;
                        block39: {
                            int i6;
                            block38: {
                                int i7;
                                block37: {
                                    int i8;
                                    if (Thread.interrupted()) {
                                        return;
                                    }
                                    chunkWrappersToGenerate.forEach(chunkWrapper -> {
                                        class_2791 chunk = chunkWrapper.getChunk();
                                        if (chunk instanceof class_2839) {
                                            class_2839 protoChunk = (class_2839)chunk;
                                            protoChunk.method_17032(region.method_22336());
                                        }
                                    });
                                    step = genEvent.targetGenerationStep;
                                    if (step != EDhApiWorldGenerationStep.EMPTY) break block37;
                                    genEvent.timer.nextEvent("light");
                                    int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                                    ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                                    for (i8 = 0; i8 < chunkWrappersToGenerate.size(); ++i8) {
                                        ChunkWrapper chunkWrapper2 = (ChunkWrapper)chunkWrappersToGenerate.get(i8);
                                        if (chunkWrapper2.getStatus() == class_2806.field_12798) continue;
                                        iChunkWrapperList.add(chunkWrapper2);
                                    }
                                    for (i8 = 0; i8 < iChunkWrapperList.size(); ++i8) {
                                        ChunkWrapper centerChunk = (ChunkWrapper)iChunkWrapperList.get(i8);
                                        if (centerChunk == null) continue;
                                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                                        class_2902.method_16684((class_2791)centerChunk.getChunk(), (Set)class_2806.field_12795.method_12160());
                                        centerChunk.recalculateDhHeightMapsIfNeeded();
                                        if (!centerChunk.isDhBlockLightingCorrect()) {
                                            DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunk, iChunkWrapperList, maxSkyLight);
                                        }
                                        this.serverlevel.updateBeaconBeamsForChunk(centerChunk, iChunkWrapperList);
                                    }
                                    genEvent.refreshTimeout();
                                    return;
                                }
                                genEvent.timer.nextEvent("structStart");
                                BatchGenerationEnvironment.throwIfThreadInterrupted();
                                this.stepStructureStart.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.STRUCTURE_START));
                                genEvent.refreshTimeout();
                                if (step != EDhApiWorldGenerationStep.STRUCTURE_START) break block38;
                                genEvent.timer.nextEvent("light");
                                int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                                ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                                for (i7 = 0; i7 < chunkWrappersToGenerate.size(); ++i7) {
                                    ChunkWrapper chunkWrapper3 = (ChunkWrapper)chunkWrappersToGenerate.get(i7);
                                    if (chunkWrapper3.getStatus() == class_2806.field_12798) continue;
                                    iChunkWrapperList.add(chunkWrapper3);
                                }
                                for (i7 = 0; i7 < iChunkWrapperList.size(); ++i7) {
                                    ChunkWrapper centerChunk = (ChunkWrapper)iChunkWrapperList.get(i7);
                                    if (centerChunk == null) continue;
                                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                                    class_2902.method_16684((class_2791)centerChunk.getChunk(), (Set)class_2806.field_12795.method_12160());
                                    centerChunk.recalculateDhHeightMapsIfNeeded();
                                    if (!centerChunk.isDhBlockLightingCorrect()) {
                                        DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunk, iChunkWrapperList, maxSkyLight);
                                    }
                                    this.serverlevel.updateBeaconBeamsForChunk(centerChunk, iChunkWrapperList);
                                }
                                genEvent.refreshTimeout();
                                return;
                            }
                            genEvent.timer.nextEvent("structRef");
                            BatchGenerationEnvironment.throwIfThreadInterrupted();
                            this.stepStructureReference.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.STRUCTURE_REFERENCE));
                            genEvent.refreshTimeout();
                            if (step != EDhApiWorldGenerationStep.STRUCTURE_REFERENCE) break block39;
                            genEvent.timer.nextEvent("light");
                            int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                            for (i6 = 0; i6 < chunkWrappersToGenerate.size(); ++i6) {
                                ChunkWrapper chunkWrapper4 = (ChunkWrapper)chunkWrappersToGenerate.get(i6);
                                if (chunkWrapper4.getStatus() == class_2806.field_12798) continue;
                                iChunkWrapperList.add(chunkWrapper4);
                            }
                            for (i6 = 0; i6 < iChunkWrapperList.size(); ++i6) {
                                ChunkWrapper centerChunk = (ChunkWrapper)iChunkWrapperList.get(i6);
                                if (centerChunk == null) continue;
                                BatchGenerationEnvironment.throwIfThreadInterrupted();
                                class_2902.method_16684((class_2791)centerChunk.getChunk(), (Set)class_2806.field_12795.method_12160());
                                centerChunk.recalculateDhHeightMapsIfNeeded();
                                if (!centerChunk.isDhBlockLightingCorrect()) {
                                    DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunk, iChunkWrapperList, maxSkyLight);
                                }
                                this.serverlevel.updateBeaconBeamsForChunk(centerChunk, iChunkWrapperList);
                            }
                            genEvent.refreshTimeout();
                            return;
                        }
                        genEvent.timer.nextEvent("biome");
                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                        this.stepBiomes.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.BIOMES));
                        genEvent.refreshTimeout();
                        if (step != EDhApiWorldGenerationStep.BIOMES) break block40;
                        genEvent.timer.nextEvent("light");
                        int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                        ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                        for (i5 = 0; i5 < chunkWrappersToGenerate.size(); ++i5) {
                            ChunkWrapper chunkWrapper5 = (ChunkWrapper)chunkWrappersToGenerate.get(i5);
                            if (chunkWrapper5.getStatus() == class_2806.field_12798) continue;
                            iChunkWrapperList.add(chunkWrapper5);
                        }
                        for (i5 = 0; i5 < iChunkWrapperList.size(); ++i5) {
                            ChunkWrapper centerChunk = (ChunkWrapper)iChunkWrapperList.get(i5);
                            if (centerChunk == null) continue;
                            BatchGenerationEnvironment.throwIfThreadInterrupted();
                            class_2902.method_16684((class_2791)centerChunk.getChunk(), (Set)class_2806.field_12795.method_12160());
                            centerChunk.recalculateDhHeightMapsIfNeeded();
                            if (!centerChunk.isDhBlockLightingCorrect()) {
                                DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunk, iChunkWrapperList, maxSkyLight);
                            }
                            this.serverlevel.updateBeaconBeamsForChunk(centerChunk, iChunkWrapperList);
                        }
                        genEvent.refreshTimeout();
                        return;
                    }
                    genEvent.timer.nextEvent("noise");
                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                    this.stepNoise.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.NOISE));
                    genEvent.refreshTimeout();
                    if (step != EDhApiWorldGenerationStep.NOISE) break block41;
                    genEvent.timer.nextEvent("light");
                    int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                    ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                    for (i4 = 0; i4 < chunkWrappersToGenerate.size(); ++i4) {
                        ChunkWrapper chunkWrapper6 = (ChunkWrapper)chunkWrappersToGenerate.get(i4);
                        if (chunkWrapper6.getStatus() == class_2806.field_12798) continue;
                        iChunkWrapperList.add(chunkWrapper6);
                    }
                    for (i4 = 0; i4 < iChunkWrapperList.size(); ++i4) {
                        ChunkWrapper centerChunk = (ChunkWrapper)iChunkWrapperList.get(i4);
                        if (centerChunk == null) continue;
                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                        class_2902.method_16684((class_2791)centerChunk.getChunk(), (Set)class_2806.field_12795.method_12160());
                        centerChunk.recalculateDhHeightMapsIfNeeded();
                        if (!centerChunk.isDhBlockLightingCorrect()) {
                            DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunk, iChunkWrapperList, maxSkyLight);
                        }
                        this.serverlevel.updateBeaconBeamsForChunk(centerChunk, iChunkWrapperList);
                    }
                    genEvent.refreshTimeout();
                    return;
                }
                genEvent.timer.nextEvent("surface");
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                this.stepSurface.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.SURFACE));
                genEvent.refreshTimeout();
                if (step != EDhApiWorldGenerationStep.SURFACE) break block42;
                genEvent.timer.nextEvent("light");
                int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                for (i3 = 0; i3 < chunkWrappersToGenerate.size(); ++i3) {
                    ChunkWrapper chunkWrapper7 = (ChunkWrapper)chunkWrappersToGenerate.get(i3);
                    if (chunkWrapper7.getStatus() == class_2806.field_12798) continue;
                    iChunkWrapperList.add(chunkWrapper7);
                }
                for (i3 = 0; i3 < iChunkWrapperList.size(); ++i3) {
                    ChunkWrapper centerChunk = (ChunkWrapper)iChunkWrapperList.get(i3);
                    if (centerChunk == null) continue;
                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                    class_2902.method_16684((class_2791)centerChunk.getChunk(), (Set)class_2806.field_12795.method_12160());
                    centerChunk.recalculateDhHeightMapsIfNeeded();
                    if (!centerChunk.isDhBlockLightingCorrect()) {
                        DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunk, iChunkWrapperList, maxSkyLight);
                    }
                    this.serverlevel.updateBeaconBeamsForChunk(centerChunk, iChunkWrapperList);
                }
                genEvent.refreshTimeout();
                return;
            }
            genEvent.timer.nextEvent("carver");
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            if (step != EDhApiWorldGenerationStep.CARVERS) break block43;
            genEvent.timer.nextEvent("light");
            int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
            for (i2 = 0; i2 < chunkWrappersToGenerate.size(); ++i2) {
                ChunkWrapper chunkWrapper8 = (ChunkWrapper)chunkWrappersToGenerate.get(i2);
                if (chunkWrapper8.getStatus() == class_2806.field_12798) continue;
                iChunkWrapperList.add(chunkWrapper8);
            }
            for (i2 = 0; i2 < iChunkWrapperList.size(); ++i2) {
                ChunkWrapper centerChunk = (ChunkWrapper)iChunkWrapperList.get(i2);
                if (centerChunk == null) continue;
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                class_2902.method_16684((class_2791)centerChunk.getChunk(), (Set)class_2806.field_12795.method_12160());
                centerChunk.recalculateDhHeightMapsIfNeeded();
                if (!centerChunk.isDhBlockLightingCorrect()) {
                    DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunk, iChunkWrapperList, maxSkyLight);
                }
                this.serverlevel.updateBeaconBeamsForChunk(centerChunk, iChunkWrapperList);
            }
            genEvent.refreshTimeout();
            return;
        }
        try {
            genEvent.timer.nextEvent("feature");
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            this.stepFeatures.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunkWrappersToGenerate, EDhApiWorldGenerationStep.FEATURES));
            genEvent.refreshTimeout();
            genEvent.timer.nextEvent("light");
        }
        catch (Throwable throwable) {
            int i9;
            genEvent.timer.nextEvent("light");
            int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
            for (i9 = 0; i9 < chunkWrappersToGenerate.size(); ++i9) {
                ChunkWrapper chunkWrapper9 = (ChunkWrapper)chunkWrappersToGenerate.get(i9);
                if (chunkWrapper9.getStatus() == class_2806.field_12798) continue;
                iChunkWrapperList.add(chunkWrapper9);
            }
            for (i9 = 0; i9 < iChunkWrapperList.size(); ++i9) {
                ChunkWrapper centerChunk = (ChunkWrapper)iChunkWrapperList.get(i9);
                if (centerChunk == null) continue;
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                class_2902.method_16684((class_2791)centerChunk.getChunk(), (Set)class_2806.field_12795.method_12160());
                centerChunk.recalculateDhHeightMapsIfNeeded();
                if (!centerChunk.isDhBlockLightingCorrect()) {
                    DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunk, iChunkWrapperList, maxSkyLight);
                }
                this.serverlevel.updateBeaconBeamsForChunk(centerChunk, iChunkWrapperList);
            }
            genEvent.refreshTimeout();
            throw throwable;
        }
        int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
        ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
        for (i = 0; i < chunkWrappersToGenerate.size(); ++i) {
            ChunkWrapper chunkWrapper10 = (ChunkWrapper)chunkWrappersToGenerate.get(i);
            if (chunkWrapper10.getStatus() == class_2806.field_12798) continue;
            iChunkWrapperList.add(chunkWrapper10);
        }
        for (i = 0; i < iChunkWrapperList.size(); ++i) {
            ChunkWrapper centerChunk = (ChunkWrapper)iChunkWrapperList.get(i);
            if (centerChunk == null) continue;
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            class_2902.method_16684((class_2791)centerChunk.getChunk(), (Set)class_2806.field_12795.method_12160());
            centerChunk.recalculateDhHeightMapsIfNeeded();
            if (!centerChunk.isDhBlockLightingCorrect()) {
                DhLightingEngine.INSTANCE.bakeChunkBlockLighting(centerChunk, iChunkWrapperList, maxSkyLight);
            }
            this.serverlevel.updateBeaconBeamsForChunk(centerChunk, iChunkWrapperList);
        }
        genEvent.refreshTimeout();
    }

    private static <T> ArrayGridList<T> GetCutoutFrom(ArrayGridList<T> total, int border) {
        return new ArrayGridList<T>(total, border, total.gridSize - border);
    }

    private static <T> ArrayGridList<T> GetCutoutFrom(ArrayGridList<T> total, EDhApiWorldGenerationStep step) {
        return BatchGenerationEnvironment.GetCutoutFrom(total, 0);
    }

    @Override
    public int getEventCount() {
        return this.generationEventList.size();
    }

    @Override
    public void stop() {
        EVENT_LOGGER.info(BatchGenerationEnvironment.class.getSimpleName() + " shutting down...", new Object[0]);
        EVENT_LOGGER.info("Canceling in progress generation event futures...", new Object[0]);
        Iterator<GenerationEvent> iter = this.generationEventList.iterator();
        while (iter.hasNext()) {
            GenerationEvent event = iter.next();
            event.future.cancel(true);
            iter.remove();
        }
        RegionFileStorageExternalCache regionStorage = this.regionFileStorageCacheRef.get();
        if (regionStorage != null) {
            try {
                regionStorage.close();
            }
            catch (IOException e) {
                EVENT_LOGGER.error("Failed to close region file storage cache!", e);
            }
        }
        EVENT_LOGGER.info(BatchGenerationEnvironment.class.getSimpleName() + " shutdown complete.", new Object[0]);
    }

    @Override
    public CompletableFuture<Void> generateChunks(int minX, int minZ, int genSize, EDhApiDistantGeneratorMode generatorMode, EDhApiWorldGenerationStep targetStep, ExecutorService worldGeneratorThreadPool, Consumer<IChunkWrapper> resultConsumer) {
        GenerationEvent genEvent = GenerationEvent.startEvent(new DhChunkPos(minX, minZ), genSize, this, generatorMode, targetStep, resultConsumer, worldGeneratorThreadPool);
        this.generationEventList.add(genEvent);
        return genEvent.future;
    }

    public static void throwIfThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException(BatchGenerationEnvironment.class.getSimpleName() + " task interrupted.");
        }
    }

    static {
        DependencySetupDoneCheck.getIsCurrentThreadDistantGeneratorThread = BatchGenerationEnvironment::isCurrentThreadDistantGeneratorThread;
        boolean isTerraFirmaCraft = false;
        try {
            Class.forName("net.dries007.tfc.world.TFCChunkGenerator");
            isTerraFirmaCraft = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        EVENT_LOGGER.info("DH TerraFirmaCraft detection: " + isTerraFirmaCraft, new Object[0]);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EDhApiWorldGenerationStep.EMPTY, (Object)1);
        builder.put((Object)EDhApiWorldGenerationStep.STRUCTURE_START, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.STRUCTURE_REFERENCE, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.BIOMES, (Object)(isTerraFirmaCraft ? 1 : 0));
        builder.put((Object)EDhApiWorldGenerationStep.NOISE, (Object)(isTerraFirmaCraft ? 1 : 0));
        builder.put((Object)EDhApiWorldGenerationStep.SURFACE, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.CARVERS, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.LIQUID_CARVERS, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.FEATURES, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.LIGHT, (Object)0);
        WORLD_GEN_CHUNK_BORDER_NEEDED_BY_GEN_STEP = builder.build();
        MAX_WORLD_GEN_CHUNK_BORDER_NEEDED = 0;
    }

    private static class InclusiveChunkPosStream
    extends Spliterators.AbstractSpliterator<class_1923> {
        private final int minX;
        private final int minZ;
        private final int maxX;
        private final int maxZ;
        int x;
        private int z;

        protected InclusiveChunkPosStream(int genMinX, int genMinZ, int width, int extraRadius) {
            super(InclusiveChunkPosStream.getCount(width, extraRadius), 64);
            this.minX = genMinX - extraRadius;
            this.minZ = genMinZ - extraRadius;
            this.maxX = genMinX + (width - 1) + extraRadius;
            this.maxZ = genMinZ + (width - 1) + extraRadius;
            this.x = this.minX - 1;
            this.z = this.minZ;
        }

        private static int getCount(int width, int extraRadius) {
            int widthPlusExtra = width + extraRadius * 2;
            return widthPlusExtra * widthPlusExtra;
        }

        @Override
        public boolean tryAdvance(Consumer<? super class_1923> consumer) {
            if (this.x == this.maxX && this.z == this.maxZ) {
                return false;
            }
            if (this.x == this.maxX) {
                this.x = this.minX;
                ++this.z;
            } else {
                ++this.x;
            }
            consumer.accept((class_1923)new class_1923(this.x, this.z));
            return true;
        }
    }

    public static class PerfCalculator {
        private static final String[] TIME_NAMES = new String[]{"total", "setup", "structStart", "structRef", "biome", "noise", "surface", "carver", "feature", "light", "cleanup"};
        public static final int SIZE = 50;
        ArrayList<Rolling> times = new ArrayList();

        public PerfCalculator() {
            for (int i = 0; i < 11; ++i) {
                this.times.add(new Rolling(50));
            }
        }

        public void recordEvent(EventTimer event) {
            for (EventTimer.Event e : event.events) {
                String name = e.name;
                int index = Arrays.asList(TIME_NAMES).indexOf(name);
                if (index == -1) continue;
                this.times.get(index).add(e.timeNs);
            }
            this.times.get(0).add(event.getTotalTimeNs());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.times.size(); ++i) {
                if (this.times.get(i).getAverage() == 0.0) continue;
                sb.append(TIME_NAMES[i]).append(": ").append(this.times.get(i).getAverage()).append("\n");
            }
            return sb.toString();
        }
    }

    @FunctionalInterface
    public static interface IEmptyChunkRetrievalFunc {
        public class_2791 getChunk(int var1, int var2);
    }
}

