/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.mixin.IMixinClientWorld;
import fi.dy.masa.tweakeroo.mixin.IMixinCustomizeFlatLevelScreen;
import fi.dy.masa.tweakeroo.mixin.block.IMixinCommandBlockExecutor;
import fi.dy.masa.tweakeroo.mixin.item.IMixinAxeItem;
import fi.dy.masa.tweakeroo.mixin.item.IMixinShovelItem;
import fi.dy.masa.tweakeroo.renderer.RenderUtils;
import fi.dy.masa.tweakeroo.tweaks.MiscTweaks;
import fi.dy.masa.tweakeroo.util.IGuiEditSign;
import fi.dy.masa.tweakeroo.util.ISignTextAccess;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2593;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3229;
import net.minecraft.class_3232;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_3966;
import net.minecraft.class_413;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7193;
import net.minecraft.class_7225;
import net.minecraft.class_744;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7743;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8242;
import net.minecraft.class_9209;
import net.minecraft.class_9334;

public class MiscUtils {
    public static final Pattern PATTERN_WORLD_PRESET = Pattern.compile("^(?<name>[a-zA-Z0-9_/&*#!=()\\[\\]{} -]+);(?<blocks>[a-z0-9_:.*,-]+);(?<biome>[a-z0-9_:.-]+);(?<options>[a-z0-9_, ()=]*);(?<icon>[a-z0-9_:.-]+)$");
    private static class_8242 previousSignText;
    private static String previousChatText;
    private static final Date DATE;
    private static double lastRealPitch;
    private static double lastRealYaw;
    private static double mouseSensitivity;
    private static boolean zoomActive;
    private static boolean periodicAttackActive;
    private static boolean periodicUseActive;
    private static boolean periodicHoldAttackActive;
    private static boolean periodicHoldUseActive;
    private static PostKeyAction lastZoomValue;
    private static PostKeyAction lastPeriodicAttackValue;
    private static PostKeyAction lastPeriodicUseValue;
    private static PostKeyAction lastPeriodicHoldAttackValue;
    private static PostKeyAction lastPeriodicHoldUseValue;

    public static void handlePlayerDeceleration() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_744 input = player.field_3913;
        if (input.field_54155.comp_3163() || input.field_54155.comp_3164() || player.field_6250 != 0.0f || player.field_6212 != 0.0f || !player.method_31549().field_7479) {
            return;
        }
        double factor = Configs.Generic.FLY_DECELERATION_FACTOR.getDoubleValue();
        player.method_18799(player.method_18798().method_1021(factor));
    }

    public static class_243 calculatePlayerMotionWithDeceleration(class_243 lastMotion, double rampAmount, double decelerationFactor) {
        class_315 options = class_310.method_1551().field_1690;
        int forward = 0;
        int vertical = 0;
        int strafe = 0;
        if (options.field_1894.method_1434()) {
            ++forward;
        }
        if (options.field_1881.method_1434()) {
            --forward;
        }
        if (options.field_1913.method_1434()) {
            ++strafe;
        }
        if (options.field_1849.method_1434()) {
            --strafe;
        }
        if (options.field_1903.method_1434()) {
            ++vertical;
        }
        if (options.field_1832.method_1434()) {
            --vertical;
        }
        double speed = forward != 0 && strafe != 0 ? 1.2 : 1.0;
        double forwardRamped = MiscUtils.getRampedMotion(lastMotion.field_1352, forward, rampAmount, decelerationFactor) / speed;
        double verticalRamped = MiscUtils.getRampedMotion(lastMotion.field_1351, vertical, rampAmount, decelerationFactor);
        double strafeRamped = MiscUtils.getRampedMotion(lastMotion.field_1350, strafe, rampAmount, decelerationFactor) / speed;
        return new class_243(forwardRamped, verticalRamped, strafeRamped);
    }

    public static double getRampedMotion(double current, int input, double rampAmount, double decelerationFactor) {
        if (input != 0) {
            if (input < 0) {
                rampAmount *= -1.0;
            }
            if (input < 0 != current < 0.0) {
                current = 0.0;
            }
            current = class_3532.method_15350((double)(current + rampAmount), (double)-1.0, (double)1.0);
        } else {
            current *= decelerationFactor;
        }
        return current;
    }

    public static boolean isZoomActive() {
        return FeatureToggle.TWEAK_ZOOM.getBooleanValue() && Hotkeys.ZOOM_ACTIVATE.getKeybind().isKeybindHeld();
    }

    public static void checkZoomStatus() {
        if (zoomActive && !MiscUtils.isZoomActive()) {
            MiscUtils.onZoomDeactivated();
        }
    }

    public static void onZoomActivated() {
        if (Configs.Generic.ZOOM_ADJUST_MOUSE_SENSITIVITY.getBooleanValue()) {
            MiscUtils.setMouseSensitivityForZoom();
            lastZoomValue = new PostKeyAction(Configs.Generic.ZOOM_FOV.getDoubleValue());
        }
        zoomActive = true;
    }

    public static void onZoomDeactivated() {
        if (zoomActive) {
            MiscUtils.resetMouseSensitivityForZoom();
            if (lastZoomValue != null && lastZoomValue.isActive()) {
                if (lastZoomValue.getLastDoubleValue() != Configs.Generic.ZOOM_FOV.getDoubleValue() && Configs.Generic.ZOOM_RESET_FOV_ON_ACTIVATE.getBooleanValue()) {
                    Configs.Generic.ZOOM_FOV.setDoubleValue(lastZoomValue.getLastDoubleValue());
                }
                lastZoomValue.setActionHandled();
            }
            class_310.method_1551().field_1769.method_3292();
            zoomActive = false;
        }
    }

    public static void setMouseSensitivityForZoom() {
        double origFov;
        class_310 mc = class_310.method_1551();
        double fov = Configs.Generic.ZOOM_FOV.getDoubleValue();
        if (fov < (origFov = (double)((Integer)mc.field_1690.method_41808().method_41753()).intValue())) {
            if (mouseSensitivity <= 0.0 || mouseSensitivity > 1.0) {
                mouseSensitivity = (Double)mc.field_1690.method_42495().method_41753();
            }
            double min = 0.04;
            double sens = min + (0.5 - min) * (1.0 - (origFov - fov) / origFov);
            mc.field_1690.method_42495().method_41748((Object)Math.min(mouseSensitivity, sens));
        }
    }

    public static void resetMouseSensitivityForZoom() {
        if (mouseSensitivity > 0.0) {
            class_310.method_1551().field_1690.method_42495().method_41748((Object)mouseSensitivity);
            mouseSensitivity = -1.0;
        }
    }

    public boolean isPeriodicAttackActive() {
        return periodicAttackActive;
    }

    public static void onPeriodicAttackActivated() {
        lastPeriodicAttackValue = new PostKeyAction(Configs.Generic.PERIODIC_ATTACK_INTERVAL.getIntegerValue());
        periodicAttackActive = true;
    }

    public static void onPeriodicAttackDeactivated() {
        if (periodicAttackActive) {
            if (lastPeriodicAttackValue != null && lastPeriodicAttackValue.isActive()) {
                if (lastPeriodicAttackValue.getLastIntValue() != Configs.Generic.PERIODIC_ATTACK_INTERVAL.getIntegerValue() && Configs.Generic.PERIODIC_ATTACK_RESET_ON_ACTIVATE.getBooleanValue()) {
                    Configs.Generic.PERIODIC_ATTACK_INTERVAL.setIntegerValue(lastPeriodicAttackValue.getLastIntValue());
                }
                lastPeriodicAttackValue.setActionHandled();
            }
            periodicAttackActive = false;
        }
    }

    public boolean isPeriodicUseActive() {
        return periodicUseActive;
    }

    public static void onPeriodicUseActivated() {
        lastPeriodicUseValue = new PostKeyAction(Configs.Generic.PERIODIC_USE_INTERVAL.getIntegerValue());
        periodicUseActive = true;
    }

    public static void onPeriodicUseDeactivated() {
        if (periodicUseActive) {
            if (lastPeriodicUseValue != null && lastPeriodicUseValue.isActive()) {
                if (lastPeriodicUseValue.getLastIntValue() != Configs.Generic.PERIODIC_USE_INTERVAL.getIntegerValue() && Configs.Generic.PERIODIC_USE_RESET_ON_ACTIVATE.getBooleanValue()) {
                    Configs.Generic.PERIODIC_USE_INTERVAL.setIntegerValue(lastPeriodicUseValue.getLastIntValue());
                }
                lastPeriodicUseValue.setActionHandled();
            }
            periodicUseActive = false;
        }
    }

    public boolean isPeriodicHoldAttackActive() {
        return periodicHoldAttackActive;
    }

    public static void onPeriodicHoldAttackActivated() {
        lastPeriodicHoldAttackValue = new PostKeyAction(Configs.Generic.PERIODIC_HOLD_ATTACK_INTERVAL.getIntegerValue());
        periodicHoldAttackActive = true;
    }

    public static void onPeriodicHoldAttackDeactivated() {
        if (periodicHoldAttackActive) {
            if (lastPeriodicHoldAttackValue != null && lastPeriodicHoldAttackValue.isActive()) {
                if (lastPeriodicHoldAttackValue.getLastIntValue() != Configs.Generic.PERIODIC_HOLD_ATTACK_INTERVAL.getIntegerValue() && Configs.Generic.PERIODIC_HOLD_ATTACK_RESET_ON_ACTIVATE.getBooleanValue()) {
                    Configs.Generic.PERIODIC_HOLD_ATTACK_INTERVAL.setIntegerValue(lastPeriodicHoldAttackValue.getLastIntValue());
                }
                lastPeriodicHoldAttackValue.setActionHandled();
            }
            periodicHoldAttackActive = false;
        }
    }

    public boolean isPeriodicHoldUseActive() {
        return periodicHoldUseActive;
    }

    public static void onPeriodicHoldUseActivated() {
        lastPeriodicHoldUseValue = new PostKeyAction(Configs.Generic.PERIODIC_HOLD_USE_INTERVAL.getIntegerValue());
        periodicHoldUseActive = true;
    }

    public static void onPeriodicHoldUseDeactivated() {
        if (periodicHoldUseActive) {
            if (lastPeriodicHoldUseValue != null && lastPeriodicHoldUseValue.isActive()) {
                if (lastPeriodicHoldUseValue.getLastIntValue() != Configs.Generic.PERIODIC_HOLD_USE_INTERVAL.getIntegerValue() && Configs.Generic.PERIODIC_HOLD_USE_RESET_ON_ACTIVATE.getBooleanValue()) {
                    Configs.Generic.PERIODIC_HOLD_USE_INTERVAL.setIntegerValue(lastPeriodicHoldUseValue.getLastIntValue());
                }
                lastPeriodicHoldUseValue.setActionHandled();
            }
            periodicHoldUseActive = false;
        }
    }

    public static boolean isStrippableLog(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return IMixinAxeItem.tweakeroo_getStrippedBlocks().containsKey(state.method_26204());
    }

    public static boolean isShovelPathConvertableBlock(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return IMixinShovelItem.tweakeroo_getPathStates().containsKey(state.method_26204());
    }

    public static boolean getUpdateExec(class_2593 te) {
        return ((IMixinCommandBlockExecutor)te.method_11040()).getUpdateLastExecution();
    }

    public static void setUpdateExec(class_2593 te, boolean value) {
        ((IMixinCommandBlockExecutor)te.method_11040()).setUpdateLastExecution(value);
    }

    public static void printDeathCoordinates(class_310 mc) {
        class_2338 pos = PositionUtils.getEntityBlockPos((class_1297)mc.field_1724);
        String dim = mc.field_1724.method_5770().method_27983().method_29177().toString();
        String str = StringUtils.translate((String)"tweakeroo.message.death_coordinates", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), dim});
        class_5250 message = class_2561.method_43470((String)str);
        class_2583 style = message.method_10866();
        String coords = pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260();
        style = style.method_10958(new class_2558(class_2558.class_2559.field_11745, coords));
        style = style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)coords)));
        message.method_10862(style);
        mc.field_1705.method_1743().method_1812((class_2561)message);
        Tweakeroo.logger.info(str);
    }

    public static String getChatTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat(Configs.Generic.CHAT_TIME_FORMAT.getStringValue());
        DATE.setTime(System.currentTimeMillis());
        return sdf.format(DATE);
    }

    public static void setLastChatText(String text) {
        previousChatText = text;
    }

    public static String getLastChatText() {
        return previousChatText;
    }

    public static int getChatBackgroundColor(int colorOrig) {
        int newColor = Configs.Generic.CHAT_BACKGROUND_COLOR.getIntegerValue();
        return newColor & 0xFFFFFF | (int)((double)(newColor >>> 24) / 255.0 * ((double)(colorOrig >>> 24) / 255.0) / 0.5 * 255.0) << 24;
    }

    public static void copyTextFromSign(class_2625 te, boolean front) {
        previousSignText = ((ISignTextAccess)te).tweakeroo$getText(front);
    }

    public static void applyPreviousTextToSign(class_2625 te, @Nullable class_7743 guiLines, boolean front) {
        if (previousSignText != null) {
            te.method_49840(previousSignText, front);
            if (guiLines != null) {
                ((IGuiEditSign)guiLines).tweakeroo$applyText(previousSignText);
            }
        }
    }

    public static boolean commandNearbyPets(boolean sitDown) {
        class_310 mc = class_310.method_1551();
        class_638 world = mc.field_1687;
        class_746 player = mc.field_1724;
        if (world != null && player != null) {
            UUID uuid = player.method_5667();
            double centerX = player.method_23317();
            double centerY = player.method_23318();
            double centerZ = player.method_23321();
            double range = 6.0;
            class_238 box = new class_238(centerX - range, centerY - range, centerZ - range, centerX + range, centerY + range, centerZ + range);
            Predicate<class_1297> filter = e -> MiscUtils.isTameableOwnedBy(e, uuid);
            for (class_1297 entity : world.method_8333(null, box, filter)) {
                if (((class_1321)entity).method_6172() == sitDown) continue;
                MiscUtils.rightClickEntity(entity, mc, (class_1657)player);
            }
        }
        return true;
    }

    public static boolean isTameableOwnedBy(class_1297 entity, UUID ownerUuid) {
        return entity instanceof class_1321 && ownerUuid.equals(((class_1321)entity).method_6139()) && ((class_1321)entity).method_6181();
    }

    public static void rightClickEntity(class_1297 entity, class_310 mc, class_1657 player) {
        class_1269.class_9860 success;
        class_1268 hand = class_1268.field_5808;
        class_1269 actionResult = mc.field_1761.method_2917(player, entity, new class_3966(entity), hand);
        if (!actionResult.method_23665()) {
            actionResult = mc.field_1761.method_2905(player, entity, hand);
        }
        if (actionResult instanceof class_1269.class_9860 && (success = (class_1269.class_9860)actionResult).comp_2909() == class_1269.class_9861.field_52427) {
            player.method_6104(hand);
        }
    }

    public static double getLastRealPitch() {
        return lastRealPitch;
    }

    public static double getLastRealYaw() {
        return lastRealYaw;
    }

    public static void setEntityRotations(class_1297 entity, float yaw, float pitch) {
        entity.method_36456(yaw);
        entity.method_36457(pitch);
        entity.field_5982 = yaw;
        entity.field_6004 = pitch;
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            living.field_6241 = yaw;
            living.field_6259 = yaw;
        }
    }

    public static float getSnappedPitch(double realPitch) {
        if (Configs.Generic.SNAP_AIM_MODE.getOptionListValue() != SnapAimMode.YAW) {
            if (lastRealPitch != realPitch) {
                lastRealPitch = realPitch;
                RenderUtils.notifyRotationChanged();
            }
            if (FeatureToggle.TWEAK_SNAP_AIM_LOCK.getBooleanValue()) {
                return (float)Configs.Internal.SNAP_AIM_LAST_PITCH.getDoubleValue();
            }
            double step = Configs.Generic.SNAP_AIM_PITCH_STEP.getDoubleValue();
            int limit = Configs.Generic.SNAP_AIM_PITCH_OVERSHOOT.getBooleanValue() ? 180 : 90;
            double snappedPitch = realPitch < 0.0 ? -MiscUtils.calculateSnappedAngle(-realPitch, step) : MiscUtils.calculateSnappedAngle(realPitch, step);
            double offset = Math.abs(class_3532.method_15393((float)((float)(snappedPitch - realPitch))));
            if (GuiBase.isCtrlDown()) {
                System.out.printf("real: %.2f, snapped: %.2f, offset: %.2f\n", realPitch, snappedPitch, offset);
            }
            if (!Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue() || offset <= Configs.Generic.SNAP_AIM_THRESHOLD_PITCH.getDoubleValue()) {
                snappedPitch = class_3532.method_15350((double)class_3532.method_15338((double)snappedPitch), (double)(-limit), (double)limit);
                if (Configs.Internal.SNAP_AIM_LAST_PITCH.getDoubleValue() != snappedPitch) {
                    String g = GuiBase.TXT_GREEN;
                    String r = GuiBase.TXT_RST;
                    String str = String.format("%s%s%s (step %s%s%s)", g, String.valueOf(class_3532.method_15338((double)snappedPitch)), r, g, String.valueOf(step), r);
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.snapped_to_pitch", (Object[])new Object[]{str});
                    Configs.Internal.SNAP_AIM_LAST_PITCH.setDoubleValue(snappedPitch);
                }
                return class_3532.method_15393((float)((float)snappedPitch));
            }
        }
        Configs.Internal.SNAP_AIM_LAST_PITCH.setDoubleValue(realPitch);
        return (float)realPitch;
    }

    public static float getSnappedYaw(double realYaw) {
        if (Configs.Generic.SNAP_AIM_MODE.getOptionListValue() != SnapAimMode.PITCH) {
            if (lastRealYaw != realYaw) {
                lastRealYaw = realYaw;
                RenderUtils.notifyRotationChanged();
            }
            if (FeatureToggle.TWEAK_SNAP_AIM_LOCK.getBooleanValue()) {
                return (float)Configs.Internal.SNAP_AIM_LAST_YAW.getDoubleValue();
            }
            double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
            double snappedYaw = MiscUtils.calculateSnappedAngle(realYaw, step);
            if (!Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue() || (double)Math.abs(class_3532.method_15393((float)((float)(snappedYaw - realYaw)))) <= Configs.Generic.SNAP_AIM_THRESHOLD_YAW.getDoubleValue()) {
                if (Configs.Internal.SNAP_AIM_LAST_YAW.getDoubleValue() != snappedYaw) {
                    String g = GuiBase.TXT_GREEN;
                    String r = GuiBase.TXT_RST;
                    String str = String.format("%s%s%s (step %s%s%s)", g, String.valueOf(class_3532.method_15338((double)snappedYaw)), r, g, String.valueOf(step), r);
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.snapped_to_yaw", (Object[])new Object[]{str});
                    Configs.Internal.SNAP_AIM_LAST_YAW.setDoubleValue(snappedYaw);
                }
                return class_3532.method_15393((float)((float)snappedYaw));
            }
        }
        Configs.Internal.SNAP_AIM_LAST_YAW.setDoubleValue(realYaw);
        return (float)realYaw;
    }

    public static double calculateSnappedAngle(double realRotation, double step) {
        double offsetRealRotation = class_3532.method_15367((double)realRotation, (double)360.0) + step / 2.0;
        return class_3532.method_15367((double)((double)((int)(offsetRealRotation / step)) * step), (double)360.0);
    }

    public static boolean writeAllMapsAsImages() {
        File dir;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return true;
        }
        Map<class_9209, class_22> data = ((IMixinClientWorld)mc.field_1687).tweakeroo_getMapStates();
        String worldName = StringUtils.getWorldOrServerName();
        if (worldName == null) {
            worldName = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date(System.currentTimeMillis()));
        }
        if (!(dir = FileUtils.getConfigDirectory().toPath().resolve("tweakeroo").resolve("map_images").resolve(worldName).toFile()).exists() && !dir.mkdirs()) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to create directory: " + dir.getAbsolutePath()), (Object[])new Object[0]);
            return true;
        }
        int count = 0;
        for (Map.Entry<class_9209, class_22> entry : data.entrySet()) {
            File file = new File(dir, entry.getKey().method_56814() + ".png");
            MiscUtils.writeMapAsImage(file, entry.getValue());
            ++count;
        }
        InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.INFO, (String)String.format("Wrote %d maps to image files", count), (Object[])new Object[0]);
        return true;
    }

    private static void writeMapAsImage(File fileOut, class_22 state) {
        BufferedImage image = new BufferedImage(128, 128, 2);
        for (int y = 0; y < 128; ++y) {
            for (int x = 0; x < 128; ++x) {
                int index = x + y * 128;
                int color = class_3620.method_38480((int)state.field_122[index]);
                int outputColor = color & 0xFF00FF00 | (color & 0xFF0000) >> 16 | (color & 0xFF) << 16;
                image.setRGB(x, y, outputColor);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "png", fileOut);
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to write image to file: " + fileOut.getAbsolutePath()), (Object[])new Object[0]);
        }
    }

    public static boolean isShulkerBox(class_1799 stack) {
        class_1747 blockItem;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_2480;
    }

    public static boolean hasCustomMaxStackSize(class_1799 stack) {
        int currentStackSize;
        int defaultStackSize = (Integer)stack.method_58658().method_57830(class_9334.field_50071, (Object)1);
        return defaultStackSize != (currentStackSize = ((Integer)stack.method_57825(class_9334.field_50071, (Object)1)).intValue());
    }

    public static boolean registerPresetFromString(class_413 screen, String str) {
        Matcher matcher = PATTERN_WORLD_PRESET.matcher(str);
        if (matcher.matches()) {
            class_6880.class_6883 referenceEntry;
            class_7193 generatorOptionsHolder = ((IMixinCustomizeFlatLevelScreen)screen).tweakeroo_getCreateWorldParent().method_48657().method_48728();
            class_5455.class_6890 registryManager = generatorOptionsHolder.method_45689();
            class_7699 featureSet = generatorOptionsHolder.comp_1030().comp_1011();
            class_2378 biomeLookup = registryManager.method_30530(class_7924.field_41236);
            class_2378 structureLookup = registryManager.method_30530(class_7924.field_41248);
            class_2378 featuresLookup = registryManager.method_30530(class_7924.field_41245);
            class_7225.class_7226 blockLookup = registryManager.method_30530(class_7924.field_41254).method_45919(featureSet);
            class_3232 defaultConfig = class_3232.method_14309((class_7871)biomeLookup, (class_7871)structureLookup, (class_7871)featuresLookup);
            class_3232 currentConfig = screen.method_29055();
            class_6880.class_6883 biomeEntry = referenceEntry = biomeLookup.method_46747(class_1972.field_9451);
            String name = matcher.group("name");
            String blocksString = matcher.group("blocks");
            String biomeName = matcher.group("biome");
            String iconItemName = matcher.group("icon");
            try {
                Optional<class_5321> optBiome = Optional.ofNullable(class_2960.method_12829((String)biomeName)).map(biomeId -> class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biomeId));
                biomeEntry = optBiome.flatMap(arg_0 -> ((class_7871)biomeLookup).method_46746(arg_0)).orElse(referenceEntry);
            }
            catch (Exception optBiome) {
                // empty catch block
            }
            if (biomeEntry == null) {
                Tweakeroo.logger.error("Invalid biome while parsing flat world string: '{}'", (Object)biomeName);
                return false;
            }
            class_1792 item = null;
            try {
                Optional opt = class_7923.field_41178.method_10223(class_2960.method_60654((String)iconItemName));
                if (opt.isPresent()) {
                    item = (class_1792)((class_6880.class_6883)opt.get()).comp_349();
                }
            }
            catch (Exception opt) {
                // empty catch block
            }
            if (item == null) {
                Tweakeroo.logger.error("Invalid item for icon while parsing flat world string: '{}'", (Object)iconItemName);
                return false;
            }
            List<class_3229> layers = MiscTweaks.parseBlockString(blocksString);
            if (layers == null) {
                Tweakeroo.logger.error("Failed to get the layers for the flat world preset");
                return false;
            }
            class_3232 newConfig = defaultConfig.method_46727(layers, defaultConfig.method_41139(), (class_6880)biomeEntry);
            screen.method_29054(newConfig);
            return true;
        }
        Tweakeroo.logger.error("Flat world preset string did not match the regex");
        return false;
    }

    static {
        previousChatText = "";
        DATE = new Date();
        mouseSensitivity = -1.0;
    }

    public static class PostKeyAction {
        private int lastIntValue;
        private double lastDoubleValue;
        private long lastActive;
        private boolean active = false;

        public PostKeyAction(int lastIntValue) {
            this.lastIntValue = lastIntValue;
            this.lastDoubleValue = -1.0;
            this.lastActive = class_156.method_648();
            this.active = true;
        }

        public PostKeyAction(double lastDoubleValue) {
            this.lastDoubleValue = lastDoubleValue;
            this.lastIntValue = -1;
            this.lastActive = class_156.method_648();
            this.active = true;
        }

        public boolean isActive() {
            return this.active;
        }

        public int getLastIntValue() {
            return this.lastIntValue;
        }

        public double getLastDoubleValue() {
            return this.lastDoubleValue;
        }

        public long getLastActive() {
            return this.lastActive;
        }

        public void setActionHandled() {
            this.lastIntValue = -1;
            this.lastDoubleValue = -1.0;
            this.lastActive = class_156.method_648();
            this.active = false;
        }
    }
}

