/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.button;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_6880;

public abstract class ButtonBase
extends WidgetBase {
    protected static final class_2960 BUTTON_TEXTURE = class_2960.method_60656((String)"widget/button");
    protected static final class_2960 BUTTON_DISABLE_TEXTURE = class_2960.method_60656((String)"widget/button_disabled");
    protected static final class_2960 BUTTON_HOVER_TEXTURE = class_2960.method_60656((String)"widget/button_highlighted");
    protected final List<String> hoverStrings = new ArrayList<String>();
    protected final ImmutableList<String> hoverHelp;
    protected String displayString;
    protected boolean enabled = true;
    protected boolean visible = true;
    protected boolean hovered;
    protected boolean hoverInfoRequiresShift;
    @Nullable
    protected IButtonActionListener actionListener;

    public ButtonBase(int x, int y, int width, int height) {
        this(x, y, width, height, "");
    }

    public ButtonBase(int x, int y, int width, int height, String text) {
        this(x, y, width, height, text, null);
    }

    public ButtonBase(int x, int y, int width, int height, String text, @Nullable IButtonActionListener actionListener) {
        super(x, y, width, height);
        if (width < 0) {
            this.width = this.getStringWidth(text) + 10;
        }
        this.displayString = text;
        this.hoverHelp = ImmutableList.of((Object)StringUtils.translate("malilib.gui.button.hover.hold_shift_for_info", new Object[0]));
    }

    public ButtonBase setActionListener(@Nullable IButtonActionListener actionListener) {
        this.actionListener = actionListener;
        return this;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDisplayString(String text) {
        this.displayString = text;
    }

    public boolean isMouseOver() {
        return this.hovered;
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        this.mc.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        if (this.actionListener != null) {
            this.actionListener.actionPerformedWithButton(this, mouseButton);
        }
        return true;
    }

    @Override
    public boolean onMouseScrolledImpl(int mouseX, int mouseY, double horizontalAmount, double verticalAmount) {
        int mouseButton = verticalAmount < 0.0 ? 1 : 0;
        return this.onMouseClickedImpl(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.enabled && this.visible && super.isMouseOver(mouseX, mouseY);
    }

    public void updateDisplayString() {
    }

    public boolean hasHoverText() {
        return !this.hoverStrings.isEmpty();
    }

    public void setHoverInfoRequiresShift(boolean requireShift) {
        this.hoverInfoRequiresShift = requireShift;
    }

    public void setHoverStrings(String ... hoverStrings) {
        this.setHoverStrings(Arrays.asList(hoverStrings));
    }

    public void setHoverStrings(List<String> hoverStrings) {
        this.hoverStrings.clear();
        for (String str : hoverStrings) {
            String[] parts;
            str = StringUtils.translate(str, new Object[0]);
            for (String part : parts = str.split("\\\\n")) {
                this.hoverStrings.add(StringUtils.translate(part, new Object[0]));
            }
        }
    }

    public List<String> getHoverStrings() {
        if (this.hoverInfoRequiresShift && !GuiBase.isShiftDown()) {
            return this.hoverHelp;
        }
        return this.hoverStrings;
    }

    public void clearHoverStrings() {
        this.hoverStrings.clear();
    }

    protected int getTextureOffset(boolean isMouseOver) {
        return !this.enabled ? 0 : (isMouseOver ? 2 : 1);
    }

    protected class_2960 getTexture(boolean isMouseOver) {
        return !this.enabled ? BUTTON_DISABLE_TEXTURE : (isMouseOver ? BUTTON_HOVER_TEXTURE : BUTTON_TEXTURE);
    }

    @Override
    public void postRenderHovered(class_332 drawContext, int mouseX, int mouseY, boolean selected) {
        super.postRenderHovered(drawContext, mouseX, mouseY, selected);
        if (this.hasHoverText() && this.isMouseOver()) {
            RenderUtils.drawHoverText(drawContext, mouseX, mouseY, this.getHoverStrings());
        }
    }
}

