/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import journeymap.api.services.CommonPlatformService;
import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.event.handlers.keymapping.KeyBindingAction;
import journeymap.client.event.handlers.keymapping.KeyConflictContext;
import journeymap.client.event.handlers.keymapping.KeyEvent;
import journeymap.client.event.handlers.keymapping.KeyModifier;
import journeymap.client.event.handlers.keymapping.UpdateAwareKeyBinding;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.option.ClientOptionsManager;
import journeymap.client.ui.option.OptionScreen;
import journeymap.client.ui.waypointmanager.WaypointManager;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.BooleanField;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_408;
import net.minecraft.class_437;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

public class KeyEventHandler {
    public UpdateAwareKeyBinding kbMapZoomin;
    public UpdateAwareKeyBinding kbMapZoomout;
    public UpdateAwareKeyBinding kbMapToggleType;
    public UpdateAwareKeyBinding kbCreateWaypoint;
    public UpdateAwareKeyBinding kbToggleWaypointRendering;
    public UpdateAwareKeyBinding kbToggleWaypointWorldRendering;
    public UpdateAwareKeyBinding kbToggleWaypointMapRendering;
    public UpdateAwareKeyBinding kbToggleWaypoints;
    public UpdateAwareKeyBinding kbFullscreenCreateWaypoint;
    public UpdateAwareKeyBinding kbFullscreenChatPosition;
    public UpdateAwareKeyBinding kbFullscreenToggle;
    public UpdateAwareKeyBinding kbWaypointManager;
    public UpdateAwareKeyBinding kbMinimapToggle;
    public UpdateAwareKeyBinding kbMinimapPreset;
    public UpdateAwareKeyBinding kbFullmapOptionsManager;
    public UpdateAwareKeyBinding kbFullmapPanNorth;
    public UpdateAwareKeyBinding kbFullmapPanSouth;
    public UpdateAwareKeyBinding kbFullmapPanEast;
    public UpdateAwareKeyBinding kbFullmapPanWest;
    public UpdateAwareKeyBinding kbFullmapButtonHide;
    public UpdateAwareKeyBinding kbEntityNameDisplay;
    public UpdateAwareKeyBinding kbFullmapFollowPlayer;
    protected Comparator<KeyBindingAction> kbaComparator = Comparator.comparingInt(KeyBindingAction::order);
    protected final ListMultimap<Integer, KeyBindingAction> minimapPreviewActions = MultimapBuilder.hashKeys().arrayListValues(2).build();
    protected final ListMultimap<Integer, KeyBindingAction> inGameActions = MultimapBuilder.hashKeys().arrayListValues(2).build();
    protected final ListMultimap<Integer, KeyBindingAction> inGuiActions = MultimapBuilder.hashKeys().arrayListValues(2).build();
    public boolean sortActionsNeeded = true;
    protected Logger logger = Journeymap.getLogger();
    protected final KeyEvent keyEvent;
    public UpdateAwareKeyBinding kbTest;
    boolean skipMousePress = false;

    public KeyEventHandler(KeyEvent keyEvent) {
        this.keyEvent = keyEvent;
        this.kbMapZoomin = this.register("key.journeymap.zoom_in", KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 61);
        this.kbMapZoomout = this.register("key.journeymap.zoom_out", KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 45);
        this.kbMapToggleType = this.register("key.journeymap.minimap_type", KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 91);
        this.kbMinimapPreset = this.register("key.journeymap.minimap_preset", KeyConflictContext.IN_GAME, KeyModifier.NONE, 92);
        this.kbCreateWaypoint = this.register("key.journeymap.create_waypoint", KeyConflictContext.IN_GAME, KeyModifier.NONE, 66);
        this.kbToggleWaypointRendering = this.register("key.journeymap.toggle_render_waypoints", KeyConflictContext.UNIVERSAL, KeyModifier.NONE, -1);
        this.kbToggleWaypointWorldRendering = this.register("key.journeymap.toggle_render_waypoints_world", KeyConflictContext.UNIVERSAL, KeyModifier.NONE, -1);
        this.kbToggleWaypointMapRendering = this.register("key.journeymap.toggle_render_waypoints_map", KeyConflictContext.UNIVERSAL, KeyModifier.NONE, -1);
        this.kbToggleWaypoints = this.register("key.journeymap.toggle_waypoints", KeyConflictContext.UNIVERSAL, KeyModifier.NONE, -1);
        this.kbFullscreenCreateWaypoint = this.register("key.journeymap.fullscreen_create_waypoint", KeyConflictContext.GUI, KeyModifier.NONE, 66);
        this.kbFullscreenChatPosition = this.register("key.journeymap.fullscreen_chat_position", KeyConflictContext.GUI, KeyModifier.NONE, 67);
        this.kbFullscreenToggle = this.register("key.journeymap.map_toggle_alt", KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 74);
        this.kbWaypointManager = this.register("key.journeymap.fullscreen_waypoints", KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 78);
        this.kbMinimapToggle = CommonPlatformService.Loader.FORGE.equals((Object)Services.COMMON_SERVICE.getLoader()) ? this.register("key.journeymap.minimap_toggle_alt", KeyConflictContext.IN_GAME, KeyModifier.CONTROL, 74) : this.register("key.journeymap.minimap_toggle_alt", KeyConflictContext.IN_GAME, KeyModifier.NONE, 77);
        this.kbFullmapOptionsManager = this.register("key.journeymap.fullscreen_options", KeyConflictContext.GUI, KeyModifier.NONE, 79);
        this.kbFullmapPanNorth = this.register("key.journeymap.fullscreen.north", KeyConflictContext.GUI, KeyModifier.NONE, 265);
        this.kbFullmapPanSouth = this.register("key.journeymap.fullscreen.south", KeyConflictContext.GUI, KeyModifier.NONE, 264);
        this.kbFullmapPanEast = this.register("key.journeymap.fullscreen.east", KeyConflictContext.GUI, KeyModifier.NONE, 262);
        this.kbFullmapPanWest = this.register("key.journeymap.fullscreen.west", KeyConflictContext.GUI, KeyModifier.NONE, 263);
        this.kbFullmapFollowPlayer = this.register("key.journeymap.fullscreen_follow_player", KeyConflictContext.GUI, KeyModifier.NONE, 70);
        this.kbFullmapButtonHide = this.register("key.journeymap.fullscreen.disable_buttons", KeyConflictContext.GUI, KeyModifier.NONE, -1);
        this.kbEntityNameDisplay = this.register("key.journeymap.toggle_entity_names", KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 71);
    }

    public KeyEventHandler registerActions() {
        this.setAction(this.minimapPreviewActions, this.kbMapZoomin, () -> MiniMap.state().minimapZoomIn());
        this.setAction(this.inGuiActions, this.kbMapZoomin, this.fullscreenAction(() -> this.getFullscreen().zoomIn()));
        this.setAction(this.inGuiActions, this.kbFullmapFollowPlayer, this.fullscreenAction(() -> this.getFullscreen().setFollow(true)));
        this.setAction(this.minimapPreviewActions, this.kbMapZoomout, () -> MiniMap.state().minimapZoomOut());
        this.setAction(this.inGuiActions, this.kbMapZoomout, this.fullscreenAction(() -> this.getFullscreen().zoomOut()));
        this.setAction(this.minimapPreviewActions, this.kbMapToggleType, () -> MiniMap.state().toggleMapType());
        this.setAction(this.inGuiActions, this.kbMapToggleType, this.fullscreenAction(() -> this.getFullscreen().toggleMapType()));
        this.setAction(this.minimapPreviewActions, this.kbMinimapPreset, UIManager.INSTANCE::switchMiniMapPreset);
        this.inGameActions.putAll(this.minimapPreviewActions);
        this.setAction(this.inGameActions, this.kbCreateWaypoint, () -> UIManager.INSTANCE.openWaypointEditor(null, true));
        this.setAction(this.inGameActions, this.kbToggleWaypointRendering, WaypointStore::toggleWaypointRendering);
        this.setAction(this.inGuiActions, this.kbToggleWaypointRendering, WaypointStore::toggleWaypointRendering);
        this.setAction(this.inGameActions, this.kbToggleWaypointWorldRendering, KeyEventHandler::toggleWorldWaypoints);
        this.setAction(this.inGuiActions, this.kbToggleWaypointWorldRendering, KeyEventHandler::toggleWorldWaypoints);
        this.setAction(this.inGameActions, this.kbToggleWaypointMapRendering, KeyEventHandler::toggleMapWaypoints);
        this.setAction(this.inGuiActions, this.kbToggleWaypointMapRendering, KeyEventHandler::toggleMapWaypoints);
        this.setAction(this.inGameActions, this.kbToggleWaypoints, WaypointStore::toggleAllWaypoints);
        this.setAction(this.inGuiActions, this.kbFullscreenCreateWaypoint, this.fullscreenAction(() -> this.getFullscreen().createWaypointAtMouse()));
        this.setAction(this.inGuiActions, this.kbFullscreenChatPosition, this.fullscreenAction(() -> this.getFullscreen().chatPositionAtMouse()));
        this.setAction(this.inGameActions, this.kbFullscreenToggle, UIManager.INSTANCE::openFullscreenMap);
        this.setAction(this.inGuiActions, this.kbFullscreenToggle, () -> {
            if (this.inFullscreenWithoutChat()) {
                UIManager.INSTANCE.closeAll();
            }
        });
        this.setAction(this.inGameActions, this.kbWaypointManager, () -> UIManager.INSTANCE.openWaypointManager(null, null));
        this.setAction(this.inGuiActions, this.kbWaypointManager, () -> {
            if (this.inFullscreenWithoutChat()) {
                UIManager.INSTANCE.openWaypointManager(null, this.getFullscreen());
            } else if (this.inWaypointManager()) {
                UIManager.INSTANCE.closeWithKeyBind();
            }
        });
        this.setAction(this.inGameActions, this.kbMinimapToggle, UIManager.INSTANCE::toggleMinimap);
        this.setAction(this.inGuiActions, this.kbFullmapOptionsManager, () -> {
            if (this.inFullscreenWithoutChat()) {
                UIManager.INSTANCE.openOptionsManager((class_437)this.getFullscreen(), new Category[0]);
            } else if (this.inOptionsScreen()) {
                UIManager.INSTANCE.closeWithKeyBind();
            }
        });
        this.setAction(this.inGuiActions, this.kbFullmapPanNorth, this.fullscreenAction(() -> this.getFullscreen().moveCanvas(0.0, -16.0)));
        this.setAction(this.inGuiActions, this.kbFullmapPanSouth, this.fullscreenAction(() -> this.getFullscreen().moveCanvas(0.0, 16.0)));
        this.setAction(this.inGuiActions, this.kbFullmapPanEast, this.fullscreenAction(() -> this.getFullscreen().moveCanvas(16.0, 0.0)));
        this.setAction(this.inGuiActions, this.kbFullmapPanWest, this.fullscreenAction(() -> this.getFullscreen().moveCanvas(-16.0, 0.0)));
        this.setAction(this.inGuiActions, this.kbFullmapButtonHide, this.fullscreenAction(() -> this.getFullscreen().hideButtons()));
        this.setAction(this.inGuiActions, this.kbEntityNameDisplay, this.fullscreenAction(() -> this.getFullscreen().toggleEntityNames()));
        this.setAction(this.inGameActions, this.kbEntityNameDisplay, UIManager.INSTANCE::toggleMiniMapEntityNames);
        return this;
    }

    Runnable fullscreenAction(Runnable action) {
        return () -> {
            if (this.inFullscreenWithoutChat()) {
                action.run();
            }
        };
    }

    private void printMem() {
        System.out.println("print");
        MemoryUtil.memReport((address, memory, threadId, threadName, stacktrace) -> System.out.println("address:" + address + " threadId:" + threadId + " threadName:" + threadName + " stacktrace:" + Arrays.toString(stacktrace)));
    }

    private UpdateAwareKeyBinding register(String description, KeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode) {
        String category = keyConflictContext == KeyConflictContext.GUI ? Constants.getString("jm.common.hotkeys_keybinding_fullscreen_category") : Constants.getString("jm.common.hotkeys_keybinding_category");
        UpdateAwareKeyBinding kb = Services.CLIENT_SERVICE.getKeyBinding(description, keyConflictContext, keyModifier, class_3675.class_307.field_1668, keyCode, category, this);
        try {
            this.keyEvent.register((class_304)kb);
        }
        catch (Throwable t) {
            this.logger.error("Unexpected error when registering keybinding : {} :", (Object)kb, (Object)t);
        }
        return kb;
    }

    private void setAction(ListMultimap<Integer, KeyBindingAction> multimap, UpdateAwareKeyBinding keyBinding, Runnable action) {
        multimap.put((Object)keyBinding.getKeyValue().method_1444(), (Object)new KeyBindingAction(keyBinding, action));
    }

    public List<UpdateAwareKeyBinding> getInGuiKeybindings() {
        List<UpdateAwareKeyBinding> list = this.inGuiActions.values().stream().map(KeyBindingAction::getKeyBinding).collect(Collectors.toList());
        list.sort(Comparator.comparing(kb -> Constants.getString(kb.getText())));
        return list;
    }

    public void sortActions() {
        this.sortActions(this.minimapPreviewActions);
        this.sortActions(this.inGameActions);
        this.sortActions(this.inGuiActions);
        this.sortActionsNeeded = false;
    }

    private void sortActions(ListMultimap<Integer, KeyBindingAction> multimap) {
        ArrayList copy = new ArrayList(multimap.values());
        multimap.clear();
        for (KeyBindingAction kba : copy) {
            multimap.put((Object)kba.getKeyBinding().getKeyValue().method_1444(), (Object)kba);
        }
        for (Integer key : multimap.keySet()) {
            multimap.get((Object)key).sort(this.kbaComparator);
            Journeymap.getLogger().debug((Object)multimap.get((Object)key));
        }
    }

    public int getPressedKey(ListMultimap<Integer, KeyBindingAction> actions) {
        Iterator iterator = actions.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            for (KeyBindingAction action : actions.get((Object)key)) {
                if (key == -1 || !action.getKeyBinding().isKeyPressed() && !this.isPressed(action, key)) continue;
                return action.getKeyBinding().getKeyValue().method_1444();
            }
        }
        return -1;
    }

    boolean isPressed(KeyBindingAction action, int key) {
        if (action.getKeyBinding().getMapping().method_1433(key)) {
            return GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)key) == 1;
        }
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)key);
    }

    public boolean onGameKeyboardEvent(int key) {
        int pressed;
        if (JourneymapClient.getInstance().enabled() && key != class_3675.field_16237.method_1444() && !this.debugKeyDown() && (pressed = this.getPressedKey(this.inGameActions)) == key && !this.isInChat() && this.emptyScreen()) {
            return this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.inGameActions, key, true, false);
        }
        return true;
    }

    public boolean onGuiKeyboardEvent(class_437 screen, int key) {
        if (JourneymapClient.getInstance().enabled() && key != class_3675.field_16237.method_1444() && !this.debugKeyDown()) {
            if (screen == null) {
                return true;
            }
            int pressed = this.getPressedKey(this.inGuiActions);
            if (pressed == key) {
                if (this.inFullscreenWithoutChat() || this.inWaypointManager() || this.inOptionsScreen()) {
                    return this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.inGuiActions, key, true, false);
                }
                if (this.inMinimapPreview() && this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.minimapPreviewActions, key, false, false)) {
                    ((ClientOptionsManager)class_310.method_1551().field_1755).refreshMinimapOptions();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onMouseEvent(int key, class_437 screen, int action) {
        if (JourneymapClient.getInstance().enabled()) {
            if (action == 1) {
                if (this.inFullscreenWithoutChat()) {
                    this.skipMousePress = this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.inGuiActions, key, true, true);
                    return this.skipMousePress;
                }
                if (this.inMinimapPreview()) {
                    if (this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.minimapPreviewActions, key, false, true)) {
                        ((ClientOptionsManager)class_310.method_1551().field_1755).refreshMinimapOptions();
                        this.skipMousePress = true;
                    }
                } else if (screen == null && !this.skipMousePress) {
                    return this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.inGameActions, key, true, true);
                }
            } else if (screen == null) {
                this.skipMousePress = false;
            }
        }
        return false;
    }

    protected boolean onInputEvent(Multimap<Integer, KeyBindingAction> multimap, int key, boolean useContext, boolean mouse) {
        try {
            if (this.sortActionsNeeded) {
                this.sortActions();
            }
            for (KeyBindingAction kba : multimap.get((Object)key)) {
                if (!kba.isActive(key, useContext, mouse ? class_3675.class_307.field_1672 : class_3675.class_307.field_1668) || class_310.method_1551().field_1687 == null || !this.canUseKey()) continue;
                this.logger.debug("Firing " + String.valueOf(kba));
                kba.getAction().run();
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Error checking keybinding", (Object)LogFormatter.toPartialString(e));
        }
        return false;
    }

    protected Fullscreen getFullscreen() {
        return UIManager.INSTANCE.openFullscreenMap();
    }

    protected boolean isInChat() {
        return class_310.method_1551().field_1755 instanceof class_408;
    }

    protected boolean canUseKey() {
        return class_310.method_1551().field_1755 instanceof JmUILegacy | class_310.method_1551().field_1755 instanceof JmUI || class_310.method_1551().field_1755 == null;
    }

    protected boolean emptyScreen() {
        return class_310.method_1551().field_1755 == null;
    }

    protected boolean debugKeyDown() {
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)292);
    }

    protected boolean inFullscreenWithoutChat() {
        return class_310.method_1551().field_1755 instanceof Fullscreen && !((Fullscreen)class_310.method_1551().field_1755).isChatOpen() && !((Fullscreen)class_310.method_1551().field_1755).isSearchFocused();
    }

    protected boolean inFullscreenWithChatOpen() {
        return class_310.method_1551().field_1755 instanceof Fullscreen && ((Fullscreen)class_310.method_1551().field_1755).isChatOpen();
    }

    protected boolean inWaypointManager() {
        WaypointManager manager;
        class_437 class_4372 = class_310.method_1551().field_1755;
        return class_4372 instanceof WaypointManager && !(manager = (WaypointManager)class_4372).isSearchFocused();
    }

    protected boolean inOptionsScreen() {
        return class_310.method_1551().field_1755 instanceof OptionScreen;
    }

    protected boolean inMinimapPreview() {
        return class_310.method_1551().field_1755 instanceof ClientOptionsManager && ((ClientOptionsManager)class_310.method_1551().field_1755).previewMiniMap();
    }

    protected static void toggleWorldWaypoints() {
        BooleanField prop;
        prop.set((prop = JourneymapClient.getInstance().getWaypointProperties().renderWaypointsWorld).get() == false);
    }

    protected static void toggleMapWaypoints() {
        BooleanField prop;
        prop.set((prop = JourneymapClient.getInstance().getWaypointProperties().renderWaypointsMap).get() == false);
    }
}

