/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import earcut4j.Earcut;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.client.data.DataCache;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.Shape;
import journeymap.common.Journeymap;
import net.minecraft.class_1044;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

public class DrawPolygonStep
extends BaseOverlayDrawStep<PolygonOverlay> {
    protected List<Point2D.Double> fillPoints = new ArrayList<Point2D.Double>();
    protected List<List<Point2D.Double>> strokePoints = new ArrayList<List<Point2D.Double>>();
    protected List<Point2D.Double> texturePoints = new ArrayList<Point2D.Double>();
    private class_2960 textureResource;
    private class_1044 texture;
    boolean doRender = true;
    boolean onScreen;

    public DrawPolygonStep(PolygonOverlay polygon) {
        super(polygon);
    }

    public void draw(class_332 graphics, class_4587 poseStack, class_4597.class_4598 buffers, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
            this.onScreen = false;
            return;
        }
        this.onScreen = this.isOnScreen(xOffset, yOffset, renderer, rotation);
        if (this.onScreen && this.doRender) {
            this.ensureTexture();
            DrawUtil.drawPolygon(graphics, poseStack, buffers, xOffset, yOffset, this.fillPoints, this.strokePoints, this.texturePoints, this.texture, ((PolygonOverlay)this.overlay).getShapeProperties());
            if (this.isTextInMinimap(renderer)) {
                this.drawText(poseStack, buffers, xOffset, yOffset, renderer, fontScale, 0.0);
            }
        }
    }

    public void setTextureResource(class_2960 textureResource) {
        this.textureResource = textureResource;
        if (this.texture != null) {
            this.texture.close();
        }
        this.texture = null;
    }

    public class_2960 getTextureResource() {
        return this.textureResource;
    }

    protected void ensureTexture() {
        if (this.textureResource == null || this.texture != null) {
            return;
        }
        try {
            this.texture = TextureCache.getTexture(this.textureResource);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting PolygonOverlay texture: " + String.valueOf(e), (Throwable)e);
        }
    }

    private boolean isTextInMinimap(Renderer renderer) {
        if (renderer.getUIState().ui == Context.UI.Minimap) {
            class_310 mc = class_310.method_1551();
            DisplayVars dv = UIManager.INSTANCE.getMiniMap().getDisplayVars();
            Point2D.Double centerPoint = renderer.getPixel(mc.field_1724.method_23317(), mc.field_1724.method_23321());
            if (centerPoint == null) {
                return false;
            }
            Rectangle2D.Double centerRect = new Rectangle2D.Double(((Point2D)centerPoint).getX() - (double)(dv.getMinimapWidth() / 2.0f), ((Point2D)centerPoint).getY() - (double)(dv.getMinimapHeight() / 2.0f), dv.getMinimapWidth(), dv.getMinimapHeight());
            if (dv.getShape() == Shape.Circle) {
                return centerPoint.distance(this.labelPosition) < (double)(dv.getMinimapWidth() / 2.0f);
            }
            return centerRect.contains(renderer.getWindowPosition(this.labelPosition));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updatePositions(Renderer renderer, double rotation) {
        if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
            return;
        }
        if (Context.UI.Minimap == renderer.getUIState().ui) {
            void var6_8;
            class_243 playerPos = class_310.method_1551().field_1724.method_19538();
            int limit = renderer.getZoom() * (renderer.getGridSize() * 2);
            class_2338 class_23382 = (class_2338)((PolygonOverlay)this.overlay).getOuterArea().getPoints().get(0);
            for (class_2338 point : ((PolygonOverlay)this.overlay).getOuterArea().getPoints()) {
                double distanceToPlayer = point.method_19770((class_2374)playerPos);
                if (!(point.method_10262((class_2382)var6_8) > class_3532.method_33723((double)distanceToPlayer))) continue;
                class_2338 class_23383 = point;
            }
            if (!var6_8.method_19771((class_2382)class_310.method_1551().field_1724.method_24515(), (double)limit)) {
                this.doRender = false;
                return;
            }
        }
        this.doRender = true;
        List<class_2338> points = DataCache.INSTANCE.getTriangulation((PolygonOverlay)this.overlay);
        this.fillPoints.clear();
        this.texturePoints.clear();
        for (class_2338 class_23384 : points) {
            Point2D.Double pixel = renderer.getBlockPixelInGrid(class_23384);
            if (this.fillPoints.isEmpty()) {
                this.screenBounds.setRect(pixel.x, pixel.y, 1.0, 1.0);
            } else {
                this.screenBounds.add(pixel);
            }
            this.fillPoints.add(pixel);
            this.texturePoints.add(new Point2D.Double(class_23384.method_10263(), class_23384.method_10260()));
        }
        boolean needClockwise = ((PolygonOverlay)this.overlay).getShapeProperties().getStrokePosition() != ShapeProperties.StrokePosition.CENTER;
        this.strokePoints.clear();
        this.strokePoints.add(DrawPolygonStep.toScreen(renderer, ((PolygonOverlay)this.overlay).getOuterArea(), needClockwise, false));
        if (((PolygonOverlay)this.overlay).getHoles() != null) {
            for (MapPolygon hole : ((PolygonOverlay)this.overlay).getHoles()) {
                this.strokePoints.add(DrawPolygonStep.toScreen(renderer, hole, needClockwise, true));
            }
        }
        TextProperties textProperties = ((PolygonOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }

    private static List<Point2D.Double> toScreen(@NotNull Renderer renderer, @NotNull MapPolygon polygon, boolean needClockwise, boolean hole) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        if (polygon.getPoints().isEmpty()) {
            return points;
        }
        int direction = 0;
        class_2338 prev = (class_2338)polygon.getPoints().getLast();
        for (class_2338 pos : polygon.getPoints()) {
            points.add(renderer.getBlockPixelInGrid(pos));
            if (!needClockwise) continue;
            direction += (pos.method_10263() + prev.method_10263()) * (pos.method_10260() - prev.method_10260());
            prev = pos;
        }
        if (needClockwise && direction < 0 != hole) {
            Collections.reverse(points);
        }
        return points;
    }

    public static List<MapPolygon> triangulate(@NotNull PolygonOverlay overlay) {
        List holesList = Optional.ofNullable(overlay.getHoles()).orElse(new ArrayList());
        List blockPoints = Stream.concat(overlay.getOuterArea().getPoints().stream(), holesList.stream().flatMap(hole -> hole.getPoints().stream())).collect(Collectors.toList());
        double[] points = new double[blockPoints.size() * 2];
        for (int index = 0; index < blockPoints.size(); ++index) {
            points[index * 2] = ((class_2338)blockPoints.get(index)).method_10263();
            points[index * 2 + 1] = ((class_2338)blockPoints.get(index)).method_10260();
        }
        int[] holes = new int[holesList.size()];
        int holeIndex = overlay.getOuterArea().getPoints().size();
        for (int index = 0; index < holesList.size(); ++index) {
            holes[index] = holeIndex;
            holeIndex += ((MapPolygon)holesList.get(index)).getPoints().size();
        }
        List<Integer> triangles = Earcut.earcut(points, holes, 2);
        ArrayList<MapPolygon> trianglePolys = new ArrayList<MapPolygon>();
        for (int index = 0; index < triangles.size(); index += 3) {
            ArrayList<class_2338> trianglePoints = new ArrayList<class_2338>();
            trianglePoints.add((class_2338)blockPoints.get(triangles.get(index + 2)));
            trianglePoints.add((class_2338)blockPoints.get(triangles.get(index + 1)));
            trianglePoints.add((class_2338)blockPoints.get(triangles.get(index)));
            trianglePolys.add(new MapPolygon(trianglePoints));
        }
        return trianglePolys;
    }

    @Override
    public void draw(class_332 graphics, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
    }

    protected void drawText(class_4587 poseStack, class_4597.class_4598 buffers, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        TextProperties textProperties = ((PolygonOverlay)this.overlay).getTextProperties();
        if (textProperties.isActiveIn(renderer.getUIState())) {
            double y;
            double x;
            if (this.labelPosition != null) {
                if (this.labelLines == null) {
                    this.updateTextFields();
                }
                if (this.labelLines != null) {
                    x = this.labelPosition.x + xOffset;
                    y = this.labelPosition.y + yOffset;
                    DrawPolygonStep.drawLabels(poseStack, buffers, this.labelLines, x, y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, textProperties.getBackgroundColor(), textProperties.getBackgroundOpacity(), textProperties.getColor(), textProperties.getOpacity(), (double)textProperties.getScale() * fontScale, textProperties.hasFontShadow(), rotation);
                }
            }
            if (renderer.getUIState().ui != Context.UI.Minimap && this.titlePosition != null) {
                if (this.titleLines == null) {
                    this.updateTextFields();
                }
                if (this.titleLines != null) {
                    x = this.titlePosition.x + 5.0 + xOffset;
                    y = this.titlePosition.y + yOffset;
                    DrawPolygonStep.drawLabels(poseStack, buffers, this.titleLines, x, y, DrawUtil.HAlign.Right, DrawUtil.VAlign.Above, textProperties.getBackgroundColor(), textProperties.getBackgroundOpacity(), textProperties.getColor(), textProperties.getOpacity(), (double)textProperties.getScale() * fontScale, textProperties.hasFontShadow(), rotation);
                }
            }
        }
    }

    public static void drawLabels(class_4587 poseStack, class_4597.class_4598 buffers, String[] lines, double x, double y, DrawUtil.HAlign hAlign, DrawUtil.VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        if (lines.length == 0) {
            return;
        }
        if (lines.length == 1) {
            if (bgColor != null && bgAlpha > 0.0f) {
                DrawUtil.drawBatchLabel(poseStack, (class_2561)class_2561.method_43470((String)lines[0]), DrawStep.Pass.TextBG, (class_4597)buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            }
            DrawUtil.drawBatchLabel(poseStack, (class_2561)class_2561.method_43470((String)lines[0]), DrawStep.Pass.Text, (class_4597)buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            return;
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        double vpad = fontRenderer.method_1726() ? 0.0 : (fontShadow ? 6.0 : 4.0);
        double hpad = 4.0;
        Objects.requireNonNull(fontRenderer);
        double lineHeight = 9.0 * fontScale;
        double bgHeight = lineHeight * (double)lines.length + vpad;
        double bgWidth = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            for (String line : lines) {
                bgWidth = Math.max(bgWidth, (double)fontRenderer.method_1727(line) * fontScale);
            }
            if (bgWidth % 2.0 == 0.0) {
                bgWidth += 1.0;
            }
        }
        bgWidth += 4.0;
        double rectX = x;
        double rectY = y;
        switch (hAlign) {
            case Left: {
                rectX = x - bgWidth + 2.0;
                break;
            }
            case Center: {
                rectX = (float)(x - (Math.max(1.0, bgWidth) / 2.0 + fontScale) + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case Right: {
                rectX = x - 2.0 - 0.5;
            }
        }
        switch (vAlign) {
            case Above: {
                rectY = (y -= lineHeight * (double)lines.length) - bgHeight / 2.0 - vpad / 2.0;
                break;
            }
            case Middle: {
                rectY = (y -= bgHeight / 2.0) - vpad / 2.0 - 5.0 * fontScale;
                break;
            }
            case Below: {
                rectY = y;
            }
        }
        if (bgColor != null && bgAlpha > 0.0f) {
            class_4588 vertexBuilder = buffers.getBuffer(JMRenderTypes.RECTANGLE_RENDER_TYPE);
            DrawUtil.drawRectangle(poseStack, vertexBuilder, rectX, rectY, bgWidth, bgHeight, bgColor, bgAlpha);
        }
        for (String line : lines) {
            DrawUtil.drawBatchLabel(poseStack, (class_2561)class_2561.method_43470((String)line), DrawStep.Pass.Text, (class_4597)buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            y += lineHeight;
        }
    }

    public static class SimpleCacheLoader
    extends CacheLoader<PolygonOverlay, DrawPolygonStep> {
        public DrawPolygonStep load(PolygonOverlay overlay) throws Exception {
            return new DrawPolygonStep(overlay);
        }
    }

    public static class TriangulationCacheLoader
    extends CacheLoader<PolygonOverlay, List<class_2338>> {
        public List<class_2338> load(PolygonOverlay overlay) throws Exception {
            return DrawPolygonStep.triangulate(overlay).stream().flatMap(poly -> poly.getPoints().stream()).collect(Collectors.toList());
        }
    }
}

