/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.log.JMLogger;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.RenderWrapper;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.RegionMipmapGenerator;
import journeymap.client.texture.gl.GlRegionTexture;
import journeymap.common.Journeymap;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_10868;
import net.minecraft.class_1923;

public class RegionTexture
extends class_1044 {
    protected final ReentrantLock bufferLock = new ReentrantLock();
    protected Set<class_1923> dirtyChunks = new HashSet<class_1923>();
    protected List<WeakReference<Listener<RegionTexture>>> listeners = new ArrayList<WeakReference<Listener<RegionTexture>>>(0);
    protected long lastImageUpdate;
    protected String description;
    protected boolean bindNeeded;
    protected long lastBound;
    protected class_1011 image;
    protected class_1011[] mipmaps;
    protected int width;
    protected int height;
    protected int textureId = -1;
    protected final int mipmapLevels;

    public RegionTexture(class_1011 pixels, String description) {
        this.mipmapLevels = JourneymapClient.getInstance().getCoreProperties().mipmapLevels.get();
        this.setNativeImage(pixels, true);
        this.description = description;
        this.mipmaps = RegionMipmapGenerator.generateMipmaps(this.image, this.mipmapLevels);
    }

    public void bind() {
        this.bindRegionTexture();
    }

    public void bindRegionTexture() {
        if (this.bindNeeded && RenderSystem.isOnRenderThread()) {
            if (this.bufferLock.tryLock()) {
                try {
                    int err;
                    if (this.field_56974 == null) {
                        this.field_56974 = GlRegionTexture.createTexture(this.description, 5, TextureFormat.RGBA8, this.image.method_4307(), this.image.method_4323(), 1, this.mipmapLevels + 1);
                        this.field_60597 = RenderSystem.getDevice().createTextureView(this.field_56974, 0, this.mipmapLevels + 1);
                    }
                    this.field_56974.setAddressMode(AddressMode.CLAMP_TO_EDGE);
                    this.textureId = ((class_10868)this.field_56974).method_68427();
                    if (this.lastBound == 0L || this.dirtyChunks.isEmpty()) {
                        if (this.mipmaps == null) {
                            this.mipmaps = RegionMipmapGenerator.generateMipmaps(this.image, this.mipmapLevels);
                        }
                        for (int i = 0; i <= this.mipmapLevels; ++i) {
                            if (this.image == null || this.image.field_4988 == 0L || this.id() == -1) continue;
                            this.method_4527(false, true);
                            RenderSystem.getDevice().createCommandEncoder().writeToTexture(this.field_56974, this.mipmaps[i], i, 0, 0, 0, this.mipmaps[i].method_4307(), this.mipmaps[i].method_4323(), 0, 0);
                        }
                        this.bindNeeded = false;
                        this.lastBound = System.currentTimeMillis();
                        return;
                    }
                    this.uploadDirtyChunks();
                    while ((err = RenderWrapper.getError()) != 0) {
                        JMLogger.logOnce("GL Error in RegionTexture after upload: " + err + " in " + String.valueOf((Object)this));
                    }
                    this.dirtyChunks.clear();
                    this.lastBound = System.currentTimeMillis();
                    this.bindNeeded = false;
                }
                catch (Throwable t) {
                    Journeymap.getLogger().warn("Can't bind texture: ", t);
                }
                finally {
                    this.bufferLock.unlock();
                }
            }
        } else if (!RenderSystem.isOnRenderThread()) {
            JMLogger.logOnce("Attempted to bind off renderthread: " + this.description);
        }
    }

    private void uploadDirtyChunks() {
        for (class_1923 pos : this.dirtyChunks) {
            class_1011 chunkImage = ImageUtil.getSubImage(pos.field_9181, pos.field_9180, 16, 16, this.image, false);
            try {
                if (chunkImage.field_4988 == 0L || this.field_56974 == null) continue;
                chunkImage.method_47594(this.image, 0, 0, pos.field_9181, pos.field_9180, 16, 16, false, false);
                this.method_4527(false, true);
                RenderSystem.getDevice().createCommandEncoder().writeToTexture(this.field_56974, chunkImage, 0, 0, pos.field_9181, pos.field_9180, 16, 16, 0, 0);
            }
            finally {
                if (chunkImage == null) continue;
                chunkImage.close();
            }
        }
        if (this.field_56974 != null) {
            RegionMipmapGenerator.updateMipmapsAndUpload(this.mipmaps, this.dirtyChunks, this.field_56974);
        }
    }

    public long getLastImageUpdate() {
        return this.lastImageUpdate;
    }

    public boolean isBound() {
        return this.field_56974 != null && this.id() != -1;
    }

    public int id() {
        return this.textureId;
    }

    public boolean isDefunct() {
        return this.image == null && this.id() == -1 || this.image != null && this.image.field_4988 == 0L;
    }

    public void setNativeImage(class_1011 image, boolean retainImage) {
        if (image == null) {
            return;
        }
        this.handleImage(image, retainImage);
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    public Integer getRGB(int x, int y) {
        int rgba = this.image.method_61940(x, y);
        return RGB.rgbaToRgb(rgba);
    }

    public void setNativeImage(class_1011 image, boolean retainImage, HashSet<class_1923> updatedChunks) {
        if (image == null) {
            return;
        }
        this.handleImage(image, retainImage);
        this.dirtyChunks.addAll(updatedChunks);
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    private void handleImage(class_1011 image, boolean retainImage) {
        this.bindNeeded = true;
        try {
            this.bufferLock.lock();
            this.width = image.method_4307();
            this.height = image.method_4323();
            if (retainImage) {
                if (this.image == null) {
                    this.image = image;
                } else if (image.field_4988 != this.image.field_4988) {
                    this.image.method_4317(image);
                }
            }
            if (image.field_4988 != this.image.field_4988) {
                this.clearMipmaps();
                image.close();
            }
        }
        finally {
            this.bufferLock.unlock();
        }
    }

    public void addListener(Listener<RegionTexture> addedListener) {
        Iterator<WeakReference<Listener<RegionTexture>>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener<RegionTexture>> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            if (addedListener != listener) continue;
            return;
        }
        this.listeners.add(new WeakReference<Listener<RegionTexture>>(addedListener));
    }

    public void removeListener(Listener<RegionTexture> listener) {
        Iterator<WeakReference<Listener<RegionTexture>>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener<RegionTexture>> ref = iter.next();
            Listener nextListener = (Listener)ref.get();
            if (nextListener != listener) continue;
            iter.remove();
        }
    }

    protected void notifyListeners() {
        Iterator<WeakReference<Listener<RegionTexture>>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener<RegionTexture>> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            listener.textureImageUpdated(this);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("glid", this.id()).add("description", (Object)this.description).add("lastImageUpdate", this.lastImageUpdate).toString();
    }

    public boolean bindNeeded() {
        return this.bindNeeded;
    }

    public int getWidth() {
        return this.image.method_4307();
    }

    public int getHeight() {
        return this.image.method_4323();
    }

    public boolean hasImage() {
        return this.image != null && this.image.field_4988 > 0L;
    }

    private void clearMipmaps() {
        if (this.mipmaps != null) {
            for (int i = 0; i < this.mipmaps.length; ++i) {
                if (this.mipmaps[i] == null) continue;
                this.mipmaps[i].close();
                this.mipmaps[i] = null;
            }
            this.mipmaps = null;
        }
    }

    public void close() {
        this.listeners.forEach(Reference::clear);
        if (this.image != null) {
            this.image.close();
        }
        if (this.field_56974 != null) {
            JMRenderTypes.clearRegionRenderTypes(((class_10868)this.field_56974).method_68427());
            this.field_56974.close();
            this.field_56974 = null;
        }
        if (this.field_60597 != null) {
            this.field_60597.close();
            this.field_60597 = null;
        }
        this.bindNeeded = false;
        this.lastImageUpdate = 0L;
        this.lastBound = 0L;
        this.clearMipmaps();
        this.image = null;
        this.textureId = -1;
    }

    public class_1011 getNativeImage() {
        return this.image;
    }

    public GpuTextureView method_71659() {
        return this.field_60597 != null ? this.field_60597 : null;
    }

    public static interface Listener<T extends class_1044> {
        public void textureImageUpdated(T var1);
    }
}

