/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.List;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8027;
import net.minecraft.class_8028;

public class ScrollListPane<T extends Slot>
extends class_4280<Slot<T>> {
    public SlotMetadata lastTooltipMetadata;
    public List<class_5481> lastTooltip;
    public long lastTooltipTime;
    public long hoverDelay = 400L;
    protected int hpad = 12;
    private List<T> rootSlots;
    private SlotMetadata lastPressed;
    protected int lastClickedIndex;
    protected int scrollbarX;
    protected int listWidth;
    private boolean alignTop;

    public ScrollListPane(class_310 mc, int x, int y, int width, int height, int slotHeight) {
        super(mc, y, width, height, slotHeight);
        this.updateSize(width, height, x, y);
    }

    public void updateSize(int width, int height, int x, int y) {
        super.method_55444(width, height, x, y);
        this.scrollbarX = this.field_22758 - this.hpad;
        this.listWidth = this.field_22758 - this.hpad * 4;
    }

    public void setListWidth(int width) {
        this.scrollbarX = (this.field_22758 + width) / 2 - this.hpad;
        this.listWidth = width - this.hpad * 4;
    }

    public void setSlots(List<T> slots) {
        this.rootSlots = slots;
        this.updateSlots();
    }

    public List<T> getRootSlots() {
        return this.rootSlots;
    }

    public void updateSlots() {
        int sizeBefore = this.method_25340();
        this.method_25396().clear();
        int columnWidth = 0;
        for (Slot slot : this.rootSlots) {
            columnWidth = Math.max(columnWidth, slot.getColumnWidth());
            super.method_25321((class_350.class_351)slot);
            List childSlots = slot.getChildSlots(this.listWidth, columnWidth);
            if (childSlots == null || childSlots.isEmpty()) continue;
            for (Slot child : childSlots) {
                super.method_25321(child);
            }
        }
        int sizeAfter = this.method_25340();
        if (sizeBefore < sizeAfter) {
            this.method_25309(-(sizeAfter * this.getItemHeight()));
            this.method_25309(this.lastClickedIndex * this.getItemHeight());
        }
    }

    public void scrollTo(Slot slot) {
        this.method_25309(-(this.method_25396().size() * this.field_22741));
        this.method_25309(this.method_25396().indexOf((Object)slot) * this.field_22741);
    }

    public boolean method_25332(int index) {
        return super.method_25332(index);
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_4587 pose = new class_4587();
        try {
            Slot slot = (Slot)this.method_25308(mouseX, mouseY);
            if (slot != null) {
                SlotMetadata tooltipMetadata = slot.getCurrentTooltip(mouseX, mouseY);
                if (tooltipMetadata != null && !tooltipMetadata.getTooltip().equals(this.lastTooltip)) {
                    this.lastTooltipMetadata = tooltipMetadata;
                    this.lastTooltip = tooltipMetadata.getTooltip();
                    this.lastTooltipTime = System.currentTimeMillis();
                }
                if (tooltipMetadata == null) {
                    this.lastTooltip = null;
                    this.lastTooltipMetadata = null;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.renderBackground(graphics, pose, mouseX, mouseY, partialTicks);
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
    }

    protected void method_57713(class_332 graphics) {
    }

    protected void method_49603(class_332 graphics) {
        super.method_49603(graphics);
    }

    protected void method_57715(class_332 graphics) {
    }

    public void method_25311(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25311(graphics, mouseX, mouseY, partialTicks);
    }

    public int method_25322() {
        return this.listWidth;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clicked = false;
        if (this.method_25405(mouseX, mouseY)) {
            clicked = super.method_25402(mouseX, mouseY, button);
            Slot slot = (Slot)this.method_25308(mouseX, mouseY);
            if (slot == null) {
                return clicked;
            }
            this.lastClickedIndex = this.method_25396().indexOf((Object)slot);
            this.lastPressed = slot.getLastPressed();
            if (slot instanceof CategorySlot) {
                this.updateSlots();
            }
        }
        return clicked;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        for (int slotIndex = 0; slotIndex < this.method_25340(); ++slotIndex) {
            Slot slot;
            if (slotIndex != this.lastClickedIndex || !(slot = this.getSlot(this.lastClickedIndex)).method_25406(mouseX, mouseY, mouseButton)) continue;
            this.lastPressed = null;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.method_25396().isEmpty()) {
            return false;
        }
        if (this.lastClickedIndex > -1 && this.getSlot(this.lastClickedIndex) != null && this.getSlot(this.lastClickedIndex).method_25403(mouseX, mouseY, button, mouseDX, mouseDY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public class_8016 method_48205(class_8023 focusNavigationEvent) {
        if (this.method_25340() == 0) {
            return null;
        }
        if (focusNavigationEvent instanceof class_8023.class_8024) {
            class_8016 path;
            class_8023.class_8024 arrowNavigation = (class_8023.class_8024)focusNavigationEvent;
            Slot focused = (Slot)this.method_25336();
            if (arrowNavigation.comp_1191().method_48237() == class_8027.field_41822 && focused != null) {
                return class_8016.method_48192((class_4069)this, (class_8016)focused.method_48205(focusNavigationEvent));
            }
            int index = -1;
            class_8028 direction = arrowNavigation.comp_1191();
            if (this.method_25370() && focused != null) {
                index = focused.method_25396().indexOf(focused.method_25399());
            }
            if (index == -1) {
                switch (direction) {
                    case field_41828: {
                        index = Integer.MAX_VALUE;
                        direction = class_8028.field_41827;
                        break;
                    }
                    case field_41829: {
                        index = 0;
                        direction = class_8028.field_41827;
                        break;
                    }
                    default: {
                        index = 0;
                    }
                }
            }
            do {
                if ((focused = (Slot)this.method_48199(direction, s -> true, (class_350.class_351)focused)) != null) continue;
                return null;
            } while ((path = focused.method_25396().isEmpty() ? class_8016.method_48193((class_364)focused) : focused.focusPathAtIndex((class_8023)arrowNavigation, index)) == null);
            return class_8016.method_48192((class_4069)this, (class_8016)path);
        }
        if (!this.method_25370() && focusNavigationEvent instanceof class_8023.class_8026) {
            class_8023.class_8026 tabNavigation = (class_8023.class_8026)focusNavigationEvent;
            Slot selected = (Slot)this.method_25334();
            if (selected == null) {
                selected = this.getSlot(0);
            }
            class_8016 path = selected.method_25396().isEmpty() ? class_8016.method_48193((class_364)selected) : selected.focusPathAtIndex((class_8023)tabNavigation, 0);
            return class_8016.method_48192((class_4069)this, (class_8016)path);
        }
        return null;
    }

    public Slot getSlot(int index) {
        if (super.method_25340() > index) {
            return (Slot)((Object)this.method_25396().get(index));
        }
        return null;
    }

    public SlotMetadata getLastPressed() {
        return this.lastPressed;
    }

    public void resetLastPressed() {
        this.lastPressed = null;
    }

    public Slot getLastPressedParentSlot() {
        if (this.lastPressed != null) {
            for (Slot slot : this.rootSlots) {
                if (!slot.contains(this.lastPressed)) continue;
                return slot;
            }
        }
        return null;
    }

    public boolean method_25400(char typedChar, int keyCode) {
        for (int slotIndex = 0; slotIndex < this.method_25340(); ++slotIndex) {
            if (slotIndex != this.lastClickedIndex) continue;
            return this.getSlot(this.lastClickedIndex).method_25400(typedChar, keyCode);
        }
        return false;
    }

    public boolean method_25404(int key, int value, int modifier) {
        if (this.method_25334() != null) {
            return ((Slot)this.method_25334()).method_25404(key, value, modifier);
        }
        return false;
    }

    protected int method_65507() {
        return this.scrollbarX;
    }

    protected void renderBackground(class_332 graphics, class_4587 poseStack, int i, int j, float f) {
        graphics.method_25296(0, this.method_46427(), this.field_22758, this.field_22759 + this.method_46427(), -1072689136, -804253680);
    }

    protected int method_44395() {
        int contentHeight = super.method_44395();
        if (this.alignTop) {
            contentHeight = Math.max(this.method_55443() - this.getTop() - 4, contentHeight);
        }
        return contentHeight;
    }

    public int getTop() {
        return super.method_46427();
    }

    public int method_25364() {
        return this.field_22759;
    }

    public void setAlignTop(boolean alignTop) {
        this.alignTop = alignTop;
    }

    public int getItemHeight() {
        return this.field_22741;
    }

    public void method_47399(class_6382 narrationElementOutput) {
    }
}

