/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.Litematica;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CachedItemTags {
    private static final CachedItemTags INSTANCE = new CachedItemTags();
    private final HashMap<String, Entry> entries = new HashMap();

    public static CachedItemTags getInstance() {
        return INSTANCE;
    }

    private CachedItemTags() {
    }

    public void build(String name, @Nonnull List<String> list) {
        if (name.isEmpty()) {
            Litematica.LOGGER.error("CachedItemTags#build: Invalid list name.");
            return;
        }
        if (list.isEmpty()) {
            Litematica.LOGGER.warn("CachedItemTags#build: list '{}' is empty.", (Object)name);
            return;
        }
        Entry entry = new Entry(list);
        Entry oldEntry = this.entries.put(name, entry);
        if (oldEntry != null) {
            oldEntry.clear();
        }
    }

    @Nullable
    public Entry get(String name) {
        if (this.entries.containsKey(name)) {
            return this.entries.get(name);
        }
        return null;
    }

    public void clear() {
        this.entries.forEach((name, entry) -> entry.clear());
    }

    public List<String> matchAny(class_1792 item) {
        ArrayList<String> list = new ArrayList<String>();
        this.entries.forEach((name, entry) -> {
            if (entry.contains(item)) {
                list.add((String)name);
            }
        });
        return list;
    }

    public List<String> matchAny(class_6880<class_1792> item) {
        ArrayList<String> list = new ArrayList<String>();
        this.entries.forEach((name, entry) -> {
            if (entry.contains(item)) {
                list.add((String)name);
            }
        });
        return list;
    }

    public boolean match(String name, class_1792 item) {
        Entry entry = this.get(name);
        if (entry != null) {
            return entry.contains(item);
        }
        Litematica.LOGGER.warn("CachedItemTags#match(Item): Invalid tag list '{}'", (Object)name);
        return false;
    }

    public boolean match(String name, class_6880<class_1792> item) {
        Entry entry = this.get(name);
        if (entry != null) {
            return entry.contains(item);
        }
        Litematica.LOGGER.warn("CachedItemTags#match(RegistryEntry): Invalid tag list '{}'", (Object)name);
        return false;
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        this.entries.forEach((name, entry) -> obj.add(name, entry.toJson()));
        return obj;
    }

    public void fromJson(JsonObject obj) {
        this.entries.clear();
        for (String key : obj.keySet()) {
            Entry entry;
            if (!obj.isJsonArray() || (entry = Entry.fromJson(obj.get(key))) == null) continue;
            this.entries.put(key, entry);
        }
    }

    public static class Entry {
        private final HashSet<class_6880<class_1792>> items = new HashSet();
        private final HashSet<class_6885<class_1792>> tags = new HashSet();

        public Entry() {
        }

        public Entry(List<String> list) {
            this();
            this.insertFromList(list);
        }

        public void insertItem(class_1792 item) {
            this.items.add((class_6880<class_1792>)class_7923.field_41178.method_47983((Object)item));
        }

        public void insertItem(class_6880<class_1792> item) {
            this.items.add(item);
        }

        public void insertTag(class_6862<class_1792> tag) {
            if (class_310.method_1551().field_1687 != null) {
                class_2378 wrapper = class_310.method_1551().field_1687.method_30349().method_30530(class_7923.field_41178.method_46765());
                wrapper.method_46733(tag).ifPresent(this.tags::add);
            }
        }

        public void insertFromString(String entry) {
            if (entry.startsWith("#")) {
                class_2960 id = class_2960.method_12829((String)entry.substring(1));
                if (id != null) {
                    class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id);
                    if (tag != null) {
                        this.insertTag((class_6862<class_1792>)tag);
                    } else {
                        Litematica.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block tag '{}'", (Object)entry);
                    }
                } else {
                    Litematica.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block tag id '{}'", (Object)entry);
                }
            } else {
                class_2960 id = class_2960.method_12829((String)entry);
                if (id != null) {
                    class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
                    if (item != null) {
                        this.insertItem(item);
                    } else {
                        Litematica.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block '{}'", (Object)entry);
                    }
                } else {
                    Litematica.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block id '{}'", (Object)entry);
                }
            }
        }

        public void insertFromList(List<String> list) {
            if (list.isEmpty()) {
                Litematica.LOGGER.warn("CachedItemTags.Entry#insertFromList: List is empty.");
                return;
            }
            for (String entry : list) {
                this.insertFromString(entry);
            }
        }

        public boolean contains(class_1792 item) {
            class_6880 entry = class_7923.field_41178.method_47983((Object)item);
            for (class_6885<class_1792> listEntry : this.tags) {
                if (!listEntry.method_40241(entry)) continue;
                return true;
            }
            return this.items.contains(entry);
        }

        public boolean contains(class_6880<class_1792> item) {
            return this.contains((class_1792)item.comp_349());
        }

        public List<String> toList() {
            ArrayList<String> list = new ArrayList<String>();
            this.items.forEach(entry -> list.add(entry.method_55840()));
            this.tags.forEach(entry -> list.add("#" + entry.method_45925().toString()));
            return list;
        }

        public JsonElement toJson() {
            JsonArray arr = new JsonArray();
            this.items.forEach(entry -> arr.add((JsonElement)new JsonPrimitive(entry.method_55840())));
            this.tags.forEach(entry -> arr.add((JsonElement)new JsonPrimitive("#" + entry.method_45925().toString())));
            return arr;
        }

        @Nullable
        public static Entry fromJson(JsonElement element) {
            if (element.isJsonArray()) {
                JsonArray arr = element.getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < arr.size(); ++i) {
                    list.add(arr.get(i).getAsString());
                }
                Entry entry = new Entry();
                entry.insertFromList(list);
                return entry;
            }
            return null;
        }

        public void clear() {
            this.items.clear();
            this.tags.clear();
        }
    }
}

