/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.util;

import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3x2f;
import org.joml.Vector3f;

@ApiStatus.Experimental
public class MatrixUtils {
    public static Matrix3x2f inverse(Matrix3x2f matrix) {
        float m00 = matrix.m00;
        float m01 = matrix.m01;
        float m10 = matrix.m10;
        float m11 = matrix.m11;
        float m20 = matrix.m20;
        float m21 = matrix.m21;
        float det = m00 * m11 - m10 * m01;
        if (Math.abs(det) < 1.0E-5f) {
            System.err.println("Warning: Matrix is singular (determinant near zero), cannot be accurately inverted.");
            return null;
        }
        float invDet = 1.0f / det;
        float invM00 = m11 * invDet;
        float invM01 = -m01 * invDet;
        float invM10 = -m10 * invDet;
        float invM11 = m00 * invDet;
        float invM20 = -(invM00 * m20 + invM10 * m21);
        float invM21 = -(invM01 * m20 + invM11 * m21);
        return new Matrix3x2f(invM00, invM01, invM10, invM11, invM20, invM21);
    }

    public static Rectangle transform(Matrix3x2f matrix, Rectangle rectangle) {
        Vector3f vec1 = new Vector3f((float)rectangle.x, (float)rectangle.y, 1.0f);
        matrix.transform(vec1);
        Vector3f vec2 = new Vector3f((float)rectangle.getMaxX(), (float)rectangle.getMaxY(), 1.0f);
        matrix.transform(vec2);
        int x1 = Math.round(vec1.x());
        int x2 = Math.round(vec2.x());
        int y1 = Math.round(vec1.y());
        int y2 = Math.round(vec2.y());
        return new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
    }

    public static Point transform(Matrix3x2f matrix, Point point) {
        Vector3f mouse = new Vector3f((float)point.x, (float)point.y, 1.0f);
        matrix.transform(mouse);
        return new Point((double)mouse.x(), (double)mouse.y());
    }
}

