/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import java.util.List;
import java.util.function.Predicate;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.ItemRecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.impl.common.transfer.InputSlotCrafter;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;

public class NewInputSlotCrafter<T extends class_1703, C extends class_1263>
extends InputSlotCrafter<T, C> {
    protected final List<SlotAccessor> inputSlots;
    protected final List<SlotAccessor> inventorySlots;
    protected final List<InputIngredient<class_1799>> inputs;

    public NewInputSlotCrafter(T container, List<SlotAccessor> inputSlots, List<SlotAccessor> inventorySlots, List<InputIngredient<class_1799>> inputs) {
        super(container);
        this.inputSlots = inputSlots;
        this.inventorySlots = inventorySlots;
        this.inputs = inputs;
    }

    @Override
    protected Iterable<SlotAccessor> getInputSlots() {
        return this.inputSlots;
    }

    @Override
    protected Iterable<SlotAccessor> getInventorySlots() {
        return this.inventorySlots;
    }

    @Override
    protected List<InputIngredient<class_1799>> getInputs() {
        return this.inputs;
    }

    @Override
    protected void populateRecipeFinder(ItemRecipeFinder recipeFinder) {
        for (SlotAccessor slot : this.getInventorySlots()) {
            recipeFinder.addNormalItem(slot.getItemStack());
        }
    }

    @Override
    protected void markDirty() {
        this.player.method_31548().method_5431();
        this.container.method_34252();
    }

    @Override
    protected void cleanInputs() {
        for (SlotAccessor slot : this.getInputSlots()) {
            class_1799 stackToReturn = slot.getItemStack();
            if (!slot.allowModification((class_1657)this.player)) {
                throw new IllegalStateException("Slot " + String.valueOf(slot) + " is not modifiable!");
            }
            if (stackToReturn.method_7960()) continue;
            while (!(stackToReturn = slot.getItemStack()).method_7960()) {
                class_1799 stackToInsert = stackToReturn.method_7972();
                stackToInsert.method_7939(1);
                if (!this.getDumpHandler().test(stackToInsert)) {
                    throw new IllegalStateException("rei.rei.no.slot.in.inv");
                }
                slot.takeStack(1);
            }
        }
    }

    private Predicate<class_1799> getDumpHandler() {
        return stackToDump -> {
            SlotAccessor nextSlot;
            Iterable<SlotAccessor> inventoryStacks = this.getInventorySlots();
            SlotAccessor occupiedSlotWithRoomForStack = NewInputSlotCrafter.getOccupiedSlotWithRoomForStack(stackToDump, inventoryStacks);
            SlotAccessor emptySlot = NewInputSlotCrafter.getEmptySlot(inventoryStacks);
            SlotAccessor slotAccessor = nextSlot = occupiedSlotWithRoomForStack == null ? emptySlot : occupiedSlotWithRoomForStack;
            if (nextSlot == null) {
                return false;
            }
            class_1799 stack = stackToDump.method_7972();
            stack.method_7939(nextSlot.getItemStack().method_7947() + stack.method_7947());
            nextSlot.setItemStack(stack);
            return true;
        };
    }

    static SlotAccessor getOccupiedSlotWithRoomForStack(class_1799 stack, Iterable<SlotAccessor> inventoryStacks) {
        for (SlotAccessor inventoryStack : inventoryStacks) {
            if (!NewInputSlotCrafter.canStackAddMore(inventoryStack.getItemStack(), stack)) continue;
            return inventoryStack;
        }
        return null;
    }

    static SlotAccessor getEmptySlot(Iterable<SlotAccessor> inventoryStacks) {
        for (SlotAccessor inventoryStack : inventoryStacks) {
            if (!inventoryStack.getItemStack().method_7960()) continue;
            return inventoryStack;
        }
        return null;
    }

    static boolean canStackAddMore(class_1799 existingStack, class_1799 stack) {
        return !existingStack.method_7960() && class_1799.method_31577((class_1799)existingStack, (class_1799)stack) && existingStack.method_7946() && existingStack.method_7947() + stack.method_7947() <= existingStack.method_7914();
    }
}

