/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.ServerApi;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IPluginPacketSender;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModChecker;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.distanthorizons.neoforge.NeoforgeClientProxy;
import com.seibel.distanthorizons.neoforge.NeoforgePluginPacketSender;
import com.seibel.distanthorizons.neoforge.NeoforgeServerProxy;
import com.seibel.distanthorizons.neoforge.wrappers.modAccessor.ModChecker;
import com.seibel.distanthorizons.neoforge.wrappers.modAccessor.OptifineAccessor;
import java.util.function.Consumer;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.AbstractModInitializer;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.GetConfigScreen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@Mod(value="distanthorizons")
public class NeoforgeMain
extends AbstractModInitializer {
    public NeoforgeMain(IEventBus eventBus) {
        eventBus.addListener(e -> {
            this.onInitializeClient();
            eventBus.addListener(this::registerNetworkingClientServer);
            eventBus.addListener(this::registerClientPayloadEvent);
        });
        eventBus.addListener(e -> {
            this.onInitializeServer();
            eventBus.addListener(this::registerNetworkingServer);
        });
    }

    public void registerNetworkingClientServer(RegisterPayloadHandlersEvent event) {
        NeoforgePluginPacketSender.setPacketHandler(event, (player, message) -> {
            ClientApi.INSTANCE.pluginMessageReceived((AbstractNetworkMessage)message);
            ServerApi.INSTANCE.pluginMessageReceived((IServerPlayerWrapper)player, (AbstractNetworkMessage)message);
        });
    }

    public void registerNetworkingServer(RegisterPayloadHandlersEvent event) {
        NeoforgePluginPacketSender.setPacketHandler(event, ServerApi.INSTANCE::pluginMessageReceived);
    }

    public void registerClientPayloadEvent(RegisterClientPayloadHandlersEvent event) {
        NeoforgePluginPacketSender.registerClientPacketHandler(event);
    }

    @Override
    protected AbstractModInitializer.IEventProxy createServerProxy(boolean isDedicated) {
        return new NeoforgeServerProxy(isDedicated);
    }

    @Override
    protected void createInitialBindings() {
        SingletonInjector.INSTANCE.bind(IModChecker.class, ModChecker.INSTANCE);
        SingletonInjector.INSTANCE.bind(IPluginPacketSender.class, new NeoforgePluginPacketSender());
    }

    @Override
    protected AbstractModInitializer.IEventProxy createClientProxy() {
        return new NeoforgeClientProxy();
    }

    @Override
    protected void initializeModCompat() {
        this.tryCreateModCompatAccessor("optifine", IOptifineAccessor.class, OptifineAccessor::new);
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> GetConfigScreen.getScreen(parent));
    }

    @Override
    protected void subscribeRegisterCommandsEvent(Consumer<CommandDispatcher<CommandSourceStack>> eventHandler) {
        NeoForge.EVENT_BUS.addListener(e -> eventHandler.accept(e.getDispatcher()));
    }

    @Override
    protected void subscribeClientStartedEvent(Runnable eventHandler) {
        eventHandler.run();
    }

    @Override
    protected void subscribeServerStartingEvent(Consumer<MinecraftServer> eventHandler) {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, e -> eventHandler.accept(e.getServer()));
    }

    @Override
    protected void runDelayedSetup() {
        SingletonInjector.INSTANCE.runDelayedSetup();
    }
}

