/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block;

import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeWrapper
implements IBiomeWrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ConcurrentMap<Holder<Biome>, BiomeWrapper> WRAPPER_BY_BIOME = new ConcurrentHashMap<Holder<Biome>, BiomeWrapper>();
    public static final ConcurrentHashMap<String, BiomeWrapper> WRAPPER_BY_RESOURCE_LOCATION = new ConcurrentHashMap();
    public static final String EMPTY_BIOME_STRING = "EMPTY";
    public static final BiomeWrapper EMPTY_WRAPPER = new BiomeWrapper(null, null);
    public static final String PLAINS_RESOURCE_LOCATION_STRING = "minecraft:plains";
    private static final HashSet<String> brokenResourceLocationStrings = new HashSet();
    private static boolean emptyStringWarningLogged = false;
    private static boolean emptyLevelSerializeFailLogged = false;
    public final Holder<Biome> biome;
    private String serialString;
    private final int hashCode;

    public static IBiomeWrapper getBiomeWrapper(Holder<Biome> biome, ILevelWrapper levelWrapper) {
        if (biome == null) {
            return EMPTY_WRAPPER;
        }
        if (WRAPPER_BY_BIOME.containsKey(biome)) {
            return (IBiomeWrapper)WRAPPER_BY_BIOME.get(biome);
        }
        BiomeWrapper newWrapper = new BiomeWrapper(biome, levelWrapper);
        WRAPPER_BY_BIOME.put(biome, newWrapper);
        return newWrapper;
    }

    private BiomeWrapper(Holder<Biome> biome, ILevelWrapper levelWrapper) {
        this.biome = biome;
        this.serialString = this.serialize(levelWrapper);
        this.hashCode = Objects.hash(this.serialString);
    }

    @Override
    public String getName() {
        if (this == EMPTY_WRAPPER) {
            return EMPTY_BIOME_STRING;
        }
        return this.biome.unwrapKey().orElse(Biomes.THE_VOID).registry().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BiomeWrapper that = (BiomeWrapper)obj;
        return Objects.equals(this.getSerialString(), that.getSerialString());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getSerialString() {
        return this.serialString;
    }

    @Override
    public Object getWrappedMcObject() {
        return this.biome;
    }

    public String toString() {
        return this.getSerialString();
    }

    public String serialize(ILevelWrapper levelWrapper) {
        if (this.biome == null) {
            return EMPTY_BIOME_STRING;
        }
        if (levelWrapper == null) {
            if (!emptyLevelSerializeFailLogged) {
                emptyLevelSerializeFailLogged = true;
                LOGGER.warn("Unable to serialize biome: [" + String.valueOf(this.biome) + "] because the passed in level wrapper is null. Future errors of this type won't be logged.");
            }
            return EMPTY_BIOME_STRING;
        }
        Level level = (Level)levelWrapper.getWrappedMcObject();
        RegistryAccess registryAccess = level.registryAccess();
        ResourceLocation resourceLocation = registryAccess.lookupOrThrow(Registries.BIOME).getKey((Object)((Biome)this.biome.value()));
        if (resourceLocation == null) {
            String biomeName = ((Biome)this.biome.value()).toString();
            LOGGER.warn("unable to serialize: " + biomeName);
            this.serialString = "";
        } else {
            this.serialString = resourceLocation.getNamespace() + ":" + resourceLocation.getPath();
        }
        return this.serialString;
    }

    public static IBiomeWrapper deserialize(String resourceLocationString, ILevelWrapper levelWrapper) throws IOException {
        String finalResourceStateString = resourceLocationString;
        if (resourceLocationString.equals(EMPTY_BIOME_STRING)) {
            if (!emptyStringWarningLogged) {
                emptyStringWarningLogged = true;
                LOGGER.warn("[EMPTY] biome string deserialized. This may mean the level was null when a save was attempted, a file saving error, or a biome saving error. Future errors will not be logged.");
            }
            return EMPTY_WRAPPER;
        }
        if (resourceLocationString.trim().isEmpty() || resourceLocationString.equals("")) {
            LOGGER.warn("Null biome string deserialized.");
            return EMPTY_WRAPPER;
        }
        if (WRAPPER_BY_RESOURCE_LOCATION.containsKey(finalResourceStateString)) {
            return WRAPPER_BY_RESOURCE_LOCATION.get(finalResourceStateString);
        }
        BiomeWrapper foundWrapper = EMPTY_WRAPPER;
        try {
            Level level = (Level)levelWrapper.getWrappedMcObject();
            RegistryAccess registryAccess = level.registryAccess();
            BiomeDeserializeResult deserializeResult = BiomeWrapper.deserializeBiome(resourceLocationString, registryAccess);
            if (!deserializeResult.success) {
                if (!brokenResourceLocationStrings.contains(resourceLocationString)) {
                    brokenResourceLocationStrings.add(resourceLocationString);
                    LOGGER.warn("Unable to deserialize biome from string: [" + resourceLocationString + "]");
                }
                BiomeWrapper biomeWrapper = EMPTY_WRAPPER;
                return biomeWrapper;
            }
            BiomeWrapper biomeWrapper = foundWrapper = (BiomeWrapper)BiomeWrapper.getBiomeWrapper(deserializeResult.biome, levelWrapper);
            return biomeWrapper;
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize the string [" + finalResourceStateString + "] into a BiomeWrapper: " + e.getMessage(), e);
        }
        finally {
            WRAPPER_BY_RESOURCE_LOCATION.putIfAbsent(finalResourceStateString, foundWrapper);
        }
    }

    public static BiomeDeserializeResult deserializeBiome(String resourceLocationString, RegistryAccess registryAccess) throws IOException {
        Holder.Direct biome;
        boolean success;
        ResourceLocation resourceLocation;
        int separatorIndex = resourceLocationString.indexOf(":");
        if (separatorIndex == -1) {
            throw new IOException("Unable to parse resource location string: [" + resourceLocationString + "].");
        }
        try {
            resourceLocation = ResourceLocation.fromNamespaceAndPath((String)resourceLocationString.substring(0, separatorIndex), (String)resourceLocationString.substring(separatorIndex + 1));
        }
        catch (Exception e) {
            throw new IOException("No Resource Location found for the string: [" + resourceLocationString + "] Error: [" + e.getMessage() + "].");
        }
        Optional optionalBiomeHolder = registryAccess.lookupOrThrow(Registries.BIOME).get(resourceLocation);
        if (optionalBiomeHolder.isPresent()) {
            Biome unwrappedBiome = (Biome)((Holder.Reference)optionalBiomeHolder.get()).value();
            success = unwrappedBiome != null;
            biome = new Holder.Direct((Object)unwrappedBiome);
        } else {
            success = false;
            biome = null;
        }
        return new BiomeDeserializeResult(success, (Holder<Biome>)biome);
    }

    public static class BiomeDeserializeResult {
        public final boolean success;
        public final Holder<Biome> biome;

        public BiomeDeserializeResult(boolean success, Holder<Biome> biome) {
            this.success = success;
            this.biome = biome;
        }
    }
}

