/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TintWithoutLevelOverrider
implements BlockAndTintGetter {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final ConcurrentMap<String, Holder<Biome>> BIOME_BY_RESOURCE_STRING = new ConcurrentHashMap<String, Holder<Biome>>();
    @NotNull
    private final BiomeWrapper biomeWrapper;

    public TintWithoutLevelOverrider(@NotNull BiomeWrapper biomeWrapper, IClientLevelWrapper clientLevelWrapper) {
        this.biomeWrapper = biomeWrapper;
    }

    public int getBlockTint(@NotNull BlockPos blockPos, @NotNull ColorResolver colorResolver) {
        String biomeString = this.biomeWrapper.getSerialString();
        if (biomeString == null || biomeString.isEmpty() || biomeString.equals("EMPTY")) {
            biomeString = "minecraft:plains";
        }
        return colorResolver.getColor(TintWithoutLevelOverrider.unwrap(TintWithoutLevelOverrider.getClientBiome(biomeString)), (double)blockPos.getX(), (double)blockPos.getZ());
    }

    private static Biome unwrap(Holder<Biome> biome) {
        return (Biome)biome.value();
    }

    private static Holder<Biome> getClientBiome(String biomeResourceString) {
        return BIOME_BY_RESOURCE_STRING.compute(biomeResourceString, (resourceString, existingBiome) -> {
            BiomeWrapper.BiomeDeserializeResult result;
            if (existingBiome != null) {
                return existingBiome;
            }
            ClientLevel clientLevel = Minecraft.getInstance().level;
            if (clientLevel == null) {
                throw new IllegalStateException("Attempted to get client biome when no client level was loaded.");
            }
            try {
                result = BiomeWrapper.deserializeBiome(resourceString, clientLevel.registryAccess());
            }
            catch (Exception e) {
                LOGGER.warn("Unable to deserialize client biome [" + resourceString + "], using fallback...");
                try {
                    result = BiomeWrapper.deserializeBiome("minecraft:plains", clientLevel.registryAccess());
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to deserialize fallback client biome [minecraft:plains], returning NULL.");
                    return null;
                }
            }
            if (result.success) {
                existingBiome = result.biome;
            }
            return existingBiome;
        });
    }

    public float getShade(@NotNull Direction direction, boolean shade) {
        throw new UnsupportedOperationException("ERROR: getShade() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @NotNull
    public LevelLightEngine getLightEngine() {
        throw new UnsupportedOperationException("ERROR: getLightEngine() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @Nullable
    public BlockEntity getBlockEntity(@NotNull BlockPos pos) {
        throw new UnsupportedOperationException("ERROR: getBlockEntity() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @NotNull
    public BlockState getBlockState(@NotNull BlockPos pos) {
        throw new UnsupportedOperationException("ERROR: getBlockState() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockPos pos) {
        throw new UnsupportedOperationException("ERROR: getFluidState() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    public int getHeight() {
        throw new UnsupportedOperationException("ERROR: getHeight() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }

    public int getMinY() {
        throw new UnsupportedOperationException("ERROR: getMinY() called on TintWithoutLevelOverrider. Object is for tinting only.");
    }
}

