#version 150

layout(std140) uniform DynamicTransforms {
    mat4 ModelViewMat;
    vec4 ColorModulator;
    vec3 ModelOffset;
    mat4 TextureMat;
    float LineWidth;
};

uniform sampler2D Sampler0;

in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

float f_spread = .35;
float f_desaturate = 3.0;
float contrast = 5.0;

float truncate(float val) {
    if (val > 255.0) {
        return 255.0;
    }
    if (val < 0.0) {
        return 0.0;
    }
    return val;
}

vec3 spread(vec3 color, float factor)
{
    float mul = 1.0 + ((color.r + color.g + color.b) * 1.0 - 1.0) * factor;
    return color * mul;
}

vec3 desaturate(vec3 color, float factor) {
    vec3 luma = vec3(0.299, 0.587, 0.114);
    vec3 gray = vec3(dot(luma, color));
    return vec3(mix(color, gray, factor));
}

void main() {
    vec4 color = texture(Sampler0, texCoord0);
    color.rgb = desaturate(spread(color.rgb, f_spread), f_desaturate);
    if (color.a < 0.1) {
        discard;
    }

    float rr = .5;
    float rg = .6;
    float rb = .4;
    float ra = 0.0;

    float gr = .5;
    float gg = .35;
    float gb = .3;
    float ga = 0.0;

    float br = .4;
    float bg = .25;
    float bb = .15;
    float ba = 0.0;

    float factor = (259.0 * (contrast + 255.0)) / (255.0 * (259.0 - contrast));
    float c_red = truncate(factor * ((color.r - contrast) + contrast));
    float c_green = truncate(factor * ((color.g - contrast) + contrast));
    float c_blue = truncate(factor * ((color.b - contrast) + contrast));

    // sepia calculation
    float s_red = (rr * c_red) + (rb * c_blue) + (rg *c_green) + (ra * color.a);
    float s_green = (gr * c_red) + (gb * c_blue) + (gg *c_green) + (ga * color.a);
    float s_blue = (br * c_red) + (bb * c_blue) + (bg *c_green) + (ba * color.a);

    // increase contrast


    color = vec4(truncate(s_red), truncate(s_green), truncate(s_blue), 1.0);
    //    color = vec4(c_red, c_green, c_blue, 1.0);

    //                color = vec4(color.r, color.g, color.b, 1.0);
    color.rgb = desaturate(spread(color.rgb, .2), -.05);
    fragColor = color;
}
